<?php

/**

 * Shortcode countdown.

 *

 * @since  1.0

 * @author K2T Team

 * @link   http://www.sunrisetheme.com

 */



if ( ! function_exists( 'k2t_countdown_shortcode' ) ) {

	function k2t_countdown_shortcode( $atts, $content = NULL ) {

		$html = $style = $time = $year = $month = $day = $hour = $minute = $second = $fontsize = $align = $background_color = $text_color = $id = $class = '';

		extract( shortcode_atts( array(

			'style'			   => '',

			'time'             => '',

			'year'             => '',

			'month'            => '',

			'day'              => '',

			'hour'             => '',

			'minute'           => '',

			'second'           => '',

			'fontsize'         => '',

			'align'            => '',

			'background_color' => '',

			'text_color'       => '',

			'id'               => '',

			'class'            => '',

		), $atts ) );

		//Enqueue countdown js

		wp_enqueue_script( 'k2t-countdown' );



		//Global $cl and $style

		$cl = array( 'k2t-countdown' );

		$cl[] = 'countdown-' . $style;

		$style = array();



		$id    = ( $id != '' ) ? $id : 'countdown' . rand();

		$class = ( $class != '' ) ? ' ' . $class . '' : '';





		/*-------------------Align--------------------*/

		if ( in_array( trim( $align ), array( 'left', 'right', 'center' ) ) ) { $cl[] = 'align-' . trim( $align ); } else { $cl[] = 'align-left'; }



		/*--------------------Fontsize---------------------*/

		if ( !is_numeric( trim( $fontsize ) ) ) {

			$num_style = '';

		} else {

			if ( trim( $fontsize ) < 25 ) {

				$cl[] = 'countdown-small-font';

				$padding = ( trim( $fontsize ) )*0.6;

				$padding_bottom = ( trim( $fontsize ) )*0.5;

				$num_style = ' font-size: ' . trim( $fontsize ) . 'px; padding-bottom: ' . $padding_bottom . 'px';

			} else {

				$num_style = 'font-size: ' . trim( $fontsize ) . 'px';

			}

		}



		/*--------------------Background Color--------------------*/

		if ( trim( $background_color ) != '' ) { $style[] = 'background-color: ' . trim( $background_color ); }



		/*--------------------Background Color--------------------*/

		if ( trim( $text_color ) != '' ) { $style[] = 'color: ' . trim( $text_color ); }



		if ( trim( $num_style ) != '' ) { $style[] = $num_style ;}



		//Apply filters to cl

		$cl = apply_filters( 'k2t_countdown_classes', $cl );



		//Join cl class

		$cl = join( ' ', $cl );



		//Join style

		if ( !empty( $style ) ) { $style = ' style="' . trim( join( '; ', $style ) ) . '"'; } else { $style = '';};



		// Count columns display

		$j = 0;

		//for ( $i = 1; $i <= 6; $i++ ) {

			if ( ! empty( $year ) ) 	$j++;

			if ( ! empty( $month ) ) 	$j++;

			if ( ! empty( $day ) ) 		$j++;

			if ( ! empty( $hour ) ) 	$j++;

			if ( ! empty( $minute ) ) 	$j++;

			if ( ! empty( $second ) ) 	$j++;



		$html  .= '<div id="' . $id . '" class="' . trim( $cl ) . $class . '" data-time="' . $time . '">';

		$html .= do_action( 'k2t_countdown_open' );

		$html .= '<div class="inner">';

		if ( ! empty( $year ) ) 	$html .= '<div class="ele year"><span class="countdown-content"><span class="num"' . $style . '>00</span><span class="unit">' . $year . '</span></span><span class="bulkhead"></span></div>';

		if ( ! empty( $month ) ) 	$html .= '<div class="ele month"><span class="countdown-content"><span class="num"' . $style . '>00</span><span class="unit">' . $month . '</span></span><span class="bulkhead"></span></div>';

		if ( ! empty( $day ) ) 		$html .= '<div class="ele day"><span class="countdown-content"><span class="num"' . $style . '>00</span><span class="unit">' . $day . '</span></span><span class="bulkhead"></span></div>';

		if ( ! empty( $hour ) ) 	$html .= '<div class="ele hour"><span class="countdown-content"><span class="num"' . $style . '>00</span><span class="unit">' . $hour . '</span></span><span class="bulkhead"></span></div>';

		if ( ! empty( $minute ) ) 	$html .= '<div class="ele minute"><span class="countdown-content"><span class="num"' . $style . '>00</span><span class="unit">' . $minute . '</span></span><span class="bulkhead"></span></div>';

		if ( ! empty( $second ) ) 	$html .= '<div class="ele second"><span class="countdown-content"><span class="num"' . $style . '>00</span><span class="unit">' . $second . '</span></span></div>';

		$html .= '</div>';

		$html .= do_action( 'k2t_countdown_close' );



		if ( $j < 6 ) {

			$html .= '<div><style type="text/css">';

			$html .= '#'. $id .'.k2t-countdown .ele { width: '. ( 100 / $j ) .'%; }';

			$html .= '</style></div>';

		}





		$html .= '</div>'; // count down



		//Apply filters return

		$html = apply_filters( 'k2t_countdown_return', $html );



		return $html;

	}

}

