<?php

/**

 * The template for displaying content masonry.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

global $smof_data, $post;

$blog_style = 'masonry';



// Get all categories of post

$post_categories = wp_get_post_categories( get_the_ID() );

$post_categories_html = '';

if ( count( $post_categories ) > 0 ){

	foreach ($post_categories as $key => $value) {

		$category_name = get_the_category_by_ID( $value );

		$category_link = get_category_link( $value );

		if ( $key == 0 ){

			$post_categories_html .= '<a href="'. $category_link .'">'. $category_name .'</a>';

		}else{

			$post_categories_html .= ', <a href="'. $category_link .'">'. $category_name .'</a>';

		}

	}

}



// Get post format

$post_format = get_post_format();

$link        = ( function_exists( 'get_field' ) ) ? get_field( 'link_format_url', get_the_ID() ) : '';

$large       = ( function_exists( 'get_field' ) ) ? get_field( 'post_large', get_the_ID() ) : '';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'element hentry post-item ' . $post_format . '-post' ); ?>>

    <?php include 'post-format.php'; ?>

    <?php if ( $post_format != 'quote' ): ?>

    	<header>

    		<?php 

    			if ( 'link' == $post_format ) {

					the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( $link ) ), '</a></h2>' );

				} else {

					if ( $smof_data['blog-post-link'] ) {

						the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

					}

				}

    		?>

            <?php if ( $smof_data['blog-author'] ) : ?><span class="entry-author"><i class="awesome-user"></i><a title="<?php the_author();?>" href="<?php the_author_link();?>"><?php the_author();?></a></span><?php endif;?><?php if ( $smof_data['blog-date'] ):?><time data-time="<?php echo get_the_date( 'c' ) ?>" class="entry-date"><i class="awesome-clock-o"></i><?php the_time( 'j M Y' ); ?></time><?php endif;?><span class="entry-categories"><i class="awesome-suitcase"></i><?php echo $post_categories_html;?></span><?php if ( $smof_data['blog-number-comment'] ) :?><span class="entry-comment"><i class="awesome-comments-o"></i><a href="<?php comments_link(); ?>"><?php comments_number( '0 Comment', '1 Comment', '% Comments' ); ?></a></span><?php endif;?>

        </header>

        <?php endif;?>

    <?php if ( 'quote' != $post_format ) : ?>

	    <div class="entry-content clearfix">

	    	<?php

	        	if ( 'excerpts' == $smof_data['blog-display'] ) {

					echo $trimmed_content = '<p>' . wp_trim_words( get_the_content(), $smof_data['excerpt-length'] ) . '</p><a class="more-link" href="' . get_permalink() . '">'. __( 'Continue reading', 'sk' ) .'</a>';

				} else {

					if ( $smof_data['blog-readmore'] ) {

						the_content( sprintf( __( 'Continue reading', 'sk' ) ) );

					} else {

						the_content( sprintf( __( ' ', 'sk' ) ) );

					}	

				}

	        ?>

	    </div>

	<?php endif;?>

</article>