<?php

/**

 * The template for displaying archive pages.

 *

 * Learn more: http://codex.wordpress.org/Template_Hierarchy

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



if ( empty( $smof_data ) )

	$smof_data = of_get_options();



$blog_style 				= $smof_data['blog-style'];

$blog_sidebar 				= ! empty( $smof_data['blog-sidebar-position'] ) ? $smof_data['blog-sidebar-position'] : 'right-sidebar';



$blog_class = str_replace( '_', '-', $blog_sidebar ) . ' ';

switch ( $blog_style ) {

	case 'medium':

		$blog_class .= 'b-medium';

		break;

	case 'masonry':

		$blog_class .= 'b-masonry';

		break;

	default :

		$blog_class .= 'b-large';

		break;

}



get_header();



?>



	<section class="k2t-content <?php echo esc_attr( $blog_class );?>">

		<div class="k2t-wrap">

			<div class="k2t-main" role="main">



				<?php if ( $blog_style == 'masonry' ) : ?> <div class="masonry-layout column-2"> <?php endif;?>



				<div class="grid-sizer"></div>

				<?php

					if ( have_posts() ) :



						while ( have_posts() ) : the_post();

							switch ( $blog_style ) {

								case 'medium':

									get_template_part( 'templates/blog/content', 'medium' );

									break;

								case 'masonry':

									get_template_part( 'templates/blog/content', 'masonry' );

									break;

								default :

									get_template_part( 'templates/blog/content', 'large' );

									break;

							}

						endwhile;



					else :

						get_template_part( 'content', 'none' );

					endif;

				?>



				<?php if ( $blog_style == 'masonry' ) : ?> </div> <?php endif;?>



			</div><!-- #main -->



			<?php if ( $blog_sidebar != 'no_sidebar' ) { get_sidebar(); } ?>



		</div><!-- .k2t-wrap -->

	</section><!-- .k2t-content -->



<?php get_footer(); ?>