<?php

/**

 * The template for displaying single post content.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();



skstore_wpb_set_post_views( get_the_ID() );

// Get post format

$post_format = get_post_format();



// Display categories

$display_categories = ( function_exists( 'get_field' ) ) ? get_field( 'display_categories', get_the_ID() ) : '';



// Display post time

$display_post_date = ( function_exists( 'get_field' ) ) ? get_field( 'display_post_date', get_the_ID() ) : '';



// Display tags

$display_tags = ( function_exists( 'get_field' ) ) ? get_field( 'display_tags', get_the_ID() ) : '';



// Display author post bio

$display_authorbox = ( function_exists( 'get_field' ) ) ? get_field( 'display_authorbox', get_the_ID() ) : '';



// Display related post

$display_related_post = ( function_exists( 'get_field' ) ) ? get_field( 'display_related_post', get_the_ID() ) : '';



$user_meta = get_user_meta( get_the_author_meta( 'ID' ) );

$quote_content = ( function_exists( 'get_field' ) ) ? get_field( 'quote_content', get_the_ID() ) : '';

$quote_author  = ( function_exists( 'get_field' ) ) ? get_field( 'quote_author', get_the_ID() ) : '';

$quote_link    = ( function_exists( 'get_field' ) ) ? get_field( 'author_quote_url', get_the_ID() ) : '';

?>



<div id="main-col" <?php post_class(); ?>>



	<section class="entry-box">

		<?php get_template_part( 'templates/blog/post', 'format' ); ?>

		<header>

			<div class="post-meta-left">

				<?php if ( $smof_data['single-author'] ) : ?>

					<span><?php echo esc_html__( 'By', 'skstore' ) ?></span> <span class="entry-author"><?php echo get_the_author_link();?></span>

				<?php endif;?>

				<?php if ( $display_post_date != 'hide' ) : ?>

					<?php echo '<span class="entry-date">' . get_the_date() . '</span>';?>

				<?php endif;?>

				<?php if ( $smof_data['single-comments'] ) : ?>

					<span class="entry-comment"><i class="awesome-comment-o"></i><a href="<?php comments_link(); ?>"><?php comments_number( '0', '1', '%' ); ?></a></span>

					<span class="entry-comment"><i class="awesome-heart-o"></i><?php echo skstore_wpb_get_post_views( get_the_ID() ) ?></span>

				<?php endif;?>

			</div>

		</header>



		<div class="post-entry">

			<?php if ( $post_format != 'quote') {

					the_content();

				} else {

					if( isset( $quote_content ) && !empty( $quote_content ) ) :

						echo '<div class="quote-wrapper">

			                	<div class="quote-inner">

			                        	<div class="quote-content">

				                    		<h4>'. $quote_content .'</h4>

				                            <p class="quote-author"><a href="' . $quote_link . '"><span>'. esc_html( $quote_author ) .'</span></a></p>

				                    	</div><!--end:quote-content-->

			                    </div><!--end:quote-inner-->

			                </div><!--end:quote-wrapper-->';

			        else :

			        	the_content(); 

			        endif;

				}

			?>

		</div><!-- .post-entry -->



		<div class="entry-sharing">

			<div class="entry-sharing-left<?php if ( $smof_data['blog-social'] == "0" ) echo " no-right"; ?>">

				<?php 

				$tags = get_the_tags( get_the_ID() );

				if( $tags ){

					echo '<div class="widget_tag_cloud"><div class="tagcloud">';

					foreach ( (array)$tags as $key => $tag) {

						echo '<a href="'. esc_url( get_tag_link( $tag->term_id ) ) .'" title="'. esc_attr( $tag->name ) .'">'. esc_attr( $tag->name ) .'</a>';

					}

					echo '</div></div>';

				}	

				?>

			</div>

			<div class="entry-sharing-right">

				<?php if ( $smof_data['blog-social'] == "1" ) { 

						echo k2t_skstore_social_share(); 

					} 

				?>

			</div>

		</div>

	</section><!--end:entry-box-->



	<?php if ( '1' == $display_authorbox || 'default' == $display_authorbox && $smof_data['single-authorbox'] ) { ?>

	<article class="about-author clear">                             

		<div class="about-author-left">

			<?php echo get_avatar( get_the_author_meta( 'user_email' ), '150', '' );?> 

		</div>

		<div class="about-author-right">

			<h4><?php echo get_the_author_link();?></h4>     

			<?php $role = get_the_author_meta( 'roles' ); ?>

			<p class="author-role"><?php echo esc_attr( $role['0'] ); ?></p>             

			<p class="author-desc"><?php echo esc_html( get_the_author_meta( 'description' ) );?></p>

			<ul class="user-social">

				<?php $social_arr  = array( 'facebook', 'twitter', 'google-plus', 'instagram', 'youtube', 'linkedin', 'pinterest' );

				foreach ($social_arr as &$social_list) :

					if ( isset( $user_meta[$social_list] ) && !empty( $user_meta[$social_list] ) ):

				?>

						<li><a href="<?php echo esc_attr( $user_meta[$social_list][0] ); ?>"><i class="fa fa-<?php echo esc_attr( $social_list ); ?>"></i></a></li>

					<?php endif; ?>

				<?php endforeach; ?>

			</ul>

		</div>

	</article><!--about-author-->

	<?php }?>

	<div class="clear"></div>

	