define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"], function(require, exports, module) {

"use strict";



var oop = require("../lib/oop");

var lang = require("../lib/lang");

var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

var supportType = exports.supportType = "animation-fill-mode|alignment-adjust|alignment-baseline|animation-delay|animation-direction|animation-duration|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|animation|appearance|azimuth|backface-visibility|background-attachment|background-break|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|background|baseline-shift|binding|bleed|bookmark-label|bookmark-level|bookmark-state|bookmark-target|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|border|bottom|box-align|box-decoration-break|box-direction|box-flex-group|box-flex|box-lines|box-ordinal-group|box-orient|box-pack|box-shadow|box-sizing|break-after|break-before|break-inside|caption-side|clear|clip|color-profile|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|crop|cue-after|cue-before|cue|cursor|direction|display|dominant-baseline|drop-initial-after-adjust|drop-initial-after-align|drop-initial-before-adjust|drop-initial-before-align|drop-initial-size|drop-initial-value|elevation|empty-cells|fit|fit-position|float-offset|float|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|font|sk-columns|sk-rows|hanging-punctuation|height|hyphenate-after|hyphenate-before|hyphenate-character|hyphenate-lines|hyphenate-resource|hyphens|icon|image-orientation|image-rendering|image-resolution|inline-box-align|left|letter-spacing|line-height|line-stacking-sk|line-stacking-shift|line-stacking-strategy|line-stacking|list-style-image|list-style-position|list-style-type|list-style|margin-bottom|margin-left|margin-right|margin-top|margin|mark-after|mark-before|mark|marks|marquee-direction|marquee-play-count|marquee-speed|marquee-style|max-height|max-width|min-height|min-width|move-to|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|orphans|outline-color|outline-offset|outline-style|outline-width|outline|overflow-style|overflow-x|overflow-y|overflow|padding-bottom|padding-left|padding-right|padding-top|padding|page-break-after|page-break-before|page-break-inside|page-policy|page|pause-after|pause-before|pause|perspective-origin|perspective|phonemes|pitch-range|pitch|play-during|pointer-events|position|presentation-level|punctuation-trim|quotes|rendering-intent|resize|rest-after|rest-before|rest|richness|right|rotation-point|rotation|sk-align|sk-overhang|sk-position|sk-span|size|speak-header|speak-numeral|speak-punctuation|speak|speech-rate|stress|string-set|table-layout|target-name|target-new|target-position|target|text-align-last|text-align|text-decoration|text-emphasis|text-height|text-indent|text-justify|text-outline|text-shadow|text-transform|text-wrap|top|transform-origin|transform-style|transform|transition-delay|transition-duration|transition-property|transition-timing-function|transition|unicode-bidi|vertical-align|visibility|voice-balance|voice-duration|voice-family|voice-pitch-range|voice-pitch|voice-rate|voice-stress|voice-volume|volume|white-space-collapse|white-space|widows|width|word-break|word-spacing|word-wrap|z-index";

var supportFunction = exports.supportFunction = "rgb|rgba|url|attr|counter|counters";

var supportConstant = exports.supportConstant = "absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-sk|fill|fixed|georgian|glyphs|sk-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-sk|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero";

var supportConstantColor = exports.supportConstantColor = "aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow";

var supportConstantFonts = exports.supportConstantFonts = "arial|century|comic|courier|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace";



var numRe = exports.numRe = "\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";

var pseudoElements = exports.pseudoElements = "(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";

var pseudoClasses  = exports.pseudoClasses =  "(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";



var CssHighlightRules = function() {



    var keywordMapper = this.createKeywordMapper({

        "support.function": supportFunction,

        "support.constant": supportConstant,

        "support.type": supportType,

        "support.constant.color": supportConstantColor,

        "support.constant.fonts": supportConstantFonts

    }, "text", true);



    this.$rules = {

        "start" : [{

            token : "comment", // multi line comment

            regex : "\\/\\*",

            push : "comment"

        }, {

            token: "paren.lparen",

            regex: "\\{",

            push:  "ruleset"

        }, {

            token: "string",

            regex: "@.*?{",

            push:  "media"

        }, {

            token: "keyword",

            regex: "#[a-z0-9-_]+"

        }, {

            token: "variable",

            regex: "\\.[a-z0-9-_]+"

        }, {

            token: "string",

            regex: ":[a-z0-9-_]+"

        }, {

            token: "constant",

            regex: "[a-z0-9-_]+"

        }, {

            caseInsensitive: true

        }],



        "media" : [{

            token : "comment", // multi line comment

            regex : "\\/\\*",

            push : "comment"

        }, {

            token: "paren.lparen",

            regex: "\\{",

            push:  "ruleset"

        }, {

            token: "string",

            regex: "\\}",

            next:  "pop"

        }, {

            token: "keyword",

            regex: "#[a-z0-9-_]+"

        }, {

            token: "variable",

            regex: "\\.[a-z0-9-_]+"

        }, {

            token: "string",

            regex: ":[a-z0-9-_]+"

        }, {

            token: "constant",

            regex: "[a-z0-9-_]+"

        }, {

            caseInsensitive: true

        }],



        "comment" : [{

            token : "comment",

            regex : "\\*\\/",

            next : "pop"

        }, {

            defaultToken : "comment"

        }],



        "ruleset" : [

        {

            token : "paren.rparen",

            regex : "\\}",

            next:   "pop"

        }, {

            token : "comment", // multi line comment

            regex : "\\/\\*",

            push : "comment"

        }, {

            token : "string", // single line

            regex : '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'

        }, {

            token : "string", // single line

            regex : "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"

        }, {

            token : ["constant.numeric", "keyword"],

            regex : "(" + numRe + ")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"

        }, {

            token : "constant.numeric",

            regex : numRe

        }, {

            token : "constant.numeric",  // hex6 color

            regex : "#[a-f0-9]{6}"

        }, {

            token : "constant.numeric", // hex3 color

            regex : "#[a-f0-9]{3}"

        }, {

            token : ["punctuation", "entity.other.attribute-name.pseudo-element.css"],

            regex : pseudoElements

        }, {

            token : ["punctuation", "entity.other.attribute-name.pseudo-class.css"],

            regex : pseudoClasses

        }, {

            token : ["support.function", "string", "support.function"],

            regex : "(url\\()(.*)(\\))"

        }, {

            token : keywordMapper,

            regex : "\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"

        }, {

            caseInsensitive: true

        }]

    };



    this.normalizeRules();

};



oop.inherits(CssHighlightRules, TextHighlightRules);



exports.CssHighlightRules = CssHighlightRules;



});



define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"], function(require, exports, module) {

"use strict";



var Range = require("../range").Range;



var MatchingBraceOutdent = function() {};



(function() {



    this.checkOutdent = function(line, input) {

        if (! /^\s+$/.test(line))

            return false;



        return /^\s*\}/.test(input);

    };



    this.autoOutdent = function(doc, row) {

        var line = doc.getLine(row);

        var match = line.match(/^(\s*\})/);



        if (!match) return 0;



        var column = match[1].length;

        var openBracePos = doc.findMatchingBracket({row: row, column: column});



        if (!openBracePos || openBracePos.row == row) return 0;



        var indent = this.$getIndent(doc.getLine(openBracePos.row));

        doc.replace(new Range(row, 0, row, column-1), indent);

    };



    this.$getIndent = function(line) {

        return line.match(/^\s*/)[0];

    };



}).call(MatchingBraceOutdent.prototype);



exports.MatchingBraceOutdent = MatchingBraceOutdent;

});



define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"], function(require, exports, module) {

"use strict";



var oop = require("../../lib/oop");

var Behaviour = require("../behaviour").Behaviour;

var TokenIterator = require("../../token_iterator").TokenIterator;

var lang = require("../../lib/lang");



var SAFE_INSERT_IN_TOKENS =

    ["text", "paren.rparen", "punctuation.operator"];

var SAFE_INSERT_BEFORE_TOKENS =

    ["text", "paren.rparen", "punctuation.operator", "comment"];



var context;

var contextCache = {};

var initContext = function(editor) {

    var id = -1;

    if (editor.multiSelect) {

        id = editor.selection.index;

        if (contextCache.rangeCount != editor.multiSelect.rangeCount)

            contextCache = {rangeCount: editor.multiSelect.rangeCount};

    }

    if (contextCache[id])

        return context = contextCache[id];

    context = contextCache[id] = {

        autoInsertedBrackets: 0,

        autoInsertedRow: -1,

        autoInsertedLineEnd: "",

        maybeInsertedBrackets: 0,

        maybeInsertedRow: -1,

        maybeInsertedLineStart: "",

        maybeInsertedLineEnd: ""

    };

};



var CstyleBehaviour = function() {

    this.add("braces", "insertion", function(state, action, editor, session, text) {

        var cursor = editor.getCursorPosition();

        var line = session.doc.getLine(cursor.row);

        if (text == '{') {

            initContext(editor);

            var selection = editor.getSelectionRange();

            var selected = session.doc.getTextRange(selection);

            if (selected !== "" && selected !== "{" && editor.getWrapBehavioursEnabled()) {

                return {

                    text: '{' + selected + '}',

                    selection: false

                };

            } else if (CstyleBehaviour.isSaneInsertion(editor, session)) {

                if (/[\]\}\)]/.test(line[cursor.column]) || editor.inMultiSelectMode) {

                    CstyleBehaviour.recordAutoInsert(editor, session, "}");

                    return {

                        text: '{}',

                        selection: [1, 1]

                    };

                } else {

                    CstyleBehaviour.recordMaybeInsert(editor, session, "{");

                    return {

                        text: '{',

                        selection: [1, 1]

                    };

                }

            }

        } else if (text == '}') {

            initContext(editor);

            var rightChar = line.substring(cursor.column, cursor.column + 1);

            if (rightChar == '}') {

                var matching = session.$findOpeningBracket('}', {column: cursor.column + 1, row: cursor.row});

                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {

                    CstyleBehaviour.popAutoInsertedClosing();

                    return {

                        text: '',

                        selection: [1, 1]

                    };

                }

            }

        } else if (text == "\n" || text == "\r\n") {

            initContext(editor);

            var closing = "";

            if (CstyleBehaviour.isMaybeInsertedClosing(cursor, line)) {

                closing = lang.stringRepeat("}", context.maybeInsertedBrackets);

                CstyleBehaviour.clearMaybeInsertedClosing();

            }

            var rightChar = line.substring(cursor.column, cursor.column + 1);

            if (rightChar === '}') {

                var openBracePos = session.findMatchingBracket({row: cursor.row, column: cursor.column+1}, '}');

                if (!openBracePos)

                     return null;

                var next_indent = this.$getIndent(session.getLine(openBracePos.row));

            } else if (closing) {

                var next_indent = this.$getIndent(line);

            } else {

                CstyleBehaviour.clearMaybeInsertedClosing();

                return;

            }

            var indent = next_indent + session.getTabString();



            return {

                text: '\n' + indent + '\n' + next_indent + closing,

                selection: [1, indent.length, 1, indent.length]

            };

        } else {

            CstyleBehaviour.clearMaybeInsertedClosing();

        }

    });



    this.add("braces", "deletion", function(state, action, editor, session, range) {

        var selected = session.doc.getTextRange(range);

        if (!range.isMultiLine() && selected == '{') {

            initContext(editor);

            var line = session.doc.getLine(range.start.row);

            var rightChar = line.substring(range.end.column, range.end.column + 1);

            if (rightChar == '}') {

                range.end.column++;

                return range;

            } else {

                context.maybeInsertedBrackets--;

            }

        }

    });



    this.add("parens", "insertion", function(state, action, editor, session, text) {

        if (text == '(') {

            initContext(editor);

            var selection = editor.getSelectionRange();

            var selected = session.doc.getTextRange(selection);

            if (selected !== "" && editor.getWrapBehavioursEnabled()) {

                return {

                    text: '(' + selected + ')',

                    selection: false

                };

            } else if (CstyleBehaviour.isSaneInsertion(editor, session)) {

                CstyleBehaviour.recordAutoInsert(editor, session, ")");

                return {

                    text: '()',

                    selection: [1, 1]

                };

            }

        } else if (text == ')') {

            initContext(editor);

            var cursor = editor.getCursorPosition();

            var line = session.doc.getLine(cursor.row);

            var rightChar = line.substring(cursor.column, cursor.column + 1);

            if (rightChar == ')') {

                var matching = session.$findOpeningBracket(')', {column: cursor.column + 1, row: cursor.row});

                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {

                    CstyleBehaviour.popAutoInsertedClosing();

                    return {

                        text: '',

                        selection: [1, 1]

                    };

                }

            }

        }

    });



    this.add("parens", "deletion", function(state, action, editor, session, range) {

        var selected = session.doc.getTextRange(range);

        if (!range.isMultiLine() && selected == '(') {

            initContext(editor);

            var line = session.doc.getLine(range.start.row);

            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);

            if (rightChar == ')') {

                range.end.column++;

                return range;

            }

        }

    });



    this.add("brackets", "insertion", function(state, action, editor, session, text) {

        if (text == '[') {

            initContext(editor);

            var selection = editor.getSelectionRange();

            var selected = session.doc.getTextRange(selection);

            if (selected !== "" && editor.getWrapBehavioursEnabled()) {

                return {

                    text: '[' + selected + ']',

                    selection: false

                };

            } else if (CstyleBehaviour.isSaneInsertion(editor, session)) {

                CstyleBehaviour.recordAutoInsert(editor, session, "]");

                return {

                    text: '[]',

                    selection: [1, 1]

                };

            }

        } else if (text == ']') {

            initContext(editor);

            var cursor = editor.getCursorPosition();

            var line = session.doc.getLine(cursor.row);

            var rightChar = line.substring(cursor.column, cursor.column + 1);

            if (rightChar == ']') {

                var matching = session.$findOpeningBracket(']', {column: cursor.column + 1, row: cursor.row});

                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {

                    CstyleBehaviour.popAutoInsertedClosing();

                    return {

                        text: '',

                        selection: [1, 1]

                    };

                }

            }

        }

    });



    this.add("brackets", "deletion", function(state, action, editor, session, range) {

        var selected = session.doc.getTextRange(range);

        if (!range.isMultiLine() && selected == '[') {

            initContext(editor);

            var line = session.doc.getLine(range.start.row);

            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);

            if (rightChar == ']') {

                range.end.column++;

                return range;

            }

        }

    });



    this.add("string_dquotes", "insertion", function(state, action, editor, session, text) {

        if (text == '"' || text == "'") {

            initContext(editor);

            var quote = text;

            var selection = editor.getSelectionRange();

            var selected = session.doc.getTextRange(selection);

            if (selected !== "" && selected !== "'" && selected != '"' && editor.getWrapBehavioursEnabled()) {

                return {

                    text: quote + selected + quote,

                    selection: false

                };

            } else {

                var cursor = editor.getCursorPosition();

                var line = session.doc.getLine(cursor.row);

                var leftChar = line.substring(cursor.column-1, cursor.column);

                var rightChar = line.substring(cursor.column, cursor.column + 1);

                

                var token = session.getTokenAt(cursor.row, cursor.column);

                var rightToken = session.getTokenAt(cursor.row, cursor.column + 1);

                if (leftChar == "\\" && token && /escape/.test(token.type))

                    return null;

                

                var stringBefore = token && /string/.test(token.type);

                var stringAfter = !rightToken || /string/.test(rightToken.type);

                

                var pair;

                if (rightChar == quote) {

                    pair = stringBefore !== stringAfter;

                } else {

                    if (stringBefore && !stringAfter)

                        return null; // wrap string with different quote

                    if (stringBefore && stringAfter)

                        return null; // do not pair quotes inside strings 

                    var wordRe = session.$mode.tokenRe;

                    wordRe.lastIndex = 0;

                    var isWordBefore = wordRe.test(leftChar);

                    wordRe.lastIndex = 0;

                    var isWordAfter = wordRe.test(leftChar);

                    if (isWordBefore || isWordAfter)

                        return null; // before or after alphanumeric

                    if (rightChar && !/[\s;,.})\]\\]/.test(rightChar))

                        return null; // there is rightChar and it isn't closing

                    pair = true;

                }

                return {

                    text: pair ? quote + quote : "",

                    selection: [1,1]

                };

            }

        }

    });



    this.add("string_dquotes", "deletion", function(state, action, editor, session, range) {

        var selected = session.doc.getTextRange(range);

        if (!range.isMultiLine() && (selected == '"' || selected == "'")) {

            initContext(editor);

            var line = session.doc.getLine(range.start.row);

            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);

            if (rightChar == selected) {

                range.end.column++;

                return range;

            }

        }

    });



};



    

CstyleBehaviour.isSaneInsertion = function(editor, session) {

    var cursor = editor.getCursorPosition();

    var iterator = new TokenIterator(session, cursor.row, cursor.column);

    if (!this.$matchTokenType(iterator.getCurrentToken() || "text", SAFE_INSERT_IN_TOKENS)) {

        var iterator2 = new TokenIterator(session, cursor.row, cursor.column + 1);

        if (!this.$matchTokenType(iterator2.getCurrentToken() || "text", SAFE_INSERT_IN_TOKENS))

            return false;

    }

    iterator.stepForward();

    return iterator.getCurrentTokenRow() !== cursor.row ||

        this.$matchTokenType(iterator.getCurrentToken() || "text", SAFE_INSERT_BEFORE_TOKENS);

};



CstyleBehaviour.$matchTokenType = function(token, types) {

    return types.indexOf(token.type || token) > -1;

};



CstyleBehaviour.recordAutoInsert = function(editor, session, bracket) {

    var cursor = editor.getCursorPosition();

    var line = session.doc.getLine(cursor.row);

    if (!this.isAutoInsertedClosing(cursor, line, context.autoInsertedLineEnd[0]))

        context.autoInsertedBrackets = 0;

    context.autoInsertedRow = cursor.row;

    context.autoInsertedLineEnd = bracket + line.substr(cursor.column);

    context.autoInsertedBrackets++;

};



CstyleBehaviour.recordMaybeInsert = function(editor, session, bracket) {

    var cursor = editor.getCursorPosition();

    var line = session.doc.getLine(cursor.row);

    if (!this.isMaybeInsertedClosing(cursor, line))

        context.maybeInsertedBrackets = 0;

    context.maybeInsertedRow = cursor.row;

    context.maybeInsertedLineStart = line.substr(0, cursor.column) + bracket;

    context.maybeInsertedLineEnd = line.substr(cursor.column);

    context.maybeInsertedBrackets++;

};



CstyleBehaviour.isAutoInsertedClosing = function(cursor, line, bracket) {

    return context.autoInsertedBrackets > 0 &&

        cursor.row === context.autoInsertedRow &&

        bracket === context.autoInsertedLineEnd[0] &&

        line.substr(cursor.column) === context.autoInsertedLineEnd;

};



CstyleBehaviour.isMaybeInsertedClosing = function(cursor, line) {

    return context.maybeInsertedBrackets > 0 &&

        cursor.row === context.maybeInsertedRow &&

        line.substr(cursor.column) === context.maybeInsertedLineEnd &&

        line.substr(0, cursor.column) == context.maybeInsertedLineStart;

};



CstyleBehaviour.popAutoInsertedClosing = function() {

    context.autoInsertedLineEnd = context.autoInsertedLineEnd.substr(1);

    context.autoInsertedBrackets--;

};



CstyleBehaviour.clearMaybeInsertedClosing = function() {

    if (context) {

        context.maybeInsertedBrackets = 0;

        context.maybeInsertedRow = -1;

    }

};







oop.inherits(CstyleBehaviour, Behaviour);



exports.CstyleBehaviour = CstyleBehaviour;

});



define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"], function(require, exports, module) {

"use strict";



var oop = require("../../lib/oop");

var Behaviour = require("../behaviour").Behaviour;

var CstyleBehaviour = require("./cstyle").CstyleBehaviour;

var TokenIterator = require("../../token_iterator").TokenIterator;



var CssBehaviour = function () {



    this.inherit(CstyleBehaviour);



    this.add("colon", "insertion", function (state, action, editor, session, text) {

        if (text === ':') {

            var cursor = editor.getCursorPosition();

            var iterator = new TokenIterator(session, cursor.row, cursor.column);

            var token = iterator.getCurrentToken();

            if (token && token.value.match(/\s+/)) {

                token = iterator.stepBackward();

            }

            if (token && token.type === 'support.type') {

                var line = session.doc.getLine(cursor.row);

                var rightChar = line.substring(cursor.column, cursor.column + 1);

                if (rightChar === ':') {

                    return {

                       text: '',

                       selection: [1, 1]

                    }

                }

                if (!line.substring(cursor.column).match(/^\s*;/)) {

                    return {

                       text: ':;',

                       selection: [1, 1]

                    }

                }

            }

        }

    });



    this.add("colon", "deletion", function (state, action, editor, session, range) {

        var selected = session.doc.getTextRange(range);

        if (!range.isMultiLine() && selected === ':') {

            var cursor = editor.getCursorPosition();

            var iterator = new TokenIterator(session, cursor.row, cursor.column);

            var token = iterator.getCurrentToken();

            if (token && token.value.match(/\s+/)) {

                token = iterator.stepBackward();

            }

            if (token && token.type === 'support.type') {

                var line = session.doc.getLine(range.start.row);

                var rightChar = line.substring(range.end.column, range.end.column + 1);

                if (rightChar === ';') {

                    range.end.column ++;

                    return range;

                }

            }

        }

    });



    this.add("semicolon", "insertion", function (state, action, editor, session, text) {

        if (text === ';') {

            var cursor = editor.getCursorPosition();

            var line = session.doc.getLine(cursor.row);

            var rightChar = line.substring(cursor.column, cursor.column + 1);

            if (rightChar === ';') {

                return {

                   text: '',

                   selection: [1, 1]

                }

            }

        }

    });



}

oop.inherits(CssBehaviour, CstyleBehaviour);



exports.CssBehaviour = CssBehaviour;

});



define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"], function(require, exports, module) {

"use strict";



var oop = require("../../lib/oop");

var Range = require("../../range").Range;

var BaseFoldMode = require("./fold_mode").FoldMode;



var FoldMode = exports.FoldMode = function(commentRegex) {

    if (commentRegex) {

        this.foldingStartMarker = new RegExp(

            this.foldingStartMarker.source.replace(/\|[^|]*?$/, "|" + commentRegex.start)

        );

        this.foldingStopMarker = new RegExp(

            this.foldingStopMarker.source.replace(/\|[^|]*?$/, "|" + commentRegex.end)

        );

    }

};

oop.inherits(FoldMode, BaseFoldMode);



(function() {

    

    this.foldingStartMarker = /(\{|\[)[^\}\]]*$|^\s*(\/\*)/;

    this.foldingStopMarker = /^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/;

    this.singleLineBlockCommentRe= /^\s*(\/\*).*\*\/\s*$/;

    this.tripleStarBlockCommentRe = /^\s*(\/\*\*\*).*\*\/\s*$/;

    this.startRegionRe = /^\s*(\/\*|\/\/)#region\b/;

    this._getFoldWidgetBase = this.getFoldWidget;

    this.getFoldWidget = function(session, foldStyle, row) {

        var line = session.getLine(row);

    

        if (this.singleLineBlockCommentRe.test(line)) {

            if (!this.startRegionRe.test(line) && !this.tripleStarBlockCommentRe.test(line))

                return "";

        }

    

        var fw = this._getFoldWidgetBase(session, foldStyle, row);

    

        if (!fw && this.startRegionRe.test(line))

            return "start"; // lineCommentRegionStart

    

        return fw;

    };



    this.getFoldWidgetRange = function(session, foldStyle, row, forceMultiline) {

        var line = session.getLine(row);

        

        if (this.startRegionRe.test(line))

            return this.getCommentRegionBlock(session, line, row);

        

        var match = line.match(this.foldingStartMarker);

        if (match) {

            var i = match.index;



            if (match[1])

                return this.openingBracketBlock(session, match[1], row, i);

                

            var range = session.getCommentFoldRange(row, i + match[0].length, 1);

            

            if (range && !range.isMultiLine()) {

                if (forceMultiline) {

                    range = this.getSectionRange(session, row);

                } else if (foldStyle != "all")

                    range = null;

            }

            

            return range;

        }



        if (foldStyle === "markbegin")

            return;



        var match = line.match(this.foldingStopMarker);

        if (match) {

            var i = match.index + match[0].length;



            if (match[1])

                return this.closingBracketBlock(session, match[1], row, i);



            return session.getCommentFoldRange(row, i, -1);

        }

    };

    

    this.getSectionRange = function(session, row) {

        var line = session.getLine(row);

        var startIndent = line.search(/\S/);

        var startRow = row;

        var startColumn = line.length;

        row = row + 1;

        var endRow = row;

        var maxRow = session.getLength();

        while (++row < maxRow) {

            line = session.getLine(row);

            var indent = line.search(/\S/);

            if (indent === -1)

                continue;

            if  (startIndent > indent)

                break;

            var subRange = this.getFoldWidgetRange(session, "all", row);

            

            if (subRange) {

                if (subRange.start.row <= startRow) {

                    break;

                } else if (subRange.isMultiLine()) {

                    row = subRange.end.row;

                } else if (startIndent == indent) {

                    break;

                }

            }

            endRow = row;

        }

        

        return new Range(startRow, startColumn, endRow, session.getLine(endRow).length);

    };

    

    this.getCommentRegionBlock = function(session, line, row) {

        var startColumn = line.search(/\s*$/);

        var maxRow = session.getLength();

        var startRow = row;

        

        var re = /^\s*(?:\/\*|\/\/)#(end)?region\b/;

        var depth = 1;

        while (++row < maxRow) {

            line = session.getLine(row);

            var m = re.exec(line);

            if (!m) continue;

            if (m[1]) depth--;

            else depth++;



            if (!depth) break;

        }



        var endRow = row;

        if (endRow > startRow) {

            return new Range(startRow, startColumn, endRow, line.length);

        }

    };



}).call(FoldMode.prototype);



});



define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/css","ace/mode/folding/cstyle"], function(require, exports, module) {

"use strict";



var oop = require("../lib/oop");

var TextMode = require("./text").Mode;

var CssHighlightRules = require("./css_highlight_rules").CssHighlightRules;

var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;

var WorkerClient = require("../worker/worker_client").WorkerClient;

var CssBehaviour = require("./behaviour/css").CssBehaviour;

var CStyleFoldMode = require("./folding/cstyle").FoldMode;



var Mode = function() {

    this.HighlightRules = CssHighlightRules;

    this.$outdent = new MatchingBraceOutdent();

    this.$behaviour = new CssBehaviour();

    this.foldingRules = new CStyleFoldMode();

};

oop.inherits(Mode, TextMode);



(function() {



    this.foldingRules = "cStyle";

    this.blockComment = {start: "/*", end: "*/"};



    this.getNextLineIndent = function(state, line, tab) {

        var indent = this.$getIndent(line);

        var tokens = this.getTokenizer().getLineTokens(line, state).tokens;

        if (tokens.length && tokens[tokens.length-1].type == "comment") {

            return indent;

        }



        var match = line.match(/^.*\{\s*$/);

        if (match) {

            indent += tab;

        }



        return indent;

    };



    this.checkOutdent = function(state, line, input) {

        return this.$outdent.checkOutdent(line, input);

    };



    this.autoOutdent = function(state, doc, row) {

        this.$outdent.autoOutdent(doc, row);

    };



    this.createWorker = function(session) {

        var worker = new WorkerClient(["ace"], "ace/mode/css_worker", "Worker");

        worker.attachToDocument(session.getDocument());



        worker.on("csslint", function(e) {

            session.setAnnotations(e.data);

        });



        worker.on("terminate", function() {

            session.clearAnnotations();

        });



        return worker;

    };



    this.$id = "ace/mode/css";

}).call(Mode.prototype);



exports.Mode = Mode;



});

