<?php

/**

 * Icon list for menu and visuak composer.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



/*--------------------------------------------------------------

	Define icon path

--------------------------------------------------------------*/

function k2t_vc_icon_url() {

	return get_template_directory_uri() . '/framework/extensions/k2ticon';

}



/*--------------------------------------------------------------

	Icon init

--------------------------------------------------------------*/

function k2t_vc_icon_init() {

	// Enqueue icon font style

	wp_enqueue_style( 'icon-font-style', k2t_vc_icon_url() . '/css/icon-font-style.css' );



	// Enqueue icon font style back-end

	wp_enqueue_style( 'k2ticon-icon-generator', k2t_vc_icon_url() . '/css/generator.css' );



	// Enqueue icon font script

	wp_enqueue_script( 'k2ticon-icon-generator', k2t_vc_icon_url() . '/js/generator.js', array( 'jquery' ), '', false );



	if ( ! is_admin() ) {

		wp_enqueue_style( 'icon-font-style' );

	} elseif ( is_admin() ) {

		wp_enqueue_style( 'icon-font-style' );

		wp_enqueue_style( 'k2ticon-icon-generator' );	

		wp_enqueue_script( 'k2ticon-icon-generator' );		

	}

}

add_action( 'init', 'k2t_vc_icon_init' );



/*--------------------------------------------------------------

	Generate icon box

--------------------------------------------------------------*/

function k2t_vc_icon_generator() {

	include_once 'inc/list.php'; 

	//get_template_part( 'extensions/k2ticon/inc/', 'list' );

	?>

	<div id="k2ticon-generator-overlay" class="k2ticon-overlay-bg" style="display:none"></div>

	<div id="k2ticon-generator-wrap" style="display:none">

		<div id="k2ticon-generator">

			<a href="#" id="k2ticon-generator-close"><span class="k2ticon-close-icon"></span></a>

			<div id="k2ticon-generator-shell">

				

				<table border="0" id="k2ticon-generator-options">

					<tr>

						<td class="generator-title">

							<span>Icon Pack:</span>

						</td>							

						<td>

							<select name="icon-pack" id="k2ticon-generator-select-pack">

							   <option value="fontawesome-icons-list">Font Awesome icons</option>

							   <option value="line-icons-list">Line icons</option>

							</select>

						</td>

					</tr>

				</table>

				

				<div class="k2ticon-generator-icon-select">

					<ul class="fontawesome-icon-list">

					<?php 

					foreach ( $k2ticon_icon_list['fontawesome'] as $font_awesome_icon ) {

						$selected_icon = ( 'awesome-adjust' == $font_awesome_icon ) ? ' checked' : '';

						echo '<li><input name="name" type="radio" value="' . esc_attr( $font_awesome_icon ) . '" id="' . esc_attr( $font_awesome_icon ) . '" '. $selected_icon .' ><label for="' . esc_attr( $font_awesome_icon ) . '"><i class="' . esc_attr( $font_awesome_icon ) . '"></i></label></li>';

					} 

					?>

					</ul>

					<ul class="line-icon-list" style="display:none">

					<?php 

					foreach ( $k2ticon_icon_list['line'] as $line_icon ) {

						echo '<li><input name="name" type="radio" value="' . esc_attr( $line_icon ) . '" id="' . esc_attr( $line_icon ) . '"><label for="' . esc_attr( $line_icon ) . '"><i class="' . esc_attr( $line_icon ) . '"></i></label></li>';

					} 

					?>

					</ul>

				</div>

				

				<input name="k2ticon-generator-insert" type="submit" class="button button-primary button-large" id="k2ticon-generator-insert" value="Insert Icon">

				<div class="k2ticon-clear"></div>

				

				<input type="hidden" name="k2ticon-generator-url" id="k2ticon-generator-url" value="<?php echo k2t_vc_icon_url(); ?>" />

				<input type="hidden" name="k2ticon-generator-result" id="k2ticon-generator-result" value="" />

				<input type="hidden" name="k2ticon-compatibility-mode" id="k2ticon-compatibility-mode" value="k2t_" />

			</div>

		</div>

	</div>

	

<?php

}

add_action( 'admin_footer', 'k2t_vc_icon_generator' );



?>