<?php

/**

 * k2t social widget

 *

 * @package skstore

 * @author  SunriseTheme

 * @link http://www.sunrisetheme.com

 */

if ( empty( $smof_data ) )

	$smof_data = of_get_options();



add_action( 'widgets_init', 'k2t_skstore_social_load_widgets' );

function k2t_skstore_social_load_widgets() {

	register_widget( 'k2t_skstore_widget_social' );

}

class k2t_skstore_widget_social extends WP_Widget {

	function __construct() {

		$widget_ops = array( 'classname' => 'k2t-social-widget', 'description' => esc_html__( 'K2t Social widget', 'skstore' ) );

		$control_ops = array( 'width' => 250, 'height' => 350 );

		parent::__construct( 'k2t-social', esc_html__( 'k2t - social', 'skstore' ), $widget_ops, $control_ops );

	}



	/* This method is required */

	function widget($args, $instance) {

		global $smof_data;

		extract( $args );

		echo esc_attr( $before_widget );

		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		if ( !empty( $title ) ) {

			echo esc_attr( $before_title );

			echo '<span>' . esc_html( $title ) . '</span>';

			echo esc_attr( $after_title );

		}; 

		echo '<ul class="social">';

        foreach ( k2t_skstore_social_array() as $s => $c ): 

            if ( isset ( $smof_data['social-' . $s] ) && $smof_data['social-' . $s] ) :

            	$icon = ( $s == 'vimeo' ) ? 'vimeo-square' : $s;

            	echo '<li class="li-' . esc_attr( $s ) . '"><a title="' . esc_attr( $c ) . '" href="'. esc_url( $smof_data['social-' . $s] ) .'" rel="alternate"><i class="fa fa-'. esc_attr( $icon ) .'"></i></a></li>';

            endif;

        endforeach;

        echo '</ul>';

        echo esc_attr( $after_widget );

	}





	/**

	 * Saves the widgets settings.

	 *

	 */

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];

		return $instance;

	}



	/**

	 * Creates the edit form for the widget.

	 *

	 */

function form( $instance ) {

		$defaults = array(

			'title'			=>  '',

		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		extract( $instance );

			$title = $instance['title'];

?>



		<p>

			<label for="<?php echo ($this->get_field_id( 'title' )) ?>" style="display:inline-block;width:50px"><?php esc_html_e( 'Title:', 'skstore' ) ?></label>

			<input class="widefat" style="width: 100%" id="<?php echo ( $this->get_field_id( 'title' ) ) ?>" name="<?php echo ( $this->get_field_name( 'title' ) ) ?>" type="text" value="<?php echo esc_attr( $title ) ?>" />

		</p>

		<?php

	} //end of form



} // end class