<?php

/**

 * Recent post widget.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link http://www.sunrisetheme.com

 */



add_action( 'widgets_init', 'k2t_recent_post_load_widgets' );

function k2t_recent_post_load_widgets() {

	register_widget( 'k2t_Widget_Recent_Post' );

}

class k2t_Widget_Recent_Post extends WP_Widget {



	function __construct() {

		$widget_ops  = array( 'classname' => 'k2t_widget_latest_posts', 'description' => '' );

		$control_ops = array( 'width' => 250, 'height' => 350 );

		parent::__construct( 'k2t_recent_post', esc_html__( 'skstore - Recent Post', 'skstore' ), $widget_ops, $control_ops );

	}



	function widget( $args, $instance ) {

		extract( $args );

		global $post;

		echo ( $before_widget );

		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		if ( ! empty( $title ) ) {

			echo ( $before_title );

			echo esc_html( $title );

			echo ( $after_title );

		}



		// Load parameter

		$limit         = isset( $instance['limit'] ) ? $instance['limit'] : '';

		$order         = isset( $instance['order'] ) ? $instance['order'] : '';

		$orderby       = isset( $instance['orderby'] ) ? $instance['orderby'] : '';

		$display_thumb = isset( $instance['display_thumb'] ) ? $instance['display_thumb'] : '';

		$display_date  = isset( $instance['display_date'] ) ? $instance['display_date'] : '';

		$style  = isset( $instance['style'] ) ? $instance['style'] : '';

		$date_html     = '';



		// Load data

		$args = array(

			'post_type' => 'post',

			'post_status' => 'publish',

			'suppress_filters' => false,

		);

		if ( ! empty( $limit ) ) $args['posts_per_page'] = $limit;

		if ( ! empty( $order ) ) $args['order'] = $order;

		if ( ! empty( $orderby ) ) $args['orderby'] = $orderby;



		$recent_posts = get_posts( $args );

		$html = '';

		if ( count( $recent_posts ) > 0 ) {

			$html .= '<div class="posts-list ' . $style . '">';

			foreach ( $recent_posts as $post ) {

				setup_postdata( $post );

				$thumb_id =  get_post_thumbnail_id( get_the_ID() ) ;

				$image = ( $style == 'row' ) ? aq_resize( $thumbnail_link, 300, 200, true ) : aq_resize( $thumbnail_link, 100, 80, true );

				$thumb_size = ( $style == 'row' ) ? '300x200' : '100x80';



				if ( has_post_thumbnail( get_the_ID() ) ) {

					$thumb = wp_get_attachment_image( $thumb_id, 'k2t_skstore_184x184' );

				} else {

					$thumb = '<img src="' . get_template_directory_uri() . '/assets/img/placeholder/' . $thumb_size . '.png" alt="' . trim( get_the_title() ) . '" />';

				}

				$thumb_html = '';

				if ( $display_thumb == 'show' ) {

					$thumb_html = '

						<div class="post-thumb">

							<a href="' . get_permalink( get_the_ID() ) . '" title="' . get_the_title() . '">' . $thumb . '</a>

							<div class="mask">

								<a href="' . get_permalink( get_the_ID() ) . '" title="' . get_the_title() . '"></a>

							</div>

						</div>

					';

				}

				if ( $display_date == 'show' ) {

					$date_html = '

					<header>

						<div class="post-meta">

							<div class="post-meta-left">

								<span class="entry-date" data-time="' . get_the_date( 'c' ) . '">' . get_the_date( 'j M, Y' ) . '</span>

							</div>

							<div class="post-meta-right">

								<span class="entry-comment"><i class="awesome-heart-o"></i>' . skstore_wpb_get_post_views( get_the_ID() ) . '</span>

								<span class="entry-comment"><i class="awesome-comment-o"></i>' . get_comments_number() . '</span>

							</div>

						</div>

					<header>

					';

				}

				$html .= '

					<article class="post-item">

						' . $thumb_html . '

						<div class="post-text">

							<h4><a href="' . get_permalink( get_the_ID() ) . '" title="' . get_the_title() . '">' . get_the_title() . '</a></h4>

							' . $date_html . '

						</div>

					</article>

				';

			}

			$html .= '</div>';

		}

		echo ( $html );

		echo ( $after_widget );

		wp_reset_query();

	}



	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

		return $new_instance;

	}



	function form( $instance ) {

		$defaults = array( 'title' => esc_html__( 'Recent Post', 'skstore' ), 'limit' => 5, 'order' => 'desc', 'orderby' => 'title', 'display_thumb' => 'show', 'display_date' => 'show' );

		$instance = wp_parse_args( (array) $instance, $defaults );?>

		<p>

			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'skstore' ); ?></label>

			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />

		</p>

        <p>

			<label for="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>"><?php esc_html_e( 'Limit:', 'skstore' ); ?></label>

			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'limit' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['limit'] ); ?>" />

		</p>

        <p>

            <label for="<?php echo esc_attr( $this->get_field_id( 'order' ) ); ?>"><?php esc_html_e( 'Order:', 'skstore' ); ?></label>

            <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'order' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'order' ) ); ?>">

                <option <?php selected( $instance['order'], 'desc' ) ?> value="desc"><?php esc_html_e( 'DESC', 'skstore' );?></option>

                <option <?php selected( $instance['order'], 'asc' ) ?> value="asc"><?php esc_html_e( 'ASC', 'skstore' );?></option>

            </select>

        </p>

        <p>

            <label for="<?php echo esc_attr( $this->get_field_id( 'orderby' ) ); ?>"><?php esc_html_e( 'Orderby:', 'skstore' ); ?></label>

            <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'orderby' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'orderby' ) ); ?>">

                <option <?php selected( $instance['orderby'], 'title' ) ?> value="title"><?php esc_html_e( 'Title', 'skstore' );?></option>

                <option <?php selected( $instance['orderby'], 'post_date' ) ?> value="post_date"><?php esc_html_e( 'Date', 'skstore' );?></option>

                <option <?php selected( $instance['orderby'], 'rand' ) ?> value="rand"><?php esc_html_e( 'Random', 'skstore' );?></option>

            </select>

        </p>

		<p>

            <label for="<?php echo esc_attr( $this->get_field_id( 'display_thumb' ) ); ?>"><?php esc_html_e( 'Display Thumbnail:', 'skstore' ); ?></label>

            <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'display_thumb' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'display_thumb' ) ); ?>">

                <option <?php selected( $instance['display_thumb'], 'show' ) ?> value="show"><?php esc_html_e( 'Show', 'skstore' );?></option>

                <option <?php selected( $instance['display_thumb'], 'hided' ) ?> value="hided"><?php esc_html_e( 'Hide', 'skstore' );?></option>

            </select>

        </p>

        <p>

            <label for="<?php echo esc_attr( $this->get_field_id( 'display_date' ) ); ?>"><?php esc_html_e( 'Display Date and Comments static:', 'skstore' ); ?></label>

            <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'display_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'display_date' ) ); ?>">

                <option <?php selected( $instance['display_date'], 'show' ) ?> value="show"><?php esc_html_e( 'Show', 'skstore' );?></option>

                <option <?php selected( $instance['display_date'], 'hided' ) ?> value="hided"><?php esc_html_e( 'Hide', 'skstore' );?></option>

            </select>

        </p>

        <p>

            <label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php esc_html_e( 'Style:', 'skstore' ); ?></label>

            <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>">

                <option <?php selected( $instance['style'], 'row' ) ?> value="row"><?php esc_html_e( 'Row', 'skstore' );?></option>

                <option <?php selected( $instance['style'], 'column' ) ?> value="column"><?php esc_html_e( 'Column', 'skstore' );?></option>

            </select>

        </p>

		<?php

	}

}

?>
