<?php

/**

 * Advanced custom field for theme.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link    http://www.sunrisetheme.com

 */



if ( function_exists( 'register_field_group' ) ):



	register_field_group(

		array(

			'key'    => 'group_53d8edf4beaff',

			'title'  => 'Page Options',

			'fields' => array(

				array(

					'key'               => 'field_53e77e2f35e12',

					'label'             => 'Page layout',

					'name'              => '',

					'prefix'            => '',

					'type'              => 'tab',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => 0,

				),

				array(

					'key'               => 'field_53d8ee35180f4',

					'label'             => 'Page layout',

					'name'              => 'page_layout',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => 0,

					'choices' => array(

						'default'       => 'Default',

						'right_sidebar' => 'Right Sidebar',

						'left_sidebar'  => 'Left Sidebar',

						'no_sidebar'    => 'No Sidebar',

						'full_width'    => '100% Width',

					),

					'default_value'     => 'full_width',

					'allow_null'        => 0,

					'multiple'          => 0,

					'ui'                => 0,

					'ajax'              => 0,

					'placeholder'       => '',

					'disabled'          => 0,

					'readonly'          => 0,

				),

				array(

					'key'               => 'field_53fd51a9335a3',

					'label'             => 'Custom sidebar',

					'name'              => 'single_custom_sidebar',

					'prefix'            => '',

					'type'              => 'text',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array (

							array (

								'field' => 'field_53d8ee35180f4',

								'operator' => '==',

								'value' => 'default',

							),

						),

						array (

							array (

								'field' => 'field_53d8ee35180f4',

								'operator' => '==',

								'value' => 'right_sidebar',

							),

						),

						array (

							array (

								'field' => 'field_53d8ee35180f4',

								'operator' => '==',

								'value' => 'left_sidebar',

							),

						),

					),

					'default_value'     => '',

					'placeholder'       => '',

					'prepend'           => '',

					'append'            => '',

					'maxlength'         => '',

					'readonly'          => 0,

					'disabled'          => 0,

				),

				array(

					'key'               => 'field_542e60920bbc1',

					'label'             => 'Page sidebar width',

					'name'              => 'page_sidebar_width',

					'prefix'            => '',

					'type'              => 'number',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array (

							array (

								'field' => 'field_53d8ee35180f4',

								'operator' => '==',

								'value' => 'default',

							),

						),

						array (

							array (

								'field' => 'field_53d8ee35180f4',

								'operator' => '==',

								'value' => 'right_sidebar',

							),

						),

						array (

							array (

								'field' => 'field_53d8ee35180f4',

								'operator' => '==',

								'value' => 'left_sidebar',

							),

						),

					),

					'default_value'     => 33,

					'placeholder'       => '',

					'prepend'           => '',

					'prepend'           => '%',

					'min'               => 0,

					'max'               => 100,

					'step'              => '',

					'readonly'          => 0,

					'disabled'          => 0,

				),

				array(

					'key'               => 'field_54393ee87f9b9',

					'label'             => 'Background color',

					'name'              => 'page_background_color',

					'prefix'            => '',

					'type'              => 'color_picker',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => 0,

					'default_value'     => '#ebebeb',

				),

				array(

					'key'               => 'field_542d131580b0c',

					'label'             => 'Top padding of content',

					'name'              => 'page_content_padding_top',

					'prefix'            => '',

					'type'              => 'text',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => 0,

					'default_value'     => '0',

					'placeholder'       => '',

					'prepend'           => '',

					'prepend'           => '',

					'maxlength'         => '',

					'readonly'          => 0,

					'disabled'          => 0,

				),

				array(

					'key'               => 'field_542d132d80b0d',

					'label'             => 'Bottom padding of content',

					'name'              => 'page_content_padding_bottom',

					'prefix'            => '',

					'type'              => 'text',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => 0,

					'default_value'     => '0',

					'placeholder'       => '',

					'prepend'           => '',

					'prepend'           => '',

					'maxlength'         => '',

					'readonly'          => 0,

					'disabled'          => 0,

				),

				array(

					'key'               => 'field_542d1333j4ks',

					'label'             => 'Header style',

					'name'              => 'header_style',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => 0,

					'choices' => array(

						'header_horizontal'		=> 'Header horizontal',

						'header_vertical'       => 'Header vertical',

					),

				),

				array(

					'key'               => 'field_53fee964510140',

					'label'             => 'Page Titlebar',

					'name'              => '',

					'prefix'            => '',

					'type'              => 'tab',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => 0,

				),

				array(

					'key'               => 'field_53fd4b60338340',

					'label'             => 'Show/Hide Title Bar',

					'name'              => 'display_titlebar',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => 'Only support page layout "Full Width" and "No Sidebar"',

					'required'          => 0,

					'conditional_logic' => 0,

					'choices' => array(

						'show'  => 'Show',

						'hided' => 'Hide',

					),

					'default_value' => 'show',

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_53fee992510150',

					'label'             => 'Titlebar layout',

					'name'              => 'titlebar_layout',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						'justify' => 'Justify',

						'center'  => 'Center',

					),

					'default_value' => 'center',

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_53fee990308890',

					'label'             => 'Search Form',

					'name'              => 'search_form',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						'show'  => 'Show',

						'hided' => 'Hide',

					),

					'default_value' => 'hided',

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_53fd4b60338350',

					'label'             => 'Main Title Underline',

					'name'              => 'title_underline',

					'prefix'            => '',

					'type'              => 'select',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						'show'  => 'Show',

						'hided' => 'Hide',

					),

					'default_value' => 'show',

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_542e57d7501060',

					'label'             => 'Page titlebar font size',

					'name'              => 'page_titlebar_font_size',

					'prefix'            => '',

					'type'              => 'text',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'default_value'     => '20px',

					'placeholder'       => '',

					'prepend'           => '',

					'prepend'           => '',

					'maxlength'         => '',

					'readonly'          => 0,

					'disabled'          => 0,

				),

				array(

					'key'               => 'field_53fftww651019',

					'label'             => 'Page title bar color',

					'name'              => 'page_titlebar_color',

					'prefix'            => '',

					'type'              => 'color_picker',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'default_value'     => '',

				),

				array(

					'key'               => 'field_53feec3f510160',

					'label'             => 'Top padding',

					'name'              => 'padding_top',

					'prefix'            => '',

					'type'              => 'text',

					'instructions'      => 'Unit: px (Ex: 10px)',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						)

					),

					'default_value'     => '100px',

					'placeholder'       => '',

					'prepend'           => '',

					'prepend'           => '',

					'maxlength'         => '',

					'readonly'          => 0,

					'disabled'          => 0,

				),

				array(

					'key'               => 'field_53feec3f510170',

					'label'             => 'Bottom padding',

					'name'              => 'padding_bottom',

					'prefix'            => '',

					'type'              => 'text',

					'instructions'      => 'Unit: px (Ex: 10px)',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						)

					),

					'default_value'     => '80px',

					'placeholder'       => '',

					'prepend'           => '',

					'prepend'           => '',

					'maxlength'         => '',

					'readonly'          => 0,

					'disabled'          => 0,

				),

				array(

					'key'               => 'field_53feecb2510180',

					'label'             => 'Background image',

					'name'              => 'background_image',

					'prefix'            => '',

					'type'              => 'image',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'return_format'     => 'array',

					'preview_size'      => 'thumbnail',

					'library'           => 'all',

				),

				array(

					'key'               => 'field_53feeda05101b0',

					'label'             => 'Background position',

					'name'              => 'background_position',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						'left top'      => 'Left Top',

						'left center'   => 'Left Center',

						'left bottom'   => 'Left Bottom',

						'right top'     => 'Right Top',

						'right center'  => 'Right Center',

						'right bottom'  => 'Right Bottom',

						'center top'    => 'Center top',

						'center center' => 'Center Center',

						'center bottom' => 'Center Bottom',

					),

					'default_value' => array(),

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_53fuida05167b0',

					'label'             => 'Background size',

					'name'              => 'background_size',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						'inherit' => 'Inherit',

						'cover'   => 'Cover',

						'contain' => 'Contain',

						'full'    => '100%',

					),

					'default_value' => 'cover',

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_52rguda05101b0',

					'label'             => 'Background repeat',

					'name'              => 'background_repeat',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						'no-repeat' => 'No Repeat',

						'repeat'    => 'Repeat',

						'repeat-x'  => 'Repeat X',

						'repeat-y'  => 'Repeat Y',

					),

					'default_value' => 'repeat',

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_53feecea510190',

					'label'             => 'Background color',

					'name'              => 'background_color',

					'prefix'            => '',

					'type'              => 'color_picker',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b6033834',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'default_value'     => '',

				),

				array(

					'key'               => 'field_54336341fb9f70',

					'label'             => 'Background parallax',

					'name'              => 'background_parallax',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						'1' => 'True',

						'0' => 'False',

					),

					'default_value' => array(),

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_53feefc15101f0',

					'label'             => 'Titlebar shadow opacity',

					'name'              => 'titlebar_shadow_opacity',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => 'Set your shadow opacity in titlebar',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						0     => 0,

						'0.1' => '0.1',

						'0.2' => '0.2',

						'0.3' => '0.3',

						'0.4' => '0.4',

						'0.5' => '0.5',

						'0.6' => '0.6',

						'0.7' => '0.7',

						'0.8' => '0.8',

						'0.9' => '0.9',

						1     => 1,

					),

					'default_value' => array(

						'0' => '0',

					),

					'allow_null'  => 0,

					'multiple'    => 0,

					'ui'          => 0,

					'ajax'        => 0,

					'placeholder' => '',

					'disabled'    => 0,

					'readonly'    => 0,

				),

				array(

					'key'               => 'field_53fef060510200',

					'label'             => 'Titlebar overlay opacity',

					'name'              => 'titlebar_overlay_opacity',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => 'Set your overlay opacity in titlebar',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						0     => 0,

						'0.1' => '0.1',

						'0.2' => '0.2',

						'0.3' => '0.3',

						'0.4' => '0.4',

						'0.5' => '0.5',

						'0.6' => '0.6',

						'0.7' => '0.7',

						'0.8' => '0.8',

						'0.9' => '0.9',

						1     => 1,

					),

					'default_value' => array(),

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_53fef07c510210',

					'label'             => 'Titlebar clipmask opacity',

					'name'              => 'titlebar_clipmask_opacity',

					'prefix'            => '',

					'type'              => 'select',

					'instructions'      => 'Set your clipmask opacity in titlebar',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b6033834',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'choices' => array(

						0     => 0,

						'0.1' => '0.1',

						'0.2' => '0.2',

						'0.3' => '0.3',

						'0.4' => '0.4',

						'0.5' => '0.5',

						'0.6' => '0.6',

						'0.7' => '0.7',

						'0.8' => '0.8',

						'0.9' => '0.9',

						1     => 1,

					),

					'default_value' => array(),

					'allow_null'    => 0,

					'multiple'      => 0,

					'ui'            => 0,

					'ajax'          => 0,

					'placeholder'   => '',

					'disabled'      => 0,

					'readonly'      => 0,

				),

				array(

					'key'               => 'field_53fef0eb510230',

					'label'             => 'Custom titlebar content',

					'name'              => 'titlebar_custom_content',

					'prefix'            => '',

					'type'              => 'wysiwyg',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => array(

						array(

							array(

								'field'    => 'field_53fd4b60338340',

								'operator' => '==',

								'value'    => 'show',

							),

						),

					),

					'default_value'     => '',

					'tabs'              => 'all',

					'toolbar'           => 'full',

					'media_upload'      => 1,

				),

				array (

					'key' => 'field_55af590378723',

					'label' => 'Blog',

					'name' => '',

					'type' => 'tab',

					'instructions' => '',

					'required' => 0,

					'conditional_logic' => 0,

					'wrapper' => array (

						'width' => '',

						'class' => '',

						'id' => '',

					),

					'placement' => 'top',

				),

				array (

					'key' => 'field_55af591778724',

					'label' => 'Select categories',

					'name' => 'page_select_categories',

					'type' => 'taxonomy',

					'instructions' => '',

					'required' => 0,

					'conditional_logic' => 0,

					'wrapper' => array (

						'width' => '',

						'class' => '',

						'id' => '',

					),

					'taxonomy' => 'category',

					'field_type' => 'multi_select',

					'allow_null' => 0,

					'add_term' => 1,

					'save_terms' => 1,

					'load_terms' => 0,

					'return_format' => 'id',

					'multiple' => 0,

				),

			),

			'location' => array(

				array(

					array(

						'param'    => 'post_type',

						'operator' => '==',

						'value'    => 'page',

					),

				),

			),

			'menu_order'            => 0,

			'position'              => 'normal',

			'style'                 => 'default',

			'label_placement'       => 'top',

			'instruction_placement' => 'label',

			'hide_on_screen'        => '',

		) );



	register_field_group( array(

		'key'    => 'group_53d9acd573a57',

		'title'  => 'Post options',

		'fields' => array(

			array(

				'key'               => 'field_53df40c5588c3',

				'label'             => 'Post Layout',

				'name'              => '',

				'prefix'            => '',

				'type'              => 'tab',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

			),

			array(

				'key'               => 'field_53df40dd588c5',

				'label'             => 'Post layout',

				'name'              => 'post_layout',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'default'       => 'Default',

					'right_sidebar' => 'Right Sidebar',

					'left_sidebar'  => 'Left Sidebar',

					'no_sidebar'    => 'No Sidebar',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_43df3480f5f9b',

				'label'             => 'choose large post thumbnail for masonry layout only',

				'name'              => 'post_large',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'large' => 'True',

					''      => 'False',

				),

				'default_value' => '',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53df4176c5f9b',

				'label'             => 'Custom sidebar name',

				'name'              => 'single_custom_sidebar',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_543b350c0528f',

				'label'             => 'Post metadata',

				'name'              => '',

				'prefix'            => '',

				'type'              => 'tab',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

			),

			array(

				'key'               => 'field_53e2ed3bf58b4',

				'label'             => 'Show/Hide Categories',

				'name'              => 'display_categories',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'default' => 'Default',

					1 => 'Show',

					2 => 'Hide',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53e2ed80f58b5',

				'label'             => 'Show/Hide post date',

				'name'              => 'display_post_date',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'default' => 'Default',

					1 => 'Show',

					2 => 'Hide',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53e2f31b8b379',

				'label'             => 'Show/Hide tags',

				'name'              => 'display_tags',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'default' => 'Default',

					1 => 'Show',

					2 => 'Hide',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53e2eda4f58b7',

				'label'             => 'Show/Hide authorbox',

				'name'              => 'display_authorbox',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'default' => 'Default',

					1 => 'Show',

					2 => 'Hide',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53e2edbff58b8',

				'label'             => 'Show/Hide related post',

				'name'              => 'display_related_post',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'default' => 'Default',

					1 => 'Show',

					2 => 'Hide',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53df3ff5e761f',

				'label'             => 'Post format',

				'name'              => '',

				'prefix'            => '',

				'type'              => 'tab',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

			),

			array(

				'key'               => 'field_53e2edeff58b8',

				'label'             => 'Choose video source',

				'name'              => 'video_format_source',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'link'  => 'Video Link',

					'embed' => 'Video Embed code',

					'local' => 'Upload local file',

				),

				'default_value' => 'link',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_54338f305aaf9',

				'label'             => 'Video format url',

				'name'              => 'video_url',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => 'You can choose Youtube or Vimeo link (eg: https://www.youtube.com/watch?v=uxHXATYpt2w)',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						'rule' => array(

							'field'    => 'field_53e2edeff58b8',

							'operator' => '==',

							'value'    => 'link',

						),

					),

				),

				'default_value'     => '',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_53da05e21c492',

				'label'             => 'Video embed code',

				'name'              => 'video_code',

				'prefix'            => '',

				'type'              => 'textarea',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						'rule' => array(

							'field'    => 'field_53e2edeff58b8',

							'operator' => '==',

							'value'    => 'embed',

						),

					),

				),

				'default_value'     => '',

				'placeholder'       => '',

				'maxlength'         => '',

				'rows'              => '',

				'new_lines'         => 'wpautop',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_53df78207e598',

				'label'             => 'Upload video file',

				'name'              => 'video_local',

				'prefix'            => '',

				'type'              => 'file',

				'instructions'      => 'Support .mp4 file only',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						'rule' => array(

							'field'    => 'field_53e2edeff58b8',

							'operator' => '==',

							'value'    => 'local',

						),

					),

				),

				'return_format'     => 'array',

				'library'           => 'all',

			),

			array(

				'key'               => 'field_53e2etiff58b8',

				'label'             => 'Choose audio source',

				'name'              => 'audio_format_source',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'link'  => 'Soundcloud link',

					'local' => 'Upload local file',

				),

				'default_value' => 'link',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53de3fbbcb5e4',

				'label'             => 'Soundcloud link',

				'name'              => 'audio_url',

				'prefix'            => '',

				'type'              => 'text',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						'rule' => array(

							'field'    => 'field_53e2etiff58b8',

							'operator' => '==',

							'value'    => 'link',

						),

					),

				),

				'default_value'     => '',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_53df78207e597',

				'label'             => 'Upload audio file',

				'name'              => 'audio_local',

				'prefix'            => '',

				'type'              => 'file',

				'instructions'      => 'Support .mp3 file only',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						'rule' => array(

							'field'    => 'field_53e2etiff58b8',

							'operator' => '==',

							'value'    => 'local',

						),

					),

				),

				'return_format'     => 'array',

				'library'           => 'all',

			),

			array(

				'key'               => 'field_53d9aedbf3c36',

				'label'             => 'Quote author',

				'name'              => 'quote_author',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_543390cd5aafb',

				'label'             => 'Author quote url',

				'name'              => 'author_quote_url',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => 'Option for format "quote" only',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_543830cd5aafb',

				'label'             => 'Quote Content',

				'name'              => 'quote_content',

				'prefix'            => '',

				'type'              => 'textarea',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

				'placeholder'       => '',

				'maxlength'         => '',

				'rows'              => '',

				'new_lines'         => 'wpautop',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_53de3e23b0d0f',

				'label'             => 'Gallery format',

				'name'              => 'post_gallery',

				'prefix'            => '',

				'type'              => 'gallery',

				'instructions'      => 'Option for format "gallery" only',

				'required'          => 0,

				'conditional_logic' => 0,

				'min'               => '',

				'max'               => '',

				'preview_size'      => 'thumbnail',

				'library'           => 'all',

			),

			array(

				'key'               => 'field_54005a6a90104',

				'label'             => 'Gallery auto play',

				'name'              => 'gallery_auto',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'true'  => 'True',

					'false' => 'False',

				),

				'default_value'     => array(

					'false' => 'false',

				),

				'allow_null'  => 0,

				'multiple'    => 0,

				'ui'          => 0,

				'ajax'        => 0,

				'placeholder' => '',

				'disabled'    => 0,

				'readonly'    => 0,

			),

			array(

				'key'               => 'field_54005ed990105',

				'label'             => 'Gallery duration time',

				'name'              => 'gallery_auto_time_wait',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => 5000,

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_54005f8e90106',

				'label'             => 'Gallery speed',

				'name'              => 'gallery_speed',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => 300,

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_54005fa690107',

				'label'             => 'Gallery pagination',

				'name'              => 'gallery_pagination',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'true'  => 'True',

					'false' => 'False',

				),

				'default_value' => 'false',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_5400601f90108',

				'label'             => 'Gallery navigation',

				'name'              => 'gallery_navigation',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'true'  => 'True',

					'false' => 'False',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_5400607990109',

				'label'             => 'Gallery mousewheel using',

				'name'              => 'gallery_mousewheel',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'true'  => 'True',

					'false' => 'False',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53fee96451014',

				'label'             => 'Post Titlebar',

				'name'              => '',

				'prefix'            => '',

				'type'              => 'tab',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

			),

			array(

				'key'               => 'field_53fd4b6033834',

				'label'             => 'Show/Hide Title Bar',

				'name'              => 'display_titlebar',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => 'Only support page layout "Full Width" and "No Sidebar"',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'show'  => 'Show',

					'hided' => 'Hide',

				),

				'default_value' => 'show',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53fee99251015',

				'label'             => 'Titlebar layout',

				'name'              => 'titlebar_layout',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					'justify' => 'Justify',

					'center'  => 'Center',

				),

				'default_value' => 'center',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53fee99030889',

				'label'             => 'Search Form',

				'name'              => 'search_form',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					'show'  => 'Show',

					'hided' => 'Hide',

				),

				'default_value' => 'hided',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53fd4b6033835',

				'label'             => 'Main Title Underline',

				'name'              => 'title_underline',

				'prefix'            => '',

				'type'              => 'select',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					'show'  => 'Show',

					'hided' => 'Hide',

				),

				'default_value' => 'show',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_542e57d750106',

				'label'             => 'Page titlebar font size',

				'name'              => 'page_titlebar_font_size',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'default_value'     => '20px',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_53fftww651019',

				'label'             => 'Page title bar color',

				'name'              => 'page_titlebar_color',

				'prefix'            => '',

				'type'              => 'color_picker',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'default_value'     => '',

			),

			array(

				'key'               => 'field_53feec3f51016',

				'label'             => 'Top padding',

				'name'              => 'padding_top',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => 'Unit: px (Ex: 10px)',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					)

				),

				'default_value'     => '100px',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_53feec3f51017',

				'label'             => 'Bottom padding',

				'name'              => 'padding_bottom',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => 'Unit: px (Ex: 10px)',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					)

				),

				'default_value'     => '80px',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_53feecb251018',

				'label'             => 'Background image',

				'name'              => 'background_image',

				'prefix'            => '',

				'type'              => 'image',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'return_format'     => 'array',

				'preview_size'      => 'thumbnail',

				'library'           => 'all',

			),

			array(

				'key'               => 'field_53feeda05101b',

				'label'             => 'Background position',

				'name'              => 'background_position',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					'left top'      => 'Left Top',

					'left center'   => 'Left Center',

					'left bottom'   => 'Left Bottom',

					'right top'     => 'Right Top',

					'right center'  => 'Right Center',

					'right bottom'  => 'Right Bottom',

					'center top'    => 'Center top',

					'center center' => 'Center Center',

					'center bottom' => 'Center Bottom',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53fuida05167b',

				'label'             => 'Background size',

				'name'              => 'background_size',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					'inherit' => 'Inherit',

					'cover'   => 'Cover',

					'contain' => 'Contain',

					'full'    => '100%',

				),

				'default_value' => 'cover',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_52rguda05101b',

				'label'             => 'Background repeat',

				'name'              => 'background_repeat',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					'no-repeat' => 'No Repeat',

					'repeat'    => 'Repeat',

					'repeat-x'  => 'Repeat X',

					'repeat-y'  => 'Repeat Y',

				),

				'default_value' => 'repeat',

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53feecea51019',

				'label'             => 'Background color',

				'name'              => 'background_color',

				'prefix'            => '',

				'type'              => 'color_picker',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'default_value'     => '',

			),

			array(

				'key'               => 'field_54336341fb9f7',

				'label'             => 'Background parallax',

				'name'              => 'background_parallax',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					'1' => 'True',

					'0' => 'False',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53feefc15101f',

				'label'             => 'Titlebar shadow opacity',

				'name'              => 'titlebar_shadow_opacity',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => 'Set your shadow opacity in titlebar',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					0     => 0,

					'0.1' => '0.1',

					'0.2' => '0.2',

					'0.3' => '0.3',

					'0.4' => '0.4',

					'0.5' => '0.5',

					'0.6' => '0.6',

					'0.7' => '0.7',

					'0.8' => '0.8',

					'0.9' => '0.9',

					1     => 1,

				),

				'default_value' => array(

					'0' => '0',

				),

				'allow_null'  => 0,

				'multiple'    => 0,

				'ui'          => 0,

				'ajax'        => 0,

				'placeholder' => '',

				'disabled'    => 0,

				'readonly'    => 0,

			),

			array(

				'key'               => 'field_53fef06051020',

				'label'             => 'Titlebar overlay opacity',

				'name'              => 'titlebar_overlay_opacity',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => 'Set your overlay opacity in titlebar',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					0     => 0,

					'0.1' => '0.1',

					'0.2' => '0.2',

					'0.3' => '0.3',

					'0.4' => '0.4',

					'0.5' => '0.5',

					'0.6' => '0.6',

					'0.7' => '0.7',

					'0.8' => '0.8',

					'0.9' => '0.9',

					1     => 1,

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53fef07c51021',

				'label'             => 'Titlebar clipmask opacity',

				'name'              => 'titlebar_clipmask_opacity',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => 'Set your clipmask opacity in titlebar',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'choices' => array(

					0     => 0,

					'0.1' => '0.1',

					'0.2' => '0.2',

					'0.3' => '0.3',

					'0.4' => '0.4',

					'0.5' => '0.5',

					'0.6' => '0.6',

					'0.7' => '0.7',

					'0.8' => '0.8',

					'0.9' => '0.9',

					1     => 1,

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_53fef0eb51023',

				'label'             => 'Custom titlebar content',

				'name'              => 'titlebar_custom_content',

				'prefix'            => '',

				'type'              => 'wysiwyg',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => array(

					array(

						array(

							'field'    => 'field_53fd4b6033834',

							'operator' => '==',

							'value'    => 'show',

						),

					),

				),

				'default_value'     => '',

				'tabs'              => 'all',

				'toolbar'           => 'full',

				'media_upload'      => 1,

			),

		),

		'location' => array(

			array(

				array(

					'param'    => 'post_type',

					'operator' => '==',

					'value'    => 'post',

				),

			),

		),

		'menu_order'            => 0,

		'position'              => 'normal',

		'style'                 => 'default',

		'label_placement'       => 'top',

		'instruction_placement' => 'label',

		'hide_on_screen'        => '',

	) );



	register_field_group( array(

		'key'    => 'group_540d72068b18e',

		'title'  => 'Product Setting',

		'fields' => array(

			array(

				'key'               => 'field_540d720d3c1c6',

				'label'             => 'Hover Effect',

				'name'              => 'product_hover_effect',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'default' => 'Default',

					'fade'    => 'Fade',

					'slide'   => 'Slide',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

		),

		'location' => array(

			array(

				array(

					'param'    => 'post_type',

					'operator' => '==',

					'value'    => 'product',

				),

			),

		),

		'menu_order'            => 0,

		'position'              => 'normal',

		'style'                 => 'default',

		'label_placement'       => 'top',

		'instruction_placement' => 'label',

		'hide_on_screen'        => '',

	) );



register_field_group( array(

		'key'    => 'group_540d713660823',

		'title'  => 'Product Category Setting',

		'fields' => array(

			array(

				'key'               => 'field_540d713666606',

				'label'             => 'Product categories',

				'name'              => '',

				'prefix'            => '',

				'type'              => 'tab',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

			),

			array(

				'key'               => 'field_540d71366660b',

				'label'             => 'Layout',

				'name'              => 'product_cat_layout',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'default'       => 'Default',

					'right_sidebar' => 'Right Sidebar',

					'left_sidebar'  => 'Left Sidebar',

					'no_sidebar'    => 'Fullwidth',

					'full_width'    => '100% width',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_540d71366660e',

				'label'             => 'Sidebar name',

				'name'              => 'product_cat_custom_sidebar',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_540d713666613',

				'label'             => 'Titlebar',

				'name'              => '',

				'prefix'            => '',

				'type'              => 'tab',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

			),

			array(

				'key'               => 'field_540d713666611',

				'label'             => 'Show/Hide titlebar',

				'name'              => 'product_cat_display_titlebar',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => 'Only support page layout "Full Width" and "No Sidebar"',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'show'  => 'Show',

					'hided' => 'Hide',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_540d713666618',

				'label'             => 'Top padding',

				'name'              => 'product_cat_padding_top',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => 'Unit: px (Ex: 10px)',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_540d71366661a',

				'label'             => 'Bottom padding',

				'name'              => 'product_cat_padding_bottom',

				'prefix'            => '',

				'type'              => 'text',

				'instructions'      => 'Unit: px (Ex: 10px)',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

				'placeholder'       => '',

				'prepend'           => '',

				'prepend'           => '',

				'maxlength'         => '',

				'readonly'          => 0,

				'disabled'          => 0,

			),

			array(

				'key'               => 'field_540d71366661c',

				'label'             => 'Background image',

				'name'              => 'product_cat_background_image',

				'prefix'            => '',

				'type'              => 'image',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'return_format'     => 'array',

				'preview_size'      => 'thumbnail',

				'library'           => 'all',

			),

			array(

				'key'               => 'field_540d71366661e',

				'label'             => 'Background color',

				'name'              => 'product_cat_background_color',

				'prefix'            => '',

				'type'              => 'color_picker',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

			),

			array(

				'key'               => 'field_540d713666623',

				'label'             => 'Background image position',

				'name'              => 'product_cat_background_position',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'left'   => 'Left',

					'right'  => 'Right',

					'center' => 'Center',

					'top'    => 'Top',

					'bottom' => 'Bottom',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_540d713666625',

				'label'             => 'Background image parallax',

				'name'              => 'product_cat_background_parallax',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'show'  => 'Show',

					'hided' => 'Hide',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_540d713666627',

				'label'             => 'Background parallax style',

				'name'              => 'product_cat_background_parallax_style',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					'style-1' => 'Style 1',

					'style-2' => 'Style 2',

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_540d713666629',

				'label'             => 'Titlebar shadow opacity',

				'name'              => 'product_cat_titlebar_shadow_opacity',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					0 => 0,

					'0.1' => '0.1',

					'0.2' => '0.2',

					'0.3' => '0.3',

					'0.4' => '0.4',

					'0.5' => '0.5',

					'0.6' => '0.6',

					'0.7' => '0.7',

					'0.8' => '0.8',

					'0.9' => '0.9',

					1 => 1,

				),

				'default_value' => 

					array(

						'0.5' => '0.5',

					),

				'allow_null'  => 0,

				'multiple'    => 0,

				'ui'          => 0,

				'ajax'        => 0,

				'placeholder' => '',

				'disabled'    => 0,

				'readonly'    => 0,

			),

			array(

				'key'               => 'field_540d71366662b',

				'label'             => 'Titlebar overlay opacity',

				'name'              => 'product_cat_titlebar_overlay_opacity',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					0 => 0,

					'0.1' => '0.1',

					'0.2' => '0.2',

					'0.3' => '0.3',

					'0.4' => '0.4',

					'0.5' => '0.5',

					'0.6' => '0.6',

					'0.7' => '0.7',

					'0.8' => '0.8',

					'0.9' => '0.9',

					1 => 1,

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_540d71366662d',

				'label'             => 'Titlebar clipmask opacity',

				'name'              => 'product_cat_titlebar_clipmask_opacity',

				'prefix'            => '',

				'type'              => 'select',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'choices' => array(

					0 => 0,

					'0.1' => '0.1',

					'0.2' => '0.2',

					'0.3' => '0.3',

					'0.4' => '0.4',

					'0.5' => '0.5',

					'0.6' => '0.6',

					'0.7' => '0.7',

					'0.8' => '0.8',

					'0.9' => '0.9',

					1 => 1,

				),

				'default_value' => array(),

				'allow_null'    => 0,

				'multiple'      => 0,

				'ui'            => 0,

				'ajax'          => 0,

				'placeholder'   => '',

				'disabled'      => 0,

				'readonly'      => 0,

			),

			array(

				'key'               => 'field_540d71366662f',

				'label'             => 'Titlebar custom content',

				'name'              => 'product_cat_titlebar_custom_content',

				'prefix'            => '',

				'type'              => 'wysiwyg',

				'instructions'      => '',

				'required'          => 0,

				'conditional_logic' => 0,

				'default_value'     => '',

				'tabs'              => 'all',

				'toolbar'           => 'full',

				'media_upload'      => 1,

			),

		),

		'location' => array(

			array(

				array(

					'param'    => 'taxonomy',

					'operator' => '==',

					'value'    => 'product_cat',

				),

			),

		),

		'menu_order'            => 0,

		'position'              => 'normal',

		'style'                 => 'default',

		'label_placement'       => 'top',

		'instruction_placement' => 'label',

		'hide_on_screen'        => '',

	) );

register_field_group(

		array(

			'key'    => 'group_99d8edf4beaff',

			'title'  => 'Produc Extra meta for single style -> ?',

			'fields' => array(

				array(

					'key'               => 'field_99e77e2f35e12',

					'label'             => 'Extra meta for single style -> ?',

					'name'              => '',

					'prefix'            => '',

					'type'              => 'tab',

					'instructions'      => '',

					'required'          => 0,

					'conditional_logic' => 0,

				),

				array(

					'key'               => 'field_99d8ee35180f4',

					'label'             => 'Text detail 1',

					'name'              => 'sing_product_text_1',

					'prefix'            => '',

					'type'              => 'wysiwyg',

				),

				array(

					'key'               => 'field_99d8djmnde',

					'label'             => 'Image product 1',

					'name'              => 'sing_product_img_1',

					'prefix'            => '',

					'type' 				=> 'image',

					'save_format' 		=> 'id',

					'preview_size' 		=> 'thumbnail',

				),



				array(

					'key'               => 'field_99d8ee3djmdnw',

					'label'             => 'Text detail 2',

					'name'              => 'sing_product_text_2',

					'prefix'            => '',

					'type'              => 'wysiwyg',

				),

				array(

					'key'               => 'field_99d8djdmnesa',

					'label'             => 'Image product 2',

					'name'              => 'sing_product_img_2',

					'prefix'            => '',

					'type' 				=> 'image',

					'save_format' 		=> 'id',

					'preview_size' 		=> 'thumbnail',

				),

			),

		'location' => array(

			array(

				array(

					'param'    => 'post_type',

					'operator' => '==',

					'value'    => 'product',

				),

			),

		),

		'menu_order'            => 1,

		'position'              => 'normal',

		'style'                 => 'default',

		'label_placement'       => 'top',

		'instruction_placement' => 'label',

		'hide_on_screen'        => '',

	)

);

endif;

