<?php

/**

 * Enqueue stylesheet.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link    http://www.sunrisetheme.com

 */

/**

 * AJAX Saving Options

 *

 * @since 1.0.0

 */

add_action( 'wp_ajax_of_ajax_post_action', 'of_ajax_callback' );



/*--------------------------------------------------------------

	Enqueue front-end inline script

--------------------------------------------------------------*/

if ( ! function_exists( 'k2t_skstore_front_end_enqueue_inline_script' ) ) :

	function k2t_skstore_front_end_enqueue_inline_script() {

		// Get theme options

		global $smof_data;



		if ( ! wp_script_is(' k2t-inline-scripts', 'scripts' ) ) {



			if ( isset( $smof_data['blog-style'] ) && 'timeline' == $smof_data['blog-style'] ) {

				echo '

				<scr' . 'ipt>

					jQuery(window).load(function($) {

						var $ = jQuery;

						function timeline_indicator() {

							var post = $( ".b-timeline" ).find( ".hentry" );

							$.each( post, function( i,obj ) {           

								var posLeft = $( obj ).css( "left" );

								if( posLeft == "0px" ) {

									$(obj).addClass( "post-left" );

								} else {

									$(obj).addClass( "post-right" );

								}

							});

						}



						// Pagination load more

						function timeline_pagination() {

							var $container = $( ".k2t-blog-timeline" );

							$container.isotope({

								itemSelector : ".hentry"

							}); 

							$container.infinitescroll({

								navSelector: ".nav-seemore-inner", // selector for the paged navigation

								nextSelector: ".nav-seemore-inner a", // selector for the NEXT link (to page 2)

								itemSelector: ".hentry", // selector for all items you"ll retrieve

								loading: {

									finishedMsg: "No more pages to load.",

									img: "http://i.imgur.com/qkKy8.gif"

								}

							},

								function( newElements ) {

									$container.isotope( "appended", $( newElements ) );

									timeline_indicator();

								} 

							);

						}



						var container = document.querySelector(".k2t-blog-timeline");

						var msnry = new Masonry( container, {

							itemSelector: ".hentry",

							columnWidth: container.querySelector(".hentry")

						});



						msnry.on( "layoutComplete", function() {

							timeline_indicator();

							timeline_pagination();

						});

						// manually trigger initial layout

						msnry.layout();

					});

				</scr' . 'ipt>';

			}



			global $wp_scripts;

			$wp_scripts->scripts[] = 'k2t-inline-scripts';

		}

	}

	add_action( 'wp_footer', 'k2t_skstore_front_end_enqueue_inline_script', 10000 );

endif;



// func change logo for default login page

function skstore_login_logo() {

	global $smof_data;

	if( isset( $smof_data['login_logo'] ) && $smof_data['login_logo'] != ''):

	?>

    <style type="text/css">

        .login h1 a {

            background: url(<?php echo esc_url( $smof_data['login_logo'] ); ?>) no-repeat center center !important;

            width: 100% !important;

            height: 80px !important;

        }

    </style>

<?php endif; }

add_action( 'login_enqueue_scripts', 'skstore_login_logo' );





/**

 * Create admin option page.

 *

 * @return  void

 */



function skstore_welcome_admin_menu() {

	global $submenu, $pagenow;



	if ( current_user_can( 'edit_theme_options' ) ) {

		$menu = 'add_menu_' . 'page';

		// Add page menu

		$menu(

			esc_html__( 'SKstore Welcome', 'skstore' ),

			esc_html__( 'SKstore Welcome', 'skstore' ),

			'manage_options',

			'skstore-welcome',

			array( 'skstore_welcome', 'html' ),

			get_template_directory_uri() . '/framework/assets/images/back-end-logo.png',

			2

		);



		// Add submenu

		$sub_menu = 'add_submenu_' . 'page';

		$sub_menu(

			'SKstore WP',

			esc_html__( ' Dashboard', 'skstore' ),

			esc_html__( 'Dashboard', 'skstore' ),

			'manage_options',

			'skstore-welcome',

			array( 'skstore_welcome', 'html' )

		);



	}



	// redirect to welcome page

	if ( is_admin() && 'themes.php' == $pagenow && isset( $_GET['activated'] ) && $_GET['activated'] == 'true' ) {

		wp_redirect( admin_url ( 'admin.php?page=skstore-welcome' ) );

	}



	skstore_welcome::initialize();

}



add_action( 'admin_menu', 'skstore_welcome_admin_menu' );







/*--------------------------------------------------------------

	Enqueue back-end script

--------------------------------------------------------------*/

if ( ! function_exists( 'k2t_skstore_admin_enqueue_script' ) ) :

	function k2t_skstore_admin_enqueue_script( $hook ) {

		wp_enqueue_media();

		wp_enqueue_script( 'k2t-media-load', get_template_directory_uri() . '/framework/assets/js/media-load.js', array(), '1.0', true );

		if ( 'nav-menus.php' == $hook ) {

	        wp_enqueue_script( 'k2t-megamenu', get_template_directory_uri() . '/framework/assets/js/megamenu.js', array(), '1.0', true );

		}

	}

	add_action( 'admin_enqueue_scripts', 'k2t_skstore_admin_enqueue_script' );

endif;



/*--------------------------------------------------------------

	Custom CSS

--------------------------------------------------------------*/

if ( ! function_exists( 'k2t_skstore_front_end_enqueue_inline_css' ) ) {

	function k2t_skstore_front_end_enqueue_inline_css() {

		global $smof_data, $content_width;



		$pre = '';

		if ( is_single() ) {

			$pre = 'single-';

		} elseif ( is_category() ) {

			$pre = 'blog-';

		}

		?>

		<style>



			<?php

			/* Content width

			------------------------------------------------- */

			if ( ! empty( $smof_data['boxed-layout'] ) ) {

				echo '

					.boxed .k2t-container { max-width: ' . $smof_data['use-content-width'] . 'px; }

				';

			} else {

				if ( isset ( $smof_data['use-content-width'] ) ) {

					echo '

						.k2t-wrap, .container { max-width: ' . $smof_data['use-content-width'] . 'px; }

					';

				}

			}





			/* Sidebar width

			------------------------------------------------- */

			$page_layout   = ( function_exists( 'get_field' ) ) ? get_field( 'page_layout', get_the_ID() ) : '';

			$sidebar_width = $smof_data['sidebar_width'];

			$page_sidebar_width = ( function_exists( 'get_field' ) ) ? get_field( 'page_sidebar_width', get_the_ID() ) : '';

			$page_sidebar_width = empty( $page_sidebar_width ) ? '' : $page_sidebar_width;

			if ( is_page() && ( $page_layout != 'left-sidebr' && $page_layout != 'right-sidebar' ) ) {

				if ( ! empty( $page_sidebar_width ) ) {

					echo '

						.k2t-sidebar, .k2t-sidebar-sub { width:' . $page_sidebar_width . '% !important; }

						.k2t-blog, .k2t-main { width:' . ( 100 - $page_sidebar_width ) . '% !important; }

					';

				}

			} else {

				if ( ! empty( $sidebar_width ) ) {

					echo '

						.k2t-sidebar, .k2t-sidebar-sub { width:' . $sidebar_width . '% !important; }

						.k2t-blog, .k2t-main {width:' . ( 100 - $sidebar_width ) . '% !important; }

					';

				}

			}



			/* Logo margin

			------------------------------------------------- */

			if ( isset ( $smof_data['logo-margin-top'] ) || isset ( $smof_data['logo-margin-left'] ) || isset ( $smof_data['logo-margin-right'] ) || isset ( $smof_data['logo-margin-bottom'] ) ) {

				echo '

					.k2t-logo { margin-top: ' . $smof_data['logo-margin-top'] . 'px !important;margin-left: ' . $smof_data['logo-margin-left'] . 'px !important;margin-right: ' . $smof_data['logo-margin-right'] . 'px !important;margin-bottom: ' . $smof_data['logo-margin-bottom'] . 'px !important; }

				';

			}



			/* Global color scheme

			------------------------------------------------- */

			if ( $smof_data['heading-color'] || $smof_data['heading-font'] ) {

				echo '

					h1, h2, h3, h4 { color: ' . $smof_data['heading-color'] . '; font-family: ' . $smof_data['heading-font'] . '; }

					.k2t-navigation ul li a,

					.k2t-navigation ul li span { font-family: ' . $smof_data['heading-font'] . '; }

				';

			}



			if ( $smof_data['link-color'] ) {

				echo '

					a { color: ' . $smof_data['link-color'] . '; }

				';

			}

			if ( $smof_data['link-hover-color'] ) {

				echo '

					a:hover, a:focus { color: ' . $smof_data['link-hover-color'] . '; }

				';

			}



			if ( $smof_data['main-menu-color'] ) {

				echo '

					.k2t-header-mid .k2t-menu li a,

					.k2t-header-mid .k2t-menu > li > a:hover, .k2t-header-mid .k2t-menu > li.current-menu-item > a, .k2t-header-mid .k2t-menu > li.current-menu-parent > a, .k2t-header-mid .k2t-menu > li.current-menu-ancestor > a { color: ' . $smof_data['main-menu-color'] . '!important; }

				';

			}

			if ( $smof_data['sub-menu-color'] ) {

				echo '

					.k2t-header-mid .k2t-menu li ul li a span::before,

					.k2t-header-mid .k2t-menu li ul li a { color: ' . $smof_data['sub-menu-color'] . ' !important; }

				';

			}



			if ( $smof_data['main-background-color'] ) {

				echo '

					.k2t-content, .k2t-body { background-color: ' . $smof_data['main-background-color'] . '; }

				';

			}



			/* Typography

			------------------------------------------------- */

			if ( $smof_data['body-font'] || $smof_data['body-size'] ) {

				echo '

					body { font-family: ' . $smof_data['body-font'] . '; font-size: ' . $smof_data['body-size'] . 'px; }

				';

			}

			if ( $smof_data['mainnav-font'] || $smof_data['mainnav-size'] ) {

				echo '

					.k2t-header-mid .k2t-menu,.k2t-header-mid .k2t-menu > li > a, .k2t-header .k2t-menu .mega-container ul, .vertical-menu .k2t-header-mid .k2t-menu { font-family: ' . $smof_data['mainnav-font'] . '; font-size: ' . $smof_data['mainnav-size'] . 'px; }

				';

			}

			if ( $smof_data['mainnav-text-transform'] ) {

				echo '

					.k2t-header-mid .k2t-menu > li > a { text-transform: ' . $smof_data['mainnav-text-transform'] . '; }

				';

			}

			if ( $smof_data['mainnav-font-weight'] ) {

				echo '

					.k2t-header-mid .k2t-menu > li > a { font-weight: ' . $smof_data['mainnav-font-weight'] . '; }

				';

			}

			if ( $smof_data['h1-size'] || $smof_data['h2-size'] || $smof_data['h3-size'] || $smof_data['h4-size'] || $smof_data['h5-size'] || $smof_data['h6-size'] ) {

				echo '

					h1 { font-size: ' . $smof_data['h1-size'] . 'px; }

					h2 { font-size: ' . $smof_data['h2-size'] . 'px; }

					h3 { font-size: ' . $smof_data['h3-size'] . 'px; }

					h4 { font-size: ' . $smof_data['h4-size'] . 'px; }

					h5 { font-size: ' . $smof_data['h5-size'] . 'px; }

					h6 { font-size: ' . $smof_data['h6-size'] . 'px; }

				';

			}

			if ( $smof_data['submenu-mainnav-size'] ) {

				echo '

					.k2t-header-mid .k2t-menu .sub-menu { font-size: ' . $smof_data['submenu-mainnav-size'] . 'px; }

				';

			}



			if ( function_exists( 'get_field' ) ) :

				/* Title bar style

				------------------------------------------------- */

				// Get post or page id

				if ( is_home() ) {

					$id = get_option( 'page_for_posts' );

				} else {

					$id = get_the_ID();

				}

				if ( get_field( 'titlebar_overlay_opacity', $id ) ) {

					echo '

						.k2t-title-bar .mask.colors { opacity: ' . get_field( 'titlebar_overlay_opacity', $id ) . '; }

					';

				} elseif ( ! empty( $smof_data[$pre . 'titlebar-overlay-opacity'] ) ) {

					echo '

						.k2t-title-bar .mask.colors { opacity: ' . $smof_data[$pre . 'titlebar-overlay-opacity'] / 10 . '; }

					';

				}

				if ( ! get_field( 'titlebar_shadow_opacity', $id ) ) {

					echo '

						.k2t-title-bar.shadow:after { opacity: ' . get_field( 'titlebar_shadow_opacity', $id ) . '; }

					';

				} elseif ( ! empty( $smof_data[$pre . 'titlebar-shadow-opacity'] ) ) {

					echo '

						.k2t-title-bar.shadow:after { opacity: ' . $smof_data[$pre . 'titlebar-shadow-opacity'] / 10 . '; }

					';

				}if ( get_field( 'titlebar_clipmask_opacity', $id ) ) {

					echo '

						.k2t-title-bar .mask.pattern { opacity: ' . get_field( 'titlebar_clipmask_opacity', $id ) . '; }

					';

				} elseif ( !empty( $smof_data[$pre . 'titlebar-clipmask-opacity'] ) ) {

					echo '

						.k2t-title-bar .mask.pattern { opacity: ' . $smof_data[$pre . 'titlebar-clipmask-opacity'] / 10 . '; }

					';

				}

				if ( get_field( 'background_parallax', $id ) ) {

					echo '

						.k2t-title-bar.parallax { background-size: cover; background-attachment: fixed; }

					';

				}



				/* Page layout

				------------------------------------------------- */

				$page_content_padding_top = ( function_exists( 'get_field' ) ) ? get_field( 'page_content_padding_top', $id ) : '';

				$page_content_padding_bottom = ( function_exists( 'get_field' ) ) ? get_field( 'page_content_padding_bottom', $id ) : '';

				if ( get_field( 'page_background_color', get_the_ID() ) ) {

					echo 'body { background-color: ' . get_field( 'page_background_color', get_the_ID() ) . '; }';

				}

				if ( $page_content_padding_top || $page_content_padding_bottom ) {

					if ( is_numeric( $page_content_padding_top ) ) {

						echo '.k2t-content .container > * { padding-top: ' . $page_content_padding_top . 'px;}';

					} else {

						echo '.k2t-content .container > * { padding-top: ' . $page_content_padding_top . ';}';

					}

					if ( is_numeric( $page_content_padding_bottom ) ) {

						echo '.k2t-content .container > * { padding-bottom: ' . $page_content_padding_bottom . 'px;}';

					} else {

						echo '.k2t-content .container > * { padding-bottom: ' . $page_content_padding_bottom . ';}';

					}

				}

			endif;



			/* Custom CSS

			------------------------------------------------- */

			if ( isset ( $smof_data['custom_css'] ) ) {

				$custom_css = $smof_data['custom_css'];

				echo $custom_css;

			}



			?>



			/* Primary color

			------------------------------------------------- */

			<?php if ( isset ( $smof_data['primary-color'] ) && ! empty( $smof_data['primary-color'] ) ) : ?>

			.button-border,

			.h-element i,

			.custom-login .login-from .not-a-member-handle,

			.wp-social-login-provider-list .wp-social-login-provider:hover:after,

			.search-box.style-2 .k2t-search-form #s,

			.search-box.style-2 .k2t-search-form .orig,

			.k2t-searchbox .searchsubmit:hover,

			.k2t-header-top a,

			.k2t-header-top .k2t-menu li a:hover,

			.k2t-header-mid .search-box:hover,

			.k2t-header-mid .social li a:hover,

			.k2t-header-mid .k2t-menu li > a.current,

			.k2t-header-bot a,

			.k2t-header-bot .social li a:hover,

			.k2t-breadcrumbs a:hover,

			.post-item .entry-title a:hover,

			.entry-box .entry-title a:hover,

			.post-item header span a:hover,

			.entry-box header span a:hover,

			.entry-box footer a.post,

			.about-author .author-role,

			.user-social li:hover i,

			.comment-body .comment-reply-link:hover,

			.comment-body .comment-edit-link:hover,

			.form-submit #submit label.error,

			#response,

			.wpb_video_wrapper #player .title a,

			.error-404-des a:hover,

			.widget_shopping_cart .widget-title:after,

			.widget ul li a:hover,

			.widget ul li.current-cat a,

			.widget .posts-list .post-item h4 a:hover,

			.k2t-footer .k2t-top-footer .null-instagram-feed .clear:hover a,

			.k2t-footer .k2t-bottom .null-instagram-feed .clear a:hover:before,

			.k2t-footer .k2t-wrap .k2t-row > div a:hover,

			.k2t-info a:hover,

			.k2t-info .row > div .social a,

			.social-open,

			#close-canvas:after,

			.light-footer .k2t-footer .k2t-bottom .widget-title,

			.dhvc-woo-info .dhvc-woo-title a:hover,

			.woocommerce .social li a:hover i,

			.woocommerce table.shop_table td.product-name a:hover,

			.woocommerce table.shop_table td.product-subtotal span,

			.woocommerce .cart-collaterals .cart_totals table tr.cart-subtotal td,

			.woocommerce .cart-collaterals .cart_totals table tr.order-total td,

			.woocommerce .product .p-title a:hover,

			.woocommerce .product .p-cat a:hover,

			.woocommerce div.product .price ins .amount,

			.woocommerce div.product .price > .amount,

			.shop-cart .shop-item ul.product_list_widget li a:hover,

			.woocommerce div.product .price  ins .amount,

			.woocommerce div.product .price > .amount,

			.k2t-iconbox-list:not(.style-3) li:hover .title,

			.k2t-iconbox.layout-1 .iconbox-icon,

			.k2t-iconbox.layout-1 .iconbox-image,

			.k2t-iconbox.layout-2 > .iconbox-icon:hover,

			.k2t-iconbox.layout-3 .title .h,

			.k2t-process.style-line .featured.k2t-step .step-count,

			.k2t-process.style-line .featured.k2t-step .step-inner:before,

			.k2t-progress .percent > .icon,

			.k2t-progress .percent > .icon,

			.toggle-title:hover i.defaut-icon,

			.toggle-title:hover *,

			.k2t-button .k2t-btn.has-icon i,

			.k2t-accordion.style-2 .toggle-title.open a > *,

			.k2t-accordion.style-3 .toggle-title.open a > *,

			.k2t-testimonial.style-3 .testimonial-author,

			.wpb_content_element.wpb_tabs.outline .wpb_tabs_nav li.ui-tabs-active,

			.wpb_content_element.wpb_tabs.outline .wpb_tabs_nav li.ui-tabs-active *,

			.wpb_content_element.wpb_tabs.outline .wpb_tabs_nav li:hover,

			.wpb_content_element.wpb_tabs.outline .wpb_tabs_nav li:hover *,

			.wpb_content_element.wpb_tabs.solid .wpb_tabs_nav li.ui-tabs-active a,

			.wpb_content_element.wpb_tabs.solid .wpb_tabs_nav li:hover a ,

			.wpb_content_element.wpb_tabs.solid .wpb_tabs_nav li.ui-tabs-active a i,

			.wpb_content_element.wpb_tabs.solid .wpb_tabs_nav li:hover a i,

			.wpb_content_element.wpb_tabs.bottom_line .wpb_tabs_nav li:hover a,

			.wpb_content_element.wpb_tabs.bottom_line .wpb_tabs_nav li.ui-tabs-active a,

			.wpb_content_element.wpb_tabs.bottom_line .wpb_tabs_nav li:hover a i,

			.wpb_content_element.wpb_tabs.bottom_line .wpb_tabs_nav li.ui-tabs-active a i,

			.wpb_tour.wpb_content_element .wpb_tour_tabs_wrapper .wpb_tabs_nav > li.ui-tabs-active > a,

			.wpb_tour.wpb_content_element .wpb_tour_tabs_wrapper .wpb_tabs_nav > li:hover > a,

			.wpb_tour.wpb_content_element.outline .wpb_tour_tabs_wrapper .wpb_tabs_nav > li:hover a,

			.wpb_teaser_sk .post-title:hover, .wpb_teaser_sk .post-title:hover a,

			.k2t-blog-post .post-content > h3 a:hover,

			.k2t-countdown .ele .unit,

			.k2t-heading .h span.heading-style,

			.woocommerce .product-related div.products  .text-heading span.heading-style,

			.vc_tta-container .vc_tta-panels .woocommerce.columns-4 .product-item .product-thumb .wrap-3-button .button:hover:before,

			.vc_tta-container .vc_tta-panels .woocommerce.columns-4 .product-item .product-thumb .wrap-3-button a.click-fullscreen:hover:before,

			.product-item .product-name .price ins span, .product-item .product-name .price span,

			.k2t-header-mid .k2t-menu li ul > li:hover > a span, .k2t-header-mid .k2t-menu li ul > li.current-menu-item > a span, .k2t-header-mid .k2t-menu li ul > li.current-menu-ancestor > a span,

			.k2t-header.header-horizontal .k2t-menu li.is_purchase a span:after, .yith-wcwl-add-to-wishlist:hover .yith-wcwl-wishlistexistsbrowse a:before, .yith-wcwl-add-to-wishlist:hover .yith-wcwl-add-button a:before, .widget_tag_cloud .tagcloud a:hover, .widget.widget_tag_cloud .tagcloud a:hover, .k2t-shop .products .product-item .product-thumb:hover a:hover:before,

			.dhvc-woo-images .dhvc-woo-quickview a:hover:before,

			.dhvc-woo-list-item .dhvc-woo-images .add-to-cart:hover a:before,

			.dhvc-woo-grid-item .dhvc-woo-images .add-to-cart:hover a:before,

			.woocommerce .cart-collaterals .cart_totals .shop_table .shipping .shipping-calculator-form  p  button:hover,

			.woocommerce .social li a:hover i:before,

			.woocommerce div.product .price del .amount,

			.woocommerce table.shop_table td.product-price span, .woocommerce-page table.shop_table td.product-price span,

			.header-social-share .header-social a:hover span

			{

				color: <?php echo esc_html( $smof_data['primary-color'] ) ?>;

			}



			.yith-wcwl-add-to-wishlist:hover .yith-wcwl-wishlistexistsbrowse a:before, .yith-wcwl-add-to-wishlist:hover .yith-wcwl-add-button a:before,

			.woocommerce-page .cart-collaterals .cart_totals table.shop_table .order-total td, .woocommerce-page .cart-collaterals .cart_totals table.shop_table .order-total td *,

			.dhvc-woo-price .amount,

			.k2t-header.header-vertical .k2t-menu li.is_purchase a:before,

			.dhvc-woo-images .yith-wcwl-add-to-wishlist:hover .yith-wcwl-wishlistexistsbrowse a:before, .dhvc-woo-images .yith-wcwl-add-to-wishlist:hover .yith-wcwl-add-button a:before,

			.left-sidebar .dhvc-woo-list-item:hover .dhvc-woo-info .dhvc-woo-title a, .right-sidebar .dhvc-woo-list-item:hover .dhvc-woo-info .dhvc-woo-title a,

			.woocommerce a.remove:hover {

				color: <?php echo esc_html( $smof_data['primary-color'] ) ?> ! important;

			}



			button, input[type="button"]:hover,

			input[type="reset"]:hover,

			input[type="submit"]:hover,

			.button-border:hover,

			.k2t-navigation ul li span.current,

			.k2t-navigation ul li:hover a,

			.widget .searchform .searchsubmit:hover,

			.k2t-btt:hover,

			.wpcf7 input.wpcf7-submit:hover,

			.social li a:hover,

			#uwpqsf_id .uwpqsf_class input#uwpqsf_id_btn:hover,

			.wpb_alert.wpb_content_element.wpb_alert-info,

			.ig_popup.ig_inspire input[type="submit"],

			.k2t-title-bar .searchform .searchsubmit,

			.form-submit #submit:hover,

			.k2t-info .row > div .social a,

			.woocommerce .product .p-info .button:hover,

			.woocommerce .product .p-info .added_to_cart:hover,

			.woocommerce #content input.button,

			.woocommerce #respond input#submit:hover,

			.woocommerce input.button:hover,

			.woocommerce div.product form.cart .button:hover,

			.woocommerce-page div.product form.cart .button:hover,

			.woocommerce .widget_layered_nav ul li.chosen a,

			.woocommerce-page .widget_layered_nav ul li.chosen a,

			.woocommerce div.product .variations .variations_button .button:hover,

			.woocommerce div.product .cart .button:hover,

			.product-tab.wpb_tabs .wpb_tabs_nav li.ui-state-active a,

			.woocommerce.columns-3 .product-item .product-thumb .button:hover,

			.k2t-btn,

			.k2t-button a:hover,

			.k2t-button:hover a,

			.k2t-iconbox-list.style-2 li:hover .iconbox-list-icon i,

			.k2t-iconbox-list.style-3 li:hover .iconbox-list-icon i,

			.k2t-process.style-box .k2t-step.featured,

			.pricing-footer .k2t-button a:hover,

			.pricing-special span,

			.k2t-header-bot .k2t-menu > li.children > a:hover:before,

			.k2t-header-bot .k2t-menu > li.children > a:hover:after,

			#simple-subscribe-style2 .widgetGuts.shortcode #frm-subscriptionFront .subscribeButton.button:hover,

			.dhvc-woo-list-item .dhvc-woo-addtocart a.added_to_cart.wc-forward,

			.woocommerce nav.woocommerce-pagination ul li a:focus,

			.woocommerce nav.woocommerce-pagination ul li a:hover,

			.woocommerce nav.woocommerce-pagination ul li span.current,

			.select2-results .select2-highlighted,

			.k2t-accordion .toggle-title:hover .defaut-icon:after,

			.k2t-accordion .toggle-title:hover .defaut-icon:before,

			.k2t-accordion.style-1 .toggle-title.open,

			.iview div.iview-directionNav a.iview-nextNav,

			.iview div.iview-directionNav a.iview-prevNav,

			.custom-link,

			.woocommerce #content input.button:hover,

			.woocommerce #respond input#submit:hover,

			.woocommerce a.button:hover,

			.woocommerce button.button:hover,

			.woocommerce input.button:hover,

			.woocommerce-page #content input.button:hover,

			.woocommerce-page a.button:hover,

			.woocommerce-page button.button:hover,

			.woocommerce-page input.button:hover,

			.woocommerce #content input.button.alt:hover,

			.woocommerce #respond input#submit.alt:hover,

			.woocommerce a.button.alt:hover,

			.woocommerce button.button.alt:hover,

			.woocommerce input.button.alt:hover,

			.woocommerce-page #content input.button.alt:hover,

			.woocommerce-page a.button.alt:hover,

			.woocommerce-page button.button.alt:hover,

			.woocommerce-page input.button.alt:hover,

			.woocommerce #content div.product form.cart .button,

			.woocommerce-page #content div.product form.cart .button,

			.quick_view_ultimate_container .quick_view_ultimate_button:hover:before,

			.product-item .product-thumb:hover a.click-fullscreen:hover:before,

			.woocommerce ul.products li.product .onsale.soldout,

			.woocommerce-page ul.products li.product .onsale.soldout,

			.single-product.woocommerce span.onsale.soldout,

			.woocommerce span.onsale, .woocommerce-page span.onsale.soldout,

			article.product-item div.product-thumb span.onsale,

			.woocommerce ul.products li.product .onsale,

			.woocommerce-page ul.products li.product .onsale,

			.single-product.woocommerce span.onsale,

			.woocommerce span.onsale, .woocommerce-page span.onsale,

			.k2t-slick-slider .product-item .product-thumb .button:hover,

			.k2t-slick-slider .product-item:hover .product-thumb .yith-wcwl-add-to-wishlist:hover,

			.k2t-slick-slider .product-item:hover .product-thumb .yith-wcwl-wishlistexistsbrowse:hover,

			.k2t-slick-slider .product-item:hover .product-thumb .yith-wcwl-wishlistaddedbrowse:hover,

			.k2t-slick-slider .product-item .product-thumb a.click-fullscreen:hover, #close-canvas, .shop-cart .cart-control span, .k2t-iconbox.layout-1:hover .iconbox-image, .null-instagram-feed ul li a:after,

			.k2t-header .k2t-menu .mega-container .k2t-megamenu-submenu > a span:after,.k2t-header-mid .k2t-menu > .k2t-megamenu > a > span.k2t-title-menu:before,

			.k2t-header-mid .k2t-menu > li > a > span.k2t-title-menu:before,

			.b-masonry .masonry-layout.column-2 .hentry:hover .post-article-inner, .post-item .flx-entry-thumb .mask, .post-item .post-thumb .mask,

			.k2t-shop-sidebar .widget-title:hover,

			.woocommerce input.button:hover:disabled, .woocommerce input.button:hover:disabled[disabled],

			.header-social-share .header-social a:hover i

			{

				background-color: <?php echo esc_html( $smof_data['primary-color'] ) ?>;

			}



			.left-sidebar .dhvc-woo-pagination a.next:hover, .left-sidebar .dhvc-woo-pagination a.prev:hover, .right-sidebar .dhvc-woo-pagination a.next:hover, .right-sidebar .dhvc-woo-pagination a.prev:hover, .no-sidebar .dhvc-woo-pagination a.next:hover, .no-sidebar .dhvc-woo-pagination a.prev:hover{

				background: <?php echo esc_html( $smof_data['primary-color'] ); ?> !important;

			}



			article.product-item div.product-thumb span.onsale:after, .woocommerce ul.products li.product .onsale:after, .woocommerce-page ul.products li.product .onsale:after, .single-product.woocommerce span.onsale:after, .woocommerce span.onsale:after, .woocommerce-page span.onsale:after{

				border-right-color: <?php echo esc_html( $smof_data['primary-color'] ); ?>

			}



			.dhvc-woo-images .dhvc-woo-quickview a:hover:before,

			.dhvc-woo-grid-item .dhvc-woo-images .add-to-cart:hover a:before,

			.yith-wcwl-add-to-wishlist:hover .yith-wcwl-wishlistexistsbrowse a:before, .yith-wcwl-add-to-wishlist:hover .yith-wcwl-add-button a:before,

			.dhvc-woo-images .yith-wcwl-add-to-wishlist:hover .yith-wcwl-wishlistexistsbrowse a:before, .dhvc-woo-images .yith-wcwl-add-to-wishlist:hover .yith-wcwl-add-button a:before, {

				color: <?php echo esc_html( $smof_data['primary-color'] ); ?> !important;

			}



			.dhvc-woo-pagination .current,.dhvc-woo-pagination a:hover,

			.k2t-accordion.style-2 .toggle-title.open i.defaut-icon:after,

			.k2t-accordion.style-2 .toggle-title.open i.defaut-icon:before,

			.k2t-accordion.style-3 .toggle-title.open i.defaut-icon:after,

			.k2t-accordion.style-3 .toggle-title.open i.defaut-icon:before

			{

				background-color: <?php echo esc_html( $smof_data['primary-color'] ) ?> ! important;

			}



			.wpcf7 input:focus,

			.wpcf7 textarea:focus,

			.wpcf7 select:focus,

			.button-border,

			.custom-login .login-from .not-a-member-handle,

			.social-open,

			.widget_tag_cloud .tagcloud a:hover ,

			.widget.widget_tag_cloud .tagcloud a:hover

			#frm-subscriptionFront #frm-email:focus,

			.woocommerce .quantity input.qty:focus,

			.k2t-iconbox.layout-3:hover .iconbox-icon i,

			.pricing-footer .k2t-button a,

			.pricing-footer .k2t-button a:hover,

			.search-no-results .searchform .form-group input:focus,

			.wpb_content_element.wpb_tabs.outline .wpb_tabs_nav li.ui-tabs-active,

			.k2t-header.header-vertical .k2t-header-mid .k2t-menu > li:hover, .k2t-iconbox.layout-1 .iconbox-icon, .k2t-iconbox.layout-1 .iconbox-image,

			.k2t-accordion.style-2 .toggle-title.open, .k2t-accordion.style-2 .toggle-title.open .defaut-icon,

			.k2t-accordion.style-3 .toggle-title.open, .k2t-accordion.style-3 .toggle-title.open .defaut-icon,

			.k2t-slick-slider .product-item .product-thumb .button:hover,

			.k2t-slick-slider .product-item:hover .product-thumb .button:hover, .k2t-slick-slider .product-item:hover .product-thumb .yith-wcwl-add-to-wishlist:hover, .k2t-slick-slider .product-item:hover .product-thumb .yith-wcwl-wishlistexistsbrowse:hover, .k2t-slick-slider .product-item:hover .product-thumb .yith-wcwl-wishlistaddedbrowse:hover, .k2t-slick-slider .product-item .product-thumb:hover a.click-fullscreen:hover,

			.vc_tta-container .vc_tta-panels .woocommerce.columns-4 .k2t-product-page .product-item:hover .product-thumb,

			.product-item .product-thumb:hover,

			.dhvc-woo-item:hover .dhvc-woo-images:before,

			.woocommerce-billing-fields > h3:after, .woocommerce-shipping-fields > h3:after, .woocommerce-checkout-review-order > h3:after,

			input[type="text"]:focus, input[type="email"]:focus, input[type="url"]:focus, input[type="password"]:focus, input[type="search"]:focus

			{

				border-color: <?php echo esc_html( $smof_data['primary-color'] ) ?>;

			}

			.k2t-sidebar .widget-title,

			.grid-1-columns .dhvc-woo-grid-list .dhvc-woo-grid-item:hover, .k2t-header.header-vertical .k2t-header-mid .k2t-menu .current-menu-ancestor,

			.grid-2-columns .dhvc-woo-grid-list .dhvc-woo-grid-item:hover

			{

				border-color: <?php echo esc_html( $smof_data['primary-color'] ) ?> !important;

			}



			<?php endif; ?>



			<?php if ( isset ( $smof_data['heading-color'] ) && ! empty( $smof_data['heading-color'] ) )  : ?>

			.post-item .entry-title a,

			.entry-box .entry-title a {

				color: <?php echo esc_html( $smof_data['heading-color'] ) ?>;

			}

			.widget_shopping_cart,

			.wpcf7 input,

			.wpcf7 textarea,

			.wpcf7 select,

			.cart-coupon .coupon #coupon_code,

			.woocommerce form .form-row input.input-text,

			.woocommerce form .form-row textarea,

			.woocommerce-page form .form-row input.input-text,

			.woocommerce-page form .form-row textarea,

			.select2-container .select2-choice,

			.k2t-iconbox.layout-2.dashed .iconbox-icon,

			.toggle-title i.defaut-icon,

			.k2t-accordion.style-1 .toggle-title,

			.k2t-accordion.style-3 .toggle-title,

			.k2t-big-tab .tabnav li a  {

				border-color: <?php echo esc_html( $smof_data['heading-color'] ) ?>;



			}



			<?php endif; ?>



			<?php if ( isset ( $smof_data['text-color'] ) && ! empty( $smof_data['text-color'] ) )  : ?>

			body, input, select, textarea,

			.user-social li i,

			.comment-body .comment-meta > a,

			.error-404-des,

			.error-404-des a,

			.error-404-copy,

			.k2t-footer .k2t-top-footer .null-instagram-feed .clear a,

			.ig_message p,

			.list-style1 ul li,

			.list-style1 ul li > *,

			input[type="text"],

			input[type="email"],

			input[type="url"],

			input[type="password"],

			input[type="search"],

			textarea {

				color: <?php echo esc_html( $smof_data['text-color'] ) ?>;

			}

			<?php endif; ?>



		</style>

	<?php }

	add_action( 'wp_head','k2t_skstore_front_end_enqueue_inline_css' );

}



/*--------------------------------------------------------------

	Enqueue theme style

--------------------------------------------------------------*/

if ( ! function_exists( 'k2t_skstore_enqueue_theme_style' ) ) {

	function k2t_skstore_enqueue_theme_style() {

		global $wp_styles, $smof_data;





	}

	add_action( 'wp_enqueue_scripts', 'k2t_skstore_enqueue_theme_style' );

}

if ( class_exists( 'Vc_Manager' ) ) :

	vc_set_as_theme( true );

endif;



/*-------------------------------------------------------------------

	Map for Visual Composer Shortcode.

--------------------------------------------------------------------*/

if ( class_exists( 'Vc_Manager' ) ) :

	if ( ! function_exists( 'k2t_vc_map_shortcodes' ) ) :



		function k2t_vc_map_shortcodes() {



			$k2t_icon = array( '', 'fa fa-glass', 'fa fa-music', 'fa fa-search', 'fa fa-enskpe-o', 'fa fa-heart', 'fa fa-star', 'fa fa-star-o', 'fa fa-user', 'fa fa-film', 'fa fa-th-large', 'fa fa-th', 'fa fa-th-list', 'fa fa-check', 'fa fa-remove', 'fa fa-close', 'fa fa-times', 'fa fa-search-plus', 'fa fa-search-minus', 'fa fa-power-off', 'fa fa-signal', 'fa fa-gear', 'fa fa-cog', 'fa fa-trash-o', 'fa fa-home', 'fa fa-file-o', 'fa fa-clock-o', 'fa fa-road', 'fa fa-download', 'fa fa-arrow-circle-o-down', 'fa fa-arrow-circle-o-up', 'fa fa-inbox', 'fa fa-play-circle-o', 'fa fa-rotate-right', 'fa fa-repeat', 'fa fa-refresh', 'fa fa-list-alt', 'fa fa-lock', 'fa fa-flag', 'fa fa-headphones', 'fa fa-volume-off', 'fa fa-volume-down', 'fa fa-volume-up', 'fa fa-qrcode', 'fa fa-barcode', 'fa fa-tag', 'fa fa-tags', 'fa fa-book', 'fa fa-bookmark', 'fa fa-print', 'fa fa-camera', 'fa fa-font', 'fa fa-bold', 'fa fa-italic', 'fa fa-text-height', 'fa fa-text-width', 'fa fa-align-left', 'fa fa-align-center', 'fa fa-align-right', 'fa fa-align-justify', 'fa fa-list', 'fa fa-dedent', 'fa fa-outdent', 'fa fa-indent', 'fa fa-video-camera', 'fa fa-photo', 'fa fa-image', 'fa fa-picture-o', 'fa fa-pencil', 'fa fa-map-marker', 'fa fa-adjust', 'fa fa-tint', 'fa fa-edit', 'fa fa-pencil-square-o', 'fa fa-share-square-o', 'fa fa-check-square-o', 'fa fa-arrows', 'fa fa-step-backward', 'fa fa-fast-backward', 'fa fa-backward', 'fa fa-play', 'fa fa-pause', 'fa fa-stop', 'fa fa-forward', 'fa fa-fast-forward', 'fa fa-step-forward', 'fa fa-eject', 'fa fa-chevron-left', 'fa fa-chevron-right', 'fa fa-plus-circle', 'fa fa-minus-circle', 'fa fa-times-circle', 'fa fa-check-circle', 'fa fa-question-circle', 'fa fa-info-circle', 'fa fa-crosshairs', 'fa fa-times-circle-o', 'fa fa-check-circle-o', 'fa fa-ban', 'fa fa-arrow-left', 'fa fa-arrow-right', 'fa fa-arrow-up', 'fa fa-arrow-down', 'fa fa-mail-forward', 'fa fa-share', 'fa fa-expand', 'fa fa-compress', 'fa fa-plus', 'fa fa-minus', 'fa fa-asterisk', 'fa fa-exclamation-circle', 'fa fa-gift', 'fa fa-leaf', 'fa fa-fire', 'fa fa-eye', 'fa fa-eye-slash', 'fa fa-warning', 'fa fa-exclamation-triangle', 'fa fa-plane', 'fa fa-calendar', 'fa fa-random', 'fa fa-comment', 'fa fa-magnet', 'fa fa-chevron-up', 'fa fa-chevron-down', 'fa fa-retweet', 'fa fa-shopping-cart', 'fa fa-folder', 'fa fa-folder-open', 'fa fa-arrows-v', 'fa fa-arrows-h', 'fa fa-bar-chart-o', 'fa fa-bar-chart', 'fa fa-twitter-square', 'fa fa-facebook-square', 'fa fa-camera-retro', 'fa fa-key', 'fa fa-gears', 'fa fa-cogs', 'fa fa-comments', 'fa fa-thumbs-o-up', 'fa fa-thumbs-o-down', 'fa fa-star-half', 'fa fa-heart-o', 'fa fa-sign-out', 'fa fa-linkedin-square', 'fa fa-thumb-tack', 'fa fa-external-link', 'fa fa-sign-in', 'fa fa-trophy', 'fa fa-github-square', 'fa fa-upload', 'fa fa-lemon-o', 'fa fa-phone', 'fa fa-square-o', 'fa fa-bookmark-o', 'fa fa-phone-square', 'fa fa-twitter', 'fa fa-facebook', 'fa fa-github', 'fa fa-unlock', 'fa fa-credit-card', 'fa fa-rss', 'fa fa-hdd-o', 'fa fa-bullhorn', 'fa fa-bell', 'fa fa-certificate', 'fa fa-hand-o-right', 'fa fa-hand-o-left', 'fa fa-hand-o-up', 'fa fa-hand-o-down', 'fa fa-arrow-circle-left', 'fa fa-arrow-circle-right', 'fa fa-arrow-circle-up', 'fa fa-arrow-circle-down', 'fa fa-globe', 'fa fa-wrench', 'fa fa-tasks', 'fa fa-filter', 'fa fa-briefcase', 'fa fa-arrows-alt', 'fa fa-group', 'fa fa-users', 'fa fa-chain', 'fa fa-link', 'fa fa-cloud', 'fa fa-flask', 'fa fa-cut', 'fa fa-scissors', 'fa fa-copy', 'fa fa-files-o', 'fa fa-paperclip', 'fa fa-save', 'fa fa-floppy-o', 'fa fa-square', 'fa fa-navicon', 'fa fa-reorder', 'fa fa-bars', 'fa fa-list-ul', 'fa fa-list-ol', 'fa fa-strikethrough', 'fa fa-underline', 'fa fa-table', 'fa fa-magic', 'fa fa-truck', 'fa fa-pinterest', 'fa fa-pinterest-square', 'fa fa-google-plus-square', 'fa fa-google-plus', 'fa fa-money', 'fa fa-caret-down', 'fa fa-caret-up', 'fa fa-caret-left', 'fa fa-caret-right', 'fa fa-columns', 'fa fa-unsorted', 'fa fa-sort', 'fa fa-sort-down', 'fa fa-sort-desc', 'fa fa-sort-up', 'fa fa-sort-asc', 'fa fa-enskpe', 'fa fa-linkedin', 'fa fa-rotate-left', 'fa fa-undo', 'fa fa-legal', 'fa fa-gavel', 'fa fa-dashboard', 'fa fa-tachometer', 'fa fa-comment-o', 'fa fa-comments-o', 'fa fa-flash', 'fa fa-bolt', 'fa fa-sitemap', 'fa fa-umbrella', 'fa fa-paste', 'fa fa-clipboard', 'fa fa-lightbulb-o', 'fa fa-exchange', 'fa fa-cloud-download', 'fa fa-cloud-upload', 'fa fa-user-md', 'fa fa-stethoscope', 'fa fa-suitcase', 'fa fa-bell-o', 'fa fa-coffee', 'fa fa-cutlery', 'fa fa-file-text-o', 'fa fa-building-o', 'fa fa-hospital-o', 'fa fa-ambulance', 'fa fa-medkit', 'fa fa-fighter-jet', 'fa fa-beer', 'fa fa-h-square', 'fa fa-plus-square', 'fa fa-angle-double-left', 'fa fa-angle-double-right', 'fa fa-angle-double-up', 'fa fa-angle-double-down', 'fa fa-angle-left', 'fa fa-angle-right', 'fa fa-angle-up', 'fa fa-angle-down', 'fa fa-desktop', 'fa fa-laptop', 'fa fa-tablet', 'fa fa-mobile-phone', 'fa fa-mobile', 'fa fa-circle-o', 'fa fa-quote-left', 'fa fa-quote-right', 'fa fa-spinner', 'fa fa-circle', 'fa fa-mail-reply', 'fa fa-reply', 'fa fa-github-alt', 'fa fa-folder-o', 'fa fa-folder-open-o', 'fa fa-smile-o', 'fa fa-frown-o', 'fa fa-meh-o', 'fa fa-gamepad', 'fa fa-keyboard-o', 'fa fa-flag-o', 'fa fa-flag-checkered', 'fa fa-terminal', 'fa fa-code', 'fa fa-mail-reply-all', 'fa fa-reply-all', 'fa fa-star-half-empty', 'fa fa-star-half-full', 'fa fa-star-half-o', 'fa fa-location-arrow', 'fa fa-crop', 'fa fa-code-fork', 'fa fa-unlink', 'fa fa-chain-broken', 'fa fa-question', 'fa fa-info', 'fa fa-exclamation', 'fa fa-superscript', 'fa fa-subscript', 'fa fa-eraser', 'fa fa-puzzle-piece', 'fa fa-microphone', 'fa fa-microphone-slash', 'fa fa-shield', 'fa fa-calendar-o', 'fa fa-fire-extinguisher', 'fa fa-rocket', 'fa fa-maxcdn', 'fa fa-chevron-circle-left', 'fa fa-chevron-circle-right', 'fa fa-chevron-circle-up', 'fa fa-chevron-circle-down', 'fa fa-html5', 'fa fa-css3', 'fa fa-anchor', 'fa fa-unlock-alt', 'fa fa-bullseye', 'fa fa-ellipsis-h', 'fa fa-ellipsis-v', 'fa fa-rss-square', 'fa fa-play-circle', 'fa fa-ticket', 'fa fa-minus-square', 'fa fa-minus-square-o', 'fa fa-level-up', 'fa fa-level-down', 'fa fa-check-square', 'fa fa-pencil-square', 'fa fa-external-link-square', 'fa fa-share-square', 'fa fa-compass', 'fa fa-toggle-down', 'fa fa-caret-square-o-down', 'fa fa-toggle-up', 'fa fa-caret-square-o-up', 'fa fa-toggle-right', 'fa fa-caret-square-o-right', 'fa fa-euro', 'fa fa-eur', 'fa fa-gbp', 'fa fa-dollar', 'fa fa-usd', 'fa fa-rupee', 'fa fa-inr', 'fa fa-cny', 'fa fa-rmb', 'fa fa-yen', 'fa fa-jpy', 'fa fa-ruble', 'fa fa-rouble', 'fa fa-rub', 'fa fa-won', 'fa fa-krw', 'fa fa-bitcoin', 'fa fa-btc', 'fa fa-file', 'fa fa-file-text', 'fa fa-sort-alpha-asc', 'fa fa-sort-alpha-desc', 'fa fa-sort-amount-asc', 'fa fa-sort-amount-desc', 'fa fa-sort-numeric-asc', 'fa fa-sort-numeric-desc', 'fa fa-thumbs-up', 'fa fa-thumbs-down', 'fa fa-youtube-square', 'fa fa-youtube', 'fa fa-xing', 'fa fa-xing-square', 'fa fa-youtube-play', 'fa fa-dropbox', 'fa fa-stack-overflow', 'fa fa-instagram', 'fa fa-flickr', 'fa fa-adn', 'fa fa-bitbucket', 'fa fa-bitbucket-square', 'fa fa-tumblr', 'fa fa-tumblr-square', 'fa fa-long-arrow-down', 'fa fa-long-arrow-up', 'fa fa-long-arrow-left', 'fa fa-long-arrow-right', 'fa fa-apple', 'fa fa-windows', 'fa fa-android', 'fa fa-linux', 'fa fa-dribbble', 'fa fa-skype', 'fa fa-foursquare', 'fa fa-trello', 'fa fa-female', 'fa fa-male', 'fa fa-gittip', 'fa fa-sun-o', 'fa fa-moon-o', 'fa fa-archive', 'fa fa-bug', 'fa fa-vk', 'fa fa-weibo', 'fa fa-renren', 'fa fa-pagelines', 'fa fa-stack-exchange', 'fa fa-arrow-circle-o-right', 'fa fa-arrow-circle-o-left', 'fa fa-toggle-left', 'fa fa-caret-square-o-left', 'fa fa-dot-circle-o', 'fa fa-wheelchair', 'fa fa-vimeo-square', 'fa fa-turkish-lira', 'fa fa-try', 'fa fa-plus-square-o', 'fa fa-space-shuttle', 'fa fa-slack', 'fa fa-enskpe-square', 'fa fa-wordpress', 'fa fa-openid', 'fa fa-institution', 'fa fa-bank', 'fa fa-university', 'fa fa-mortar-board', 'fa fa-graduation-cap', 'fa fa-yahoo', 'fa fa-google', 'fa fa-reddit', 'fa fa-reddit-square', 'fa fa-stumbleupon-circle', 'fa fa-stumbleupon', 'fa fa-delicious', 'fa fa-digg', 'fa fa-pied-piper', 'fa fa-pied-piper-alt', 'fa fa-drupal', 'fa fa-joomla', 'fa fa-language', 'fa fa-fax', 'fa fa-building', 'fa fa-child', 'fa fa-paw', 'fa fa-spoon', 'fa fa-cube', 'fa fa-cubes', 'fa fa-behance', 'fa fa-behance-square', 'fa fa-steam', 'fa fa-steam-square', 'fa fa-recycle', 'fa fa-automobile', 'fa fa-car', 'fa fa-cab', 'fa fa-taxi', 'fa fa-tree', 'fa fa-spotify', 'fa fa-deviantart', 'fa fa-soundcloud', 'fa fa-database', 'fa fa-file-pdf-o', 'fa fa-file-word-o', 'fa fa-file-excel-o', 'fa fa-file-powerpoint-o', 'fa fa-file-photo-o', 'fa fa-file-picture-o', 'fa fa-file-image-o', 'fa fa-file-zip-o', 'fa fa-file-archive-o', 'fa fa-file-sound-o', 'fa fa-file-audio-o', 'fa fa-file-movie-o', 'fa fa-file-video-o', 'fa fa-file-code-o', 'fa fa-vine', 'fa fa-codepen', 'fa fa-jsfiddle', 'fa fa-life-bouy', 'fa fa-life-buoy', 'fa fa-life-saver', 'fa fa-support', 'fa fa-life-ring', 'fa fa-circle-o-notch', 'fa fa-ra', 'fa fa-rebel', 'fa fa-ge', 'fa fa-empire', 'fa fa-git-square', 'fa fa-git', 'fa fa-hacker-news', 'fa fa-tencent-weibo', 'fa fa-qq', 'fa fa-wechat', 'fa fa-weixin', 'fa fa-send', 'fa fa-paper-plane', 'fa fa-send-o', 'fa fa-paper-plane-o', 'fa fa-history', 'fa fa-circle-thin', 'fa fa-header', 'fa fa-paragraph', 'fa fa-sliders', 'fa fa-share-alt', 'fa fa-share-alt-square', 'fa fa-bomb', 'fa fa-soccer-ball-o', 'fa fa-futbol-o', 'fa fa-tty', 'fa fa-binoculars', 'fa fa-plug', 'fa fa-slideshare', 'fa fa-twitch', 'fa fa-yelp', 'fa fa-newspaper-o', 'fa fa-wifi', 'fa fa-calculator', 'fa fa-paypal', 'fa fa-google-wallet', 'fa fa-cc-visa', 'fa fa-cc-mastercard', 'fa fa-cc-discover', 'fa fa-cc-amex', 'fa fa-cc-paypal', 'fa fa-cc-stripe', 'fa fa-bell-slash', 'fa fa-bell-slash-o', 'fa fa-trash', 'fa fa-copyright', 'fa fa-at', 'fa fa-eyedropper', 'fa fa-paint-brush', 'fa fa-birthday-cake', 'fa fa-area-chart', 'fa fa-pie-chart', 'fa fa-line-chart', 'fa fa-lastfm', 'fa fa-lastfm-square', 'fa fa-toggle-off', 'fa fa-toggle-on', 'fa fa-bicycle', 'fa fa-bus', 'fa fa-ioxhost', 'fa fa-angellist', 'fa fa-cc', 'fa fa-shekel', 'fa fa-sheqel', 'fa fa-ils', 'fa fa-meanpath' );

			sort( $k2t_icon );

			trim( join( 'fa ', $k2t_icon ) );



			$k2t_margin_top = array(

				'param_name'  => 'mgt',

				'heading'     => esc_html__( 'Margin Top', 'skstore' ),

				'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

				'type'        => 'textfield',

			);

			$k2t_margin_right = array(

				'param_name'  => 'mgr',

				'heading'     => esc_html__( 'Margin Right', 'skstore' ),

				'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

				'type'        => 'textfield',

			);

			$k2t_margin_bottom = array(

				'param_name'  => 'mgb',

				'heading'     => esc_html__( 'Margin Bottom', 'skstore' ),

				'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

				'type'        => 'textfield',

			);

			$k2t_margin_left = array(

				'param_name'  => 'mgl',

				'heading'     => esc_html__( 'Margin Left', 'skstore' ),

				'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

				'type'        => 'textfield',

			);

			$k2t_id = array(

				'param_name'  => 'id',

				'heading'     => esc_html__( 'ID', 'skstore' ),

				'description' => esc_html__( '(Optional) Enter a unique ID.', 'skstore' ),

				'type'        => 'textfield',

			);

			$k2t_class = array(

				'param_name'  => 'class',

				'heading'     => esc_html__( 'Class', 'skstore' ),

				'description' => esc_html__( '(Optional) Enter a unique class name.', 'skstore' ),

				'type'        => 'textfield',

			);

			$k2t_animation = array(

				'param_name' => 'anm',

				'heading' 	 => esc_html__( 'Enable Animation', 'skstore' ),

				'type' 		 => 'checkbox',

				'value'      => array(

					'' => true

				)

			);

			$k2t_animation_name = array(

				'param_name' => 'anm_name',

				'heading' 	 => esc_html__( 'Animation', 'skstore' ),

				'type' 		 => 'dropdown',

				'dependency' => array(

					'element' => 'anm',

					'value'   => array( '1' ),

					'not_empty' => false,

				),

				'value'      => array( 'bounce', 'flash', 'pulse', 'rubberBand', 'shake', 'swing', 'tada', 'wobble', 'bounceIn', 'bounceInDown', 'bounceInLeft', 'bounceInRight', 'bounceInUp', 'fadeIn', 'fadeInDown', 'fadeInDownBig', 'fadeInLeft', 'fadeInLeftBig', 'fadeInRight', 'fadeInRightBig', 'fadeInUp', 'fadeInUpBig', 'flip', 'flipInX', 'flipInY', 'lightSpeedIn', 'rotateIn', 'rotateInDownLeft', 'rotateInDownRight', 'rotateInUpLeft', 'rotateInUpRight', 'rollIn', 'zoomIn', 'zoomInDown', 'zoomInLeft', 'zoomInRight', 'zoomInUp' ),

			);

			$k2t_animation_delay = array(

				'param_name'  => 'anm_delay',

				'heading'     => esc_html__( 'Animation Delay', 'skstore' ),

				'description' => esc_html__( 'Numeric value only, 1000 = 1second.', 'skstore' ),

				'type'        => 'textfield',

				'std'		  => '2000',

				'dependency' => array(

					'element' => 'anm',

					'value'   => array( '1' ),

					'not_empty' => false,

				),

			);



			/*  [ Row ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_row', array(

					'name'        => esc_html__( 'Row', 'skstore' ),

					'icon'        => 'fa fa-tasks',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'session_layout',

					'heading'     => esc_html__( 'Session layout', 'skstore' ),

					'type'        => 'dropdown',

					'value'       => array(

						esc_html__( 'None', 'skstore' ) => '',

						esc_html__( 'Full Width', 'skstore' ) => 'no_wrap',

						esc_html__( 'Fullscreen', 'skstore' ) => 'fullscreen'

					)

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_setting',

					'heading'     => esc_html__( 'Background type', 'skstore' ),

					'type'        => 'dropdown',

					'value'       => array(

						esc_html__( 'Background Color', 'skstore' ) => 'bg_color',

						esc_html__( 'Background Image', 'skstore' ) => 'bg_image',

						esc_html__( 'Background Video', 'skstore' ) => 'bg_video',

						esc_html__( 'Background Slider', 'skstore' ) => 'bg_slider',

					)

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'dark_background_style',

					'heading'     => esc_html__( 'Background with dark style', 'skstore' ),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => 'true'

					)

				)

			);

			// Background Image

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_img',

					'heading'     => esc_html__( 'Background Image', 'skstore' ),

					'type'        => 'attach_image',

					'holder'      => 'div',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_img_position',

					'heading'     => esc_html__( 'Background Position', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'None', 'skstore' )      => '',

						esc_html__( 'Left Top', 'skstore' )      => 'left top',

						esc_html__( 'Left Center', 'skstore' )   => 'left center',

						esc_html__( 'Left Bottom', 'skstore' )   => 'left bottom',

						esc_html__( 'Right Top', 'skstore' )     => 'right top',

						esc_html__( 'Right Center', 'skstore' )  => 'right center',

						esc_html__( 'Right Bottom', 'skstore' )  => 'right bottom',

						esc_html__( 'Center Top', 'skstore' )    => 'center top',

						esc_html__( 'Center Center', 'skstore' ) => 'center center',

						esc_html__( 'Center Bottom', 'skstore' ) => 'center bottom',

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_img_repeat',

					'heading'     => esc_html__( 'Background Repeat', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'No repeat', 'skstore' ) => 'no-repeat',

						esc_html__( 'Repeat', 'skstore' )    => 'repeat',

						esc_html__( 'Repeat X', 'skstore' )  => 'repeat-x',

						esc_html__( 'Repeat Y', 'skstore' )  => 'repeat-y',

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_img_size',

					'heading'     => esc_html__( 'Background size', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'None', 'skstore' ) => '',

						esc_html__( 'Auto', 'skstore' )    => 'auto',

						esc_html__( 'Length', 'skstore' )  => 'length',

						esc_html__( 'Percentage', 'skstore' )  => 'percentage',

						esc_html__( 'Cover', 'skstore' )  => 'cover',

						esc_html__( 'Contain', 'skstore' )  => 'contain',

						esc_html__( 'Initial', 'skstore' )  => 'initial',

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name' => 'background_img_size_perc',

					'heading'    => esc_html__( 'Background Size Percentage', 'skstore' ),

					'type'       => 'textfield',

					'dependency' => array(

						'element' => 'background_img_size',

						'value'   => array( 'percentage' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_img_animation',

					'heading'     => esc_html__( 'Background Animation', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'None', 'skstore' ) => '',

						esc_html__( 'Left to Right', 'skstore' ) => 'left_to_right',

						esc_html__( 'Right to Left', 'skstore' )    => 'right_to_left',

						esc_html__( 'Top to Bottom', 'skstore' )  => 'top_to_bottom',

						esc_html__( 'Bottom to Top', 'skstore' )  => 'bottom_to_top',

					),

				)

			);

			// Background Video

			vc_add_param(

				'vc_row', array(

					'param_name' => 'background_video_link',

					'heading'    => esc_html__( 'Background Video ID', 'skstore' ),

					'type'       => 'textfield',

					'description' => esc_html__( 'Only support youtube (eg: fDxFScMvoG8)', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_video' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name' => 'background_video_play_id',

					'heading'    => esc_html__( 'Set background video ID', 'skstore' ),

					'description' => esc_html__( 'You can use this ID for your action ( ex: button, link, image...) to play background video', 'skstore' ),

					'type'       => 'textfield',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_video' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_video_mute',

					'heading'     => esc_html__( 'Video Mute', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_video' )

					),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => 'false'

					)

				)

			);

			// Slider Background

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_slider_images',

					'heading'     => esc_html__( 'Background Slider Images', 'skstore' ),

					'type'        => 'attach_images',

					'holder'      => 'div',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_slider' )

					),

				)

			);

			// General Background

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_gen_auto_play',

					'heading'     => esc_html__( 'Auto Play', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_video', 'bg_slider' )

					),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => 'false'

					)

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_gen_parallax',

					'heading'     => esc_html__( 'Parallax Background', 'skstore' ),

					'description' => esc_html__( 'Parallax effect for background images', 'skstore' ),

					'type'        => 'checkbox',

					'value'       => array(

						'' => true,

					),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_gen_color',

					'heading'     => esc_html__( 'Background Color', 'skstore' ),

					'type'        => 'colorpicker',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_color', 'bg_image', 'bg_video', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_gen_mask_layer_image',

					'heading'     => esc_html__( 'Mask Layer Image', 'skstore' ),

					'type'        => 'attach_image',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_video', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_gen_mask_layer_repeat',

					'heading'     => esc_html__( 'Mask Layer Repeat', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_video', 'bg_slider' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'No repeat', 'skstore' ) => 'no-repeat',

						esc_html__( 'Repeat', 'skstore' )    => 'repeat',

						esc_html__( 'Repeat X', 'skstore' )  => 'repeat-x',

						esc_html__( 'Repeat Y', 'skstore' )  => 'repeat-y',

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name' => 'background_gen_mask_layer_opacity',

					'heading'    => esc_html__( 'Mask Layer Opacity', 'skstore' ),

					'type'       => 'textfield',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_video', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'background_gen_mask_layer_color',

					'heading'     => esc_html__( 'Mask Layer Color', 'skstore' ),

					'type'        => 'colorpicker',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_video', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name'  => 'scrolldown',

					'heading'     => esc_html__( 'Scrolldown Button', 'skstore' ),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => 'true'

					)

				)

			);

			vc_remove_param( 'vc_row', 'font_color' );

			vc_remove_param( 'vc_row', 'el_class' );

			vc_add_param( 'vc_row', $k2t_id );

			vc_add_param( 'vc_row', $k2t_class );



			/*  [ Column ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_column', array(

					'name'        => esc_html__( 'Row', 'skstore' ),

					'icon'        => 'fa fa-tasks',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_setting',

					'heading'     => esc_html__( 'Background type', 'skstore' ),

					'type'        => 'dropdown',

					'value'       => array(

						esc_html__( 'Background Color', 'skstore' ) => 'bg_color',

						esc_html__( 'Background Image', 'skstore' ) => 'bg_image',

						esc_html__( 'Background Video', 'skstore' ) => 'bg_video',

						esc_html__( 'Background Slider', 'skstore' ) => 'bg_slider',

					)

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'dark_background_style',

					'heading'     => esc_html__( 'Background with dark style', 'skstore' ),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => 'true'

					)

				)

			);

			// Background Image

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_img',

					'heading'     => esc_html__( 'Background Image', 'skstore' ),

					'type'        => 'attach_image',

					'holder'      => 'div',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_img_position',

					'heading'     => esc_html__( 'Background Position', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'None', 'skstore' )      => '',

						esc_html__( 'Left Top', 'skstore' )      => 'left top',

						esc_html__( 'Left Center', 'skstore' )   => 'left center',

						esc_html__( 'Left Bottom', 'skstore' )   => 'left bottom',

						esc_html__( 'Right Top', 'skstore' )     => 'right top',

						esc_html__( 'Right Center', 'skstore' )  => 'right center',

						esc_html__( 'Right Bottom', 'skstore' )  => 'right bottom',

						esc_html__( 'Center Top', 'skstore' )    => 'center top',

						esc_html__( 'Center Center', 'skstore' ) => 'center center',

						esc_html__( 'Center Bottom', 'skstore' ) => 'center bottom',

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_img_repeat',

					'heading'     => esc_html__( 'Background Repeat', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'No repeat', 'skstore' ) => 'no-repeat',

						esc_html__( 'Repeat', 'skstore' )    => 'repeat',

						esc_html__( 'Repeat X', 'skstore' )  => 'repeat-x',

						esc_html__( 'Repeat Y', 'skstore' )  => 'repeat-y',

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_img_size',

					'heading'     => esc_html__( 'Background size', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'None', 'skstore' ) => '',

						esc_html__( 'Auto', 'skstore' )    => 'auto',

						esc_html__( 'Length', 'skstore' )  => 'length',

						esc_html__( 'Percentage', 'skstore' )  => 'percentage',

						esc_html__( 'Cover', 'skstore' )  => 'cover',

						esc_html__( 'Contain', 'skstore' )  => 'contain',

						esc_html__( 'Initial', 'skstore' )  => 'initial',

					),

				)

			);

			vc_add_param(

				'vc_row', array(

					'param_name' => 'background_img_size_perc',

					'heading'    => esc_html__( 'Background Size Percentage', 'skstore' ),

					'type'       => 'textfield',

					'dependency' => array(

						'element' => 'background_img_size',

						'value'   => array( 'percentage' )

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_img_animation',

					'heading'     => esc_html__( 'Background Animation', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'None', 'skstore' ) => '',

						esc_html__( 'Left to Right', 'skstore' ) => 'left_to_right',

						esc_html__( 'Right to Left', 'skstore' )    => 'right_to_left',

						esc_html__( 'Top to Bottom', 'skstore' )  => 'top_to_bottom',

						esc_html__( 'Bottom to Top', 'skstore' )  => 'bottom_to_top',

					),

				)

			);

			// Background Video

			vc_add_param(

				'vc_column', array(

					'param_name' => 'background_video_link',

					'heading'    => esc_html__( 'Background Video ID', 'skstore' ),

					'type'       => 'textfield',

					'description' => esc_html__( 'Only support youtube (eg: fDxFScMvoG8)', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_video' )

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name' => 'background_video_play_id',

					'heading'    => esc_html__( 'Set background video ID', 'skstore' ),

					'description' => esc_html__( 'You can use this ID for your action ( ex: button, link, image...) to play background video', 'skstore' ),

					'type'       => 'textfield',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_video' )

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_video_mute',

					'heading'     => esc_html__( 'Video Mute', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_video' )

					),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => 'false'

					)

				)

			);

			// Slider Background

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_slider_images',

					'heading'     => esc_html__( 'Background Slider Images', 'skstore' ),

					'type'        => 'attach_images',

					'holder'      => 'div',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_slider' )

					),

				)

			);

			// General Background

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_gen_auto_play',

					'heading'     => esc_html__( 'Background Auto Play', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_video', 'bg_slider' )

					),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => 'false'

					)

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_gen_parallax',

					'heading'     => esc_html__( 'Parallax Background', 'skstore' ),

					'description' => esc_html__( 'Parallax effect for background images', 'skstore' ),

					'type'        => 'checkbox',

					'value'       => array(

						'' => true,

					),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_gen_color',

					'heading'     => esc_html__( 'Background Color', 'skstore' ),

					'type'        => 'colorpicker',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_color', 'bg_image', 'bg_video', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_gen_mask_layer_image',

					'heading'     => esc_html__( 'Mask Layer Image', 'skstore' ),

					'type'        => 'attach_image',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_video', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_gen_mask_layer_repeat',

					'heading'     => esc_html__( 'Mask Layer Repeat', 'skstore' ),

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_video', 'bg_slider' )

					),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'No repeat', 'skstore' ) => 'no-repeat',

						esc_html__( 'Repeat', 'skstore' )    => 'repeat',

						esc_html__( 'Repeat X', 'skstore' )  => 'repeat-x',

						esc_html__( 'Repeat Y', 'skstore' )  => 'repeat-y',

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name' => 'background_gen_mask_layer_opacity',

					'heading'    => esc_html__( 'Mask Layer Opacity', 'skstore' ),

					'type'       => 'textfield',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_video', 'bg_slider' )

					),

				)

			);

			vc_add_param(

				'vc_column', array(

					'param_name'  => 'background_gen_mask_layer_color',

					'heading'     => esc_html__( 'Mask Layer Color', 'skstore' ),

					'type'        => 'colorpicker',

					'dependency' => array(

						'element' => 'background_setting',

						'value'   => array( 'bg_image', 'bg_video', 'bg_slider' )

					),

				)

			);

			vc_remove_param( 'vc_column', 'font_color' );

			vc_remove_param( 'vc_column', 'el_class' );

			vc_add_param( 'vc_column', $k2t_id );

			vc_add_param( 'vc_column', $k2t_class );



			/*  [ VC Tabs]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_tabs', array(

					'name'        => esc_html__( 'Tabs', 'skstore' ),

					'icon'        => 'fa fa-text-height',

					'category'    => esc_html__( 'Content', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_tabs', array(

					'param_name' => 'align',

					'heading' 	 => esc_html__( 'Align', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'Left', 'skstore' ) 					=> 'left',

						esc_html__( 'Center', 'skstore' )    				=> 'center',

						esc_html__( 'Right', 'skstore' )    				=> 'right',

					),

				)

			);

			vc_add_param(

				'vc_tabs', array(

					'param_name' => 'style',

					'heading' 	 => esc_html__( 'Style', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'OutLine', 'skstore' ) 				=> 'outline',

						esc_html__( 'Fill', 'skstore' ) 					=> 'fill',

						esc_html__( 'Solid', 'skstore' )    				=> 'solid',

						esc_html__( 'Bottom Line', 'skstore' )    			=> 'bottom_line',

					),

				)

			);

			vc_add_param(

				'vc_tabs', array(

					'param_name'  => 'icon_font_size',

					'heading'     => esc_html__( 'Icon Font size', 'skstore' ),

					'type'        => 'textfield',

					'holder'      => 'div',

				)

			);

			vc_remove_param( 'vc_tabs', 'el_class' );

			vc_add_param( 'vc_tabs', $k2t_class );



			/*  [ VC Vertical tab ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_tour', array(

					'name'        => esc_html__( 'Vertical tabs', 'skstore' ),

					'icon'        => 'fa fa-list-ul',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_tour', array(

					'param_name' => 'style',

					'heading' 	 => esc_html__( 'Styles', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'OutLine', 'skstore' ) 				=> 'outline',

						esc_html__( 'Solid', 'skstore' )    				=> 'solid',

					),

				)

			);



			/*  [ VC Tab]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_tab', array(

					'name'        => esc_html__( 'Text Block', 'skstore' ),

					'icon'        => 'fa fa-text-height',

					'category'    => esc_html__( 'Content', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_tab', array(

					'param_name' => 'icon',

					'heading' 	 => esc_html__( 'Icons', 'skstore' ),

					'type' 		 => 'k2t_icon',

					'value'      => '',

				)

			);

			vc_add_param(

				'vc_tab', array(

					'param_name'  => 'icon_pos',

					'heading'     => esc_html__( 'Icon Position', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'Left', 'skstore' ) => 'left',

						esc_html__( 'Top', 'skstore' )    => 'top',

					),

				)

			);



			/*  [ VC Column Text ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_column_text', array(

					'name'        => esc_html__( 'Text Block', 'skstore' ),

					'icon'        => 'fa fa-text-height',

					'category'    => esc_html__( 'Content', 'skstore' ),

					'description' => '',

				)

			);

			vc_remove_param( 'vc_column_text', 'css_animation' );

			vc_remove_param( 'vc_column_text', 'el_class' );

			vc_add_param( 'vc_column_text', $k2t_animation );

			vc_add_param( 'vc_column_text', $k2t_animation_name );

			vc_add_param( 'vc_column_text', $k2t_animation_delay );

			vc_add_param( 'vc_column_text', $k2t_id );

			vc_add_param( 'vc_column_text', $k2t_class );



			/*  [ VC Separator ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_separator', array(

					'name'        => esc_html__( 'Separator', 'skstore' ),

					'icon'        => 'fa fa-minus',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_separator', array(

					'param_name'  => 'style',

					'heading'     => esc_html__( 'Style', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'Border', 'skstore' ) => '',

						esc_html__( 'Dashed', 'skstore' )    => 'dashed',

						esc_html__( 'Dotted', 'skstore' )    => 'dotted',

						esc_html__( 'Double', 'skstore' )    => 'double',

						esc_html__( 'Shadow', 'skstore' )    => 'shadow',

					),

				)

			);



			/*  [ VC Separator With Text ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_text_separator', array(

					'name'        => esc_html__( 'Separator with text', 'skstore' ),

					'icon'        => 'fa fa-text-width',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Message Box ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_message', array(

					'name'        => esc_html__( 'Message box', 'skstore' ),

					'icon'        => 'fa fa-file-text-o',

					'category'    => esc_html__( 'Content', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_message', array(

					'param_name' => 'icon',

					'heading' 	 => esc_html__( 'Icons', 'skstore' ),

					'type' 		 => 'k2t_icon',

					'value'      => '',

				)

			);

			vc_add_param(

				'vc_message', array(

					'param_name'  => 'background_transparent',

					'heading'     => esc_html__( 'Background Transparent', 'skstore' ),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => true

					)

				)

			);

			vc_add_param(

				'vc_message', array(

					'param_name'  => 'is_close',

					'heading'     => esc_html__( 'Is Close', 'skstore' ),

					'type'        => 'checkbox',

					'holder'      => 'div',

					'value'       => array(

						'' => true

					)

				)

			);

			vc_remove_param( 'vc_message', 'css_animation' );

			vc_remove_param( 'vc_message', 'el_class' );

			vc_remove_param( 'vc_message', 'icon_fontawesome' );

			vc_remove_param( 'vc_message', 'icon_type' );

			vc_remove_param( 'vc_message', 'icon_openiconic' );

			vc_remove_param( 'vc_message', 'icon_typicons' );

			vc_remove_param( 'vc_message', 'icon_entypo' );

			vc_remove_param( 'vc_message', 'icon_pixelicons' );

			vc_remove_param( 'vc_message', 'icon_linecons' );

			vc_add_param( 'vc_message', $k2t_animation );

			vc_add_param( 'vc_message', $k2t_animation_name );

			vc_add_param( 'vc_message', $k2t_animation_delay );

			vc_add_param( 'vc_message', $k2t_id );

			vc_add_param( 'vc_message', $k2t_class );



			/*  [ VC Facebook ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_facebook', array(

					'name'        => esc_html__( 'Facebook like', 'skstore' ),

					'icon'        => 'fa fa-facebook',

					'category'    => esc_html__( 'Socials', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Tweetmeme ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_tweetmeme', array(

					'name'        => esc_html__( 'Tweetmeme', 'skstore' ),

					'icon'        => 'fa fa-twitter',

					'category'    => esc_html__( 'Socials', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Google Plus ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_googleplus', array(

					'name'        => esc_html__( 'Google Plus', 'skstore' ),

					'icon'        => 'fa fa-google-plus',

					'category'    => esc_html__( 'Socials', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Pinterest ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_pinterest', array(

					'name'        => esc_html__( 'Pinterest', 'skstore' ),

					'icon'        => 'fa fa-pinterest',

					'category'    => esc_html__( 'Socials', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Single Image ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_single_image', array(

					'name'        => esc_html__( 'Single Image', 'skstore' ),

					'icon'        => 'fa fa-image',

					'category'    => esc_html__( 'Content', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_single_image', array(

					'param_name'  => 'image_style',

					'heading'     => esc_html__( 'Image Style', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'None', 'skstore' ) => '',

						esc_html__( 'Rounded', 'skstore' )    => 'rounded',

						esc_html__( 'Border', 'skstore' )    => 'border',

						esc_html__( 'Outline', 'skstore' )    => 'outline',

						esc_html__( 'Shadow', 'skstore' )    => 'shadow',

					),

				)

			);

			vc_add_param(

				'vc_single_image', array(

					'param_name'  => 'image_hover_style',

					'heading'     => esc_html__( 'Image Hover Style', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'None', 'skstore' ) => '',

						esc_html__( 'Dark', 'skstore' )    => 'dark',

						esc_html__( 'Light', 'skstore' )    => 'light',

						esc_html__( 'Banner', 'skstore' )    => 'banner',

					),

				)

			);

			vc_add_param(

				'vc_single_image', array(

					'param_name' => 'image_banner_hover',

					'heading'    => esc_html__( 'Image Banner Content', 'skstore' ),

					'type'       => 'textarea',

					'dependency' => array(

						'element' => 'image_hover_style',

						'value'   => array( 'banner' )

					),

				)

			);

			vc_remove_param( 'vc_single_image', 'css_animation' );

			vc_remove_param( 'vc_single_image', 'el_class' );

			vc_remove_param( 'vc_single_image', 'style' );

			vc_remove_param( 'vc_single_image', 'border_color' );

			vc_remove_param( 'vc_single_image', 'img_link_large' );

			vc_remove_param( 'vc_single_image', 'img_link_target' );

			vc_add_param( 'vc_single_image', $k2t_animation );

			vc_add_param( 'vc_single_image', $k2t_animation_name );

			vc_add_param( 'vc_single_image', $k2t_animation_delay );

			vc_add_param( 'vc_single_image', $k2t_id );

			vc_add_param( 'vc_single_image', $k2t_class );



			/*  [ VC Gallery ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_gallery', array(

					'name'        => esc_html__( 'Gallery', 'skstore' ),

					'icon'        => 'fa fa-caret-square-o-right',

					'category'    => esc_html__( 'Media', 'skstore' ),

					'description' => '',

				)

			);

			vc_remove_param( 'vc_gallery', 'el_class' );

			vc_add_param( 'vc_gallery', $k2t_id );

			vc_add_param( 'vc_gallery', $k2t_class );



			/*  [ VC Carousel ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_images_carousel', array(

					'name'        => esc_html__( 'Carousel', 'skstore' ),

					'icon'        => 'fa fa-exchange',

					'category'    => esc_html__( 'Media', 'skstore' ),

					'description' => '',

				)

			);

			vc_remove_param( 'vc_images_carousel', 'el_class' );

			vc_add_param( 'vc_images_carousel', $k2t_id );

			vc_add_param( 'vc_images_carousel', $k2t_class );



			/*  [ VC Toggle ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_toggle', array(

					'name'        => esc_html__( 'Toggles', 'skstore' ),

					'icon'        => 'fa fa-indent',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);

			vc_remove_param( 'vc_toggle', 'css_animation' );

			vc_remove_param( 'vc_toggle', 'el_class' );

			vc_remove_param( 'vc_toggle', 'style' );

			vc_remove_param( 'vc_toggle', 'color' );

			vc_remove_param( 'vc_toggle', 'size' );

			vc_add_param( 'vc_toggle', $k2t_animation );

			vc_add_param( 'vc_toggle', $k2t_animation_name );

			vc_add_param( 'vc_toggle', $k2t_animation_delay );

			vc_add_param( 'vc_toggle', $k2t_id );

			vc_add_param( 'vc_toggle', $k2t_class );



			/*  [ VC Video ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_video', array(

					'name'        => esc_html__( 'Video', 'skstore' ),

					'icon'        => 'fa fa-video-camera',

					'category'    => esc_html__( 'Media', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Raw HTML ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_raw_html', array(

					'name'        => esc_html__( 'Raw HTML code', 'skstore' ),

					'icon'        => 'fa fa-code',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Raw JS ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_raw_js', array(

					'name'        => esc_html__( 'Raw JS code', 'skstore' ),

					'icon'        => 'fa fa-code',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Empty Space ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_empty_space', array(

					'name'        => esc_html__( 'Empty Space', 'skstore' ),

					'icon'        => 'fa fa-arrows-v',

					'category'    => esc_html__( 'Structure', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC Custom Heading ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_custom_heading', array(

					'name'        => esc_html__( 'Custom Heading', 'skstore' ),

					'icon'        => 'fa fa-header',

					'category'    => esc_html__( 'Typography', 'skstore' ),

					'description' => '',

				)

			);

			vc_add_param(

				'vc_custom_heading', array(

					'param_name' => 'text_transform',

					'heading' 	 => esc_html__( 'Text Transform', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'Inherit', 'skstore' )    => 'inherit',

						esc_html__( 'Uppercase', 'skstore' )  => 'uppercase',

						esc_html__( 'lowercase', 'skstore' )  => 'lowercase',

						esc_html__( 'initial', 'skstore' )    => 'initial',

						esc_html__( 'capitalize', 'skstore' ) => 'capitalize',

					),

				)

			);

			vc_remove_param( 'vc_custom_heading', 'el_class' );

			vc_add_param( 'vc_custom_heading', $k2t_animation );

			vc_add_param( 'vc_custom_heading', $k2t_animation_name );

			vc_add_param( 'vc_custom_heading', $k2t_animation_delay );

			vc_add_param( 'vc_custom_heading', $k2t_id );

			vc_add_param( 'vc_custom_heading', $k2t_class );



			/*  [ VC Posts sk ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_basic_grid', array(

					'name'        => esc_html__( 'Post sk', 'skstore' ),

					'icon'        => 'fa fa-th',

					'category'    => esc_html__( 'Content', 'skstore' ),

					'description' => ''

				)

			);

			vc_add_param(

				'vc_basic_grid', array(

					'param_name' => 'align',

					'heading' 	 => esc_html__( 'Align', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'Left', 'skstore' )    => 'left',

						esc_html__( 'Center', 'skstore' )  => 'center',

						esc_html__( 'Right', 'skstore' )  => 'right',

					),

				)

			);

			vc_add_param(

				'vc_basic_grid', array(

					'param_name' => 'style',

					'heading' 	 => esc_html__( 'Style', 'skstore' ),

					'type' 		 => 'dropdown',

					'value'      => array(

						esc_html__( 'Default', 'skstore' )    => 'default',

						esc_html__( 'Boxed', 'skstore' )  => 'boxed',

					),

				)

			);

			//vc_remove_param( 'vc_posts_grid', 'filter' );



			/*  [ VC WP Search ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_search', array(

					'name'        => esc_html__( 'WP Search', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);

			/*  [ VC WP Meta ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_meta', array(

					'name'        => esc_html__( 'WP Meta', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP recent comments ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_recentcomments', array(

					'name'        => esc_html__( 'WP Recent Comments', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

					'params'	  => $k2t_animation,

				)

			);



			/*  [ VC WP calendar ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_calendar', array(

					'name'        => esc_html__( 'WP Calendar', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP pages ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_pages', array(

					'name'        => esc_html__( 'WP Pages', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP Tagcloud ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_tagcloud', array(

					'name'        => esc_html__( 'WP Tagcloud', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP custom menu ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_custommenu', array(

					'name'        => esc_html__( 'WP Custom Menu', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP text ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_text', array(

					'name'        => esc_html__( 'WP Text', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP posts ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_posts', array(

					'name'        => esc_html__( 'WP Posts', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP categories ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_categories', array(

					'name'        => esc_html__( 'WP Categories', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP archives ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_archives', array(

					'name'        => esc_html__( 'WP Archives', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ VC WP rss ]

			- - - - - - - - - - - - - - - - - - - */

			vc_map_update(

				'vc_wp_rss', array(

					'name'        => esc_html__( 'WP RSS', 'skstore' ),

					'icon'        => 'fa fa-wordpress',

					'category'    => esc_html__( 'WordPress', 'skstore' ),

					'description' => '',

				)

			);



			/*  [ K2t Accordion ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_accordion = array(

				'base'            => 'accordion',

				'name'            => esc_html__( 'K2t Accordion', 'skstore' ),

				'icon'            => 'fa fa-sort-amount-desc',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_parent'       => array( 'only' => 'toggle' ),

				'content_element' => true,

				'js_view'         => 'VcColumnView',

				'params'          => array(

					array(

						'param_name'  => 'style',

						'heading' 	  => esc_html__( 'Style', 'skstore' ),

						'description' => esc_html__( 'Select style for accordion', 'skstore'),

						'type' 		  => 'dropdown',

						'value'       => array( '1', '2','3'),

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_accordion );



		/* [ K2t Woo Products ] */

		if ( is_plugin_active('dhvc-woocommerce/dhvc-woocommerce.php') ) :

			vc_map ( array (

							"name" => __ ( "DHVC Slider Products", 'skstore' ),

							"base" => "sk_woo_products",

							"category" => __ ( "DHVC Shortcodes", 'skstore' ),

							"icon" => "icon-dhvc-woo-product-page",

							"params" => array (

									array (

											"type" => "dhvc_woo_product_page_field_products_ajax",

											"heading" => __ ( "Select products", 'skstore' ),

											"param_name" => "ids"

									),

									array (

											"type" => "textfield",

											"heading" => __ ( "Columns", 'skstore' ),

											"param_name" => "columns",

											"value" => 4

									),

									array (

											"type" => "dropdown",

											"heading" => __ ( "Products Ordering", 'skstore' ),

											"param_name" => "orderby",

											"value" => array (

													""=>"",

													__ ( 'Publish Date', 'skstore' ) => 'date',

													__ ( 'Modified Date', 'skstore' ) => 'modified',

													__ ( 'Random', 'skstore' ) => 'rand',

													__ ( 'Alphabetic', 'skstore' ) => 'title',

													__ ( 'Popularity', 'skstore' ) => 'popularity',

													__ ( 'Rate', 'skstore' ) => 'rating',

													__ ( 'Price', 'skstore' ) => 'price'

											)

									),

									array (

											"type" => "dropdown",

											"class" => "",

											"heading" => __ ( "Ascending or Descending", 'skstore' ),

											"param_name" => "order",

											"value" => array (

													""=>"",

													__ ( 'Ascending', 'skstore' ) => 'ASC',

													__ ( 'Descending', 'skstore' ) => 'DESC'

											)

									),

									array (

											"type" => "dropdown",

											"heading" => __ ( "Choose Style", 'skstore' ),

											"param_name" => "el_class",

											'value'=>'',

											"description" => __ ( "Slider products", 'skstore' ),

											"value" => array (

													__ ( 'Style 1', 'skstore' ) => 'style-1',

													__ ( 'Style 2', 'skstore' ) => 'style-2'

											)

									),

									array (

											"type" => "dropdown",

											"heading" => esc_html__( "Slider items: ", 'skstore' ),

											"param_name" => "items",

											"value" => array (

													__ ( '5 items', 'skstore' ) => '5',

											)

									),

							)

					) );

		endif;

			/*  [ K2t Accordion Items ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_accordion_item = array(

				'base'            => 'toggle',

				'name'            => esc_html__( 'K2t Accordion Item', 'skstore' ),

				'icon'            => 'fa fa-sort-amount-desc',

				'category'        => esc_html__( 'SKstore shortcodes', 'skstore' ),

				'as_child'        => array( 'only' => 'accordion' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Title', 'skstore' ),

						'description' => esc_html__( 'Title for your accordion item.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'icon',

						'heading' 	 => esc_html__( 'Icons', 'skstore' ),

						'type' 		 => 'k2t_icon',

						'value'      => '',

					),

					array(

						'param_name'  => 'acc_content',

						'heading'     => esc_html__( 'Content', 'skstore' ),

						'description' => esc_html__( 'Enter your text.', 'skstore' ),

						'type'        => 'textarea',

						'holder'      => 'div',

						'value'       => ''

					),

					array(

						'param_name'  => 'open',

						'heading'     => esc_html__( 'Open', 'skstore' ),

						'description' => esc_html__( 'Select for your accordion item to be open by default.', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true'

						)

					),

					$k2t_animation,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_accordion_item );



			/*  [ K2t Brands ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_brands = array(

				'base'            => 'brands',

				'name'            => esc_html__( 'K2t Brands', 'skstore' ),

				'icon'            => 'fa fa-photo',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_parent'       => array( 'only' => 'brand' ),

				'content_element' => true,

				'js_view'         => 'VcColumnView',

				'params'          => array(

					array(

						'param_name'  => 'column',

						'heading' 	  => esc_html__( 'Column', 'skstore' ),

						'description' => esc_html__( 'Select column display brand', 'skstore'),

						'type' 		  => 'dropdown',

						'value'       => array( '1', '2', '3', '4', '5', '6', '7', '8' ),

					),

					array(

						'param_name'  => 'padding',

						'heading'     => esc_html__( 'Padding', 'skstore' ),

						'description' => esc_html__( 'If you select true, it will be padding between item', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true',

						)

					),

					array(

						'param_name'  => 'grayscale',

						'heading'     => esc_html__( 'Grayscale', 'skstore' ),

						'description' => esc_html__( 'Display grayscale.', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true'

						)

					),

					$k2t_id, $k2t_class

				)

			);

			vc_map( $k2t_brands );



			/*  [ K2t Brand Items ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_brands_item = array(

				'base'            => 'brand',

				'name'            => esc_html__( 'K2t Brands Item', 'skstore' ),

				'icon'            => 'fa fa-photo',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_child'        => array( 'only' => 'brands' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Brand Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'tooltip',

						'heading'     => esc_html__( 'Tooltip', 'skstore' ),

						'description' => esc_html__( 'Enable tooltip.', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true'

						)

					),

					array(

						'param_name'  => 'link',

						'heading'     => esc_html__( 'Upload Brand', 'skstore' ),

						'type'        => 'attach_image',

						'holder'      => 'div',

					),

					array(

						'param_name'  => 'related_url',

						'heading'     => esc_html__( 'Related URL', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

				)

			);

			vc_map( $k2t_brands_item );



			/*  [ K2t Button ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_button = array(

				'base'            => 'button',

				'name'            => esc_html__( 'K2t Button', 'skstore' ),

				'icon'            => 'fa fa-square',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Button Text', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'link',

						'heading'     => esc_html__( 'Link', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'target',

						'heading' 	 => esc_html__( 'Link Target', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Open in a new window', 'skstore' )                      => '_blank',

							esc_html__( 'Open in the same frame as it was clicked', 'skstore' )  => '_self'

						),

					),

					array(

						'param_name' => 'icon',

						'heading' 	 => esc_html__( 'Choose Icon', 'skstore' ),

						'type' 		 => 'k2t_icon',

						'value'      => '',

					),

					array(

						'param_name' => 'icon_position',

						'heading' 	 => esc_html__( 'Icon Position', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Right', 'skstore' ) 				=> 'right',

							esc_html__( 'Left', 'skstore' )  				=> 'left'

						),

					),

					array(

						'param_name' => 'size',

						'heading' 	 => esc_html__( 'Size', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Small', 'skstore' ) 				=> 'small',

							esc_html__( 'Medium', 'skstore' ) 				=> 'medium',

							esc_html__( 'Large', 'skstore' )  				=> 'large'

						),

					),

					array(

						'param_name' => 'align',

						'heading' 	 => esc_html__( 'Align', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Left', 'skstore' )   				=> 'left',

							esc_html__( 'Center', 'skstore' ) 				=> 'center',

							esc_html__( 'Right', 'skstore' )  				=> 'right'

						),

					),

					array(

						'param_name' => 'button_style',

						'heading' 	 => esc_html__( 'Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Default', 'skstore' )   			=> 'default',

							esc_html__( 'Green', 'skstore' )   			=> 'green',

							esc_html__( 'Black', 'skstore' ) 				=> 'black',

							esc_html__( 'Violet', 'skstore' )  			=> 'violet',

							esc_html__( 'Blue', 'skstore' )  				=> 'blue',

							esc_html__( 'Red', 'skstore' )  				=> 'red',

							esc_html__( 'Gray', 'skstore' )  				=> 'gray',

							esc_html__( 'Yellow', 'skstore' )  			=> 'yellow',

						),

					),

					array(

						'param_name'  => 'fullwidth',

						'heading'     => esc_html__( 'Button Full Width', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true'

						)

					),

					array(

						'param_name'  => 'color',

						'heading'     => esc_html__( 'Button Background Color', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'button_style',

							'value'   => array( 'custom' )

						),

					),

					array(

						'param_name'  => 'text_color',

						'heading'     => esc_html__( 'Button Text Color', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'button_style',

							'value'   => array( 'custom' )

						),

					),

					array(

						'param_name'  => 'hover_bg_color',

						'heading'     => esc_html__( 'Background Hover Color', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'button_style',

							'value'   => array( 'custom' )

						),

					),

					array(

						'param_name'  => 'hover_text_color',

						'heading'     => esc_html__( 'Text Hover Color', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'button_style',

							'value'   => array( 'custom' )

						),

					),

					array(

						'param_name'  => 'border_color',

						'heading'     => esc_html__( 'Button border Color', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'button_style',

							'value'   => array( 'custom' )

						),

					),

					array(

						'param_name'  => 'border_width',

						'heading'     => esc_html__( 'Button border width', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'button_style',

							'value'   => array( 'custom' )

						),

					),

					array(

						'param_name'  => 'hover_border_color',

						'heading'     => esc_html__( 'Border Hover Color', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'button_style',

							'value'   => array( 'custom' )

						),

					),

					array(

						'param_name'  => 'radius',

						'heading'     => esc_html__( 'Button radius', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'pill',

						'heading'     => esc_html__( 'Pill', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true'

						)

					),

					array(

						'param_name'  => 'd3',

						'heading'     => esc_html__( '3D', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true'

						)

					),

					array(

						'param_name'  => 'border',

						'heading'     => esc_html__( 'No Border Button', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true'

						)

					),

					$k2t_margin_top,

					$k2t_margin_right,

					$k2t_margin_bottom,

					$k2t_margin_left,

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_button );



			/*  [ K2t Circle button ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_circle_button = array(

				'base'            => 'circle_button',

				'name'            => esc_html__( 'K2t Circle Button', 'skstore' ),

				'icon'            => 'fa fa-circle',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'name',

						'heading'     => esc_html__( 'Button Name', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'link',

						'heading'     => esc_html__( 'Link To', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'icon_hover',

						'heading' 	 => esc_html__( 'Icon Hover', 'skstore' ),

						'type' 		 => 'k2t_icon',

						'value'      => '',

					),

					array(

						'param_name'  => 'background_color',

						'heading'     => esc_html__( 'Button Background Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_circle_button );



			/*  [ K2t Counter ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_counter = array(

				'base'            => 'counter',

				'name'            => esc_html__( 'K2t Counter', 'skstore' ),

				'icon'            => 'fa fa-list-ol',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name' => 'style_type',

						'heading' 	 => esc_html__( 'Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Icon Top', 'skstore' )  => '1',

							esc_html__( 'Icon Left', 'skstore' ) => '2',

						),

					),

					array(

						'param_name'  => 'border_width',

						'heading'     => esc_html__( 'Border Width', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

					),

					array(

						'param_name' => 'border_style',

						'heading'    => esc_html__( 'Border Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Solid', 'skstore' )  => 'solid',

							esc_html__( 'Dashed', 'skstore' ) => 'dashed'

						),

					),

					array(

						'param_name'  => 'border_color',

						'heading'     => esc_html__( 'Border', 'skstore' ),

						'type'        => 'colorpicker'

					),

					array(

						'param_name' => 'icon_type',

						'heading'    => esc_html__( 'Icon Type', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Icon font', 'skstore' )    => 'icon_font',

							esc_html__( 'Icon Graphic', 'skstore' ) => 'icon_graphic',

						),

					),

					array(

						'param_name'  => 'icon_font',

						'heading'     => esc_html__( 'Choose Icon', 'skstore' ),

						'type' 		 => 'k2t_icon',

						'value'      => '',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_font' ),

						),

					),

					array(

						'param_name'  => 'icon_size',

						'heading'     => esc_html__( 'Icon size', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_font' ),

						),

					),

					array(

						'param_name'  => 'icon_color',

						'heading'     => esc_html__( 'Icon Color', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_font' ),

						),

					),

					array(

						'param_name'  => 'icon_background',

						'heading'     => esc_html__( 'Icon Background', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_font' ),

						),

					),

					array(

						'param_name'  => 'icon_border_color',

						'heading'     => esc_html__( 'Icon Border', 'skstore' ),

						'type'        => 'colorpicker',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_font' ),

						),

					),

					array(

						'param_name' => 'icon_border_style',

						'heading'    => esc_html__( 'Icon Border Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Solid', 'skstore' )  => 'solid',

							esc_html__( 'Dashed', 'skstore' ) => 'dashed'

						),

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_font' ),

						)

					),

					array(

						'param_name'  => 'icon_border_width',

						'heading'     => esc_html__( 'Icon Border Width', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_font' ),

						),

					),

					array(

						'param_name'  => 'icon_border_radius',

						'heading'     => esc_html__( 'Icon Border Radius', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_font' ),

						),

					),

					array(

						'param_name'  => 'icon_graphic',

						'heading'     => esc_html__( 'Upload icon graphic', 'skstore' ),

						'type'        => 'attach_image',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_graphic' ),

						),

					),

					array(

						'param_name'  => 'number',

						'heading'     => esc_html__( 'Counter to number', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'number_font_size',

						'heading'     => esc_html__( 'Number font size', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'number_color',

						'heading'     => esc_html__( 'Number Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Counter Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'title_underline',

						'heading' 	 => esc_html__( 'Counter Underline', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => 'true'

						),

					),

					array(

						'param_name'  => 'title_font_size',

						'heading'     => esc_html__( 'Title font size', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'title_color',

						'heading'     => esc_html__( 'Title Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					array(

						'param_name'  => 'speed',

						'heading'     => esc_html__( 'Animation Speed', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'delay',

						'heading'     => esc_html__( 'Animation Delay', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_counter );



			/*  [ K2t Google Map ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_google_map = array(

				'base'            => 'google_map',

				'name'            => esc_html__( 'K2t Google Maps', 'skstore' ),

				'icon'            => 'fa fa-map-marker',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'z',

						'heading'     => esc_html__( 'Zoom Level', 'skstore' ),

						'description' => esc_html__( 'Between 0-20', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'lat',

						'heading'     => esc_html__( 'Latitude', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'lon',

						'heading'     => esc_html__( 'Longitude', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'w',

						'heading'     => esc_html__( 'Width', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'h',

						'heading'     => esc_html__( 'Height', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'address',

						'heading'     => esc_html__( 'Address', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'marker',

						'heading' 	 => esc_html__( 'Marker', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => 'true'

						),

						'dependency' => array(

							'element' => 'address',

							'not_empty'   => true,

						),

					),

					array(

						'param_name'  => 'markerimage',

						'heading'     => esc_html__( 'Marker Image', 'skstore' ),

						'description' => esc_html__( 'Change default Marker.', 'skstore' ),

						'type'        => 'attach_image',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'marker',

							'value'   => array( 'true' ),

						),

					),

					array(

						'param_name' => 'traffic',

						'heading' 	 => esc_html__( 'Show Traffic', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => 'true'

						)

					),

					array(

						'param_name' => 'draggable',

						'heading' 	 => esc_html__( 'Draggable', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => 'true'

						)

					),

					array(

						'param_name' => 'infowindowdefault',

						'heading' 	 => esc_html__( 'Show Info Map', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => 'true'

						)

					),

					array(

						'param_name'  => 'infowindow',

						'heading'     => esc_html__( 'Content Info Map', 'skstore' ),

						'description' => esc_html__( 'Strong, br are accepted.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'hidecontrols',

						'heading' 	 => esc_html__( 'Hide Control', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => 'true'

						)

					),

					array(

						'param_name' => 'scrollwheel',

						'heading' 	 => esc_html__( 'Scroll wheel zooming', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => 'true'

						)

					),

					array(

						'param_name' => 'maptype',

						'heading' 	 => esc_html__( 'Map Type', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'ROADMAP', 'skstore' )   => 'ROADMAP',

							esc_html__( 'SATELLITE', 'skstore' ) => 'SATELLITE',

							esc_html__( 'HYBRID', 'skstore' )    => 'HYBRID',

							esc_html__( 'TERRAIN', 'skstore' )   => 'TERRAIN'

						),

					),

					array(

						'param_name' => 'mapstype',

						'heading' 	 => esc_html__( 'Map style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'None', 'skstore' )   => '',

							esc_html__( 'Subtle Grayscale', 'skstore' )   => 'grayscale',

							esc_html__( 'Blue water', 'skstore' ) => 'blue_water',

							esc_html__( 'Pale Dawn', 'skstore' ) => 'pale_dawn',

							esc_html__( 'Shades of Grey', 'skstore' ) => 'shades_of_grey',

						),

					),

					array(

						'param_name'  => 'color',

						'heading'     => esc_html__( 'Background Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_google_map );



			/*  [ K2t Heading ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_heading = array(

				'base'            => 'heading',

				'name'            => esc_html__( 'K2T Heading', 'skstore' ),

				'icon'            => 'fa fa-header',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'content',

						'heading'     => esc_html__( 'Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'value'       => ''

					),

					array(

						'param_name' => 'h',

						'heading' 	 => esc_html__( 'Heading Tag', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'H1', 'skstore' ) => 'h1',

							esc_html__( 'H2', 'skstore' ) => 'h2',

							esc_html__( 'H3', 'skstore' ) => 'h3',

							esc_html__( 'H4', 'skstore' ) => 'h4',

							esc_html__( 'H5', 'skstore' ) => 'h5',

							esc_html__( 'H6', 'skstore' ) => 'h6',

							esc_html__( 'Custom', 'skstore' ) => 'custom' ),

					),

					array(

						'param_name' => 'heading_icon',

						'heading' 	 => esc_html__( 'Heading Icon', 'skstore' ),

						'type' 		 => 'attach_image',

						'holder'      => 'div',

					),

					array(

						'param_name' => 'underline',

						'heading' 	 => esc_html__( 'Heading Underline', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'True', 'skstore' )  => 'true',

							esc_html__( 'False', 'skstore' ) => 'false',

						)

					),

					array(

						'param_name'  => 'font_size',

						'heading'     => esc_html__( 'Custom Font Size', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'h',

							'value'   => array( 'custom' )

						),

					),

					array(

						'param_name' => 'align',

						'heading' 	 => esc_html__( 'Align', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Left', 'skstore' )   => 'left',

							esc_html__( 'Center', 'skstore' ) => 'center',

							esc_html__( 'Right', 'skstore' )  => 'right'

						),

					),

					array(

						'param_name'  => 'font',

						'heading'     => esc_html__( 'Font', 'skstore' ),

						'description' => esc_html__( 'Use Google Font', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_heading );



			/*  [ K2t Icon Box ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_icon_box = array(

				'base'            => 'iconbox',

				'name'            => esc_html__( 'K2t Icon Box', 'skstore' ),

				'icon'            => 'fa fa-th',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name' => 'layout',

						'heading' 	 => esc_html__( 'Layout', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array( '1', '2', '3', '4' ),

					),

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'fontsize',

						'heading'     => esc_html__( 'Title Font Size', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'color',

						'heading'     => esc_html__( 'Title Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					array(

						'param_name' => 'text_transform',

						'heading' 	 => esc_html__( 'Text Transform', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Inherit', 'skstore' )    => 'inherit',

							esc_html__( 'Uppercase', 'skstore' )  => 'uppercase',

							esc_html__( 'Lowercase', 'skstore' )  => 'lowercase',

							esc_html__( 'Initial', 'skstore' )    => 'initial',

							esc_html__( 'Capitalize', 'skstore' ) => 'capitalize',

						),

					),

					array(

						'param_name' => 'icon_type',

						'heading' 	 => esc_html__( 'Icon Type', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Icon Fonts', 'skstore' )  => 'icon_fonts',

							esc_html__( 'Graphics', 'skstore' )    => 'graphics',

							esc_html__( 'No icon', 'skstore' )     => 'no_icon',

							esc_html__( 'Background Icon', 'skstore' ) => 'background_icon',

						)

					),

					array(

						'param_name' => 'graphic',

						'heading' 	 => esc_html__( 'Choose Images', 'skstore' ),

						'type' 		 => 'attach_image',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'graphics', 'background_icon' )

						),

					),

					array(

						'param_name' => 'icon',

						'heading' 	 => esc_html__( 'Choose Icon', 'skstore' ),

						'type' 		 => 'k2t_icon',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_fonts' )

						),

						'value'      => '',

					),

					array(

						'param_name'  => 'icon_font_size',

						'heading'     => esc_html__( 'Icon size', 'skstore' ),

						'type'        => 'textfield',

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_fonts' )

						),

					),

					array(

						'param_name' => 'icon_color',

						'heading' 	 => esc_html__( 'Icon Color', 'skstore' ),

						'type' 		 => 'colorpicker',

						'dependency' => array(

							'element' => 'icon_type',

							'value'   => array( 'icon_fonts' )

						),

					),

					array(

						'param_name'  => 'link',

						'heading'     => esc_html__( 'Link to', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'link_text',

						'heading'     => esc_html__( 'Link text', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'border',

						'heading' 	 => esc_html__( 'Border', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'None', 'skstore' )    => 'none',

							esc_html__( 'Solid', 'skstore' )  => 'solid',

							esc_html__( 'Dashed', 'skstore' )  => 'dashed',

							esc_html__( 'Dotted', 'skstore' )    => 'dotted',

						),

					),

					array(

						'param_name'  => 'content',

						'heading'     => esc_html__( 'Content', 'skstore' ),

						'type'        => 'textarea_html',

						'holder'      => 'div',

						'value'       => ''

					),

					$k2t_margin_top,

					$k2t_margin_right,

					$k2t_margin_bottom,

					$k2t_margin_left,

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_icon_box );



			/*  [ K2t Icon List ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_icon_list = array(

				'base'            => 'iconlist',

				'name'            => esc_html__( 'K2t Icon List', 'skstore' ),

				'icon'            => 'fa fa-list',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_parent'       => array( 'only' => 'li' ),

				'content_element' => true,

				'js_view'         => 'VcColumnView',

				'params'          => array(

					array(

						'param_name' => 'icon',

						'heading' 	 => esc_html__( 'Choose Icon', 'skstore' ),

						'type' 		 => 'k2t_icon',

						'value'      => '',

					),

					array(

						'param_name'  => 'color',

						'heading'     => esc_html__( 'Icon Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			$k2t_icon_list_item = array(

				'base'            => 'li',

				'name'            => esc_html__( 'Icon List Item', 'skstore' ),

				'icon'            => 'fa fa-ellipsis-v',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_child'        => array( 'only' => 'iconlist' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'icon',

						'heading' 	 => esc_html__( 'Choose Icon', 'skstore' ),

						'type' 		 => 'k2t_icon',

						'value'      => '',

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

				)

			);

			vc_map( $k2t_icon_list );

			vc_map( $k2t_icon_list_item );



			/*  [ K2t Banner ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_banner = array(

				'base'            => 'banner',

				'name'            => esc_html__( 'K2t Banner', 'skstore' ),

				'icon'            => 'fa fa-file-image-o',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_parent'       => array( 'only' => 'vc_single_image, vc_raw_html, iconbox, button' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'image',

						'heading'     => esc_html__( 'Image background', 'skstore' ),

						'type'        => 'attach_image',

						'holder'      => 'div',

					),

					array(

						'param_name' => 'banner_hover',

						'heading' 	 => esc_html__( 'Hover', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							'none'   => 'none',

							'round-border' => 'round-border',

						)

					),

					array(

						'param_name'  => 'border',

						'heading'     => esc_html__( 'Banner Border', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => true

						),

					),

					array(

						'param_name'  => 'border_width',

						'heading'     => esc_html__( 'Border Width', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'value'	  	  => '1',

						'holder'      => 'div',

						'dependency'  => array(

							'element' => 'border',

							'value'   => array( '1' )

						),

					),

					array(

						'param_name' => 'border_style',

						'heading'    => esc_html__( 'Border Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Dashed', 'skstore' ) => 'dashed',

							esc_html__( 'Solid', 'skstore' )  => 'solid',

						),

						'dependency' => array(

							'element' => 'border',

							'value'   => array( '1' )

						),

					),

					array(

						'param_name'  => 'border_color',

						'heading'     => esc_html__( 'Border', 'skstore' ),

						'type'        => 'colorpicker',

						'value'       => '#fff',

						'dependency'  => array(

							'element' => 'border',

							'value'   => array( '1' )

						),

					),

					array(

						'param_name'  => 'text_box',

						'heading'     => esc_html__( 'Text', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'value'       => ''

					),

					array(

						'param_name'  => 'text_size',

						'heading'     => esc_html__( 'Text size', 'skstore' ),

						'type'        => 'textfield',

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'holder'      => 'div',

						'value'       => '18'

					),

					array(

						'param_name'  => 'color',

						'heading'     => esc_html__( 'Text Color', 'skstore' ),

						'type'        => 'colorpicker',

						'value'       => '#fff'

					),

					array(

						'param_name'  => 'link',

						'heading'     => esc_html__( 'URL', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'style',

						'heading' 	 => esc_html__( 'Banner Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							'big' => 'big',

							'medium'   => 'medium',

							'small'   => 'small',

						)

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_banner );





			/*  [ K2t Member ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_member = array(

				'base'            => 'member',

				'name'            => esc_html__( 'K2t Member', 'skstore' ),

				'icon'            => 'fa fa-user',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'image',

						'heading'     => esc_html__( 'Member Avatar', 'skstore' ),

						'type'        => 'attach_image',

						'holder'      => 'div',

					),

					array(

						'param_name'  => 'name',

						'heading'     => esc_html__( 'Member Name', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'role',

						'heading'     => esc_html__( 'Role', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'facebook',

						'heading'     => esc_html__( 'Facebook URL', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'twitter',

						'heading'     => esc_html__( 'Twitter URL', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'skype',

						'heading'     => esc_html__( 'Skype', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'pinterest',

						'heading'     => esc_html__( 'Pinterest URL', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'instagram',

						'heading'     => esc_html__( 'Instagram', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'dribbble',

						'heading'     => esc_html__( 'Dribbble URL', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'google_plus',

						'heading'     => esc_html__( 'Google Plus URL', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'content',

						'heading'     => esc_html__( 'Member Info', 'skstore' ),

						'type'        => 'textarea_html',

						'holder'      => 'div',

						'value'       => ''

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_member );



			/*  [ K2t Pricing Table ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_pricing = array(

				'base'            => 'pricing',

				'name'            => esc_html__( 'K2t Pricing Table', 'skstore' ),

				'icon'            => 'fa fa-table',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_parent'       => array( 'only' => 'pricing_column' ),

				'content_element' => true,

				'js_view'         => 'VcColumnView',

				'params'          => array(

					array(

						'param_name' => 'separated',

						'heading' 	 => esc_html__( 'Separated', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'True', 'skstore' )  => 'true',

							esc_html__( 'False', 'skstore' ) => 'false',

						)

					),

					$k2t_id,

					$k2t_class

				)

			);

			$k2t_pricing_item = array(

				'base'            => 'pricing_column',

				'name'            => esc_html__( 'Pricing Columns', 'skstore' ),

				'icon'            => 'fa fa-table',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_child'        => array( 'only' => 'pricing' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'display_title',

						'heading'     => esc_html__( 'Display Title', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true',

						)

					),

					array(

						'param_name'  => 'style',

						'heading'     => esc_html__( 'Style', 'skstore' ),

						'description' => esc_html__( 'Select your style.', 'skstore' ),

						'type'        => 'dropdown',

						'holder'      => 'div',

						'value'       => array(

							'vertical' => 'vertical',

							'horizontal' => 'horizontal',



						)

					),

					array(

						'param_name'  => 'image',

						'heading'     => esc_html__( 'Image', 'skstore' ),

						'description' => esc_html__( 'Choose Image for pricing column.', 'skstore' ),

						'type'        => 'attach_image',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'style',

							'value'   => array( 'vertical' )

						),

					),

					array(

						'param_name'  => 'price',

						'heading'     => esc_html__( 'Price', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'price_per',

						'heading'     => esc_html__( 'Price Per', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'unit',

						'heading'     => esc_html__( 'Unit', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'link',

						'heading'     => esc_html__( 'Link to', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'link_text',

						'heading'     => esc_html__( 'Link Text', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'target',

						'heading' 	 => esc_html__( 'Link Target', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Open in a new window', 'skstore' )                      => '_blank',

							esc_html__( 'Open in the same frame as it was clicked', 'skstore' )  => '_self'

						),

					),

					array(

						'param_name' => 'featured',

						'heading' 	 => esc_html__( 'Featured', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'False', 'skstore' ) => 'false',

							esc_html__( 'True', 'skstore' )  => 'true',

						)

					),

					array(

						'param_name'  => 'pricing_content',

						'heading'     => esc_html__( 'List Item', 'skstore' ),

						'description' => esc_html__( 'Using ul li tag.', 'skstore' ),

						'type'        => 'textarea_html',

						'holder'      => 'div',

						'value'       => ''

					),

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_pricing );

			vc_map( $k2t_pricing_item );



			/*  [ K2t Progress ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_progress = array(

				'base'            => 'progress',

				'name'            => esc_html__( 'K2t Progress', 'skstore' ),

				'icon'            => 'fa fa-sliders',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'percent',

						'heading'     => esc_html__( 'Percent', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, between 1-100.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'color',

						'heading'     => esc_html__( 'Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					array(

						'param_name'  => 'background_color',

						'heading'     => esc_html__( 'Background Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					array(

						'param_name'  => 'text_color',

						'heading'     => esc_html__( 'Text Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'height',

						'heading'     => esc_html__( 'Height', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'striped',

						'heading'     => esc_html__( 'Striped', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => 'true'

						)

					),

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_progress );



			/*  [ K2t Responsive Text ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_responsive_text = array(

				'base'            => 'responsive_text',

				'name'            => esc_html__( 'K2t Responsive text', 'skstore' ),

				'icon'            => 'fa fa-arrows-alt',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'compression',

						'heading'     => esc_html__( 'Compression', 'skstore' ),

						'description' => esc_html__( 'Numeric value only.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'min_size',

						'heading'     => esc_html__( 'Min Font Size', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'max_size',

						'heading'     => esc_html__( 'Max Font Size', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_responsive_text );



			/*  [ K2t Testimonial ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_textimonial = array(

				'base'            => 'testimonial',

				'name'            => esc_html__( 'K2t Testimonial', 'skstore' ),

				'icon'            => 'fa fa-comments-o',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name' => 'style',

						'heading' 	 => esc_html__( 'Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Style 1', 'skstore' ) => '1',

							esc_html__( 'Style 2', 'skstore' ) => '2',

							esc_html__( 'Style 3', 'skstore' ) => '3',

						)

					),

					array(

						'param_name'  => 'image',

						'heading'     => esc_html__( 'Avatar', 'skstore' ),

						'description' => esc_html__( 'Choose avatar for testimonial author.', 'skstore' ),

						'type'        => 'attach_image',

						'holder'      => 'div',

					),

					array(

						'param_name' => 'align',

						'heading' 	 => esc_html__( 'Avatar Position', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Left', 'skstore' )  => 'left',

							esc_html__( 'Right', 'skstore' ) => 'right',

						),

						'dependency' => array(

							'element' => 'style',

							'value'   => array( '1' )

						),

					),

					array(

						'param_name'  => 'name',

						'heading'     => esc_html__( 'Name', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'position',

						'heading'     => esc_html__( 'Position', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'target',

						'heading' 	 => esc_html__( 'Link Target', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Open in a new window', 'skstore' ) => '_blank',

							esc_html__( 'Open in the same frame as it was clicked', 'skstore' )  => '_self'

						),

					),

					array(

						'param_name'  => 'content',

						'heading'     => esc_html__( 'Text', 'skstore' ),

						'description' => esc_html__( 'Enter your testimonial.', 'skstore' ),

						'type'        => 'textarea_html',

						'holder'      => 'div',

						'value'       => ''

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_textimonial );



			/*  [ K2t Blockquote ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_blockquote = array(

				'base'            => 'blockquote',

				'name'            => esc_html__( 'K2t Blockquote', 'skstore' ),

				'icon'            => 'fa fa-quote-left',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name' => 'style',

						'heading' 	 => esc_html__( 'Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Style 1', 'skstore' )   => '1',

							esc_html__( 'Style 2', 'skstore' )   => '2',

						),

					),

					array(

						'param_name' => 'align',

						'heading' 	 => esc_html__( 'Align', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Left', 'skstore' )   => 'left',

							esc_html__( 'Center', 'skstore' ) => 'center',

							esc_html__( 'Right', 'skstore' )  => 'right'

						),

					),

					array(

						'param_name'  => 'author',

						'heading'     => esc_html__( 'Author', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'link_author',

						'heading'     => esc_html__( 'Link to', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'content',

						'heading'     => esc_html__( 'Content', 'skstore' ),

						'type'        => 'textarea_html',

						'holder'      => 'div',

						'value'       => ''

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_blockquote );



			/*  [ K2t Countdown ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_countdown = array(

				'base'            => 'countdown',

				'name'            => esc_html__( 'K2t Countdown', 'skstore' ),

				'icon'            => 'fa fa-sort-numeric-desc',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'style',

						'heading'     => esc_html__( 'Countdown Style', 'skstore' ),

						'type' 		  => 'dropdown',

						'value'       => array(

							esc_html__( 'Square', 'skstore' )   			=> 'square',

							esc_html__( 'Circle', 'skstore' )   			=> 'circle',

						),

					),

					array(

						'param_name'  => 'time',

						'heading'     => esc_html__( 'Time', 'skstore' ),

						'description' => esc_html__( 'The time in this format: YYYY-MM-DD-HH-MM-SS', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'year',

						'heading'     => esc_html__( 'The word "Year(s)" in your language', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'month',

						'heading'     => esc_html__( 'The word "Month(s)" in your language', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'day',

						'heading'     => esc_html__( 'The word "Day(s)" in your language', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'hour',

						'heading'     => esc_html__( 'The word "Hour(s)" in your language', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'minute',

						'heading'     => esc_html__( 'The word "Minute(s)" in your language', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'second',

						'heading'     => esc_html__( 'The word "Second(s)" in your language', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'fontsize',

						'heading'     => esc_html__( 'Font Size', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, unit is pixel', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'align',

						'heading' 	 => esc_html__( 'Align', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Left', 'skstore' )   => 'left',

							esc_html__( 'Center', 'skstore' ) => 'center',

							esc_html__( 'Right', 'skstore' )  => 'right'

						),

					),

					array(

						'param_name'  => 'background_color',

						'heading'     => esc_html__( 'Background Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					array(

						'param_name'  => 'text_color',

						'heading'     => esc_html__( 'Number Color', 'skstore' ),

						'type'        => 'colorpicker',

					),

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_countdown );



			/*  [ K2t Embed ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_embed = array(

				'base'            => 'k2t_embed',

				'name'            => esc_html__( 'K2t Embed', 'skstore' ),

				'icon'            => 'fa fa-terminal',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'width',

						'heading'     => esc_html__( 'Width', 'skstore' ),

						'description' => esc_html__( 'Numeric value only, Unit is Pixel.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'content',

						'heading'     => esc_html__( 'URL or embed code', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'value'       => ''

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_embed );



			/*  [ K2T Slider ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_slider = array(

				'base'            => 'k2t_slider',

				'name'            => esc_html__( 'K2t Carousel', 'skstore' ),

				'icon'            => 'fa fa-exchange',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_parent'       => array( 'only' => 'testimonial, vc_single_image, vc_raw_html, event' ),

				'js_view'         => 'VcColumnView',

				'content_element' => true,

				'params'          => array(

					array(

						'param_name' => 'style',

						'heading' 	 => esc_html__( 'Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Style 1', 'skstore' )    => 'style_1',

							esc_html__( 'Style 2', 'skstore' )    => 'style_2',

						),

					),

					array(

						'param_name'  => 'items',

						'heading'     => esc_html__( 'Slides per view', 'skstore' ),

						'description' => esc_html__( 'Numeric value only.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

					),

					array(

						'param_name'  => 'items_desktop',

						'heading'     => esc_html__( 'Slides per view on desktop', 'skstore' ),

						'description' => esc_html__( 'Item to display for desktop small (device width <= 1200px).', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

					),

					array(

						'param_name'  => 'items_tablet',

						'heading'     => esc_html__( 'Slides per view on tablet', 'skstore' ),

						'description' => esc_html__( 'Item to display for tablet (device width <= 768px).', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

					),

					array(

						'param_name'  => 'items_mobile',

						'heading'     => esc_html__( 'Slides per view on mobile', 'skstore' ),

						'description' => esc_html__( 'Item to display for mobile (device width <= 480px).', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

					),

					array(

						'param_name'  => 'single_item',

						'heading'     => esc_html__( 'Single Item', 'skstore' ),

						'description' => esc_html__( 'Display only one item.', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => true

						),

						'dependency' => array(

							'element' => 'style',

							'value'   => array( 'style_1' ),

						),

					),

					array(

						'param_name'  => 'slide_speed',

						'heading'     => esc_html__( 'Slide speed', 'skstore' ),

						'description' => esc_html__( 'Slide speed in milliseconds.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'style',

							'value'   => array( 'style_1' ),

						),

					),

					array(

						'param_name'  => 'auto_play',

						'heading'     => esc_html__( 'Auto Play', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => true

						),

						'dependency' => array(

							'element' => 'style',

							'value'   => array( 'style_1' ),

						),

					),

					array(

						'param_name'  => 'stop_on_hover',

						'heading'     => esc_html__( 'Stop on hover', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => true

						),

						'dependency' => array(

							'element' => 'auto_play',

							'value'   => array( '1' ),

						),

					),

					array(

						'param_name'  => 'navigation',

						'heading'     => esc_html__( 'Navigation', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => true

						),

						'dependency' => array(

							'element' => 'style',

							'value'   => array( 'style_1' ),

						),

					),

					array(

						'param_name'  => 'pagination',

						'heading'     => esc_html__( 'Pagination', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => true

						),

						'dependency' => array(

							'element' => 'style',

							'value'   => array( 'style_1' ),

						),

					),

					array(

						'param_name' => 'pagi_pos',

						'heading' 	 => esc_html__( 'Pagination Position', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Top', 'skstore' )    => 'top',

							esc_html__( 'Bottom', 'skstore' ) => 'bottom',

							esc_html__( 'On Slider', 'skstore' ) => 'on_slider',

						),

						'dependency' => array(

							'element' => 'pagination',

							'value'   => array( '1' ),

						),

					),

					array(

						'param_name' => 'pagi_style',

						'heading' 	 => esc_html__( 'Pagination Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Style 1', 'skstore' ) => '1',

							esc_html__( 'Style 2', 'skstore' ) => '2',

						),

						'dependency' => array(

							'element' => 'pagination',

							'value'   => array( '1' ),

						),

					),

					array(

						'param_name'  => 'lazyLoad',

						'heading'     => esc_html__( 'LazyLoad', 'skstore' ),

						'description' => esc_html__( 'Delays loading of images. Images outside of viewport won\'t be loaded before user scrolls to them. Great for mobile devices to speed up page loadings.', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'value'       => array(

							'' => true

						)

					),

					$k2t_class

				)

			);

			vc_map( $k2t_slider );



			/*  [ K2T sk slider ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_sk_slider = array(

				'base'            => 'k2t_sk_slider',

				'name'            => esc_html__( 'K2t Sk Slider', 'skstore' ),

				'icon'            => 'fa fa-exchange',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_parent'       => array( 'only' => 'k2t_sk_slide' ),

				'js_view'         => 'VcColumnView',

				'content_element' => true,

				'params'          => array(

					array(

						'param_name' => 'style',

						'heading' 	 => esc_html__( 'Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Style 1', 'skstore' )    => '1',

							esc_html__( 'Style 2', 'skstore' )    => '2',

							esc_html__( 'Style 3', 'skstore' )    => '3',

							esc_html__( 'Style 4', 'skstore' )    => '4',

						),

					),

					$k2t_id,

					$k2t_class

				)

			);

			$k2t_sk_slide = array(

				'base'            => 'k2t_sk_slide',

				'name'            => esc_html__( 'sk Slide', 'skstore' ),

				'icon'            => 'fa fa-arrows-h',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'as_child'        => array( 'only' => 'k2t_sk_slider' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name'  => 'title',

						'heading'     => esc_html__( 'Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'sub_title',

						'heading'     => esc_html__( 'Sub Title', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'image',

						'heading' 	 => esc_html__( 'Image in slide', 'skstore' ),

						'type' 		 => 'attach_image',

						'value'      => '',

					),

					$k2t_class

				)

			);

			vc_map( $k2t_sk_slide );

			vc_map( $k2t_sk_slider );



			/*  [ K2t Blog Post ]

			- - - - - - - - - - - - - - - - - - - */

			$k2t_blog_post = array(

				'base'            => 'blog_post',

				'name'            => esc_html__( 'K2t Blog Post', 'skstore' ),

				'icon'            => 'fa fa-file-text',

				'category'        => esc_html__( 'Skstore Shortcodes', 'skstore' ),

				'content_element' => true,

				'params'          => array(

					array(

						'param_name' => 'style',

						'heading' 	 => esc_html__( 'Choose Style', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( 'Style 1', 'skstore' ) => '1',

							esc_html__( 'Style 2', 'skstore' ) => '2',

							esc_html__( 'Style 3', 'skstore' ) => '3',

							esc_html__( 'Style 4', 'skstore' ) => '4',

							esc_html__( 'Style 5', 'skstore' ) => '5',

						),

					),

					array(

						'param_name' => 'rows_num',

						'heading' 	 => esc_html__( 'Number of Rows', 'skstore' ),

						'type' 		 => 'dropdown',

						'value'      => array(

							esc_html__( '1', 'skstore' ) => '1',

							esc_html__( '2', 'skstore' ) => '2',

						),

						'dependency' => array(

							'element' => 'style',

							'value'   => array( '1' ),

						),

					),

					array(

						'param_name'  => 'limit',

						'heading'     => esc_html__( 'Number of posts to show', 'skstore' ),

						'description' => esc_html__( 'Empty is show all posts.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'cat',

						'heading'     => esc_html__( 'Show posts associated with certain categories', 'skstore' ),

						'description' => esc_html__( 'Using category id, separate multiple categories with commas.', 'skstore' ),

						'type'        => 'textfield',

						'holder'      => 'div'

					),

					array(

						'param_name' => 'slider',

						'heading' 	 => esc_html__( 'Enable Slider', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => true

						),

						'dependency' => array(

							'element' => 'style',

							'value'   => array( '2' ),

						),

					),

					array(

						'param_name' => 'show_content',

						'heading' 	 => esc_html__( 'Show Content', 'skstore' ),

						'type' 		 => 'checkbox',

						'value'      => array(

							'' => true

						),

					),

					array(

						'param_name'  => 'items',

						'heading'     => esc_html__( 'Items', 'skstore' ),

						'description' => esc_html__( 'Numeric value only.', 'skstore' ),

						'type'        => 'textfield',

						'dependency' => array(

							'element' => 'slider',

							'value'   => array( '1' ),

						),

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'items_desktop',

						'heading'     => esc_html__( 'Items for Desktop small', 'skstore' ),

						'description' => esc_html__( 'Item to display for desktop small (device width <= 1366px).', 'skstore' ),

						'type'        => 'textfield',

						'dependency' => array(

							'element' => 'slider',

							'value'   => array( '1' ),

						),

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'items_tablet',

						'heading'     => esc_html__( 'Items for Tablet', 'skstore' ),

						'description' => esc_html__( 'Item to display for tablet (device width <= 768px).', 'skstore' ),

						'type'        => 'textfield',

						'dependency' => array(

							'element' => 'slider',

							'value'   => array( '1' ),

						),

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'items_mobile',

						'heading'     => esc_html__( 'Items for Mobile', 'skstore' ),

						'description' => esc_html__( 'Item to display for mobile (device width <= 480px).', 'skstore' ),

						'type'        => 'textfield',

						'dependency' => array(

							'element' => 'slider',

							'value'   => array( '1' ),

						),

						'holder'      => 'div'

					),

					array(

						'param_name'  => 'navigation',

						'heading'     => esc_html__( 'Navigation', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'slider',

							'value'   => array( '1' ),

						),

						'value'       => array(

							'' => 'true'

						)

					),

					array(

						'param_name'  => 'pagination',

						'heading'     => esc_html__( 'Pagination', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'slider',

							'value'   => array( '1' ),

						),

						'value'       => array(

							'' => 'true'

						)

					),

					array(

						'param_name'  => 'auto_play',

						'heading'     => esc_html__( 'Auto Play', 'skstore' ),

						'type'        => 'checkbox',

						'holder'      => 'div',

						'dependency' => array(

							'element' => 'slider',

							'value'   => array( '1' ),

						),

						'value'       => array(

							'' => 'true'

						)

					),

					$k2t_animation,

					$k2t_animation_name,

					$k2t_animation_delay,

					$k2t_id,

					$k2t_class

				)

			);

			vc_map( $k2t_blog_post );



		}



		add_action( 'admin_init', 'k2t_vc_map_shortcodes' );



		/*  [ Extend container class (parents) ]

		- - - - - - - - - - - - - - - - - - - - - - - - - */

		class WPBakeryShortCode_Accordion extends WPBakeryShortCodesContainer {}

		class WPBakeryShortCode_Brands extends WPBakeryShortCodesContainer {}

		class WPBakeryShortCode_Iconlist extends WPBakeryShortCodesContainer {}

		class WPBakeryShortCode_Pricing extends WPBakeryShortCodesContainer {}

		class WPBakeryShortCode_Sticky_Tab extends WPBakeryShortCodesContainer {}

		class WPBakeryShortCode_K2t_Slider extends WPBakeryShortCodesContainer {}

		class WPBakeryShortCode_K2t_sk_Slider extends WPBakeryShortCodesContainer {}

		class WPBakeryShortCode_Banner extends WPBakeryShortCodesContainer {}





		/*  [ Extend shortcode class (children) ]

		- - - - - - - - - - - - - - - - - - - - - - - - - */

		class WPBakeryShortCode_Toggle extends WPBakeryShortCode {}

		class WPBakeryShortCode_Brand extends WPBakeryShortCode {}

		class WPBakeryShortCode_Li extends WPBakeryShortCode {}

		class WPBakeryShortCode_Pricing_Column extends WPBakeryShortCode {}

		class WPBakeryShortCode_Step extends WPBakeryShortCode {}

		class WPBakeryShortCode_Tab extends WPBakeryShortCode {}

		class WPBakeryShortCode_K2t_sk_Slide extends WPBakeryShortCode {}



	endif;

endif;



/*-------------------------------------------------------------------

	Remove Default Visual Composer Shortcode.

--------------------------------------------------------------------*/

if ( class_exists( 'Vc_Manager' ) ) :

	if ( ! function_exists( 'k2t_remove_default_shortcodes' ) ) :



		function k2t_remove_default_shortcodes() {

			vc_remove_element( 'vc_accordion' );

			vc_remove_element( 'vc_pie' );

			vc_remove_element( 'vc_posts_slider' );

			//vc_remove_element( 'vc_widget_sidebar' );

			vc_remove_element( 'vc_button' );

			vc_remove_element( 'vc_carousel' );

			vc_remove_element( 'vc_button2' );

			vc_remove_element( 'vc_cta_button' );

			vc_remove_element( 'vc_cta_button2' );

			vc_remove_element( 'vc_progress_bar' );

			vc_remove_element( 'vc_gmaps' );

			vc_remove_element( 'vc_flickr' );

		}

		add_action( 'admin_init', 'k2t_remove_default_shortcodes' );



	endif;



endif;



/*-------------------------------------------------------------------

	Remove Teaser Metabox.

--------------------------------------------------------------------*/

if ( class_exists( 'Vc_Manager' ) ) :

	if ( is_admin() ) :

		if ( ! function_exists( 'k2t_vc_remove_teaser_metabox' ) ) :



		function k2t_vc_remove_teaser_metabox() {

			$post_types = get_post_types( '', 'names' );

			foreach ( $post_types as $post_type ) {

				remove_meta_box( 'vc_teaser',  $post_type, 'side' );

			}

		}



		add_action( 'do_meta_boxes', 'k2t_vc_remove_teaser_metabox' );



		endif;

	endif;

endif;



/*-------------------------------------------------------------------

	Incremental ID Counter for Templates.

--------------------------------------------------------------------*/

if ( class_exists( 'Vc_Manager' ) ) :

	if ( ! function_exists( 'k2t_vc_templates_id_increment' ) ) :



		function k2t_vc_templates_id_increment() {

			static $count = 0; $count++;

			return $count;

		}



	endif;

endif;

/*--------------------------------------------------------------

	Enqueue google fonts

--------------------------------------------------------------*/

if ( ! function_exists( 'k2t_skstore_enqueue_google_fonts' ) ) {

	function k2t_skstore_enqueue_google_fonts() {

		global $wp_styles, $smof_data;



		$font_families = array();



		if ( isset ( $smof_data['body-font'] ) && in_array ( $smof_data['body-font'], k2t_google_fonts() ) ) {

			$body_font = $smof_data['body-font'];

			$font_families[] = $body_font .':100,300,400,600,700,800';

		}



		if ( isset ( $smof_data['heading-font'] ) && in_array ( $smof_data['heading-font'], k2t_google_fonts() ) ) {

			$heading_font = $smof_data['heading-font'];

			$font_families[] = $heading_font .':100,300,400,600,700,800';

		}



		if ( isset ( $smof_data['mainnav-font'] ) && in_array ( $smof_data['mainnav-font'], k2t_google_fonts() ) ) {

			$mainnav_font = $smof_data['mainnav-font'];

			$font_families[] = $mainnav_font .':100,300,400,600,700,800';

		}



		$query_args = array(

		    'family' => urlencode( implode( '|', $font_families ) ),

		    'subset' => urlencode( 'latin,greek-ext,cyrillic,latin-ext,greek,cyrillic-ext,vietnamese' ),

		);



		if( ! empty( $font_families ) ) {

			wp_enqueue_style( 'google-fonts', add_query_arg( $query_args, "//fonts.googleapis.com/css" ), array(), null );

			wp_enqueue_style( 'google-fonts' );

		}





	}

	add_action( 'wp_enqueue_scripts', 'k2t_skstore_enqueue_google_fonts' );

}

/*--------------------------------------------------------------

	Enqueue google fonts

--------------------------------------------------------------*/

if ( !function_exists( 'k2t_google_fonts' ) ) {

	function k2t_google_fonts() {

		$fonts = 'ABeeZee, Abel, Abril Fatface, Aclonica, Acme, Actor, Adamina, Advent Pro, Aguafina Script, Akronim, Aladin, Aldrich, Alef, Alegreya, Alegreya SC, Alegreya Sans, Alegreya Sans SC, Alex Brush, Alfa Slab One, Alice, Alike, Alike Angular, Allan, Allerta, Allerta Stencil, Allura, Almendra, Almendra Display, Almendra SC, Amarante, Amaranth, Amatic SC, Amethysta, Amiri, Amita, Anaheim, Andada, Andika, Angkor, Annie Use Your Telescope, Anonymous Pro, Antic, Antic Didone, Antic Slab, Anton, Arapey, Arbutus, Arbutus Slab, Architects Daughter, Archivo Black, Archivo Narrow, Arimo, Arizonia, Armata, Artifika, Arvo, Arya, Asap, Asset, Astloch, Asul, Atomic Age, Aubrey, Audiowide, Autour One, Average, Average Sans, Averia Gruesa Libre, Averia Libre, Averia Sans Libre, Averia Serif Libre, Bad Script, Balthazar, Bangers, Basic, Battambang, Baumans, Bayon, Belgrano, Belleza, BenchNine, Bentham, Berkshire Swash, Bevan, Bigelow Rules, Bigshot One, Bilbo, Bilbo Swash Caps, Biryani, Bitter, Black Ops One, Bokor, Bonbon, Boogaloo, Bowlby One, Bowlby One SC, Brawler, Bree Serif, Bubblegum Sans, Bubbler One, Buda, Buenard, Butcherman, Butterfly Kids, Cabin, Cabin Condensed, Cabin Sketch, Caesar Dressing, Cagliostro, Calligraffitti, Cambay, Cambo, Candal, Cantarell, Cantata One, Cantora One, Capriola, Cardo, Carme, Carrois Gothic, Carrois Gothic SC, Carter One, Caudex, Cedarville Cursive, Ceviche One, Changa One, Chango, Chau Philomene One, Chela One, Chelsea Market, Chenla, Cherry Cream Soda, Cherry Swash, Chewy, Chicle, Chivo, Cinzel, Cinzel Decorative, Clicker Script, Coda, Coda Caption, Codystar, Combo, Comfortaa, Coming Soon, Concert One, Condiment, Content, Contrail One, Convergence, Cookie, Copse, Corben, Courgette, Cousine, Coustard, Covered By Your Grace, Crafty Girls, Creepster, Crete Round, Crimson Text, Croissant One, Crushed, Cuprum, Cutive, Cutive Mono, Damion, Dancing Script, Dangrek, Dawning of a New Day, Days One, Dekko, Delius, Delius Swash Caps, Delius Unicase, Della Respira, Denk One, Devonshire, Dhurjati, Didact Gothic, Diplomata, Diplomata SC, Domine, Donegal One, Doppio One, Dorsa, Dosis, Dr Sugiyama, Droid Sans, Droid Sans Mono, Droid Serif, Duru Sans, Dynalight, EB Garamond, Eagle Lake, Eater, Economica, Eczar, Ek Mukta, Electrolize, Elsie, Elsie Swash Caps, Emblema One, Emilys Candy, Engagement, Englebert, Enriqueta, Erica One, Esteban, Euphoria Script, Ewert, Exo, Exo 2, Expletus Sans, Fanwood Text, Fascinate, Fascinate Inline, Faster One, Fasthand, Fauna One, Federant, Federo, Felipa, Fenix, Finger Paint, Fira Mono, Fira Sans, Fjalla One, Fjord One, Flamenco, Flavors, Fondamento, Fontdiner Swanky, Forum, Francois One, Freckle Face, Fredericka the Great, Fredoka One, Freehand, Fresca, Frijole, Fruktur, Fugaz One, GFS Didot, GFS Neohellenic, Gabriela, Gafata, Galdeano, Galindo, Gentium Basic, Gentium Book Basic, Geo, Geostar, Geostar Fill, Germania One, Gidugu, Gilda Display, Give You Glory, Glass Antiqua, Glegoo, Gloria Hallelujah, Goblin One, Gochi Hand, Gorditas, Goudy Bookletter 1911, Graduate, Grand Hotel, Gravitas One, Great Vibes, Griffy, Gruppo, Gudea, Gurajada, Habibi, Halant, Hammersmith One, Hanalei, Hanalei Fill, Handlee, Hanuman, Happy Monkey, Headland One, Henny Penny, Herr Von Muellerhoff, Hind, Holtwood One SC, Homemade Apple, Homenaje, IM Fell DW Pica, IM Fell DW Pica SC, IM Fell Double Pica, IM Fell Double Pica SC, IM Fell English, IM Fell English SC, IM Fell French Canon, IM Fell French Canon SC, IM Fell Great Primer, IM Fell Great Primer SC, Iceberg, Iceland, Imprima, Inconsolata, Inder, Indie Flower, Inika, Irish Grover, Istok Web, Italiana, Italianno, Jacques Francois, Jacques Francois Shadow, Jaldi, Jim Nightshade, Jockey One, Jolly Lodger, Josefin Sans, Josefin Slab, Joti One, Judson, Julee, Julius Sans One, Junge, Jura, Just Another Hand, Just Me Again Down Here, Kalam, Kameron, Kantumruy, Karla, Karma, Kaushan Script, Kavoon, Kdam Thmor, Keania One, Kelly Slab, Kenia, Khand, Khmer, Khula, Kite One, Knewave, Kotta One, Koulen, Kranky, Kreon, Kristi, Krona One, Kurale, La Belle Aurore, Laila, Lakki Reddy, Lancelot, Lateef, Lato, League Script, Leckerli One, Ledger, Lekton, Lemon, Libre Baskerville, Life Savers, Lilita One, Lily Script One, Limelight, Linden Hill, Lobster, Lobster Two, Londrina Outline, Londrina Shadow, Londrina Sketch, Londrina Solid, Lora, Love Ya Like A Sister, Loved by the King, Lovers Quarrel, Luckiest Guy, Lusitana, Lustria, Macondo, Macondo Swash Caps, Magra, Maiden Orange, Mako, Mallanna, Mandali, Marcellus, Marcellus SC, Marck Script, Margarine, Marko One, Marmelad, Martel, Martel Sans, Marvel, Mate, Mate SC, Maven Pro, McLaren, Meddon, MedievalSharp, Medula One, Megrim, Meie Script, Merienda, Merienda One, Merriweather, Merriweather Sans, Metal, Metal Mania, Metamorphous, Metrophobic, Michroma, Milonga, Miltonian, Miltonian Tattoo, Miniver, Miss Fajardose, Modak, Modern Antiqua, Molengo, Molle, Monda, Monofett, Monoton, Monsieur La Doulaise, Montaga, Montez, Montserrat, Montserrat Alternates, Montserrat Subrayada, Moul, Moulpali, Mountains of Christmas, Mouse Memoirs, Mr Bedfort, Mr Dafoe, Mr De Haviland, Mrs Saint Delafield, Mrs Sheppards, Muli, Mystery Quest, NTR, Neucha, Neuton, New Rocker, News Cycle, Niconne, Nixie One, Nobile, Nokora, Norican, Nosifer, Nothing You Could Do, Noticia Text, Noto Sans, Noto Serif, Nova Cut, Nova Flat, Nova Mono, Nova Oval, Nova Round, Nova Script, Nova Slim, Nova Square, Numans, Nunito, Odor Mean Chey, Offside, Old Standard TT, Oldenburg, Oleo Script, Oleo Script Swash Caps, Open Sans, Open Sans Condensed, Oranienbaum, Orbitron, Oregano, Orienta, Original Surfer, Oswald, Over the Rainbow, Overlock, Overlock SC, Ovo, Oxygen, Oxygen Mono, PT Mono, PT Sans, PT Sans Caption, PT Sans Narrow, PT Serif, PT Serif Caption, Pacifico, Palanquin, Palanquin Dark, Paprika, Parisienne, Passero One, Passion One, Pathway Gothic One, Patrick Hand, Patrick Hand SC, Patua One, Paytone One, Peddana, Peralta, Permanent Marker, Petit Formal Script, Petrona, Philosopher, Piedra, Pinyon Script, Pirata One, Plaster, Play, Playball, Playfair Display, Playfair Display SC, Podkova, Poiret One, Poller One, Poly, Pompiere, Pontano Sans, Poppins, Port Lligat Sans, Port Lligat Slab, Pragati Narrow, Prata, Preahvihear, Press Start 2P, Princess Sofia, Prociono, Prosto One, Puritan, Purple Purse, Quando, Quantico, Quattrocento, Quattrocento Sans, Questrial, Quicksand, Quintessential, Qwigley, Racing Sans One, Radley, Rajdhani, Raleway, Raleway Dots, Ramabhadra, Ramaraja, Rambla, Rammetto One, Ranchers, Rancho, Ranga, Rationale, Ravi Prakash, Redressed, Reenie Beanie, Revalia, Rhodium Libre, Ribeye, Ribeye Marrow, Righteous, Risque, Roboto, Roboto Condensed, Roboto Mono, Roboto Slab, Rochester, Rock Salt, Rokkitt, Romanesco, Ropa Sans, Rosario, Rosarivo, Rouge Script, Rozha One, Rubik Mono One, Rubik One, Ruda, Rufina, Ruge Boogie, Ruluko, Rum Raisin, Ruslan Display, Russo One, Ruthie, Rye, Sacramento, Sail, Salsa, Sanchez, Sancreek, Sansita One, Sarina, Sarpanch, Satisfy, Scada, Scheherazade, Schoolbell, Seaweed Script, Sevillana, Seymour One, Shadows Into Light, Shadows Into Light Two, Shanti, Share, Share Tech, Share Tech Mono, Shojumaru, Short Stack, Siemreap, Sigmar One, Signika, Signika Negative, Simonetta, Sintony, Sirin Stencil, Six Caps, Skranji, Slabo 13px, Slabo 27px, Slackey, Smokum, Smythe, Sniglet, Snippet, Snowburst One, Sofadi One, Sofia, Sonsie One, Sorts Mill Goudy, Source Code Pro, Source Sans Pro, Source Serif Pro, Special Elite, Spicy Rice, Spinnaker, Spirax, Squada One, Sree Krushnadevaraya, Stalemate, Stalinist One, Stardos Stencil, Stint Ultra Condensed, Stint Ultra Expanded, Stoke, Strait, Sue Ellen Francisco, Sumana, Sunshiney, Supermercado One, Suranna, Suravaram, Suwannaphum, Swanky and Moo Moo, Syncopate, Tangerine, Taprom, Tauri, Teko, Telex, Tenali Ramakrishna, Tenor Sans, Text Me One, The Girl Next Door, Tienne, Tillana, Timmana, Tinos, Titan One, Titillium Web, Trade Winds, Trocchi, Trochut, Trykker, Tulpen One, Ubuntu, Ubuntu Condensed, Ubuntu Mono, Ultra, Uncial Antiqua, Underdog, Unica One, UnifrakturCook, UnifrakturMaguntia, Unkempt, Unlock, Unna, VT323, Vampiro One, Varela, Varela Round, Vast Shadow, Vesper Libre, Vibur, Vidaloka, Viga, Voces, Volkhov, Vollkorn, Voltaire, Waiting for the Sunrise, Wallpoet, Walter Turncoat, Warnes, Wellfleet, Wendy One, Wire One, Yanone Kaffeesatz, Yantramanav, Yellowtail, Yeseva One, Yesteryear, Zeyada';



		$font_array = explode( ',', $fonts );

		foreach ( $font_array as $font ) {

			$font = trim( $font );

			$google_fonts_array[$font] = $font;

		}

		return $google_fonts_array;

	}

}

?>
<?php

if ( !function_exists( 'k2t_fonts_array' ) ) {

	function k2t_fonts_array() {

		return k2t_google_fonts();

	}

}
