<?php

/**

 * Main function for theme.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



if ( ! function_exists( 'k2t_skstore_setup' ) ) {

	/**

	 * Sets up theme defaults and registers support for various WordPress features.

	 *

	 * Note that this function is hooked into the after_setup_theme hook, which

	 * runs before the init hook. The init hook is too late for some features, such

	 * as indicating support for post thumbnails.

	 *

	 * @since sk 1.0

	 */

	function k2t_skstore_setup() {

		global $smof_data, $content_width;

		/**

		 * Make theme available for translation.

		 * Translations can be filed in the /languages/ directory.

		 * If you're building a theme based on sk, use a find and replace

		 * to change 'skstore' to the name of your theme in all the template files

		 */

		load_theme_textdomain( 'skstore', get_template_directory() . '/languages' );



		/**

		 * Add default posts and comments RSS feed links to head.

		 */

		add_theme_support( 'automatic-feed-links' );

		

		/**

		 * Add custom header default

		 */

		add_theme_support( 'custom-header' );		

		

		/**

		 * Add custom background default

		 */

		add_theme_support( "custom-background" );

	

		/*

		 * Enable support for Post Formats.

		 * See http://codex.wordpress.org/Post_Formats

		 */

		add_theme_support( 'post-formats', array( 'video', 'audio', 'gallery', 'quote', 'image' ) );



		/**

		 * Enable support for Post Thumbnails on posts and pages.

		 *

		 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails

		 */

		add_theme_support( 'post-thumbnails' );



		// Add images size

		add_image_size( 'k2t_skstore_870x345', 870, 345, true );		// blog style 5

		add_image_size( 'k2t_skstore_570x675', 570, 675, true );		// blog style 5

		add_image_size( 'k2t_skstore_270x345', 270, 345, true );		// blog style 5

		add_image_size( 'k2t_skstore_120x90', 120, 90, true );

		add_image_size( 'k2t_skstore_100x80', 100, 80, true );

   		add_image_size( 'k2t_skstore_300x400', 300, 400, true );

   		add_image_size( 'k2t_skstore_285x460', 285, 460, false );

		add_image_size( 'k2t_skstore_371x371', 371, 371, true );

		add_image_size( 'k2t_skstore_500x333', 500, 333, true );

		add_image_size( 'k2t_skstore_500x746', 500, 746, true );

		add_image_size( 'k2t_skstore_500x500', 500, 500, true );

		add_image_size( 'k2t_skstore_184x184', 184, 184, true );

		add_image_size( 'k2t_skstore_570x444', 570, 444, true );

		add_image_size( 'k2t_skstore_570x570', 570, 570, true );

		add_image_size( 'k2t_skstore_270x365', 270, 365, true );

		add_image_size( 'k2t_skstore_570x630', 570, 630, true );

		add_image_size( 'k2t_skstore_200x200', 200, 200, false );

		add_image_size( 'k2t_skstore_300x300', 300, 300, false );

		add_image_size( 'k2t_skstore_386x370', 386, 370, false );

		add_image_size( 'k2t_skstore_300x433', 300, 433, true );

		add_image_size( 'k2t_skstore_370x467', 370, 467, false );

		add_image_size( 'k2t_skstore_590x733', 590, 733, true );

		add_image_size( 'k2t_skstore_770x520', 750, 520, true );

		add_image_size( 'k2t_skstore_1000x500', 1000, 500, true );

		add_image_size( 'k2t_skstore_999x999', 999, 999, false );



		/**

		 * Add default woocommerce plugin.

		 */

		add_theme_support( 'woocommerce' );	



		/**

		 * Add support title-tag

		 */

		add_theme_support( 'title-tag' );		

		

		/**

		 * This theme uses wp_nav_menu() in one location.

		 *

		 * @link http://codex.wordpress.org/Post_Formats

		 */



		register_nav_menus(

			array(

				'mobile'  => esc_html__( 'Mobile Menu', 'skstore' ),

				'primary' => esc_html__( 'Main Menu', 'skstore' ),

			)

		);



		/**

		 * Tell the TinyMCE editor to use a custom stylesheet

		 */

		add_editor_style( 'assets/css/editor-style.css' );

		

		/**

		 * Set the content width based on the theme's design and stylesheet.

		 */

		if ( ! isset( $content_width ) ) {

			$content_width = isset( $smof_data['content-width'] ) ? $smof_data['content-width'] : 1100;

		}

		

	}

	add_action( 'after_setup_theme', 'k2t_skstore_setup' );

}



/* =========== Retina Logo ================ */

if ( !function_exists( 'k2t_replace_retina_logo' ) ) {

    function k2t_replace_retina_logo() {

        global $smof_data;

        $logo = isset( $smof_data['logo'] ) ? $smof_data['logo'] : get_template_directory_uri() . '/assets/img/logo.png';

        $logo_s = ( isset( $logo ) && file_exists( $logo ) ) ? getimagesize( $logo ) : array();

        echo "<sc"."ript>";?>

        jQuery(document).ready(function(){

            var retina = window.devicePixelRatio > 1 ? true : false;

            <?php if ( isset( $smof_data['retina-logo'] ) && $smof_data['retina-logo'] ): ?>

            if(retina) {

                jQuery('.k2t-logo img').attr('src', '<?php echo $smof_data["retina-logo"]; ?>');

                <?php if ( isset( $logo_s[0] ) && !empty( $logo_s[0] ) ):?>

                jQuery('.k2t-logo img').attr('width', '<?php echo $logo_s[0]; ?>');

                <?php endif;?>

                <?php if ( isset( $logo_s[1] ) && !empty( $logo_s[1] ) ):?>

                jQuery('.k2t-logo img').attr('height', '<?php echo $logo_s[1]; ?>');

                <?php endif;?>

            }

            <?php endif; ?>

        });

        <?php echo "</sc"."ript>";

    }

    add_action( 'wp_head', 'k2t_replace_retina_logo' );

}







/**

 * Adds sticky menu classes to the array of body classes.

 *

 * @param array $classes Classes for the body element.

 * @return array

 */

if ( ! function_exists( 'k2t_skstore_add_body_class' ) ) {

	function k2t_skstore_add_body_class( $classes ) {

		global $smof_data;

		if ( ! empty( $smof_data['vertical-menu'] ) ) {

			$classes[] = 'vertical';

		}



		if ( ! empty( $smof_data['boxed-layout'] ) ) {

			$classes[] = 'boxed';

		}



		return $classes;

	}

	add_filter( 'body_class', 'k2t_skstore_add_body_class' );

}



/**

 * Filters wp_title to print a neat <title> tag based on what is being viewed.

 *

 * @param string $title Default title text for current view.

 * @param string $sep Optional separator.

 * @return string The filtered title.

 */

if ( version_compare( $GLOBALS['wp_version'], '4.1', '<' ) ) :

	function k2t_skstore_wp_title( $title, $sep ) {

		if ( is_feed() ) {

			return $title;

		}



		global $page, $paged;



		// Add the blog name

		$title .= get_bloginfo( 'name', 'display' );



		// Add the blog description for the home/front page.

		$site_description = get_bloginfo( 'description', 'display' );

		if ( $site_description && ( is_home() || is_front_page() ) ) {

			$title .= " $sep $site_description";

		}



		// Add a page number if necessary:

		if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {

			$title .= " $sep " . sprintf( esc_html__( 'Page %s', 'skstore' ), max( $paged, $page ) );

		}



		return $title;

	}

	add_filter( 'wp_title', 'k2t_skstore_wp_title', 10, 2 );



	/**

	 * Title shim for sites older than WordPress 4.1.

	 *

	 * @link https://make.wordpress.org/core/2014/10/29/title-tags-in-4-1/

	 * @todo Remove this function when WordPress 4.3 is released.

	 */

	function k2t_skstore_render_title() {

		?>

		<title><?php wp_title( '|', true, 'right' ); ?></title>

		<?php

	}

	add_action( 'wp_head', 'k2t_skstore_render_title' );

endif;



/**

 * Register required plugins.

 *

 * @return  void

 */

if ( ! function_exists( 'k2t_skstore_register_theme_dependency' ) ) {

	function k2t_skstore_register_theme_dependency() {

		$plugins = array(

			array(

				'name'     => esc_html__('WooCommerce','skstore'),

				'slug'     => 'woocommerce',

				'required' => false,

			),

			array(

				'name'     => esc_html__('Yith Woocommerce Quick View','skstore'),

				'slug'     => 'yith-woocommerce-quick-view',

				'required' => false,

			),

			array(

				'name'     => esc_html__('WP Instagram Widget','skstore'),

				'slug'     => 'wp-instagram-widget',

				'required' => false,

			),

			array(

				'name'     => esc_html__('Contact Form 7','skstore'),

				'slug'     => 'contact-form-7',

				'required' => false,

			),

			array(

				'name'     => esc_html__('Envato Market','skstore'),

				'slug'     => 'envato-market',

				'source'   => get_template_directory() . '/framework/extensions/plugins/envato-market.zip',

				'required' => false,

			),

			array(

				'name'     => esc_html__('zM Ajax Login & Register','skstore'),

				'slug'     => 'zm-ajax-login-register',

				'required' => false,

			),

			array(

				'name'     => esc_html__('Visual composer','skstore'),

				'slug'     => 'js_composer',

				'source'   => get_template_directory() . '/framework/extensions/plugins/js_composer.zip',

				'required' => true,

			),

			array(

				'name'               => esc_html__('K2T SK Shortcodes','skstore'),

				'slug'               => 'k2t-sk-shortcodes',

				'source'             => get_template_directory() . '/framework/extensions/plugins/k2t-sk-shortcodes.zip',

				'required'           => true,

				'force_activation'   => false,

				'force_deactivation' => false,

			),

			array(

				'name'     => esc_html__('Advanced Custom Fields Pro','skstore'),

				'slug'     => 'advanced-custom-fields-pro',

				'source'   => get_template_directory() . '/framework/extensions/plugins/advanced-custom-fields-pro.zip',

				'required' => true,

			),

			array(

				'name'     => esc_html__('Revolution Slider','skstore'),

				'slug'     => 'revslider',

				'source'   => get_template_directory() . '/framework/extensions/plugins/revslider.zip',

				'required' => false,

			),

			array(

				'name'     => esc_html__('DHVC Woocommerce Products Layouts','skstore'),

				'slug'     => 'dhvc-woocommerce',

				'source'   => get_template_directory() . '/framework/extensions/plugins/dhvc-woocommerce.zip',

				'required' => false,

			),

			array(

				'name'     => esc_html__('WOO Product Page for Visual Composer','skstore'),

				'slug'     => 'dhvc-woocommerce-page',

				'source'   => get_template_directory() . '/framework/extensions/plugins/dhvc-woocommerce-page.zip',

				'required' => false,

			),

		);



		tgmpa( $plugins );

	}

	add_action( 'tgmpa_register', 'k2t_skstore_register_theme_dependency' );

}



/**

 * Print custom code at the end of head section.

 *

 * @package skstore

 */

if ( ! function_exists( 'k2t_skstore_add_head_code' ) ) {

	function k2t_skstore_add_head_code() {

		global $smof_data;

		if ( isset ( $smof_data['header_code'] ) && $smof_data['header_code'] ) {

			echo ($smof_data['header_code']);

		}

	}

	add_action( 'wp_head', 'k2t_skstore_add_head_code' );

}



/**

 * Print custom code at the end of body section.

 *

 * @package skstore

 */

if ( ! function_exists( 'k2t_skstore_add_footer_code' ) ) {

	function k2t_skstore_add_footer_code() {

		global $smof_data;

		if ( isset ( $smof_data['footer_code'] ) && $smof_data['footer_code'] ) {

			echo ($smof_data['footer_code']);

		}

	}

	add_action( 'wp_footer', 'k2t_skstore_add_footer_code' );

}



/**

 * Change favicon option

 *

 * @package skstore

 */

if ( ! function_exists( 'k2t_skstore_extra_icons' ) ) {

	function k2t_skstore_extra_icons() {

		global $pagenow;

		if ( $pagenow != 'wp-login.php' &&  ! has_site_icon() &&  ! is_admin() && ( ! function_exists( 'wp_site_icon' ) || ! wp_site_icon() ) ) {



			global $smof_data;

			if ( isset ( $smof_data['favicon'] ) && $smof_data['favicon'] ) {

				echo '<link sizes="16x16" href="'. esc_url( $smof_data['favicon'] ) .'" rel="icon" />';

			}

			if ( isset ( $smof_data['apple-iphone-icon'] ) && $smof_data['apple-iphone-icon'] ) {

				echo '<link rel="apple-touch-icon" sizes="57x57" href="' . esc_url( $smof_data["apple-iphone-icon"] ) . '" />';

			}

			if ( isset ( $smof_data['apple-iphone-retina-icon'] ) && $smof_data['apple-iphone-retina-icon'] ) {

				echo '<link rel="apple-touch-icon-precomposed" sizes="114x114" href="' . esc_url( $smof_data["apple-iphone-retina-icon"] ) . '" />';

			}

			if ( isset ( $smof_data['apple-ipad-icon'] ) && $smof_data['apple-ipad-icon'] ) {

				echo '<link rel="apple-touch-icon" sizes="72x72" href="' . esc_url( $smof_data["apple-ipad-icon"] ) . '" />';

			}

			if ( isset ( $smof_data['apple-ipad-retina-icon'] ) && $smof_data['apple-ipad-retina-icon'] ) {

				echo '<link rel="apple-touch-icon" sizes="144x144" href="' . esc_url( $smof_data["apple-ipad-retina-icon"] ) . '" />';

			}

		}

	}

	add_action( 'wp_head', 'k2t_skstore_extra_icons', 1 );

}



/* =========== Retina Logo ================ */

if ( !function_exists( 'k2t_replace_retina_logo' ) ) {

    function k2t_replace_retina_logo() {

        global $smof_data;

        $logo = isset( $smof_data['logo'] ) ? $smof_data['logo'] : get_template_directory_uri() . '/assets/img/logo.png';

        $logo_s = ( isset( $logo ) && file_exists( $logo ) ) ? getimagesize( $logo ) : array();

        echo "<sc"."ript>";?>

        jQuery(document).ready(function(){

            var retina = window.devicePixelRatio > 1 ? true : false;

            <?php if ( isset( $smof_data['retina-logo'] ) && $smof_data['retina-logo'] ): ?>

            if(retina) {

                jQuery('.k2t-logo img').attr('src', '<?php echo $smof_data["retina-logo"]; ?>');

                <?php if ( isset( $logo_s[0] ) && !empty( $logo_s[0] ) ):?>

                jQuery('.k2t-logo img').attr('width', '<?php echo $logo_s[0]; ?>');

                <?php endif;?>

                <?php if ( isset( $logo_s[1] ) && !empty( $logo_s[1] ) ):?>

                jQuery('.k2t-logo img').attr('height', '<?php echo $logo_s[1]; ?>');

                <?php endif;?>

            }

            <?php endif; ?>

        });

        <?php echo "</sc"."ript>";

    }

    add_action( 'wp_head', 'k2t_replace_retina_logo' );

}





/**

 * Add a thumbnail column in edit.php

 * Source: http://wordpress.org/support/topic/adding-custum-post-type-thumbnail-to-the-edit-screen

 */

if ( ! function_exists( 'k2t_skstore_columns_filter' ) ) {

	function k2t_skstore_columns_filter( $columns ) {

		$column_thumbnail = array( 'thumbnail' => esc_html__( 'Thumbnail', 'skstore' ) );

		$columns = array_slice( $columns, 0, 1, true ) + $column_thumbnail + array_slice( $columns, 1, NULL, true );

		return $columns;

	}

	add_filter( 'manage_edit-post_columns', 'k2t_skstore_columns_filter', 10, 1 );

}

if ( ! function_exists( 'k2t_skstore_add_thumbnail_value_editscreen' ) ) {

	function k2t_skstore_add_thumbnail_value_editscreen( $column_name, $post_id ) {



		$width  = (int) 50;

		$height = (int) 50;



		if ( 'thumbnail' == $column_name ) {

			// thumbnail of WP 2.9

			$thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );

			// image from gallery

			$attachments = get_children( array( 'post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image' ) );

			if ( $thumbnail_id )

				$thumb = wp_get_attachment_image( $thumbnail_id, array( $width, $height ), true );

			elseif ( $attachments ) {

				foreach ( $attachments as $attachment_id => $attachment ) {

					$thumb = wp_get_attachment_image( $attachment_id, array( $width, $height ), true );

				}

			}

			if ( isset( $thumb ) && $thumb ) {

				echo ( $thumb );

			} else {

				echo '<em>' . esc_html__( 'None', 'skstore' ) . '</em>';

			}

		}

	}

	add_action( 'manage_posts_custom_column', 'k2t_skstore_add_thumbnail_value_editscreen', 10, 2 );

}



/**

 * Custom function to use to open and display each comment.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_comments' ) ) :

	function k2t_skstore_comments( $comment, $args, $depth ) {

	// Globalize comment object

		$GLOBALS['comment'] = $comment;



		switch ( $comment->comment_type ) :



			case 'pingback'  :

			case 'trackback' :

				?>

				<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">

					<p>

						<?php

						esc_html_e( 'Pingback:', 'skstore' );

						comment_author_link();

						edit_comment_link( esc_html__( 'Edit', 'skstore' ), '<span class="edit-link">', '</span>' );

						?>

					</p>

				<?php

			break;



			default :

				global $post;

				?>

				<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">

					<article id="comment-<?php comment_ID(); ?>" class="comment-body">

						<?php

						echo '<div class="comment-thumb">' . get_avatar( $comment, 80 ) . '</div>';

						

						if ( '0' == $comment->comment_approved ) : ?>

						<p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'skstore' ); ?></p>

						<?php endif; ?>			



						<section class="comment-content comment">

							<header class="comment-meta">

								<?php

								printf(

									'<cite class="comment-author">%1$s</cite>',

									'<span>' . get_comment_author_link() . '</span>',

									( $comment->user_id == $post->post_author ) ? '<span class="author-post">' . esc_html__( 'Post author', 'skstore' ) . '</span>' : ''

								);



								printf(

									'<a href="%1$s"><time>%3$s</time></a>',

									esc_url( get_comment_link( $comment->comment_ID ) ),

									get_comment_time( 'c' ),

									sprintf( esc_html__( '%1$s at %2$s', 'skstore' ), get_comment_date(), get_comment_time() )

								);



								?>

							</header>

							<?php comment_text(); ?>

						</section><!-- .comment-content -->						

					</article><!-- #comment- -->

				<?php

			break;



		endswitch;

	}

endif;





/**

 * Add payment method.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_payment_array' ) ) {

	function k2t_skstore_payment_array() {

		return array(

			'Visa'		=>	esc_html__( 'visa-32.png', 'skstore' ),

			'MasterCard'		=>	esc_html__( 'mastercard-32.png', 'skstore' ),

			'Paypal'	=>	esc_html__( 'paypal-32.png', 'skstore' ),

			'WesternUnion'	 	=>	esc_html__( 'western-union-32.png', 'skstore' ),

			'2co'	 	=>	esc_html__( '2co-32.png', 'skstore' ),

			'ach'	 	=>	esc_html__( 'ach-32.png', 'skstore' ),

			'american-express'	 	=>	esc_html__( 'american-express-32.png', 'skstore' ),

			'cirrus'	 	=>	esc_html__( 'cirrus-32.png', 'skstore' ),

			'delta'	 	=>	esc_html__( 'delta-32.png', 'skstore' ),

			'discover'	 	=>	esc_html__( 'discover-32.png', 'skstore' ),

			'jcb'	 	=>	esc_html__( 'jcb-32.png', 'skstore' ),

			'lovicons'	 	=>	esc_html__( 'lovicons-payment-card-glyphs-32_25.png', 'skstore' ),

			'maestro'	 	=>	esc_html__( 'maestro-32.png', 'skstore' ),

			'moneybookers'	 	=>	esc_html__( 'moneybookers-32.png', 'skstore' ),

			'solo'	 	=>	esc_html__( 'solo-32.png', 'skstore' ),

			'switch'	 	=>	esc_html__( 'switch-32.png', 'skstore' ),

		);

	}

}

/**

 * Add social network.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_social_array' ) ) {

	function k2t_skstore_social_array() {

		return array(

			'facebook'		=>	esc_html__( ' Facebook', 'skstore' ),

			'twitter'		=>	esc_html__( ' Twitter', 'skstore' ),

			'google-plus'	=>	esc_html__( ' Google+', 'skstore' ),

			'linkedin'	 	=>	esc_html__( ' LinkedIn', 'skstore' ),

			'tumblr'	 	=>	esc_html__( ' Tumblr', 'skstore' ),

			'pinterest'	 	=>	esc_html__( ' Pinterest', 'skstore' ),

			'youtube'	 	=>	esc_html__( ' YouTube', 'skstore' ),

			'skype'	 		=>	esc_html__( ' Skype', 'skstore' ),

			'instagram'	 	=>	esc_html__( ' Instagram', 'skstore' ),

			'delicious'	 	=>	esc_html__( ' Delicious', 'skstore' ),

			'reddit'		=>	esc_html__( ' Reddit', 'skstore' ),

			'stumbleupon'	=>	esc_html__( ' StumbleUpon', 'skstore' ),

			'wordpress'	 	=>	esc_html__( ' WordPress', 'skstore' ),

			'joomla'		=>	esc_html__( ' Joomla', 'skstore' ),

			'blogger'	 	=>	esc_html__( ' Blogger', 'skstore' ),

			'vimeo'	 		=>	esc_html__( ' Vimeo', 'skstore' ),

			'yahoo'	 		=>	esc_html__( ' Yahoo!', 'skstore' ),

			'flickr'	 	=>	esc_html__( ' Flickr', 'skstore' ),

			'picasa'	 	=>	esc_html__( ' Picasa', 'skstore' ),

			'deviantart'	=>	esc_html__( ' DeviantArt', 'skstore' ),

			'github'	 	=>	esc_html__( ' GitHub', 'skstore' ),

			'stackoverflow'	=>	esc_html__( ' StackOverFlow', 'skstore' ),

			'xing'	 		=>	esc_html__( ' Xing', 'skstore' ),

			'flattr'	 	=>	esc_html__( ' Flattr', 'skstore' ),

			'foursquare'	=>	esc_html__( ' Foursquare', 'skstore' ),

			'paypal'	 	=>	esc_html__( ' Paypal', 'skstore' ),

			'yelp'	 		=>	esc_html__( ' Yelp', 'skstore' ),

			'soundcloud'	=>	esc_html__( ' SoundCloud', 'skstore' ),

			'lastfm'	 	=>	esc_html__( ' Last.fm', 'skstore' ),

			'lanyrd'	 	=>	esc_html__( ' Lanyrd', 'skstore' ),

			'dribbble'	 	=>	esc_html__( ' Dribbble', 'skstore' ),

			'forrst'	 	=>	esc_html__( ' Forrst', 'skstore' ),

			'steam'	 		=>	esc_html__( ' Steam', 'skstore' ),

			'behance'		=>	esc_html__( ' Behance', 'skstore' ),

			'mixi'			=>	esc_html__( ' Mixi', 'skstore' ),

			'weibo'			=>	esc_html__( ' Weibo', 'skstore' ),

			'renren'		=>	esc_html__( ' Renren', 'skstore' ),

			'evernote'		=>	esc_html__( ' Evernote', 'skstore' ),

			'dropbox'		=>	esc_html__( ' Dropbox', 'skstore' ),

			'bitbucket'		=>	esc_html__( ' Bitbucket', 'skstore' ),

			'trello'		=>	esc_html__( ' Trello', 'skstore' ),

			'vk'			=>	esc_html__( ' VKontakte', 'skstore' ),

			'home'			=>	esc_html__( ' Homepage', 'skstore' ),

			'enskpe'		=>	esc_html__( ' Email', 'skstore' ),

			'rss'			=>	esc_html__( ' RSS', 'skstore' ),

		);

	}

}



/**

 * Pagination render.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_get_pagination' ) ) {

	function k2t_skstore_get_pagination( $custom_query = false ) {

		global $wp_query;



		if ( ! $custom_query ) $custom_query = $wp_query;



		$big = 999999999; // need an unlikely integer

		$pagination = paginate_links( array(

			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),

			'format' => '?paged=%#%',

			'current' => max( 1, get_query_var( 'paged' ) ),

			'total' => $custom_query->max_num_pages,

			'type'   => 'list',

			'prev_text'    => sprintf( esc_html__( '%s &larr; Previous', 'skstore' ), '<i class="icon-angle-left"></i>' ),

			'next_text'    => sprintf( esc_html__( 'Next &rarr; %s', 'skstore' ), '<i class="icon-angle-right"></i>' ),

		) );



		if ( $pagination ) {

			return '<div class="srol-pagination">'. $pagination . '<div class="clearfix"></div></div>';

		} else return;

	}

}



// GET FOOTER BACKGROUND SETTING 



if ( ! function_exists( 'k2t_skstore_footer_bg' ) ) :

	function k2t_skstore_footer_bg() {



		global $smof_data;



		// Get footer info

		$footer_background_image    = $smof_data['footer-background-image'];

		$footer_background_color    = $smof_data['footer-background-color'];

		$footer_background_repeat   = $smof_data['footer-background-repeat'];

		$footer_background_size     = $smof_data['footer-background-size'];

		$footer_background_position = $smof_data['footer-background-position'];



		$footer_class = array();



		if ( ! empty( $footer_background_image ) ) {

			$footer_class[] = 'background-image:url(' . $footer_background_image . ');';

		}

		if ( ! empty( $footer_background_color ) ) {

			$footer_class[] = 'background-color:' . $footer_background_color . ';';

		}

		if ( ! empty( $footer_background_repeat ) ) {

			$footer_class[] = 'background-repeat:' . $footer_background_repeat . ';';

		}

		if ( ! empty( $footer_background_size ) ) {

			$footer_class[] = 'background-size:' . $footer_background_size . ';';

		}

		if ( ! empty( $footer_background_position ) ) {

			$footer_class[] = 'background-position:' . $footer_background_position . ';';

		}

		return $footer_class;

	}

endif;



if ( ! function_exists( 'skstore_bottom_footer_bg' ) ) :

	function skstore_bottom_footer_bg() {



		global $smof_data;



		// Get footer info



		$bottom_background_image    = $smof_data['bottom-background-image'];

		$bottom_background_color    = $smof_data['bottom-background-color'];

		$bottom_background_repeat   = $smof_data['bottom-background-repeat'];

		$bottom_background_size     = $smof_data['bottom-background-size'];

		$bottom_background_position = $smof_data['bottom-background-position'];



		$bottom_class = array();



		if ( ! empty( $bottom_background_image ) ) {

			$bottom_class[] = 'background-image:url(' . $bottom_background_image . ');';

		}

		if ( ! empty( $bottom_background_color ) ) {

			$bottom_class[] = 'background-color:' . $bottom_background_color . ';';

		}

		if ( ! empty( $bottom_background_repeat ) ) {

			$bottom_class[] = 'background-repeat:' . $bottom_background_repeat . ';';

		}

		if ( ! empty( $bottom_background_size ) ) {

			$bottom_class[] = 'background-size:' . $bottom_background_size . ';';

		}

		if ( ! empty( $bottom_background_position ) ) {

			$bottom_class[] = 'background-position:' . $bottom_background_position . ';';

		}

		return $bottom_class;

	}

endif;



/* Check Footer Layout */

if ( ! function_exists( 'k2t_skstore_check_footer' ) ) :

	function k2t_skstore_check_footer() {

		global $smof_data;

		$bottom_sidebars_layout = $smof_data['bottom-sidebars-layout'];

		ob_start();

			if ( ! empty( $bottom_sidebars_layout ) ) {

				switch( $bottom_sidebars_layout ) {

					case 'layout-2':

						for ( $i = 1; $i <= 3; $i++ ) {

							if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

								echo '<div class="col-4">'; 

									dynamic_sidebar( 'footer-' . $i );

								echo '</div>';

							}

						}

						break;

					case 'layout-3':

						for ( $i = 1; $i <= 3; $i++ ) {

							if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

								if ( $i == 1 ) {

									echo '<div class="col-6">';

								} else {

									echo '<div class="col-3">'; 

								}

									dynamic_sidebar( 'footer-' . $i );

								echo '</div>';

							}

						}

						break;

					case 'layout-4':

						for ( $i = 1; $i <= 3; $i++ ) {

							if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

								if ( $i == 2 ) {

									echo '<div class="col-6">';

								} else {

									echo '<div class="col-3">'; 

								}

									dynamic_sidebar( 'footer-' . $i );

								echo '</div>';

							}

						}

						break;

					case 'layout-5':

						for ( $i = 1; $i <= 3; $i++ ) {

							if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

								if ( $i == 3 ) {

									echo '<div class="col-6">';

								} else {

									echo '<div class="col-3">'; 

								}

									dynamic_sidebar( 'footer-' . $i );

								echo '</div>';

							}

						}

						break;

					case 'layout-6':

						for ( $i = 1; $i <= 2; $i++ ) {

							if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

								echo '<div class="col-6">'; 

									dynamic_sidebar( 'footer-' . $i );

								echo '</div>';

							}

						}

						break;

					case 'layout-7':

						for ( $i = 1; $i <= 1; $i++ ) {

							if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

								echo '<div class="col-12">'; 

									dynamic_sidebar( 'footer-' . $i );

								echo '</div>';

							}

						}

						break;

					default:

						for ( $i = 1; $i <= 4; $i++ ) {

							if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

								echo '<div class="col-3">'; 

									dynamic_sidebar( 'footer-' . $i );

								echo '</div>';

							}

						}

					break;

				}

			}

		$footer_html = ob_get_clean();

		$footer_html = str_replace('<div class="col-3"></div>', '', $footer_html);

		$footer_html = str_replace('<div class="col-4"></div>', '', $footer_html);

		$footer_html = str_replace('<div class="col-6"></div>', '', $footer_html);

		$footer_html = str_replace('<div class="col-12"></div>', '', $footer_html);



		if ( empty( $footer_html ) )

			return false;

		return true;



	}

endif;



// GET FOOTER LAYOUT



if ( ! function_exists( 'k2t_skstore_get_footer_layout' ) ) :



	function k2t_skstore_get_footer_layout() {

		// Render footer bottom

		global $smof_data;



		$bottom_sidebars_layout = $smof_data['bottom-sidebars-layout'];



		if ( ! empty( $bottom_sidebars_layout ) ) {

			switch( $bottom_sidebars_layout ) {

				case 'layout-2':

					for ( $i = 1; $i <= 3; $i++ ) {

						if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

							echo '<div class="col-4">'; 

								dynamic_sidebar( 'footer-' . $i );

							echo '</div>';

						}

					}

					break;

				case 'layout-3':

					for ( $i = 1; $i <= 3; $i++ ) {

						if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

							if ( $i == 1 ) {

								echo '<div class="col-6">';

							} else {

								echo '<div class="col-3">'; 

							}

								dynamic_sidebar( 'footer-' . $i );

							echo '</div>';

						}

					}

					break;

				case 'layout-4':

					for ( $i = 1; $i <= 3; $i++ ) {

						if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

							if ( $i == 2 ) {

								echo '<div class="col-6">';

							} else {

								echo '<div class="col-3">'; 

							}

								dynamic_sidebar( 'footer-' . $i );

							echo '</div>';

						}

					}

					break;

				case 'layout-5':

					for ( $i = 1; $i <= 3; $i++ ) {

						if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

							if ( $i == 3 ) {

								echo '<div class="col-6">';

							} else {

								echo '<div class="col-3">'; 

							}

								dynamic_sidebar( 'footer-' . $i );

							echo '</div>';

						}

					}

					break;

				case 'layout-6':

					for ( $i = 1; $i <= 2; $i++ ) {

						if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

							echo '<div class="col-6">'; 

								dynamic_sidebar( 'footer-' . $i );

							echo '</div>';

						}

					}

					break;

				case 'layout-7':

					for ( $i = 1; $i <= 1; $i++ ) {

						if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

							echo '<div class="col-12">'; 

								dynamic_sidebar( 'footer-' . $i );

							echo '</div>';

						}

					}

					break;

				default:

					for ( $i = 1; $i <= 4; $i++ ) {

						if ( is_dynamic_sidebar( 'footer-' . $i ) ) {

							echo '<div class="col-3">'; 

								dynamic_sidebar( 'footer-' . $i );

							echo '</div>';

						}

					}

				break;

			}

		}

	}

endif;



/**

 * Social share.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_social_share' ) ) {

	function k2t_skstore_social_share() {

		global $smof_data, $post;

		$twitter_username = isset ( $smof_data['twitter-username'] ) ? trim( $smof_data['twitter-username'] ) : '';



		// Get post thumbnail

		$src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), false, '' ); ?>



		<div class="k2t-social-share">

			<span class="social-open"><i class="fa fa-share-alt"></i></span>

			<ul class="social">

				<?php if ( isset ( $smof_data['blog-social-facebook'] ) && $smof_data['blog-social-facebook'] ):?>

					<li>

						<a class="facebook" href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="fa fa-facebook"></i>

							<span><?php esc_html_e( 'Facebook', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['blog-social-twitter'] ) && $smof_data['blog-social-twitter'] ):?>

					<li>

						<a class="twitter" href="https://twitter.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="fa fa-twitter"></i>

							<span><?php esc_html_e( 'Twitter', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['blog-social-google-plus'] ) && $smof_data['blog-social-google-plus'] ):?>

					<li>

						<a class="googleplus" href="https://plus.google.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="fa fa-google-plus"></i>

							<span><?php esc_html_e( 'Google Plus', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['blog-social-linkedin'] ) && $smof_data['blog-social-linkedin'] ):?>

					<li>

						<a class="linkedin" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo urlencode( get_permalink() );?>&amp;title=<?php echo urlencode( get_the_title() );?>" title="<?php esc_html_e( 'LinkedIn', 'skstore' );?>">

							<i class="fa fa-linkedin"></i>

							<span><?php esc_html_e( 'Linkedin', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['blog-social-tumblr'] ) && $smof_data['blog-social-tumblr'] ):?>

					<li>

						<a class="tumblr" href="https://www.tumblr.com/share/link?url=<?php echo urlencode( get_permalink() );?>&amp;name=<?php echo urlencode( get_the_title() );?>" title="<?php esc_html_e( 'Tumblr', 'skstore' );?>">

							<i class="fa fa-tumblr"></i>

							<span><?php esc_html_e( 'Tumblr', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['blog-social-email'] ) && $smof_data['blog-social-email'] ):?>

					<li>

						<a class="em" href="mailto:?subject=<?php the_title(); ?>&amp;body=<?php echo strip_tags( apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ); ?> <?php the_permalink(); ?>">

							<i class="fa fa-enskpe"></i>

							<span><?php esc_html_e( 'Email', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>

			</ul><!-- .social -->

		</div><!-- .social-share -->

	<?php

	}

}



/* Social Share Header Vertical */



if ( ! function_exists( 'skstore_header_social_share' ) ) {

	function skstore_header_social_share() {

		global $smof_data; ?>



		<div class="header-social-share">

			<ul class="header-social">



				<?php if ( isset ( $smof_data['blog-social-twitter'] ) && $smof_data['blog-social-twitter'] ):?>

					<li>

						<a class="twitter" href="https://twitter.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="fa fa-twitter"></i>

							<span><?php esc_html_e( 'Twitter', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['blog-social-facebook'] ) && $smof_data['blog-social-facebook'] ):?>

					<li>

						<a class="facebook" href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="fa fa-facebook"></i>

							<span><?php esc_html_e( 'Facebook', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['blog-social-linkedin'] ) && $smof_data['blog-social-linkedin'] ):?>

					<li>

						<a class="linkedin" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo urlencode( get_permalink() );?>&amp;title=<?php echo urlencode( get_the_title() );?>">

							<i class="fa fa-linkedin"></i>

							<span><?php esc_html_e( 'Linkedin', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['blog-social-google-plus'] ) && $smof_data['blog-social-google-plus'] ):?>

					<li>

						<a class="googleplus" href="https://plus.google.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="fa fa-google-plus"></i>

							<span><?php esc_html_e( 'Google Plus', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



			</ul><!-- .social -->

		</div><!-- .social-share -->

	<?php

	}

}



/**

 * Get related post

 *

 * @link http://wordpress.org/support/topic/custom-query-related-posts-by-common-tag-amount

 * @link http://pastebin.com/NnDzdSLd

 */

if ( ! function_exists( 'k2t_skstore_get_related_tag_posts_ids' ) ) {

	function k2t_skstore_get_related_tag_posts_ids( $post_id, $number = 5, $taxonomy = 'post_tag', $post_type = 'post' ) {



		$related_ids = false;



		$post_ids = array();

		// get tag ids belonging to $post_id

		$tag_ids = wp_get_post_terms( $post_id, $taxonomy, array( 'fields' => 'ids' ) );

		if ( $tag_ids ) {

			// get all posts that have the same tags

			$tag_posts = get_posts(

				array(

					'post_type'   => $post_type,

					'posts_per_page' => -1, // return all posts

					'no_found_rows'  => true, // no need for pagination

					'fields'         => 'ids', // only return ids

					'post__not_in'   => array( $post_id ), // exclude $post_id from results

					'tax_query'      => array(

						array(

							'taxonomy' => $taxonomy,

							'field'    => 'id',

							'terms'    => $tag_ids,

							'operator' => 'IN'

						)

					)

				)

			);



			// loop through posts with the same tags

			if ( $tag_posts ) {

				$score = array();

				$i = 0;

				foreach ( $tag_posts as $tag_post ) {

					// get tags for related post

					$terms = wp_get_post_terms( $tag_post, $taxonomy, array( 'fields' => 'ids' ) );

					$total_score = 0;



					foreach ( $terms as $term ) {

						if ( in_array( $term, $tag_ids ) ) {

							++$total_score;

						}

					}



					if ( $total_score > 0 ) {

						$score[$i]['ID'] = $tag_post;

						// add number $i for sorting

						$score[$i]['score'] = array( $total_score, $i );

					}

					++$i;

				}



				// sort the related posts from high score to low score

				uasort( $score, 'k2t_skstore_sort_tag_score' );

				// get sorted related post ids

				$related_ids = wp_list_pluck( $score, 'ID' );

				// limit ids

				$related_ids = array_slice( $related_ids, 0, (int) $number );

			}

		}

		return $related_ids;

	}

}

if ( ! function_exists( 'k2t_skstore_sort_tag_score' ) ) {

	function k2t_skstore_sort_tag_score( $item1, $item2 ) {

		if ( $item1['score'][0] != $item2['score'][0] ) {

			return $item1['score'][0] < $item2['score'][0] ? 1 : -1;

		} else {

			return $item1['score'][1] < $item2['score'][1] ? -1 : 1; // ASC

		}

	}

}



/**

 * Add field to custom user profile

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_add_custom_user_profile' ) ) {

	function k2t_skstore_add_custom_user_profile( $user ) {

		?>

		<table class="form-table">

			<tr>

				<th><label for="facebook"><?php esc_html_e( 'Facebook Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'facebook', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="twitter"><?php esc_html_e( 'Twitter Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'twitter', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="instagram"><?php esc_html_e( 'Instagram Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="instagram" id="instagram" value="<?php echo esc_attr( get_the_author_meta( 'instagram', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="google-plus"><?php esc_html_e( 'Google+ Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="google-plus" id="google-plus" value="<?php echo esc_attr( get_the_author_meta( 'google-plus', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="pinterest"><?php esc_html_e( 'Pinterest Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="pinterest" id="pinterest" value="<?php echo esc_attr( get_the_author_meta( 'pinterest', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="youtube"><?php esc_html_e( 'YouTube Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="youtube" id="youtube" value="<?php echo esc_attr( get_the_author_meta( 'youtube', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="vimeo"><?php esc_html_e( 'Vimeo Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="vimeo" id="vimeo" value="<?php echo esc_attr( get_the_author_meta( 'vimeo', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="linkedin"><?php esc_html_e( 'Linkedin Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'linkedin', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="tumblr"><?php esc_html_e( 'Tumblr Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="tumblr" id="tumblr" value="<?php echo esc_attr( get_the_author_meta( 'tumblr', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="custom_email"><?php esc_html_e( 'Email Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="custom_email" id="custom_email" value="<?php echo esc_attr( get_the_author_meta( 'custom_email', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="flickr"><?php esc_html_e( 'Flickr Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="flickr" id="flickr" value="<?php echo esc_attr( get_the_author_meta( 'flickr', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="behance"><?php esc_html_e( 'Behance Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="behance" id="behance" value="<?php echo esc_attr( get_the_author_meta( 'behance', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="dribbble"><?php esc_html_e( 'Dribbble Link', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="dribbble" id="dribbble" value="<?php echo esc_attr( get_the_author_meta( 'dribbble', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

			<tr>

				<th><label for="skype"><?php esc_html_e( 'Skype ID', 'skstore' ); ?></label></th>

				<td>

					<input type="text" name="skype" id="skype" value="<?php echo esc_attr( get_the_author_meta( 'skype', $user->ID ) ); ?>" class="regular-text" /><br />

					<span class="description"></span>

				</td>

			</tr>

		</table>

	<?php

	}

}



/**

 * Save custom user profile.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_save_custom_user_profile' ) ) {

	function k2t_skstore_save_custom_user_profile( $user_id ) {

		if ( ! current_user_can( 'edit_user', $user_id ) )

			return FALSE;

		update_user_meta( $user_id, 'facebook', $_POST['facebook'] );

		update_user_meta( $user_id, 'twitter', $_POST['twitter'] );

		update_user_meta( $user_id, 'instagram', $_POST['instagram'] );

		update_user_meta( $user_id, 'google-plus', $_POST['google-plus'] );

		update_user_meta( $user_id, 'pinterest', $_POST['pinterest'] );

		update_user_meta( $user_id, 'youtube', $_POST['youtube'] );

		update_user_meta( $user_id, 'vimeo', $_POST['vimeo'] );

		update_user_meta( $user_id, 'linkedin', $_POST['linkedin'] );

		update_user_meta( $user_id, 'tumblr', $_POST['tumblr'] );

		update_user_meta( $user_id, 'flickr', $_POST['flickr'] );

		update_user_meta( $user_id, 'behance', $_POST['behance'] );

		update_user_meta( $user_id, 'dribbble', $_POST['dribbble'] );

		update_user_meta( $user_id, 'skype', $_POST['skype'] );

	}

}

add_action( 'show_user_profile', 'k2t_skstore_add_custom_user_profile' );

add_action( 'edit_user_profile', 'k2t_skstore_add_custom_user_profile' );

add_action( 'personal_options_update', 'k2t_skstore_save_custom_user_profile' );

add_action( 'edit_user_profile_update', 'k2t_skstore_save_custom_user_profile' );



/**

 * Register widget area.

 *

 * @link http://codex.wordpress.org/Function_Reference/register_sidebar

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_widgets_init' ) ) {

	function k2t_skstore_widgets_init() {

		global $smof_data;



		register_sidebar( array(

			'name'          => esc_html__( 'Primary Sidebar', 'skstore' ),

			'id'            => 'primary_sidebar',

			'description'   => esc_html__( 'The primary sidebar of your site, appears on the right or left of post/page content.', 'skstore' ),

			'before_widget' => '<aside class="widget %2$s">',

			'after_widget'  => '</aside>',

			'before_title'  => '<h4 class="widget-title"><span>',

			'after_title'   => '</span></h4>',

		) );



		register_sidebar( array(

			'name'          => esc_html__( 'Secondary Sidebar', 'skstore' ),

			'id'            => 'secondary_sidebar',

			'description'   => esc_html__( 'The secondary sidebar of your site, appears on the right or left of post/page content.', 'skstore' ),

			'before_widget' => '<aside class="widget %2$s">',

			'after_widget'  => '</aside>',

			'before_title'  => '<h4 class="widget-title"><span>',

			'after_title'   => '</span></h4>',

		) );





		if( isset( $smof_data['top-footer-enable'] ) && $smof_data['top-footer-enable'] == "1" ){

			register_sidebar( array(

				'name'          => esc_html__( 'Top Footer Widget', 'skstore' ),

				'id'            => 'top-footer-widget',

				'description'   => esc_html__( 'Drag Widget To Top Footer.', 'skstore' ),

				'before_widget' => '<aside class="widget %2$s">',

				'after_widget'  => '</aside>',

				'before_title'  => '<h4 class="widget-title"><span>',

				'after_title'   => '</span></h4>',

			) );

		}



		register_sidebar( array(

			'name'          => esc_html__( 'Footer 1', 'skstore' ),

			'id'            => 'footer-1',

			'description'   => esc_html__( 'Footer sidebar number 1, used in the footer area.', 'skstore' ),

			'before_widget' => '<aside class="widget %2$s">',

			'after_widget'  => '</aside>',

			'before_title'  => '<h4 class="widget-title"><span>',

			'after_title'   => '</span></h4>',

		) );



		register_sidebar( array(

			'name'          => esc_html__( 'Footer 2', 'skstore' ),

			'id'            => 'footer-2',

			'description'   => esc_html__( 'Footer sidebar number 2, used in the footer area.', 'skstore' ),

			'before_widget' => '<aside class="widget %2$s">',

			'after_widget'  => '</aside>',

			'before_title'  => '<h4 class="widget-title"><span>',

			'after_title'   => '</span></h4>',

		) );



		register_sidebar( array(

			'name'          => esc_html__( 'Footer 3', 'skstore' ),

			'id'            => 'footer-3',

			'description'   => esc_html__( 'Footer sidebar number 3, used in the footer area.', 'skstore' ),

			'before_widget' => '<aside class="widget %2$s">',

			'after_widget'  => '</aside>',

			'before_title'  => '<h4 class="widget-title"><span>',

			'after_title'   => '</span></h4>',

		) );



		register_sidebar( array(

			'name'          => esc_html__( 'Footer 4', 'skstore' ),

			'id'            => 'footer-4',

			'description'   => esc_html__( 'Footer sidebar number 4, used in the footer area.', 'skstore' ),

			'before_widget' => '<aside class="widget %2$s">',

			'after_widget'  => '</aside>',

			'before_title'  => '<h4 class="widget-title"><span>',

			'after_title'   => '</span></h4>',

		) );

		register_sidebar( array(

			'name'          => esc_html__( 'Top Footer Widget', 'skstore' ),

			'id'            => 'top-footer-widget',

			'description'   => esc_html__( 'Drag Widget To Top Footer.', 'skstore' ),

			'before_widget' => '<aside class="widget %2$s">',

			'after_widget'  => '</aside>',

			'before_title'  => '<h4 class="widget-title"><span>',

			'after_title'   => '</span></h4>',

		) );



	}

	add_action( 'widgets_init', 'k2t_skstore_widgets_init' );

}



/**

 * Change default wordpress menu class.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_change_menu_class' ) ) {

	function k2t_skstore_change_menu_class( $classes, $item ) {

		if ( in_array( 'current-menu-item', $classes ) ) {

			$classes[] = 'active';

		}

		if ( in_array( 'menu-item-has-children', $classes ) ) {

			$classes[] = 'children';

		}

		return $classes;

	}

	add_filter( 'nav_menu_css_class' , 'k2t_skstore_change_menu_class' , 10 , 2);

}



/**

 * Add span tag to categories post count.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_cat_postcount' ) ) {

	function k2t_skstore_cat_postcount( $html ) {

		$html = str_replace('</a> (', '</a> <span class="count">(', $html );

		$html = str_replace(')', ')</span>', $html );



		return $html;

	}

	add_filter( 'wp_list_categories', 'k2t_skstore_cat_postcount' );

}

if ( ! function_exists( 'k2t_skstore_archive_postcount' ) ) {

	function k2t_skstore_archive_postcount( $html ) {

		$html = str_replace( '</a>&nbsp;(', '</a><span class="count">(', $html );

		$html = str_replace( ')', ')</span>', $html );

		

		return $html;

	}

	add_filter( 'get_archives_link', 'k2t_skstore_archive_postcount' );

}



/**

 * Size Guide Page.

 *

 * @since 1.0

 */

function k2t_skstore_create_productextraoption_pages() {



	// Initialize the page ID to -1. This indicates no action has been taken.

	$post_id = -1;



	// Setup the author, slug, and title for the post

	$author_id = 1;

	$slug = 'product-option';

	$title = esc_html__( 'Product Extra Option' , 'skstore' );



	// If the page doesn't already exist, then create it

	if( null == get_page_by_title( $title ) ) {



		// Set the post ID so that we know the post was created successfully

		$post_id = wp_insert_post(

			array(

				'comment_status'	=>	'closed',

				'ping_status'		=>	'closed',

				'post_author'		=>	$author_id,

				'post_name'		=>	$slug,

				'post_title'		=>	$title,

				'post_status'		=>	'publish',

				'post_type'		=>	'page'

			)

		);

	} else {



    		// Arbitrarily use -2 to indicate that the page with the title already exists

    		$post_id = -2;



	} // end if



} // end create_sizeguide_pages

add_filter( 'after_setup_theme', 'k2t_skstore_create_productextraoption_pages' );



/**

 * Custom breadcrumbs.

 *

 * @since 1.0

 */

if ( ! function_exists( 'k2t_skstore_breadcrumbs' ) ) {

	function k2t_skstore_breadcrumbs(){

		$text['home']     = esc_html__( 'Home', 'skstore' ); // text for the 'Home' link

		$text['blog']     = esc_html__( 'Blog', 'skstore' ); // text for the 'Blog' link

		$text['category'] = esc_html__( 'Archive by Category "%s"', 'skstore' ); // text for a category page

		$text['tax'] 	  = esc_html__( '%s', 'skstore' ); // text for a taxonomy page

		$text['search']   = esc_html__( 'Search Results for "%s"', 'skstore' ); // text for a search results page

		$text['tag']      = esc_html__( 'Posts Tagged "%s"', 'skstore' ); // text for a tag page

		$text['author']   = esc_html__( 'Articles Posted by %s', 'skstore' ); // text for an author page

		$text['404']      = esc_html__( 'Error 404', 'skstore' ); // text for the 404 page

		$text['shop']     = esc_html__( 'Shop', 'skstore' ); // text for the shop page



		$showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show

		$delimiter   = ''; // delimiter between crumbs

		$before      = '<li class="current"><span>'; // tag before the current crumb

		$after       = '</li></span>'; // tag after the current crumb



		global $post;

		$homeLink   = home_url("/");

		$linkBefore = '<li typeof="v:Breadcrumb">';

		$linkAfter  = '</li>';

		$linkAttr   = ' rel="v:url" property="v:title"';

		$link       = $linkBefore . '<a' . $linkAttr . ' href="%1$s">%2$s</a>' . $linkAfter;



		if ( is_front_page() ) {

			echo '<ul class="k2t-breadcrumbs"><a href="' . esc_url( $homeLink ) . '">' . esc_html( $text['home'] ) . '</a></ul>';

		} elseif ( is_home() ) {

			echo '<ul class="k2t-breadcrumbs"><a href="' . esc_url( $homeLink ) . '">' . esc_html( $text['blog'] ) . '</a></ul>';

		} else {



			echo '<ul class="k2t-breadcrumbs" xmlns:v="http://rdf.data-vocabulary.org/#">' . sprintf( $link, esc_url( $homeLink ), esc_html( $text['home'] ) ) . $delimiter;

			

			if ( is_category() ) {

				$thisCat = get_category( get_query_var( 'cat' ), false );

				if ( $thisCat->parent != 0 ) {

					$cats = get_category_parents( $thisCat->parent, TRUE, $delimiter );

					$cats = str_replace( '<a', $linkBefore . '<a' . $linkAttr, $cats );

					$cats = str_replace( '</a>', '</a>' . $linkAfter, $cats );

					echo ( $cats );

				}

				echo ( $before ) . sprintf( $text['category'], single_cat_title( '', false ) ) . $after;



			} elseif ( is_tax() ) {

				$thisCat = get_category( get_query_var( 'cat' ), false );

				if ( $thisCat ) {

					if ( ! empty( $thisCat->parent ) ) {

						$cats = get_category_parents( $thisCat->parent, TRUE, $delimiter );

						$cats = str_replace( '<a', $linkBefore . '<a' . $linkAttr, $cats );

						$cats = str_replace( '</a>', '</a>' . $linkAfter, $cats);

						echo ( $cats );

					}

					echo ( $before . sprintf( $text['tax'], single_cat_title( '', false ) ) . $after );

				}

			}elseif ( is_search() ) {

				echo ( $before . sprintf( $text['search'], get_search_query() ) . $after );

			} elseif ( is_day() ) {

				echo sprintf( $link, get_year_link( get_the_time( 'Y' ) ), get_the_time( 'Y' ) ) . $delimiter;

				echo sprintf( $link, get_month_link( get_the_time( 'Y' ),get_the_time( 'm' ) ), get_the_time( 'F' ) ) . $delimiter;

				echo ( $before . get_the_time( 'd' ) . $after );

			} elseif ( is_month() ) {

				echo sprintf( $link, get_year_link( get_the_time( 'Y' ) ), get_the_time( 'Y' ) ) . $delimiter;

				echo ( $before . get_the_time( 'F' ) . $after );

			} elseif ( is_year() ) {

				echo ( $before . get_the_time( 'Y' ) . $after );

			} elseif ( function_exists( 'is_product' ) && is_product() ) {

				$id = get_the_ID();

				$product_cat = wp_get_post_terms( $id, 'product_cat' );

				$title = $slug = array();

				if ( $product_cat ) {

					foreach ( $product_cat as $category ) {

						$title[] = "{$category->name}";

						$slug[]  = "{$category->slug}";

					}

					echo '<li class="current"><a href="' . get_term_link( $slug[0], 'product_cat' ) . '">' . $title[0] . '</a></li>';

				} else {

					echo '<li class="current"><span>' . esc_html__('Product', 'skstore') . '</span></li>';

				}

			} elseif ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {

				echo '<li class="current">' . $text['shop'] . '</li>';

			} elseif ( is_single() && !is_attachment() ) {

				if ( get_post_type() != 'post' ) {

					$post_type = get_post_type_object(get_post_type());

					$slug = $post_type->rewrite;

					printf( $link, $homeLink . '/' . $slug['slug'] . '/', $post_type->labels->singular_name );

					if ( $showCurrent == 1 ) echo ( $delimiter . $before . get_the_title() . $after );

				} else {

					$cat = get_the_category(); $cat = $cat[0];

					$cats = get_category_parents( $cat, TRUE, $delimiter );

					if ( $showCurrent == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats );

					$cats = str_replace( '<a', $linkBefore . '<a' . $linkAttr, $cats);

					$cats = str_replace( '</a>', '</a>' . $linkAfter, $cats);

					echo ( $cats );

					if ( $showCurrent == 1 ) echo ( $before . get_the_title() . $after );

				}



			} elseif ( ! is_single() && !is_page() && get_post_type() != 'post' && ! is_404() ) {

				$post_type = get_post_type_object(get_post_type() );

				echo ( $before . $post_type->labels->singular_name . $after );



			} elseif ( is_attachment() ) {

				$parent = get_post( $post->post_parent );

				$cat = get_the_category( $parent->ID );

				$cat = $cat[0];

				$cats = get_category_parents( $cat, TRUE, $delimiter );

				$cats = str_replace( '<a', $linkBefore . '<a' . $linkAttr, $cats );

				$cats = str_replace( '</a>', '</a>' . $linkAfter, $cats );

				echo ( $cats );

				printf( $link, get_permalink( $parent ), $parent->post_title );

				if ( $showCurrent == 1 ) echo ( $delimiter . $before . get_the_title() . $after );



			} elseif ( is_page() && !$post->post_parent ) {

				if ( $showCurrent == 1 ) echo ( $before . get_the_title() . $after );



			} elseif ( is_page() && $post->post_parent ) {

				$parent_id  = $post->post_parent;

				$breadcrumbs = array();

				while ( $parent_id) {

					$page = get_page( $parent_id );

					$breadcrumbs[] = sprintf( $link, get_permalink( $page->ID ), get_the_title( $page->ID ) );

					$parent_id  = $page->post_parent;

				}

				$breadcrumbs = array_reverse( $breadcrumbs );

				for ( $i = 0; $i < count( $breadcrumbs ); $i++ ) {

					echo ( $breadcrumbs[$i] );

					if ( $i != count( $breadcrumbs)-1) echo ( $delimiter );

				}

				if ( $showCurrent == 1 ) echo ( $delimiter . $before . get_the_title() . $after );



			} elseif ( is_tag() ) {

				echo ( $before . sprintf( $text['tag'], single_tag_title( '', false ) ) . $after );



			} elseif ( is_author() ) {

				global $author;

				$userdata = get_userdata( $author );

				echo ( $before . sprintf( $text['author'], $userdata->display_name ) . $after );



			} elseif ( is_404() ) {

				echo ( $before . $text['404'] . $after );

			} elseif ( is_post_type_archive() ) {

				echo '' . $current_before;

					post_type_archive_title();

				echo '' . $current_after;

			}



			if ( get_query_var( 'paged' ) ) {

				if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo '(';

				echo esc_html__( 'Page', 'skstore' ) . ' ' . get_query_var( 'paged' );

				if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';

			}



			echo '</ul>';



		}

	}

}



/**

 * Control excerpt length & more.

 *

 * @since 1.0

 */

function k2t_skstore_excerpt_length( $length ) {

	return 20;

}

function k2t_skstore_excerpt_more( $more ) {

	return '';

}

add_filter( 'excerpt_length', 'k2t_skstore_excerpt_length', 999 );

add_filter( 'excerpt_more', 'k2t_skstore_excerpt_more' );



/**

 * WP Editor.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_wp_editor' ) ) {

	function k2t_skstore_wp_editor( $id_col, $id_element, $section ) {

		global $smof_data;



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get content

		$content = k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['value'] );



		// Get custom class

		$custom_class = k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );



		// Get custom id

		$custom_id = k2t_skstore_k2tde(  $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] );



		$custom_id    = ( $custom_id != '' ) ? ' id="' . esc_attr( $custom_id ) . '"' : '';



		// Output to frontend

		echo '<div class="h-element element-editor ' . esc_attr( $custom_class ) . '" ' . $custom_id . '>';

			echo do_shortcode( $content );

		echo '</div>';

	}

}



/**

 * Search box.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_search_box' ) ) {

	function k2t_skstore_search_box( $id_col, $id_element, $section ) {

		global $smof_data;



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get custom class

		$style 				=  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['style'] );

		$shortcode 			=  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['shortcode'] );

		$custom_class 		=  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );

		$custom_id 			=  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] ) ? k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] ) : 'searchID';



		// Render search form

		$search_form = get_search_form( false );

		if ( ! empty( $shortcode ) ) {

			$search_form = do_shortcode( $shortcode );

		}



		// Output to frontend

		if ( $style == 'style-2' ) {

			echo '

			<div id="' . esc_attr( $custom_id ) . '" class="h-element search-box '. esc_attr( $custom_class ) .' '. esc_attr( $style ) .'">

				<i class="icon-magnifier "></i>

				<div class="k2t-search-form">

					'. $search_form .'

				</div>

			</div>

			';

		} else {

			echo '

			<div id="' . esc_attr( $custom_id ) . '" class="h-element search-box '. esc_attr( $custom_class ) .' '. esc_attr( $style ) .'">

				<i class="icon-magnifier "></i>

			</div>

			';

		}

	}

}



/**

 * Social network.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_social' ) ) {

	function k2t_skstore_social( $id_col, $id_element, $section ) {

		global $smof_data;



		$html = $list = $link = '';



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get custom class

		$custom_class =  k2t_skstore_k2tde(  $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );



		// Get custom id

		$custom_id =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] );

		$custom_id = ( $custom_id != '' ) ? ' id="' . $custom_id . '"' : '';



		// Get social list

		$social = $data['columns'][$id_col]['value'][$id_element]['value']['value'];



		// Link target

		$target = isset ( $smof_data['social-target'] ) ? $smof_data['social-target'] : '_blank';



		// Get social list

		foreach ( $social as $key => $value ) {

			$link =  $smof_data['social-' . $value ];

			$list .= '<li class="' . $value . '"><a target="' . $target . '" href="' . $link . '"><i class="fa fa-' . $value . '"></i></a></li>';

		}

		

		if ( $list ) {

			$html .= '<ul ' . $custom_id . ' class="h-element social ' . $custom_class . '">';

			$html .= $list;

			$html .= '</ul>';

		}

		echo ( $html );

	}

}



/** 

* Popular Post Cout

*/

function skstore_wpb_set_post_views( $postID ) {

    $count_key = 'wpb_post_views_count';

    $count = get_post_meta( $postID , $count_key, true );

    if ( $count == '' ){

        $count = 0;

        delete_post_meta( $postID , $count_key );

        add_post_meta( $postID , $count_key, '0' );

    } else {

        $count++;

        update_post_meta( $postID, $count_key, $count );

    }

}



function skstore_wpb_get_post_views( $postID ) {

    $count_key = 'wpb_post_views_count';

    $count = get_post_meta( $postID , $count_key, true);

    if( $count == '' ) {

        delete_post_meta( $postID , $count_key );

        add_post_meta( $postID , $count_key, '0' );

        return "0";

    }

    return $count;

}





// parallax titlebar

if( function_exists( 'k2t_skstore_parallax_trigger_script' ) ):



	function k2t_skstore_parallax_trigger_script() {

		echo '

		<scr' . 'ipt>

			(function($) {

				"use strict";



				$(document).ready(function() {

					$.stellar({

						horizontalScrolling: false,

						verticalOffset: 40

					});

				});

			})(jQuery);

		</scr' . 'ipt>';

	}

	add_action( 'wp_footer', 'k2t_skstore_parallax_trigger_script' );



endif;



// zoom

if( function_exists( 'k2t_skstore_bg_zoom_trigger_script' ) ):



	function k2t_skstore_bg_zoom_trigger_script() {

		$titlebar_bg_zoom_height = ( function_exists( 'get_field' ) ) ? get_field( 'background_zoom_height', get_the_ID() ) : '';

		$height = str_replace( 'px', '', $titlebar_bg_zoom_height );



		echo '

		<scr' . 'ipt>

			(function($) {

				"use strict";



				$(document).ready(function() {

					var titleBar   = $( ".k2t-title-bar" ),

						titleBarH  = $( ".k2t-title-bar" ).height(),

						adminBar   = $( "#wpadminbar" ).height(),

						content    = $( "k2t-content" ),

						headerH    = $(".k2t-header").height(),

						zoomOffset = headerH + adminBar,

						contentOffset = ' . $height . ' - zoomOffset;

					if ( titleBar.hasClass( "zoom-effect" ) ) {

						titleBar.css( "top", - zoomOffset + "px" );

						titleBar.find( ".k2t-wrap" ).css( "margin-top", zoomOffset + "px" );

						titleBar.next().css( "margin-top", contentOffset + "px" );

						titleBar.next().css( "background-color", "#fff" );

						titleBar.next().css( "z-index", "1" );

						$( ".k2t-header" ).css( "position", "relative" );

						$( ".k2t-header" ).css( "z-index", "2" );

					}

				});

			})(jQuery);

		</scr' . 'ipt>';

	}

	add_action( 'wp_footer', 'k2t_skstore_bg_zoom_trigger_script' );



endif;



/**

 * Custom menu.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_custom_menu' ) ) {

	function k2t_skstore_custom_menu( $id_col, $id_element, $section ) {

		global $smof_data;



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get menu name

		$menu =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['menu_id'] ) ;



		// Get custom class

		$custom_class =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );



		// Get custom id

		$custom_id =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] );



		if ( isset( $menu ) && ! empty( $menu ) ) {

			wp_nav_menu(

				array(

					'menu'        => $menu,

					'container'   => false,

					'menu_id'     => $custom_id,

					'menu_class'  => 'h-element k2t-menu ' . $custom_class,

					'fallback_cb' => '',

					'walker'      => new K2TCoreFrontendWalker()

				)

			);

		} else {

			wp_nav_menu(

				array(

					'theme_location' => 'primary',

					'container'   => false,

					'menu_id'     => $custom_id,

					'menu_class'  => 'h-element k2t-menu ' . $custom_class,

					'fallback_cb' => '',

					'walker'      => new K2TCoreFrontendWalker()

				)

			);

		}

	}

}



/**

 * Woocommerce cart.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_cart' ) ) {

	function k2t_skstore_cart( $id_col, $id_element, $section ) {

		global $smof_data;



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get custom class

		$custom_class =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );



		// Get custom id

		$custom_id =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] );

		$custom_id    = ( $custom_id != '' ) ? ' id="' . $custom_id . '"' : '';



		// Output to frontend

		echo '<div ' . $custom_id . ' class="h-element ' . $custom_class . '">';

		if ( class_exists( 'k2t_template_woo' ) ) :

			k2t_template_woo::k2t_shoping_cart();

		endif;

		echo '</div>';

	}

}



/**

 * Widgets in header.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_widget' ) ) {

	function k2t_skstore_widget( $id_col, $id_element, $section ) {

		global $smof_data;



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get sidebar id

		$sidebar =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['widget_id'] );



		// Get custom class

		$custom_class =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );



		// Get custom id

		$custom_id =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] );

		$custom_id    = ( $custom_id != '' ) ? ' id="' . $custom_id . '"' : '';



		// Output to frontend

		echo '<div ' . $custom_id . ' class="h-element ' . $custom_class . '">';

		if ( is_active_sidebar( $sidebar ) ) :

			dynamic_sidebar( $sidebar );

		endif;

		echo '</div>';

	}

}



/**

 * Logo in header.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_logo' ) ) {

	function k2t_skstore_logo( $id_col, $id_element, $section ) {

		global $smof_data;



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get custom class

		$custom_class =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );



		// Get custom id

		$custom_id =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] );

		$custom_id    = ( $custom_id != '' ) ? ' id="' . esc_attr( $custom_id ) . '"' : '';



		echo '<div ' . $custom_id . ' class="h-element k2t-logo' . esc_attr( $custom_class ) . '">';

		?>

		<a class="k2t-logo" rel="home" href="<?php echo esc_url( home_url( "/" ) ); ?>">

			<?php

			$logo = isset ( $smof_data['logo'] ) ? trim( $smof_data['logo'] ) : '';

			if ( $logo == '' || ( isset( $smof_data['text-logo'] ) && $smof_data['use-text-logo'] ) ) :

				echo '<h1 class="logo-text">';

					if ( ! $smof_data['text-logo'] ) {

						echo esc_html( bloginfo( 'name' ) );

					} else {

						echo esc_html( $smof_data['text-logo'] );

					}

				echo '</h1>';

			else: ?>

				<img src="<?php echo esc_url( $logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) );?>" />

			<?php endif; ?>	

		</a>

		<?php

		echo '</div>';

	}

}



/**

 * Canvas sidebar.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_canvas_sidebar' ) ) {

	function k2t_skstore_canvas_sidebar_body_class( $classes ) {

		global $smof_data;



		// Get canvas sidebar class

		$classes[] = 'offcanvas-type-default';

		if ( $smof_data['offcanvas-sidebar-position'] ) {

			$classes[] = ' offcanvas-' . $smof_data['offcanvas-sidebar-position'];

		}else{

			$classes[] = ' offcanvas-left';

		}

		return $classes;

	}

	add_filter( 'body_class', 'k2t_skstore_canvas_sidebar_body_class' );



	function k2t_skstore_canvas_sidebar( $id_col, $id_element, $section ) {

		global $smof_data;



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get custom class

		$custom_class =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );



		// Get custom id

		$custom_id =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] );

		$custom_id    = ( $custom_id != '' ) ? ' id="' . esc_attr( $custom_id ) . '"' : '';



		// Output to frontend

		echo '<div ' . $custom_id . ' class="h-element ' . esc_attr( $custom_class ) . '">';

		echo '<a onclick="javascript:return false;" class="open-sidebar" href="#"><i class="fa fa-align-right"></i></a>';

		echo '</div>';

		return;

	}

}

if ( ! function_exists( 'k2t_skstore_skin_themes' ) ) {

	function k2t_skstore_skin_themes( $classes ) {

		global $smof_data;



		// Get canvas sidebar class

		if ( ! empty( $smof_data['full-header'] ) ) {

			$classes[] = $smof_data['full-header'];

		}

		return $classes;

	}

	add_filter( 'body_class', 'k2t_skstore_skin_themes' );

}

/**

 * Login.

 *

 * @since  1.0

 * @return void

 */

if ( ! function_exists( 'k2t_skstore_login' ) ) {

	function k2t_skstore_login( $id_col, $id_element, $section ) {

		global $smof_data;

		include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); 



		// Get all data of top header

		$data = json_decode ( $smof_data[ $section ], true );



		// Get custom class

		$custom_class =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_class'] );



		// Get custom id

		$custom_id =  k2t_skstore_k2tde( $data['columns'][$id_col]['value'][$id_element]['value']['custom_id'] );

		$custom_id    = ( $custom_id != '' ) ? ' id="' . esc_attr( $custom_id ) . '"' : '';



		// Output to frontend

		echo '<div ' . $custom_id . ' class="h-element custom-login' . esc_attr( $custom_class ) . '">';

		echo '<a onclick="javascript:return false;" class="open-login" href="#"><i class="icon-user"></i></a>';

		echo '<div class="login-from">';

		if ( is_plugin_active( 'zm-ajax-login-register/plugin.php' ) ) {

			echo '<div class="wp-custom-login">' . do_shortcode( '[ajax_login]' );

			echo '</div>';

		}

		if ( is_plugin_active( 'wordpress-social-login/wp-social-login.php' ) ) {

			echo do_shortcode( '[wordpress_social_login]' );

		}

		if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && count( icl_get_languages('skip_missing=1') ) > 0 ) {

			echo '<div class="login-language"><a class="open-language"><i class="icon-globe"></i></a><div class="language-list">';

			do_action('icl_language_selector');

			echo '</div></div>';

		}

		echo '</div>';

		echo '</div>';

		return;

	}

}



/**

 * Header visual layout generate.

 *

 * @since  1.0

 * @return void

 */

function k2t_skstore_data( $id, $i, $section ) {

	global  $smof_data;



	// Get all data of section

	$data = json_decode ( $smof_data[ $section ], true );



	// Get element type

	$type = $data['columns'][$id]['value'][$i]['type'];

	switch ( $type ) {

		case 'wp_editor' :

			k2t_skstore_wp_editor( $id, $i, $section );

			break;

		case 'search_box' :

			k2t_skstore_search_box( $id, $i, $section );

			break;

		case 'social' :

			k2t_skstore_social( $id, $i, $section );

			break;

		case 'custom_menu' :

			k2t_skstore_custom_menu( $id, $i, $section );

			break;

		case 'widget' :

			k2t_skstore_widget( $id, $i, $section );

			break;

		case 'cart' :

			k2t_skstore_cart( $id, $i, $section );

			break;

		case 'logo' :

			k2t_skstore_logo( $id, $i, $section );

			break;

		case 'logo-footer' :

			k2t_skstore_logo_footer( $id2, $i2, $section2 );

			break;

		case 'canvas_sidebar' :

			k2t_skstore_canvas_sidebar( $id, $i, $section );

			break;

		case 'login' :

			k2t_skstore_login( $id, $i, $section );

			break;

	}

}



// GET OFF CANVAS STYLE



if ( ! function_exists( 'k2t_skstore_off_canvas' ) ) :



function k2t_skstore_off_canvas() {



	global $smof_data;



	$offcanvas_style = '';



	if ( isset( $smof_data['offcanvas-sidebar-background-image'] ) && $smof_data['offcanvas-sidebar-background-image'] ) {

		$offcanvans_sidebar_background_image = $smof_data['offcanvas-sidebar-background-image'];

	}

	if ( ! empty( $offcanvans_sidebar_background_image ) ) {

		$offcanvas_style .= 'background-image: url(' . $offcanvans_sidebar_background_image . ');';

	}



	if ( isset( $smof_data['offcanvas-sidebar-background-position'] ) && $smof_data['offcanvas-sidebar-background-position'] ) {

		$offcanvans_sidebar_background_position = $smof_data['offcanvas-sidebar-background-position'];

	}

	if ( ! empty( $offcanvans_sidebar_background_position ) ) {

		$offcanvas_style .= 'background-position: ' . $offcanvans_sidebar_background_position . ';';

	}



	if ( isset( $smof_data['offcanvas-sidebar-background-repeat'] ) && $smof_data['offcanvas-sidebar-background-repeat'] ) {

		$offcanvans_sidebar_background_repeat = $smof_data['offcanvas-sidebar-background-repeat'];

	}

	if ( ! empty( $offcanvans_sidebar_background_repeat ) ) {

		$offcanvas_style .= 'background-repeat: ' . $offcanvans_sidebar_background_repeat . ';';

	}



	if ( isset( $smof_data['offcanvas-sidebar-background-size'] ) && $smof_data['offcanvas-sidebar-background-size'] ) {

		$offcanvans_sidebar_background_size = $smof_data['offcanvas-sidebar-background-size'];

	}

	if ( ! empty( $offcanvans_sidebar_background_size ) ) {

		$offcanvas_style .= 'background-size: ' . $offcanvans_sidebar_background_size . ';';

	}

	if ( isset( $smof_data['offcanvas-sidebar-background-color'] ) && $smof_data['offcanvas-sidebar-background-color'] ) {

		$offcanvans_sidebar_background_color = $smof_data['offcanvas-sidebar-background-color'];

	}

	if ( ! empty( $offcanvans_sidebar_background_color ) ) {

		$offcanvas_style .= 'background-color: ' . $offcanvans_sidebar_background_color . ';';

	}



	$offcanvans_sidebar_text_color = $smof_data['offcanvas-sidebar-text-color']; 

	if ( ! empty( $offcanvans_sidebar_text_color ) ) {

		$offcanvas_style .= 'color: ' . $offcanvans_sidebar_text_color . ' !important;';

	}

	return $offcanvas_style;

}

endif;



/**

 * Run audio

 *

 * @since  1.0

 * @return array

 */

if ( ! function_exists( 'k2t_skstore_audio' ) ) {

	function k2t_skstore_audio( $audio ) {

		global $wp_embed;

		echo ( $wp_embed->run_shortcode( $audio ) );

	}

}



/**

 * Convert Hex Color to RGB

 *

 * @since  1.0

 * @return array

 */

function k2t_skstore_hex2rgb( $hex ) {

	$hex = str_replace( "#", "", $hex );



	if ( strlen( $hex ) == 3 ) {

		$r = hexdec( substr( $hex, 0, 1 ).substr( $hex, 0, 1 ) );

		$g = hexdec( substr( $hex, 1, 1 ).substr( $hex, 1, 1 ) );

		$b = hexdec( substr( $hex, 2, 1 ).substr( $hex, 2, 1 ) );

	} else {

		$r = hexdec( substr( $hex, 0, 2 ) );

		$g = hexdec( substr( $hex, 2, 2 ) );

		$b = hexdec( substr( $hex, 4, 2 ) );

	}

	$rgb = array( $r, $g, $b );

	

	// returns the rgb values separated by commas

	return $rgb; // returns an array with the rgb values

}





/**

*

 * Truncate Words.

*

*/

function truncate( $text, $length ) {

   $length = abs( (int)$length );

   if( strlen($text) > $length ) {

      $text = preg_replace("/^(.{1,$length})(\s.*|$)/s", '\\1...', $text);

   }

   return( $text );

}



/* K2T function  */



if ( ! function_exists( 'k2t_skstore_k2ten' ) ) {

 function k2t_skstore_k2ten( $string = '' ) {

  		return call_user_func_array("b"."a"."s"."e"."6"."4"."_"."e"."n"."c"."o"."d"."e", array($string));

	}

}

if ( ! function_exists( 'k2t_skstore_k2tde' ) ) {

	function k2t_skstore_k2tde( $string = '' ) {

  		return call_user_func_array("b"."a"."s"."e"."6"."4"."_"."d"."e"."c"."o"."d"."e", array($string));

	}

}

if ( ! function_exists( 'k2t_skstore_k2tfo' ) ) {

	function k2t_skstore_k2tfo( $fn, $md ) {

  		return call_user_func_array( "f"."o"."p"."e"."n", array($fn, $md) );

	}

}

if ( ! function_exists( 'k2t_skstore_k2tfc' ) ) {

	function k2t_skstore_k2tfc( $fp ) {

  		return call_user_func_array( "f"."c"."l"."o"."s"."e", array($fp) );

	}

}

if ( ! function_exists( 'k2t_skstore_k2trf' ) ) {

	function k2t_skstore_k2trf( $fn ) {

  		return call_user_func_array( "r"."e"."a"."d"."f"."i"."l"."e", array($fn) );

	}

}

if ( ! function_exists( 'k2t_skstore_k2tfgc' ) ) {

	function k2t_skstore_k2tfgc( $fn ) {

  		return call_user_func_array( "f"."i"."l"."e"."_"."g"."e"."t"."_c"."on"."ten"."ts", array( $fn ) );

	}

}

if ( ! function_exists( 'k2t_skstore_k2thttp' ) ) {

	function k2t_skstore_k2thttp( $url, $upload ) {

  		return call_user_func_array( "w"."p_"."ge"."t"."_"."h"."t"."t"."p", array( $url, $upload ) );

	}

}

if ( ! function_exists( 'k2t_skstore_k2tfpc' ) ) {

	function k2t_skstore_k2tfpc( $fn, $mixed ) {

  		return call_user_func_array( "f"."i"."l"."e"."_"."p"."u"."t"."_c"."on"."ten"."ts", array( $fn, $mixed ) );

	}

}



/**

 * Add advanced restore theme options.

 *

 * @since  1.0

 * @return void

 */

function k2t_skstore_add_advance_option() {

	$add_data = array();

	

	$backup_restore = get_option( 'k2t_skstore_theme_options_advance_backup_restore' );



	if ( isset( $backup_restore ) && $backup_restore == '' ) {

		/* Add Data Theme Options */

		$backup_id                  = $_POST['advance_id'];

		$add_data[0]['advance_id']  = $backup_id;

		$add_data[0]['backup_id']   = $backup_id . '_' . time();

		$backup_name                = $_POST['backup_name'];

		$add_data[0]['backup_name'] = $backup_name;

		$add_data[0]['time']        = date('D M j G:i Y');

		$backup_data                = $_POST['data'];

		$add_data[0]['data']        = $backup_data;

		add_option( 'k2t_skstore_theme_options_advance_backup_restore', json_encode( $add_data ) );

	} else {

		$current_backup_data     = array();

		$backup_id               = $_POST['advance_id'];

		$add_data['advance_id']  = $backup_id;

		$add_data['backup_id']   = $backup_id . '_' . time();

		$backup_name             = $_POST['backup_name'];

		$add_data['backup_name'] = $backup_name;

		$add_data['time']        = date('D M j G:i Y');

		$backup_data             = $_POST['data'];

		$add_data['data']        = $backup_data;

		$current_backup_data     = ( array )json_decode( $backup_restore ) ;

		array_push( $current_backup_data, $add_data );

		update_option( 'k2t_skstore_theme_options_advance_backup_restore', json_encode( $current_backup_data ) );

	}

	die();

}

add_action( 'wp_ajax_k2t_add_advance_option', 'k2t_skstore_add_advance_option' );

add_action( 'wp_ajax_nopriv_k2t_add_advance_option', 'k2t_skstore_add_advance_option' );



/**

 * Load advanced restore theme options.

 *

 * @since  1.0

 * @return void

 */

function k2t_skstore_load_advance_option() {

	$id                  = $_POST['advance_id'];

	$backup_restore      = get_option( 'k2t_skstore_theme_options_advance_backup_restore' );

	$current_backup_data = ( array )json_decode( $backup_restore );

	

	$output = '<div onload="">';

	foreach( $current_backup_data as $da ) {

		if( $da->advance_id == $id ) {

			$output .= '

			<li backup-id=' . $da->backup_id . ' for=' . $id . ' data="' . $da->data . '">

				<input for="' . $id . '" for-name="' . $da->backup_name . '" id="input_downloadify' . $da->backup_id . '" type="hidden" value="' . $id . '|' . $da->backup_id . '|' . $da->backup_name . '|' . $da->data . '" />

				<div id="download_backup" class="download_backup download_backup' . $da->backup_id . '">Open Text Field</div>

				<div class="dashicons_item dashicons dashicons-trash"></div>' . $da->backup_name . '

			</li>';

			

		}

		$output .= '

			<scr' . 'ipt>

				opensave.make({ 					

					width: 		20,

					height: 	20,

					filename: 	"Data.txt", 

					buttonDiv: 	"download_backup",

					dataID: 	"input_downloadify' . $da->backup_id . '",

					image_up:   "' . get_template_directory_uri() . '/framework/assets/images/download.png",

					image_down: "' . get_template_directory_uri() . '/framework/assets/images/download-hover.png",

					image_over: "' . get_template_directory_uri() . '/framework/assets/images/download-hover.png",

					label:""

				});

			</scr' . 'ipt>';

	}

	$output .= '</div>';

	

	echo ( $output );

	die();

}

add_action( 'wp_ajax_k2t_load_advance_option', 'k2t_skstore_load_advance_option' );

add_action( 'wp_ajax_nopriv_k2t_load_advance_option', 'k2t_skstore_load_advance_option' );



/**

 * Generate custom search form

 *

 * @param string $form Form HTML.

 * @return string Modified form HTML.**/

function k2t_skstore_wpdocs_my_search_form( $form ) {

    $form = '<form role="search" method="get" id="searchform" class="searchform" action="' .  esc_url( home_url( '/' ) ) . '" >

    <input type="text" value="' . get_search_query() . '" name="s" id="s" placeholder="' . esc_html__('Type Your Keyword...','skstore') . '" />

    <button type="submit" id="searchsubmit" value="'. esc_attr__( 'Search', 'skstore' ) .'" /><i class="fa fa-search"></i></button>

    </form>';

 

    return $form;

}

add_filter( 'get_search_form', 'k2t_skstore_wpdocs_my_search_form' );





/**

 * Backup advanced restore theme options.

 *

 * @since  1.0

 * @return void

 */

function k2t_skstore_backup_advance_option() {

	global $smof_data, $options_machine, $of_options;

	$id      = $_POST['advance_id'];

	$data    = $_POST['data'];

	$restore =  json_decode( k2t_skstore_k2tde( $data ) );

	foreach( $restore as $rk=>$aid ) {

		foreach ( $smof_data as $k=>$v ) {

			if ( $k == $rk && $k != '0' ) {

				if ( $smof_data[$k] != $aid ) { 

					set_theme_mod( $k, $aid );

				} else if ( is_array( $v ) ) {

					foreach ( $aid as $key=>$val ) {

						if ( $key != $k && $v[$key] == $val ) {

							set_theme_mod( $k, $aid );

							break;

						}

					}

				}			

			}

		}

	}

	die();

}

add_action( 'wp_ajax_k2t_backup_advance_option', 'k2t_skstore_backup_advance_option' );

add_action( 'wp_ajax_nopriv_k2t_backup_advance_option', 'k2t_skstore_backup_advance_option' );



/**

 * Delete backup.

 *

 * @since  1.0

 * @return void

 */

function k2t_skstore_delete_advance_option() {

	global $smof_data, $options_machine, $of_options;

	$id                  = $_POST['advance_id'];

	$backup_id           = $_POST['backup_id'];

	$data                = $_POST['data'];

	$backup_restore      = get_option( 'k2t_skstore_theme_options_advance_backup_restore' );

	$current_backup_data = ( array )json_decode( $backup_restore );

	$output              = '';

	$i = 0;

	$template = array();

	foreach( $current_backup_data as $da ) {

		if ( $da->backup_id != $backup_id ) {

			$template[] = $da;

		}

		$i++;

	}

	update_option( 'k2t_skstore_theme_options_advance_backup_restore', json_encode( $template ) );

	die();

}

add_action( 'wp_ajax_k2t_delete_advance_option', 'k2t_skstore_delete_advance_option' );

add_action( 'wp_ajax_nopriv_k2t_delete_advance_option', 'k2t_skstore_delete_advance_option' );



/**

 * Upload backup.

 *

 * @since  1.0

 * @return void

 */

function k2t_skstore_backup_from_file() {

	global $smof_data, $options_machine, $of_options;



	$data_backup         = $_POST['data_backup'];

	$backup_type         = $_POST['backup_type'];

	$backup_restore      = get_option( 'k2t_skstore_theme_options_advance_backup_restore' );

	$current_backup_data = ( array ) json_decode( $backup_restore );

	$validate_data       = '0';

	$notice              = '';

	$backup_data         = explode( '|',$data_backup );

	$data_import         = array();

	// Validate Struct 

	if ( count( $backup_data ) != 4 ) {

		$validate_data = 0;

		$notice = esc_html__( 'Data Struct False', 'skstore' );

	} else {

		// Validate check exitst type

		foreach ( $of_options as $of ) {

			if ( isset( $of['id'] ) && $of['id'] == $backup_data[0] ) {

				$validate_data = '1';

			};

		}

		if ( $validate_data == '0' ) {

			$notice = esc_html__( 'Sorry, This Backup False! Not found name of advance on db', 'skstore' );

		} else {

			// Check isset in database

			foreach ( $current_backup_data as $da ) {

				if ( $da->backup_id == $backup_data[1] ) {

					$validate_data = '1';

					$notice        = esc_html__( 'This backup really exists!! It will move to top of list backup, and restore data for you!', 'skstore' );

				}

			}

		}

		

	}

	// Check jsonstring of DATA

	if ( $data_import = json_decode(  k2t_skstore_k2tde( $backup_data[3], true ) ) ) {

		if ( $backup_type == 'save_to_back_up_list' ) {

			/* Save to backup list */

			$backup_id               = $backup_data[0];

			$add_data['advance_id']  = $backup_id;

			$add_data['backup_id']   = $backup_id . '_' . time();

			$backup_name             = $backup_data[2];

			$add_data['backup_name'] = $backup_name;

			$add_data['time']        = date('D M j G:i Y');

			$backup_data             = $backup_data[3];

			$add_data['data']        = $backup_data;

			array_push( $current_backup_data, $add_data );

			update_option( 'k2t_skstore_theme_options_advance_backup_restore', json_encode( $current_backup_data ) );

			$notice = esc_html__( 'Added To Backup List', 'skstore' );





		} else if ( $backup_type == 'restore' ) {

			/* Restore */

			global $smof_data, $options_machine, $of_options;

			$backup_id = $backup_data[0];

			$id        = $backup_data[1];

			$data      = $backup_data[3];

			$restore   =  json_decode( k2t_skstore_k2tde( $data ) );

			foreach ( $restore as $rk=>$aid ) {

				foreach ( $smof_data as $k=>$v ) {

					if ( $k == $rk && $k != '0' ) {

						if ( $smof_data[$k] != $aid ) { 

							set_theme_mod( $k, $aid );

						} else if ( is_array( $v ) ) {

							foreach ( $aid as $key=>$val ) {

								if ( $key != $k && $v[$key] == $val ) {

									set_theme_mod( $k, $aid );

									break;

								}

							}

						}			

					}

				}

			}

			$notice = esc_html__( 'Restored!', 'skstore' );



		} else if ( $backup_type == 'restore_and_save_to_backup_list' ) {

			global $smof_data, $options_machine, $of_options;

			/* Restore And Save To Backup List */

			/* Save to backup list */

			$backup_id               = $backup_data[0];

			$add_data['advance_id']  = $backup_id;

			$add_data['backup_id']   = $backup_id . '_' . time();

			$backup_name             = $backup_data[2];

			$add_data['backup_name'] = $backup_name;

			$add_data['time']        = date( 'D M j G:i Y' );

			$backup_data             = $backup_data[3];

			$add_data['data']        = $backup_data;

			array_push( $current_backup_data, $add_data );

			update_option( 'k2t_skstore_theme_options_advance_backup_restore', json_encode( $current_backup_data ) );

			$notice = esc_html__( 'Added To Backup List!', 'skstore' );





			/* Restore */

			$backup_id = $backup_data[0];

			$id        = $backup_data[1];

			$data      = $backup_data[3];

			$restore   =  json_decode( k2t_skstore_k2tde( $data ) );

			foreach ( $restore as $rk=>$aid ) {

				foreach ( $smof_data as $k=>$v ) {

					if( $k == $rk && $k != '0' ) {

						if ( $smof_data[$k] != $aid ) { 

							set_theme_mod( $k, $aid );

						} else if ( is_array( $v ) ) {

							foreach ( $aid as $key=>$val ) {

								if ( $key != $k && $v[$key] == $val ) {

									set_theme_mod( $k, $aid );

									break;

								}

							}

						}			

					}

				}

			}

			$notice = esc_html__( 'Restored!', 'skstore' );

		}

		

	} else {

		// not valid

		$notice = esc_html__( 'We can\'t Read Data backup. Have an other change for backup file!', 'skstore' );

	}

	

	print_r( $notice );



	die();

}

add_action( 'wp_ajax_k2t_backup_from_file', 'k2t_skstore_backup_from_file' );

add_action( 'wp_ajax_nopriv_k2t_backup_from_file', 'k2t_skstore_backup_from_file' );



/**

 * Save a backup.

 *

 * @since  1.0

 * @return void

 */

function k2t_skstore_save_advance_option(){

	header('Content-type: text/plain');

	header('Content-disposition: attachment; filename="data.txt"');

}

add_action( 'wp_ajax_k2t_save_advance_option', 'k2t_skstore_save_advance_option' );

add_action( 'wp_ajax_nopriv_k2t_save_advance_option', 'k2t_skstore_save_advance_option' );

