<?php

/**

 * Themes functions config woocommerce.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link http://www.sunrisetheme.com

 */



// Don't duplicate me!

if ( ! class_exists( 'k2t_template_woo' ) ) {



	/**

	 * Class to apply woocommerce templates

	 *

	 * @since 4.0.0

	 */

	class k2t_template_woo {



		/**

		 * Constructor.

		 * @return  void

		 * @since   1.0

		 */

		function __construct() {

			global $smof_data;



			// Add action

			add_action( 'wp', array( $this, 'woo_init') );

			add_action( 'widgets_init', array( $this, 'k2t_woocommerce_widgets_init' ) );

			add_action( 'wp_enqueue_scripts',  array( $this, 'k2t_woocommerce_enqueue_style' ) );

			add_action( 'after_setup_theme', array( $this, 'k2t_woocommerce_image_dimensions' ), 1 );



			// Add filters

			add_filter( 'woocommerce_add_to_cart_fragments', array( $this, 'k2t_add_to_cart_fragment' ) );

			if ( isset( $smof_data['shop-products-per-page'] ) &&  $smof_data['shop-products-per-page'] != "") {

				add_filter( 'loop_shop_per_page', function( $cols ) { return $smof_data['shop-products-per-page']; }, 20 );

			}



			// Change the default with theme functions

			add_action( 'woocommerce_before_shop_loop_item', array( $this, 'k2t_woocommerce_before_shop_loop_item' ) );

			add_action( 'woocommerce_before_shop_loop', array( $this, 'k2t_woocommer_wrap_ordering' ), 15 );

   			add_action( 'woocommerce_before_shop_loop', array( $this, 'k2t_woocommer_end_wrap_ordering' ), 35 );

   			add_action( 'woocommerce_before_shop_loop', array( $this, 'k2t_woocommer_wrap_ordering' ), 15 );

   			add_action( 'woocommerce_before_shop_loop', array( $this, 'k2t_woocommer_end_wrap_ordering' ), 35 );

			add_action( 'woocommerce_after_shop_loop_item',  array( $this, 'k2t_woocommerce_after_shop_loop_item' ) );

			add_action( 'woocommerce_before_shop_loop_item_title',  array( $this, 'k2t_woocommerce_before_shop_loop_item_title' ));

			add_action( 'woocommerce_after_shop_loop_item_title',  array( $this, 'k2t_woocommerce_after_shop_loop_item_title' ) );

			add_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 60 );

			remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );

			add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 20 );

			add_action( 'woocommerce_single_product_summary',  array( $this, 'k2t_woocommerce_out_of_stock' ), 20 );



			add_action( 'woocommerce_before_shop_loop_item', array( $this, 'k2t_wc_loop_product_thumbnail'), 10 );



			// change thumbnail product loop



			remove_filter( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );



			//woocommerce_template_loop_price

			add_action( 'woocommerce_single_product_summary',  array( $this, 'k2t_woocommerce_before_price' ), 5 );

			add_action( 'woocommerce_single_product_summary',  array( $this, 'k2t_woocommerce_after_rate' ), 10 );

			add_action( 'woocommerce_after_single_product_summary',  array( $this, 'k2t_woocommerce_show_or_hide_related_product' ) );



			// Remove order product item

			remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

			remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );

			remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );

			remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );





			// Action order product item

			add_action( 'woocommerce_before_shop_loop_item', array( $this, 'k2t_woocommer_wrap_3_button'), 15 );

			add_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 20 );

			//add_action( 'woocommerce_before_shop_loop_item', array( $this, 'k2t_add_to_wishlist'), 25 );



			// check for empty-cart get param to clear the cart

			add_action( 'init', 'skstore_woocommerce_clear_cart_url' );

			function skstore_woocommerce_clear_cart_url() {

			  global $woocommerce;



				if ( isset( $_GET['empty-cart'] ) ) {

					$woocommerce->cart->empty_cart();

				}

			}





			if( function_exists( 'YITH_WCQV_Frontend' ) ){



				function yith_add_quick_view_button( $product_id = 0, $label = '', $return = false ){



					global $product;



					! $label && $label = YITH_WCQV_Frontend()->get_button_label();





					$button = '<a href="#" class="button yith-wcqv-button" data-product_id="' . $product_id . '">' . $label . '</a>';

	    			 $button = apply_filters( 'yith_add_quick_view_button_html', $button, $label, $product );



					if( $return ) {

						return $button;

					}



					echo $button;

				}



				add_action( 'woocommerce_before_shop_loop_item', array( $this, 'yith_add_quick_view_button' ), 25 );



			}



			add_action( 'woocommerce_before_shop_loop_item', array( $this, 'k2t_woocommerce_quick_view'), 25 );



			add_action( 'woocommerce_before_shop_loop_item', array( $this, 'k2t_woocommer_end_wrap_3_button'), 35 );

			add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_rating', 11 );

			add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 9 );

			add_action('woocommerce_single_variation', array( $this, 'k2t_woocommerce_quantity') , 15 );

			//add_action('woocommerce_before_add_to_cart_button', array( $this, 'k2t_woocommerce_simple_quantity') , 15 );



			/**

			 * Setting theme options for display results count

			 *

			 * @since 1.0

			 */

			if ( isset(  $smof_data['shop-display-result-count'] ) && ! $smof_data['shop-display-result-count'] ) {

				remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );

			 }



			/**

			 * Setting theme options for display ordering

			 *

			 * @since 1.0

			 */





			if ( isset ( $smof_data['shop-display-sorting'] ) && ! $smof_data['shop-display-sorting'] ) {

				remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

			}

		}

		/**

		 * Register widget.

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_widgets_init() {

			register_sidebar( array(

				'name'          => esc_html__( 'Shop Sidebar', 'skstore' ),

				'id'            => 'shop_sidebar',

				'description'   => esc_html__( 'This sidebar is used for WooCommerce Plugin, on shop pages.', 'skstore' ),

				'before_widget' => '<aside class="widget %2$s">',

				'after_widget'  => '</aside>',

				'before_title'  => '<h2 class="widget-title"><span>',

				'after_title'   => '</span></h2>',

			) );

		}



		/**

		 * Out of stock

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_out_of_stock() {

			global $product;

			if ( ! $product->is_in_stock() ) echo '<div class="out-of-stock"><span>' . esc_html__('Out of stock ') . '</span></div>';

		}



		/**

		 * Enqueue style.

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_enqueue_style() {

			// Load woocommerce style.

			wp_enqueue_style( 'wcm-style', get_template_directory_uri() . '/assets/css/woocommerce.css' );

		}



		public static function k2t_woocommerce_quantity() {

			global $smof_data;

			global $product;

			echo 	'<div class="k2t_wc_quantity">

						<input type="text" name="k2t_quantity" value="1">

						<div class="btn-quanty">

							<span class="inc quy-up"><i class="fa fa-angle-up"></i></i></span>

							<span class="dec quy-down"><i class="fa fa-angle-down"></i></span>

						</div>

					</div>';

			echo 	'<scr' . 'ipt>

							jQuery(document).ready(function(){

								jQuery(".k2t_wc_quantity").find("input").val("1");

								jQuery(".entry-summary").find("input.qty").val("1");

								if(jQuery(".k2t_wc_quantity").length){

									jQuery(".k2t_wc_quantity .button").on("click", function() {



									  var jQuery_button = jQuery(this);

									  var oldValue = jQuery_button.parent().find("input").val();

									  if (jQuery_button.hasClass("inc")) {

										  var newVal = parseFloat(oldValue) + 1;

										} else {

										if (oldValue > 0) {

										  var newVal = parseFloat(oldValue) - 1;

										} else {

										  newVal = 0;

										}

									  }

									  jQuery_button.parent().find("input").val(newVal);

									  jQuery(".variations_button .quantity").find("input").val(newVal);

									  jQuery(".entry-summary").find("input.qty").val(newVal);

									});

								}

								jQuery(".k2t_wc_quantity input").on("keyup", function(){

									var newVal = jQuery(".k2t_wc_quantity").find("input").val();

									jQuery(".variations_button .quantity").find("input").val(newVal);

									jQuery(".entry-summary").find("input.qty").val(newVal);

								});

							});

						</scr' . 'ipt>';

		}



		public static function k2t_woocommerce_simple_quantity() {

			global $smof_data;

			global $product;

			if ( $product->get_type() == 'simple' ) :

				echo 	'<div class="k2t_wc_quantity">

							<input type="text" name="k2t_quantity" value="1">

							<div class="btn-quanty">

							<span class="inc quy-up"><i class="fa fa-angle-up"></i></i></span>

							<span class="dec quy-down"><i class="fa fa-angle-down"></i></span>

							</div>

						</div>';

				echo 	'<scr' . 'ipt>

							jQuery(document).ready(function(){

								jQuery(".k2t_wc_quantity").find("input").val("1");

								start = jQuery(".variations select option:selected").index();

								jQuery(".variations_form input").on("change", function() {

								   jQuery(".variations_form input").not(this).prop("checked", false);

								   if ( !jQuery(this).is(":checked") )

										jQuery(this).prop("checked",true);

								   var val = jQuery(this).attr("value");

									jQuery(".variations select").val(val).each(function(){

										jQuery(".variations select").trigger("change");

									});

								});



								jQuery(".k2t_wc_quantity").find("input").val("1");

								jQuery(".entry-summary").find("input.qty").val("1");

								if(jQuery(".k2t_wc_quantity").length){

									jQuery(".k2t_wc_quantity .button").on("click", function() {



									  var jQuery_button = jQuery(this);

									  var oldValue = jQuery_button.parent().find("input").val();

									  if (jQuery_button.hasClass("inc")) {

										  var newVal = parseFloat(oldValue) + 1;

										} else {

										if (oldValue > 0) {

										  var newVal = parseFloat(oldValue) - 1;

										} else {

										  newVal = 0;

										}

									  }

									  jQuery_button.parent().find("input").val(newVal);

									  jQuery(".variations_button .quantity").find("input").val(newVal);

									  jQuery(".entry-summary").find("input.qty").val(newVal);

									});

								}

								jQuery(".k2t_wc_quantity input").on("keyup", function(){

									var newVal = jQuery(".k2t_wc_quantity").find("input").val();

									jQuery(".variations_button .quantity").find("input").val(newVal);

									jQuery(".entry-summary").find("input.qty").val(newVal);

								});

							});

						</scr' . 'ipt>';

			endif;

		}



		/**

		 * Change html structure to before shop item

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_before_shop_loop_item() {

			global $smof_data;

			echo '<article class="product-item"><div class="product-thumb">';

		}

		public static function k2t_woocommer_wrap_ordering() {

		   echo '<div class="wrap-order-ring">';

		  }

		  public static function k2t_woocommer_end_wrap_ordering() {

		   echo '</div>';

		  }

		public static function k2t_woocommerce_quick_view() {}

		public static function k2t_woocommer_wrap_3_button() {

		   echo '<div class="wrap-3-button">';

		}

		public static function k2t_woocommer_end_wrap_3_button() {

		  echo '</div></div>';

		}

		/**

		 * Change html structure to after shop item

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_after_shop_loop_item() {

			global $product;

			echo '</article>';

		}



		/**

		 * Change html structure to before item action

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_before_shop_loop_item_title() {

			echo '<div class="product-name">';

		}



		/**

		 * Change html structure to after item action

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_after_shop_loop_item_title() {

			echo '</div>';

		}



		/**

		 * Change html structure to price and rating on single product

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_before_price() {

			echo '<div class="p-rate-price">';

		}

		public static function k2t_woocommerce_after_rate() {

			echo '</div>';

		}



		/**

		 * Show or hide related product

		 *

		 * @since 1.0

		 */

		public static function k2t_woocommerce_show_or_hide_related_product() {

			global $smof_data;

			if ( $smof_data['shop-single-display-related-products'] ) :

				woocommerce_output_related_products();

			endif;

		}

		public static function k2t_wc_loop_product_thumbnail() {

			$related = get_query_var( 'related_products' );

			if ( $related )

				echo woocommerce_get_product_thumbnail( 'thumb_270x365', 270, 365 );

			else

				echo woocommerce_get_product_thumbnail();   // Default Image Size

		}

		//change related size

		function woo_init() {

		    if( is_singular( 'product' ) ) {

			    add_filter( 'woocommerce_related_products_args', function( $query_args ) {

			        if( ! empty( $query_args ) ) {

			            set_query_var( 'related_products', true );

			        }



			        return $query_args;

			    } );

			}

		}



		/**

		 * Wishlist Button

		 *

		 * @return  array

		 * @since 	1.0

		 */



		public static function yith_add_quick_view_button(){

			global $product;

			echo '<a href="#" data-product_id="'.esc_attr( $product->get_id() ).'" class="click-fullscreen yith-wcqv-button" style="zoom: 1;"></a>';

		}



		public static function k2t_add_to_wishlist() {



			global $product, $yith_wcwl;



			if ( class_exists( 'YITH_WCWL_UI' ) )  {

				echo do_shortcode( '[yith_wcwl_add_to_wishlist]');

			return '';

			}

		}



		/**

		 * Add shopcart menu to header

		 *

		 * @return  array

		 */

		public static function k2t_add_to_cart_fragment( $fragments ) {

			global $woocommerce;

			ob_start();

		?>

			<a class="cart-control" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_html_e( 'View your shopping cart', 'skstore' ); ?>">

				<i class="icon-basket"></i>

				<span><?php echo esc_html( $woocommerce->cart->get_cart_contents_count() ); ?></span>

			</a>

		<?php

			$fragments['a.cart-control'] = ob_get_clean();

			return $fragments;

		}

		public static function k2t_shoping_cart() {

			global $woocommerce;



			$cart_total = apply_filters( 'woocommerce_add_to_cart_fragments' , array() );



			echo '<div class="shop-cart">';

			echo ( $cart_total['a.cart-control'] );

			echo '<div class="shop-item">';

			echo '<div class="widget_shopping_cart_content"></div>';

			echo '</div>';

			echo '</div>';

		}



		/**

		 * Set WooCommerce image dimensions upon theme activation

		 * @since 1.0

		 */

		public static function k2t_woocommerce_image_dimensions() {



			// check resize one time 4 furion



			add_option( 'wc_img_size_sk_store', true, '', 'no' );



			if ( get_option('wc_img_size_sk_store') ) :

				$catalog = array(

					'width'  => '270', // px

					'height' => '365', // px

					'crop'	 => 1

				);



				$single = array(

					'width'  => '570', // px

					'height' => '570', // px

					'crop'	 => 1

				);

				$thumbnail = array(

					'width' 	=> '100', // px

					'height'	=> '100', // px

					'crop'		=> 1

				);





				// Image sizes



				update_option( 'shop_catalog_image_size', $catalog ); // Product category thumbs

				update_option( 'shop_single_image_size', $single ); // Single product image

				update_option( 'shop_thumbnail_image_size', $thumbnail ); // Image gallery thumbs

				update_option( 'wc_img_size_sk_store', false);



			endif;

		}



	}



}

new k2t_template_woo();



//Sold Out tag

add_action( 'woocommerce_before_shop_loop_item_title', 'woo_rename_soldout' );



function woo_rename_soldout() {

    global $product;

    if ( ! $product->is_in_stock() ) {

        echo '<span class="onsale soldout">' . esc_html__( 'Sold', 'skstore'). '</span>';

    }

}



//Reorder Tab

add_filter( 'woocommerce_product_tabs', 'woo_reorder_tabs', 98 );

function woo_reorder_tabs( $tabs ) {

	global $product;

	$tabs['reviews']['priority'] = 10;			// Reviews first

	$tabs['description'];      	// Remove the description tab

	return $tabs;

}

add_filter( 'woocommerce_product_tabs', 'woo_reorder_tabs_1', 98 );

function woo_reorder_tabs_1( $tabs_new ) {

	global $product;

	$tabs_new['additional_information'] = '';

	wc_get_template_part( 'single-product/tabs' );

    if ( $tabs_new['additional_information'] ) $tabs_new['additional_information']['priority'] = 5;

    $tabs_new['additional_information']['title'] = esc_html__( 'tech specs','skstore' );

	return $tabs_new;

}



if ( ! function_exists( 'woo_social_share' ) ) {

	function woo_social_share() {

		global $smof_data, $post;

		$twitter_username = isset ( $smof_data['twitter-username'] ) ? trim( $smof_data['twitter-username'] ) : '';



		// Get post thumbnail

		$src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), false, '' ); ?>



		<div class="k2t-social-share">

			<span class='share-title'><?php echo esc_html__( 'Share:', 'skstore' ) ?></span>

			<ul class="social">

				<?php if ( isset ( $smof_data['woo-social-facebook'] ) && $smof_data['woo-social-facebook'] ):?>

					<li>

						<a class="facebook" href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="social_facebook_circle"></i>

							<span><?php esc_html_e( 'Facebook', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['woo-social-twitter'] ) && $smof_data['woo-social-twitter'] ):?>

					<li>

						<a class="twitter" href="https://twitter.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="social_twitter_circle"></i>

							<span><?php esc_html_e( 'Twitter', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['woo-social-google-plus'] ) && $smof_data['woo-social-google-plus'] ):?>

					<li>

						<a class="googleplus" href="https://plus.google.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">

							<i class="social_googleplus_circle"></i>

							<span><?php esc_html_e( 'Google Plus', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['woo-social-linkedin'] ) && $smof_data['woo-social-linkedin'] ):?>

					<li>

						<a class="linkedin" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode( get_permalink() );?>&title=<?php echo urlencode( get_the_title() );?>" title="<?php esc_html_e( 'LinkedIn', 'skstore' );?>">

							<i class="social_linkedin_circle"></i>

							<span><?php esc_html_e( 'Linkedin', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['woo-social-tumblr'] ) && $smof_data['woo-social-tumblr'] ):?>

					<li>

						<a class="tumblr" href="https://www.tumblr.com/share/link?url=<?php echo urlencode( get_permalink() );?>&name=<?php echo urlencode( get_the_title() );?>" title="<?php esc_html_e( 'Tumblr', 'skstore' );?>">

							<i class="social_tumblr_circle"></i>

							<span><?php esc_html_e( 'Tumblr', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>



				<?php if ( isset ( $smof_data['woo-social-email'] ) && $smof_data['woo-social-email'] ):?>

					<li>

						<a class="em" href="mailto:?subject=<?php the_title(); ?>&body=<?php echo strip_tags( apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ); ?> <?php the_permalink(); ?>">

							<i class="icon_mail"></i>

							<span><?php esc_html_e( 'Email', 'skstore' ); ?></span>

						</a>

					</li>

				<?php endif;?>

			</ul><!-- .social -->

		</div><!-- .social-share -->

	<?php

	}

}



add_action( 'woocommerce_share', 'woo_social_share', 10 );







//*dhvc filter *//

add_filter( 'dhvc_woo_images', 'dhvc_insert_add_to_cart' );



function dhvc_insert_add_to_cart ( $output_image ) {



	global $product;



	//get add to card

	$add_to_cart = '>';

	ob_start();

		echo '<div class="add-to-cart">';

		wc_get_template_part( 'loop/add-to','cart' );

		echo '</div>';

	$add_to_cart .= ob_get_clean();

	$pos = strpos($output_image, '>');

	$output_image = substr_replace( $output_image, $add_to_cart, $pos, 1);



	// sold out



	// $check_quantity = ( $product->get_stock_quantity() === 0 );



	// $check_quantity = $check_quantity && ( $product->get_backorders() == 'no' );



	// if ( $product->get_stock_status() || $check_quantity ) {

	// 	$sold = '<span class="onsale soldout">' . esc_html__( 'Sold', 'skstore' ) . '</span>';

	// 	$output_image .= $sold;

	// }



	//insert into output image

	return $output_image;

}





//*dhvc dhvc_woo_products



function dhvc_woo_products_fix_post__in( $query_args, $atts, $content ) {



	if ( !isset( $atts['query_type'] ) ) :

		if( !empty( $atts['products'] ) ){

			$products_ids = explode(',', $atts['products'] );

			$query_args ['post__in'] = $products_ids;

		}

	endif;



	return $query_args;

}

add_filter( 'dhvc_woo_query_args', 'dhvc_woo_products_fix_post__in', 10, 3 );



// Our hooked in function - $fields is passed via the filter!

function custom_override_edit_billing_address( $fields ) {

    $fields['first_name']['placeholder'] = 'First Name';

	$fields['last_name']['placeholder'] = 'Last Name';

	$fields['company']['placeholder'] = 'Company';

	$fields['state']['placeholder'] = 'State';

	$fields['phone']['placeholder'] = 'Phone';

    return $fields;

}



// single detail 3 extra product;

$output = '';

function dhvc_woo_single_product_text_1( $output ) {

	if( function_exists('get_field') ) :

		$text = get_field('sing_product_text_1',get_the_ID());

		return $text;

		var_dump($text);

	endif;

}

add_filter('sk_single_product_extra_meta_content_1','dhvc_woo_single_product_text_1', $output);



function dhvc_woo_single_product_text_2( $output ) {

	if( function_exists('get_field') ) :

		$text = get_field('sing_product_text_2',get_the_ID());

		return $text;

	endif;

}

add_filter('sk_single_product_extra_meta_content_2','dhvc_woo_single_product_text_2', $output);



function dhvc_woo_single_product_img_1( $output ) {

	if( function_exists('get_field') ) :

		$img_id = get_field('sing_product_img_1',get_the_ID());

		$img = wp_get_attachment_image( $img_id, 'full' );

		return $img;

	endif;

}

add_filter('sk_single_product_extra_meta_img_1','dhvc_woo_single_product_img_1', $output);



function dhvc_woo_single_product_img_2( $output ) {

	if( function_exists('get_field') ) :

		$img_id = get_field('sing_product_img_2',get_the_ID());

		$img = wp_get_attachment_image( $img_id, 'full' );

		return $img;

	endif;

}

add_filter('sk_single_product_extra_meta_img_2','dhvc_woo_single_product_img_2', $output);
