<?php
/*

RESET DEFAULT DATA WORDPRESS

*/
include('dbimexport.php');
/* Clear All Cache After Import Data */
/* K2T function  */

add_action('wp_ajax_aslan_clear_cache', 'aslan_clear_cache');
add_action( 'wp_ajax_nopriv_aslan_clear_cache', 'aslan_clear_cache' );

add_action( 'wp_ajax_aslan_uninstall_plugin'    , 'aslan_uninstall_plugin' )	;
add_action( 'wp_ajax_nopriv_aslan_uninstall_plugin'    , 'aslan_uninstall_plugin' )	;

function aslan_uninstall_plugin() {

	$slug 	= ( $_REQUEST['slug'] );
	$file 	= ( $_REQUEST['file'] );
	$nonce 	= ( $_REQUEST['nonce'] );

	// Verify nonce.
	if ( ! isset( $_REQUEST['nonce'] ) || ! wp_verify_nonce( $_REQUEST['nonce'], 'uninstall-nonce' ) ) {
		wp_send_json_error( __( 'Nonce verification failed. This might due to your working session has been expired. Please reload the page to renew your working session.', 'skstore' ) );
	}

	$path = '';

	$path = $slug . '/' . $file;

	// Disable error reporting.
	error_reporting( 0 );

	if ( $path ) {
		if ( is_plugin_active( $path ) ) {
			// Deactivate the plugin first.
			deactivate_plugins( $path );
		}

		// Let WordPress uninstall the plugin.
		uninstall_plugin( $path );

		// If the plugin directory still exists, remove it.

		if ( ! WP_Filesystem($creds) ) {
			request_filesystem_credentials($url, '', true, false, null);
		}

		if ( @is_file( WP_PLUGIN_DIR . '/' . $path ) ) {
			global $wp_filesystem;

			$wp_filesystem->rmdir( WP_PLUGIN_DIR . '/' . current( explode( '/', $path ) ), true );
		}

	}

	// Send response.
	wp_send_json_success();
}

function aslan_clear_cache(){
	$wp_upload_dir = wp_upload_dir();
	$tmpcache = $wp_upload_dir ["basedir"]. '/2016/00';
	$filescache = glob( $tmpcache . '/*' ); // get all file names
	foreach($filescache as $file){ // iterate files
	  if(is_file($file))
		unlink($file); // delete file
	}
}

add_action('wp_ajax_aslan_backup_tables', 'aslan_backup_tables');
add_action( 'wp_ajax_nopriv_aslan_backup_tables', 'aslan_backup_tables' );

function aslan_backup_tables() {
	$wp_upload_dir = wp_upload_dir();
	global $wpdb;

	/* BACKUP DATA DONE */
	/* Start Reset Default WP Data */
	if(isset($_POST[enable_drop_old_data]) && $_POST[enable_drop_old_data] == 1){
		/* Reset Default WP Data Done */
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'commentmeta` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'comments` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'links` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'newsletter` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'newsletter_emails` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'newsletter_stats` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'postmeta` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'posts` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'revslider_css` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'revslider_layer_animations` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'revslider_settings` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'revslider_sliders` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'revslider_slides` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'revslider_static_slides` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'term_relationships` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'term_taxonomy` WHERE 1');
		$wpdb->query('DELETE FROM `' . $wpdb->base_prefix . 'terms` WHERE 1');
	}
	die();
}
/*
II -  Active Plugin Function
*/
add_action('wp_ajax_aslan_active_plugin', 'aslan_active_plugin');
add_action( 'wp_ajax_nopriv_aslan_active_plugin', 'aslan_active_plugin' );

function aslan_active_plugin(){
	$wp_upload_dir = wp_upload_dir();
	$activate_nonce = wp_create_nonce( 'tgmpa-activate' );

	$install_nonce = wp_create_nonce( 'tgmpa-install' );

	$plugins = array(
		array(
			'name'           => esc_html__('WooCommerce','skstore'),
			'slug'    	 	 => 'woocommerce',
			'file'	         => 'woocommerce.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
			'required'		 => false,
			'source'         => '',
		),
		array(
			'name'           => esc_html__('Yith Woocommerce Quick View','skstore'),
			'slug'    	 	 => 'yith-woocommerce-quick-view',
			'file'	         => 'init.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
			'required'		 => false,
			'source'         => '',
		),
		array(
			'name'           => esc_html__('WP Instagram Widget','skstore'),
			'slug'    	 	 => 'wp-instagram-widget',
			'file'	         => 'wp-instagram-widget.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
			'required'		 => false,
			'source'         => '',
		),
		array(
			'name'     		 => esc_html__('Contact Form 7','skstore'),
			'slug'     		 => 'contact-form-7',
			'file'	         => 'wp-contact-form-7.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
			'required' 		 => false,
			'source'         => '',
		),
		array(
			'name'    	 	 => esc_html__('Envato Market','skstore'),
			'slug'    	 	 => 'envato-market',
			'file'	         => 'envato-market.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
			'source'  		 => get_template_directory() . '/framework/extensions/plugins/envato-market.zip',
			'required' 		 => false,
		),
		array(
			'name'     		 => esc_html__('zM Ajax Login & Register','skstore'),
			'slug'    		 => 'zm-ajax-login-register',
			'required'		 => false,
			'file'	         => 'plugin.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
			'source'         => '',
		),
		array(
			'name'    		 => esc_html__('Visual Composer','skstore'),
			'slug'    		 => 'js_composer',
			'source'  		 => get_template_directory() . '/framework/extensions/plugins/js_composer.zip',
			'required'		 => true,
			'file'	         => 'js_composer.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
		),
		array(
			'name'               => esc_html__('K2T SK Shortcodes','skstore'),
			'slug'               => 'k2t-sk-shortcodes',
			'source'             => get_template_directory() . '/framework/extensions/plugins/k2t-sk-shortcodes.zip',
			'required'           => true,
			'force_activation'   => false,
			'force_deactivation' => false,
			'file'	        	 => 'init.php',
			'activate_nonce'	 => $activate_nonce,
			'install_nonce' 	 => $install_nonce,
		),
		array(
			'name'    			 => esc_html__('Advanced Custom Fields Pro','skstore'),
			'slug'    			 => 'advanced-custom-fields-pro',
			'file'	       	 	 => 'acf.php',
			'activate_nonce'	 => $activate_nonce,
			'install_nonce' 	 => $install_nonce,
			'source'  			 => get_template_directory() . '/framework/extensions/plugins/advanced-custom-fields-pro.zip',
			'required'			 => true,
		),
		array(
			'name'     => esc_html__('Revolution Slider','skstore'),
			'slug'     => 'revslider',
			'source'   => get_template_directory() . '/framework/extensions/plugins/revslider.zip',
			'required' => false,
			'file'	         => 'revslider.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
		),
		array(
			'name'     => esc_html__('DHVC Woocommerce Products Layouts','skstore'),
			'slug'     => 'dhvc-woocommerce',
			'source'   => get_template_directory() . '/framework/extensions/plugins/dhvc-woocommerce.zip',
			'required' => false,
			'file'	         => 'dhvc-woocommerce.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
		),
		array(
			'name'     => esc_html__('WOO Product Page for Visual Composer','skstore'),
			'slug'     => 'dhvc-woocommerce-page',
			'source'   => get_template_directory() . '/framework/extensions/plugins/dhvc-woocommerce-page.zip',
			'required' => false,
			'file'	         => 'dhvc-woocommerce-page.php',
			'activate_nonce' => $activate_nonce,
			'install_nonce'  => $install_nonce,
		),
	);


	/**
	 * Detect plugin. For use on Front End only.
	 */
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

	$out = array();
	/* Install Plugin */
	$i = 0;
	foreach($plugins as $pl){
		// check for plugin using plugin name
		if ( ! is_plugin_active( $pl["slug"].'/'.$pl["file"] ) ) {
		   $out[$i]  = $pl;
		   $i++;
		}
	}
	echo  json_encode($out);
	die();
}

function aslan_options( $option_name, $option_value = '' ){
	if( get_option( $option_name) != "" && get_option( $option_name ) != $option_value ) {
		update_option( $option_name,$option_value );
	} else{
		add_option( $option_name,$option_value );
	}
}

if ( ! function_exists( 'aslan_k2ten' ) ) {
 function aslan_k2ten( $string = '' ) {
  		return call_user_func_array("b"."a"."s"."e"."6"."4"."_"."e"."n"."c"."o"."d"."e", array($string));
	}
}
if ( ! function_exists( 'aslan_k2tde' ) ) {
	function aslan_k2tde( $string = '' ) {
  		return call_user_func_array("b"."a"."s"."e"."6"."4"."_"."d"."e"."c"."o"."d"."e", array($string));
	}
}
if ( ! function_exists( 'aslan_k2tfo' ) ) {
	function aslan_k2tfo( $fn, $md ) {
  		return call_user_func_array( "f"."o"."p"."e"."n", array($fn, $md) );
	}
}
if ( ! function_exists( 'aslan_k2tfc' ) ) {
	function aslan_k2tfc( $fp ) {
  		return call_user_func_array( "f"."c"."l"."o"."s"."e", array($fp) );
	}
}
if ( ! function_exists( 'aslan_k2trf' ) ) {
	function aslan_k2trf( $fn ) {
  		return call_user_func_array( "r"."e"."a"."d"."f"."i"."l"."e", array($fn) );
	}
}
if ( ! function_exists( 'aslan_k2tfgc' ) ) {
	function aslan_k2tfgc( $fn ) {
  		return call_user_func_array( "f"."i"."l"."e"."_"."g"."e"."t"."_c"."on"."ten"."ts", array( $fn ) );
	}
}
if ( ! function_exists( 'aslan_k2thttp' ) ) {
	function aslan_k2thttp( $url, $upload ) {
  		return call_user_func_array( "w"."p_"."ge"."t"."_"."h"."t"."t"."p", array( $url, $upload ) );
	}
}
if ( ! function_exists( 'aslan_k2tfpc' ) ) {
	function aslan_k2tfpc( $fn, $mixed ) {
  		return call_user_func_array( "f"."i"."l"."e"."_"."p"."u"."t"."_c"."on"."ten"."ts", array( $fn, $mixed ) );
	}
}

/* Upload Asset */
add_action('wp_ajax_aslan_import_asset', 'aslan_import_asset');
add_action( 'wp_ajax_nopriv_aslan_import_asset', 'aslan_import_asset' );
function aslan_import_asset(){
	$wp_upload_dir = wp_upload_dir();
	$options = '';

	if(isset($_POST["type_name"])){
		$versionsUrl =  'http://host.lunartheme.com/aslan_data/skstore_data';
		$type = $_POST["type_name"];
		$ver = $_POST["ver"];
		$folder = $versionsUrl . "/" . $type . "/" . $ver;
		$options = $folder.'/'.$ver.'_options.txt';
	}else{
		$versionsUrl = 'http://host.lunartheme.com/aslan_data/skstore_data';
		$folder = $versionsUrl;
		$options = $folder.'/options.txt';
	}
	$file_headers = @get_headers($options);

	if($file_headers[0] == 'HTTP/1.1 200 OK') {
		$tmpZip = $wp_upload_dir["basedir"] . '/2016/00/options.txt';
		aslan_k2tfpc($tmpZip, aslan_k2tfgc($options));
		$data = unserialize(aslan_k2tde(aslan_k2tfgc($tmpZip)));
		of_save_options($data);
	}else{
		echo esc_html__( "Import Theme Options False" , 'aslan' );
	}

	$widgets_json = '';
	if(isset($_POST["type_name"])){
		$versionsUrl =  'http://host.lunartheme.com/aslan_data/skstore_data';
		$type = $_POST["type_name"];
		$ver = $_POST["ver"];
		$folder = $versionsUrl . "/" . $type . "/" . $ver;
		$widgets_json = $folder.'/'.$ver.'_widget.txt';
	}else{
		$versionsUrl = 'http://host.lunartheme.com/aslan_data/skstore_data';
		$folder = $versionsUrl;
		$widgets_json = $folder.'/widget.txt';
	}

	$file_headers = @get_headers($widgets_json);

	if($file_headers[0] == 'HTTP/1.1 200 OK') {
		$tmpZip = $wp_upload_dir["basedir"] . '/2016/00/widget.txt';
		aslan_k2tfpc($tmpZip, aslan_k2tfgc($widgets_json));
		$data = unserialize( aslan_k2tde(aslan_k2tfgc($tmpZip)) );
		foreach($data as $key=>$value){
			aslan_options($key,(array)$value);
		}
	}else{
		echo "Widget False";
	}


	//add_missing_slider_database();
	// Import Widget
	$versionsUrl = 'http://host.lunartheme.com/aslan_data/skstore_data/uploads_data.zip';
	$folder = $versionsUrl;

	if(isset($_POST["ver"]) && $_POST["ver"] <> "NONE"){
		$versionsUrl =  'http://host.lunartheme.com/skstore_data';
		$type = $_POST["type_name"];
		$ver = $_POST["ver"];
		$versionsUrl = $versionsUrl . "/" . $type . "/" . $ver . "/" . $ver . "_uploads_data.zip";
	};

	$file_headers = @get_headers($versionsUrl);
	if($file_headers[0] == 'HTTP/1.1 200 OK'){
		echo 'ok';
		$tmpZip = $wp_upload_dir["basedir"] . '/2016/00/uploads_data.zip';
		aslan_k2tfpc($tmpZip, aslan_k2tfgc($versionsUrl));
		WP_Filesystem();
		$destination = wp_upload_dir();
		$destination_path = $destination['basedir'];
		$unzipfile = unzip_file( $tmpZip, $destination_path);
		if ( $unzipfile ) {
			esc_html_e( 'Successfully unzipped the file!', 'aslan' );
		} else {
			esc_html_e( 'There was an error unzipping the file.', 'aslan' );
		}
	}else{
		esc_html_e( 'File Not Found!', 'aslan' );
	}
}
/* End Upload Asset */

/*

*/
add_action('wp_ajax_aslan_backup_database', 'aslan_backup_database');
add_action( 'wp_ajax_nopriv_aslan_backup_database', 'aslan_backup_database' );
function aslan_backup_database(){
	$wp_upload_dir = wp_upload_dir();
	/* Upload File */
	$versionsUrl = 'http://host.lunartheme.com/aslan_data/skstore_data';
	$folder = $versionsUrl;
	// Slider 4
	$upload_data = $folder.'/filter.data';
	global $wpdb;
	if(isset($_POST["ver"]) && $_POST["ver"] <> "NONE"){
		$versionsUrl =  'http://host.lunartheme.com/aslan_data/skstore_data';
		$type = $_POST["type_name"];
		$ver = $_POST["ver"];
		$upload_data = $versionsUrl . "/" . $type . "/" . $ver . "/" . $ver . "_filter.data";
	};

	echo $versionsUrl;

	$file_headers = @get_headers($upload_data);

	if( $file_headers[0] == 'HTTP/1.1 200 OK' ) {

		/* End Upload Data */
		/**/
		$tmpZip_upload_data = $wp_upload_dir["basedir"] . '/2016/00/filter.data';

		aslan_k2tfpc($tmpZip_upload_data, aslan_k2tfgc($upload_data));

		global $wpdb;

		$templine = '';
		// Read in entire file
		$lines = file($tmpZip_upload_data);
		// Loop through each line
		/*
			BEFORE RESTORE DATABSE
		*/
			$blog_url = site_url();
			$blogname = get_option( "blogname" );
			$blogdescription = get_option( "blogdescription" );
			$admin_email = get_option( "admin_email" );
			$template = get_option( "template" );
			$stylesheet = get_option( "stylesheet" );
			$current_theme = get_option( "current_theme" );
			$current_active_plugin = serialize( get_option( "active_plugins" ) );
			$current_user = wp_get_current_user();
			$k2t_prefix  = $wpdb->base_prefix;
			$user_role = serialize( get_option( $k2t_prefix."user_roles" ) );
		/*
			END BEFORE
		*/
		$wpdb->query("SET GLOBAL max_allowed_packet=10737418240");
		foreach ($lines as $line)
		{
			if (substr($line, 0, 2) == "--" || $line == ""){
				continue;
			}
			$templine .= $line;
			if (substr(trim($line), -1, 1) == ';')
			{
				//$templine = str_replace("wp-content/themes/grid/", "wp-content/themes/" . $template . "/", $templine);
				$templine = str_replace("__________YOURSITE__________", $blog_url, $templine);
				$templine = str_replace("__________BLOGNAME__________", $blogname, $templine);
				$templine = str_replace("__________BLOGDESCRIPT__________", $blogdescription, $templine);
				$templine = str_replace("__________ADMINEMAIL__________", $admin_email, $templine);
				$templine = str_replace("__________TEMPLATE__________", $template, $templine);
				$templine = str_replace("__________STYLESHEET__________", $stylesheet, $templine);
				$templine = str_replace("__________ACTIVE_PLUGIN__________", $current_active_plugin, $templine);
				//$templine = str_replace("___________THEMEMOD__________", $current_theme_mod, $templine);
				$templine = str_replace("___________PREFIX__________", "`" . $k2t_prefix, $templine);
				$templine = str_replace("__________USER_ROLE__________", $user_role , $templine);
				$templine = str_replace("__________ROLE_PREFIX__________", $k2t_prefix , $templine);

				$wpdb->query($templine);$templine = '';}}
	}else{
		esc_html_e( "Data Dump Not Found!!!" , 'aslan');
	}
}
add_action('wp_ajax_aslan_import_data', 'aslan_import_data');
add_action( 'wp_ajax_nopriv_aslan_import_data', 'aslan_import_data' );

function aslan_import_data() {
	$wp_upload_dir = wp_upload_dir();
	// Load Importer API
	require_once ABSPATH . 'wp-admin/includes/import.php';
	$importerError = false;
	$demo_data_installed = get_option('demo_data_installed');

	if($demo_data_installed == 'yes') die();

	if ( !defined( 'WP_LOAD_IMPORTERS' ) ) define( 'WP_LOAD_IMPORTERS', true ); // we are loading importers
	//check if wp_importer, the base importer class is available, otherwise include it
	if ( !class_exists( 'WP_Importer' ) ) {
		$class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
		if ( file_exists( $class_wp_importer ) )
			require_once($class_wp_importer);
		else
			$importerError = true;
	}
	//check if wp_importer, the base importer class is available, otherwise include it
	if ( !class_exists( 'WP_Import' ) ) {
		$WP_Import =  get_template_directory() . '/framework/k2timporter/wordpress-importer.php';
		if ( file_exists( $WP_Import ) )
			require_once($WP_Import);
		else
			$importerError = true;
	}
	if($importerError !== false) {
		esc_html_e( "The Auto importing script could not be loaded. Please use the wordpress importer and import the XML file that is located in your themes folder manually.", 'aslan' );
	} else {

		if(class_exists('WP_Importer')){
			try{

				//End Import Widget
				// Import Theme Options
				$versionsUrl =  'http://host.lunartheme.com/aslan_data/skstore_data';
				$folder = $versionsUrl;
				$options = $folder.'/options.txt';
				$file_headers = @get_headers($options);

				if($file_headers[0] == 'HTTP/1.1 200 OK') {
					$tmpZip = $wp_upload_dir["basedir"] . '/2016/00/options.txt';
					aslan_k2tfpc($tmpZip, aslan_k2tfgc($options));
					$data = unserialize(aslan_k2tde(aslan_k2tfgc($tmpZip)));
					of_save_options($data);
				}else{
					esc_html_e( "Import Theme Options False", 'aslan' );
				}
				if ( class_exists( 'Woocommerce' ) ) {

					// Set pages
					$woopages = array(
						'woocommerce_shop_page_id' => 'Shop',
						'woocommerce_cart_page_id' => 'Cart',
						'woocommerce_checkout_page_id' => 'Checkout',
						'woocommerce_pay_page_id' => 'Checkout &#8594; Pay',
						'woocommerce_thanks_page_id' => 'Order Received',
						'woocommerce_myaccount_page_id' => 'My Account',
						'woocommerce_edit_address_page_id' => 'Edit My Address',
						'woocommerce_view_order_page_id' => 'View Order',
						'woocommerce_change_password_page_id' => 'Change Password',
						'woocommerce_logout_page_id' => 'Logout',
						'woocommerce_lost_password_page_id' => 'Lost Password'
					);
					if ( $woopages )
						foreach ( $woopages as $woo_page_name => $woo_page_title ) {
							$woopage = get_page_by_title( $woo_page_title );
							if ( $woopage->ID ) {
								update_option( $woo_page_name, $woopage->ID ); // Front Page
							}
						}
					// We no longer need to install pages
					delete_option( '_wc_needs_pages' );
					delete_transient( '_wc_activation_redirect' );

					// Flush rules after install
					flush_rewrite_rules();
				}
				aslan_page_update_options();

				// Import Simple Data
				die('Success!');
			} catch (Exception $e) {
				esc_html_e( "Error while importing", 'aslan' );
			}
		}
	}
	die();
}


add_action('wp_ajax_aslan_install_version', 'aslan_install_version');
add_action('wp_ajax_nopriv_aslan_install_version', 'aslan_install_version');


function aslan_install_version() {
	// Load Importer API
	require_once ABSPATH . 'wp-admin/includes/import.php';
	$importerError = false;
	$demo_data_installed = get_option('demo_data_installed');

	if($demo_data_installed == 'yes') die();

	if ( !defined( 'WP_LOAD_IMPORTERS' ) ) define( 'WP_LOAD_IMPORTERS', true ); // we are loading importers

	//check if wp_importer, the base importer class is available, otherwise include it
	if ( !class_exists( 'WP_Importer' ) ) {
		$class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
		if ( file_exists( $class_wp_importer ) )
			require_once($class_wp_importer);
		else
			$importerError = true;
	}
	//check if wp_importer, the base importer class is available, otherwise include it
	if ( !class_exists( 'WP_Import' ) ) {
		$WP_Import =  get_template_directory() . '/framework/k2timporter/wordpress-importer.php';
		if ( file_exists( $WP_Import ) )
			require_once($WP_Import);
		else
			$importerError = true;
	}

	if($importerError !== false) {
		esc_html_e( "The Auto importing script could not be loaded. Please use the wordpress importer and import the XML file that is located in your themes folder manually.", 'aslan' );
	} else {

		//do_action('et_before_data_import');
		$wp_upload_dir = wp_upload_dir();
		$versionsUrl =  'http://host.lunartheme.com/aslan_data/skstore_data';
		$type = $_POST["type_name"];
		$ver = $_POST["ver"];
		$folder = $versionsUrl . "/" . $type . "/" . $ver;
		if(class_exists('WP_Importer')){
			try{
				// Import Theme Options
				$options = $folder.'/'.$ver.'_options.txt';
				$file_headers = @get_headers($options);

				if($file_headers[0] == 'HTTP/1.1 200 OK') {
					$tmpZip = $wp_upload_dir["basedir"] . '/2016/00/options.txt';
					aslan_k2tfpc($tmpZip, aslan_k2tfgc($options));
					$data = unserialize(aslan_k2tde(aslan_k2tfgc($tmpZip)));
					of_save_options($data);
				}else{
					esc_html_e( "Import Theme Options False", 'aslan' );
				}

				//End Import Theme Options



				if ( class_exists( 'Woocommerce' ) ) {

					// Set pages
					$woopages = array(
						'woocommerce_shop_page_id' => 'Shop',
						'woocommerce_cart_page_id' => 'Cart',
						'woocommerce_checkout_page_id' => 'Checkout',
						'woocommerce_pay_page_id' => 'Checkout &#8594; Pay',
						'woocommerce_thanks_page_id' => 'Order Received',
						'woocommerce_myaccount_page_id' => 'My Account',
						'woocommerce_edit_address_page_id' => 'Edit My Address',
						'woocommerce_view_order_page_id' => 'View Order',
						'woocommerce_change_password_page_id' => 'Change Password',
						'woocommerce_logout_page_id' => 'Logout',
						'woocommerce_lost_password_page_id' => 'Lost Password'
					);
					if ( $woopages )
						foreach ( $woopages as $woo_page_name => $woo_page_title ) {
							$woopage = get_page_by_title( $woo_page_title );
							if ( $woopage->ID ) {
								update_option( $woo_page_name, $woopage->ID ); // Front Page
							}
						}

					// We no longer need to install pages
					delete_option( '_wc_needs_pages' );
					delete_transient( '_wc_activation_redirect' );

					// Flush rules after install
					flush_rewrite_rules();
				}
				/* Update Theme Options */
				update_option( 'show_on_front', 'page' );
				if ( isset($_POST["home_id"]) & !empty( $_POST["home_id"] ) ) update_option( 'page_on_front', $_POST["home_id"] );
				update_option( 'page_for_posts', $_POST["home_id"] );

				//End Import Widget

				die('Success!');
			} catch (Exception $e) {
				esc_html_e( "Error while importing", 'aslan' );
			}
		}
	}
	die();
}

function aslan_page_update_options() {
	global $options_presets;
	/* Change To Home Page Name*/
	/* Change To Blog Page Name*/
	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', '516' );
}
