<?php

/*

Title		: SMOF

Description	: Slightly Modified Options Framework

Version		: 1.5.2

Author		: Syamil MJ

Author URI	: http://aquagraphite.com

License		: GPLv3 - http://www.gnu.org/copyleft/gpl.html



Credits		: Thematic Options Panel - http://wptheming.com/2010/11/thematic-options-panel-v2/

		 	  Woo Themes - http://woothemes.com/

		 	  Option Tree - http://wordpress.org/extend/plugins/option-tree/



Contributors: Syamil MJ - http://aquagraphite.com

			  Andrei Surdu - http://smartik.ws/

			  Jonah Dahlquist - http://nucleussystems.com/

			  partnuz - https://github.com/partnuz

			  Alex Poslavsky - https://github.com/plovs

			  Dovy Paukstys - http://simplerain.com

*/



define( 'SMOF_VERSION', '1.5.2' );



/**

 * Definitions

 *

 * @since 1.4.0

 */

$theme_version = '';

$smof_output = '';

	    

if( function_exists( 'wp_get_theme' ) ) {

	if( is_child_theme() ) {

		$temp_obj = wp_get_theme();

		$theme_obj = wp_get_theme( $temp_obj->get('Template') );

	} else {

		$theme_obj = wp_get_theme();    

	}



	$theme_version = $theme_obj->get('Version');

	$theme_name = $theme_obj->get('Name');

	$theme_uri = $theme_obj->get('ThemeURI');

	$author_uri = $theme_obj->get('AuthorURI');

} else {

	$theme_data = wp_get_theme( get_template_part('/style.css') );

	$theme_version = $theme_data['Version'];

	$theme_name = $theme_data['Name'];

	$theme_uri = $theme_data['ThemeURI'];

	$author_uri = $theme_data['AuthorURI'];

}





define( 'THEMENAME', $theme_name );

/* Theme version, uri, and the author uri are not completely necessary, but may be helpful in adding functionality */

define( 'THEMEVERSION', $theme_version );

define( 'THEMEURI', $theme_uri );

define( 'THEMEAUTHORURI', $author_uri );



define( 'BACKUPS', 'backups' );



/**

 * Required action filters

 *

 * @uses add_action()

 *

 * @since 1.0.0

 */

add_action( 'admin_init', 'optionsframework_admin_init' );

add_action( 'admin_menu', 'optionsframework_add_admin' );



/**

 * Required Files

 *

 * @since 1.0.0

 */

require_once K2T_FRAMEWORK_PATH . 'inc/fn.theme.php';



// SMOF Theme option



require_once K2T_FRAMEWORK_PATH . 'smof/functions.filters.php';				

require_once K2T_FRAMEWORK_PATH . 'smof/functions.interface.php';

require_once K2T_FRAMEWORK_PATH . 'smof/class.options_machine.php';			

require_once K2T_FRAMEWORK_PATH . 'smof/functions.options.php';

require_once K2T_FRAMEWORK_PATH . 'inc/class.skstore_welcome.php'; 	// SK wellcome

require_once K2T_FRAMEWORK_PATH . 'inc/sample_data.php'; 				// SK wellcome

