<?php
add_action( 'init', 'of_options' );

if ( ! function_exists( 'of_options' ) ) {
	function of_options() {

		/*-----------------------------------------------------------------------------------*/
		/* The Options Array */
		/*-----------------------------------------------------------------------------------*/

		// Set the Options Array
		global $of_options, $smof_data;
		$of_options = array();

		$patterns_path = get_stylesheet_directory() . '/assets/img/patterns/light/';
		$patterns_url  = get_template_directory_uri() . '/assets/img/patterns/light/';
		$light_pattern_arr = array( '' => esc_html__( 'None', 'skstore' ) );
		if ( is_dir( $patterns_path ) ) {
			if ( $patterns_dir = opendir( $patterns_path ) ) {
				while ( ( $patterns_file = readdir( $patterns_dir ) ) !== false ) {
					if ( ( stristr( $patterns_file, '.png' ) !== false || stristr( $patterns_file, '.jpg' ) !== false || stristr( $patterns_file, '.gif' ) !== false ) && stristr( $patterns_file , '2X' ) === false ) {
						$light_pattern_arr[ $patterns_url . $patterns_file ] = $patterns_file;
					}
				}
			}
		}
		asort( $light_pattern_arr );

		$patterns_path = get_stylesheet_directory() . '/assets/img/patterns/dark/';
		$patterns_url = get_template_directory_uri() . '/assets/img/patterns/dark/';
		$dark_pattern_arr = array( '' => esc_html__( 'None', 'skstore' ) );
		if ( is_dir( $patterns_path ) ) {
			if ( $patterns_dir = opendir( $patterns_path ) ) {
				while ( ( $patterns_file = readdir( $patterns_dir ) ) !== false ) {
					if ( ( stristr( $patterns_file, '.png' ) !== false || stristr( $patterns_file, '.jpg' ) !== false || stristr( $patterns_file, '.gif' ) !== false ) && stristr( $patterns_file , '2X' ) === false ) {
						$dark_pattern_arr[ $patterns_url . $patterns_file ] = $patterns_file;
					}
				}
			}
		}
		asort( $dark_pattern_arr );

		// Get all menu
		$total_menu = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
		$total_menu_arr = array( '' => esc_html__( 'None', 'skstore' ) );
		if ( count( $total_menu ) > 0 ) {
			foreach ( $total_menu as $menu ) {
				$total_menu_arr[$menu->term_id] = $menu->name;
			}
		}

		// Get all sidebar
		$sidebars = array();
		if ( count( array ( $GLOBALS['wp_registered_sidebars'] > 0 ) ) ){
			foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {

				$sidebars[$sidebar['id']] = $sidebar['name'];
			}
		}

		/*-----------------------------------------------------------------------------------*/
		/* General */
		/*-----------------------------------------------------------------------------------*/
		
		$of_options[] = array( 'name' => esc_html__( 'General', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-cog" aria-hidden="true"></i>'
		);

		$of_options[] = array( 'name' => esc_html__( 'General', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'General', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide breadcrumb', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'breadcrumb',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide page loader', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'pageloader',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'API Key', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => 'key_map',
			'desc' => esc_html__( 'Please enter Google Map API Key for Contact page', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Logo For Default Login Page', 'skstore' ),
			'type' => 'media',
			'id'   => 'login_logo',
			'std'  => get_template_directory_uri() . '/assets/img/logo.png',
			'desc' => esc_html__( 'The logo size in our demo is 105x80px. Please use jpg, jpeg, png or gif image for best performance.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Sidebar width', 'skstore' ),
			'type' => 'sliderui',
			'id'   => 'sidebar_width',
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
			'std'  => 33,
			'desc' => esc_html__( 'Unit: %', 'skstore' ),
		);
		$of_options[] = array( 'name' => esc_html__( 'Header Code', 'skstore' ),
			'type' => 'textarea',
			'std'  => '',
			'id'   => 'header_code',
			'desc' => esc_html__( 'You can load Google fonts here.', 'skstore' ),
			'is_js_editor' => '1'
		);

		$of_options[] = array( 'name' => esc_html__( 'Footer Code', 'skstore' ),
			'type' => 'textarea',
			'std'  => '',
			'id'   => 'footer_code',
			'desc' => esc_html__( 'You can fill Google Analytics tracking code or something here.', 'skstore' ),
			'is_js_editor' => '1'
		);

		$of_options[] = array( 'name' => esc_html__( 'Custom CSS', 'skstore' ),
			'type' => 'textarea',
			'std'  => '',
			'id'   => 'custom_css',
			'desc' => esc_html__( 'If you know a little about CSS, you can write your custom CSS here. Do not edit CSS files (it will be lost when you update this theme).', 'skstore' ),
			'is_css_editor' => '1'
		);

		/* Icons */
		$of_options[] = array( 'name' => esc_html__( 'Icons', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Icons', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Favicon', 'skstore' ),
			'type' => 'media',
			'id'   => 'favicon',
			'std'  => get_template_directory_uri() . '/assets/img/icons/favicon.png',
			'desc' => esc_html__( 'Favicon is a small icon image at the topbar of your browser. Should be 16x16px or 32x32px image (png, ico...)', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'IPhone icon (57x57px)', 'skstore' ),
			'type' => 'media',
			'id'   => 'apple-iphone-icon',
			'std'  => get_template_directory_uri() . '/assets/img/icons/iphone.png',
			'desc' => esc_html__( 'Similar to the Favicon, the <strong> iPhone icon</strong> is a file used for a web page icon on the  iPhone. When someone bookmarks your web page or adds your web page to their home screen, this icon is used. If this file is not found, these  products will use the screen shot of the web page, which often looks like no more than a white square.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'IPhone retina icon (114x114px)', 'skstore' ),
			'type' => 'media',
			'id'   => 'apple-iphone-retina-icon',
			'std'  => get_template_directory_uri() . '/assets/img/icons/iphone@2x.png',
			'desc' => esc_html__( 'The same as  iPhone icon but for Retina iPhone.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'IPad icon (72x72px)', 'skstore' ),
			'type' => 'media',
			'id'   => 'apple-ipad-icon',
			'std'  => get_template_directory_uri() . '/assets/img/icons/ipad.png',
			'desc' => esc_html__( 'The same as  iPhone icon but for iPad.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'IPad Retina icon (144x144px)', 'skstore' ),
			'type' => 'media',
			'id'   => 'apple-ipad-retina-icon',
			'std'  => get_template_directory_uri() . '/assets/img/icons/ipad@2x.png',
			'desc' => esc_html__( 'The same as  iPhone icon but for Retina iPad.', 'skstore' ),
		);

		/*-----------------------------------------------------------------------------------*/
		/* Header
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Header', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-header" aria-hidden="true"></i>',
		);
		/* Header */
		$of_options[] = array( 'name' => esc_html__( 'Header Backup Options', 'skstore' ),
			'type' => 'advance_importer',
			'std'  => esc_html__( 'Header Backup Options', 'skstore' ),
			'desc' => 'Import or Export Header layouts for all Header sections',
			'id' => 'header-advance-import',
			'advance_importer' => array( 'sticky-menu' , 'vertical-menu', 'fixed-header' , 'use-top-header' , 'header_section_1' , 'use-mid-header' , 'header_section_2' , 'use-bot-header' , 'header_section_3' )
		);
		/* Header */
		$of_options[] = array( 'name' => esc_html__( 'Header Settings', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Header Settings', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Sticky menu?', 'skstore' ),
			'type' => 'select',
			'options' => array(
				''        => esc_html__( 'None', 'skstore' ),
				'sticky_top' => esc_html__( 'Sticky menu on top header', 'skstore' ),
				'sticky_mid' => esc_html__( 'Sticky menu on middle header', 'skstore' ),
				'sticky_bot' => esc_html__( 'Sticky menu on bottom header', 'skstore' ),
			),
			'std'  => '',
			'id'   => 'sticky-menu',
			'desc' => esc_html__( 'Enable this setting so that the header section and menus inlcuded in the header are sticky', 'skstore' ),

		);

		$of_options[] = array( 'name' => esc_html__( 'Header Layouts', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Header Layouts', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Fixed header?', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'fixed-header',
			'desc' => esc_html__( 'If the setting is enabled, the body section will be displayed under the header. If the setting is disabled, the body section will be displayed above the header. In the 2nd case, you can make the header transparent to create a very nice style', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Display social on vertical menu?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'vertical-social',
		);

		$of_options[] = array( 'name' => esc_html__( 'Top Header Section', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'use-top-header',
			'desc' => esc_html__( 'Show or hide top header layout.', 'skstore' ),
			'k2t_logictic' => array(
				'0' => array( ),
				'1' => array( 'header_section_1' ),
			),			
		);

		$of_options[] = array(
			'type' => 'k2t_header_option',
			'std'  => '',
			'id'   => 'header_section_1',
			'desc' => '',
			
		);

		$of_options[] = array( 'name' => esc_html__( 'Middle Header Section', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'use-mid-header',
			'desc' => esc_html__( 'Show or hide middle header layout.', 'skstore' ),
			'k2t_logictic' => array(
				'0' => array( ),
				'1' => array( 'header_section_2' ),

			),		
		);

		$of_options[] = array(
			'type' => 'k2t_header_option',
			'std'  => '{"name":"header_section_2","setting":{"bg_image":"","bg_color":"","opacity":"","fixed_abs":"fixed","custom_css":""},"columns_num":2,"htmlData":"","columns":[{"id":1,"percent":"2","value":[{"id":"1425696862388","type":"logo","value":{"custom_class":"","custom_id":""}}]},{"id":2,"value":[{"id":"1434273437540","type":"custom_menu","value":{"menu_id":"QWxsIFBhZ2Vz","custom_class":"","custom_id":""}}],"percent":"10"}]}',
			'id'   => 'header_section_2',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Bottom Header Section', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'use-bot-header',
			'desc' => esc_html__( 'Show or hide middle header layout.', 'skstore' ),
			'k2t_logictic' => array(
				'0' => array( ),
				'1' => array( 'header_section_3' ),
			),		
		);

		$of_options[] = array(
			'type' => 'k2t_header_option',
			'std'  => '',
			'id'   => 'header_section_3',
			'desc' => '',
		);

		/* Logo */
		$of_options[] = array( 'name' => esc_html__( 'Logo', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Logo', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Use text logo', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'use-text-logo',
			'desc' => esc_html__( 'Turn it ON if you want to use text logo instead of image logo.', 'skstore' ),
			'logicstic' => true,
		);

		$of_options[] = array( 'name' => esc_html__( 'Text logo', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => 'text-logo',
			'desc' => '',
			'conditional_logic' => array(
				'field'    => 'use-text-logo',
				'value'    => 'switch-1',
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Logo', 'skstore' ),
			'type' => 'media',
			'id'   => 'logo',
			'std'  => get_template_directory_uri() . '/assets/img/logo.png',
			'desc' => esc_html__( 'The logo size in our demo is 105x80px. Please use jpg, jpeg, png or gif image for best performance.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Retina logo', 'skstore' ),
			'type' => 'media',
			'id'   => 'retina-logo',
			'std'  => get_template_directory_uri() . '/assets/img/logo@2x.png',
			'desc' => esc_html__( '2x times your logo dimension.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Logo margin top (px)', 'skstore' ),
			'type' => 'sliderui',
			'id'   => 'logo-margin-top',
			'min'  => 0,
			'max'  => 200,
			'step' => 1,
			'std'  => 0,
		);

		$of_options[] = array( 'name' => esc_html__( 'Logo margin right (px)', 'skstore' ),
			'type' => 'sliderui',
			'id'   => 'logo-margin-right',
			'min'  => 0,
			'max'  => 200,
			'step' => 1,
			'std'  => 0,
		);

		$of_options[] = array( 'name' => esc_html__( 'Logo margin bottom (px)', 'skstore' ),
			'type' => 'sliderui',
			'id'   => 'logo-margin-bottom',
			'min'  => 0,
			'max'  => 200,
			'step' => 1,
			'std'  => 0,
		);

		$of_options[] = array( 'name' => esc_html__( 'Logo margin left (px)', 'skstore' ),
			'type' => 'sliderui',
			'id'   => 'logo-margin-left',
			'min'  => 0,
			'max'  => 200,
			'step' => 1,
			'std'  => 0,
		);

		/*-----------------------------------------------------------------------------------*/
		/* Footer
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Footer', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-minus" aria-hidden="true"></i>'
		);

		/* logo footer */
		$of_options[] = array( 'name' => esc_html__( 'Logo Footer', 'skstore' ),
			'type' => 'media',
			'id'   => 'footer-logo-image',
			'std'  => get_template_directory_uri() . '/assets/img/logo-footer.png',
			'desc' => esc_html__( 'The logo size in our demo is 105x80px. Please use jpg, jpeg, png or gif image for best performance.', 'skstore' ),
		);

		$of_options[] = array( 'name'   => __( 'Show/Hide "Go to top"', 'skstore' ),
			'id'   => 'footer-gototop',
			'type' => 'switch',
			'std'  => true,
		);


		/* Top Footer */
		$of_options[] = array( 'name' => esc_html__( 'Top Footer Setting', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Top Footer', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Enable Top Footer Widget', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'top-footer-enable',
			'desc' => esc_html__( 'Enable Sidebar Top Footer.', 'skstore' ),
			/*'k2t_logictic' => array(
				'0' => array( ),
				'1' => array( 'header_section_2' ),

			),*/		
		);
		


		/* Widget area */
		$of_options[] = array( 'name' => esc_html__( 'Widget area', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Main Footer', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Sidebars layout', 'skstore' ),
			'type' => 'select',
			'id'   => 'bottom-sidebars-layout',
			'options' => array(
				'layout-1' => esc_html__( '1/4 1/4 1/4 1/4', 'skstore' ),
				'layout-2' => esc_html__( '1/3 1/3 1/3', 'skstore' ),
				'layout-3' => esc_html__( '1/2 1/4 1/4', 'skstore' ),
				'layout-4' => esc_html__( '1/4 1/2 1/4', 'skstore' ),
				'layout-5' => esc_html__( '1/4 1/4 1/2', 'skstore' ),
				'layout-6' => esc_html__( '1/2 1/2', 'skstore' ),
				'layout-7' => esc_html__( '1', 'skstore' ),
			),
			'std'  => 'layout-1',
			'desc' => esc_html__( 'Select sidebars layout', 'skstore' ),
		);

		$of_options[] = array( 'name'   => esc_html__( 'Background color', 'skstore' ),
			'id'   => 'bottom-background-color',
			'type' => 'color',
			'std'  => '#1b1b1b',
		);

		$of_options[] = array( 'name'   => esc_html__( 'Background image', 'skstore' ),
			'id'   => 'bottom-background-image',
			'type' => 'upload',
			'std'  => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background position?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''    => esc_html__( 'None', 'skstore' ),
				'left top'      => esc_html__( 'Left Top', 'skstore' ),
				'left center'   => esc_html__( 'Left Center', 'skstore' ),
				'left bottom'   => esc_html__( 'Left Bottom', 'skstore' ),
				'right top'     => esc_html__( 'Right Top', 'skstore' ),
				'right center'  => esc_html__( 'Right Center', 'skstore' ),
				'right bottom'  => esc_html__( 'Right Bottom', 'skstore' ),
				'center top'    => esc_html__( 'Center Top', 'skstore' ),
				'center center' => esc_html__( 'Center Center', 'skstore' ),
				'center bottom' => esc_html__( 'Center Bottom', 'skstore' ),
			),
			'std'  => '',
			'id'   => 'bottom-background-position',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background repeat?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''    => esc_html__( 'None', 'skstore' ),
				'no-repeat' => esc_html__( 'No repeat', 'skstore' ),
				'repeat'    => esc_html__( 'Repeat', 'skstore' ),
				'repeat-x'  => esc_html__( 'Repeat X', 'skstore' ),
				'repeat-y'  => esc_html__( 'Repeat Y', 'skstore' ),
			),
			'std'  => '',
			'id'  => 'bottom-background-repeat',
			'desc'  => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background size?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''        => esc_html__( 'None', 'skstore' ),
				'auto'    => esc_html__( 'Auto', 'skstore' ),
				'cover'   => esc_html__( 'Cover', 'skstore' ),
				'contain' => esc_html__( 'Contain', 'skstore' ),
			),
			'std'  => '',
			'id'   => 'bottom-background-size',
			'desc' => '',
		);

		/* Footer bottom */
		$of_options[] = array( 'name' => esc_html__( 'Footer', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Bottom Footer', 'skstore' ),
		);

		$of_options[] = array( 'name'   => esc_html__( 'Background color', 'skstore' ),
			'id'   => 'footer-background-color',
			'type' => 'color',
			'std'  => '#fff',
		);

		$of_options[] = array( 'name'   => esc_html__( 'Background image', 'skstore' ),
			'id'   => 'footer-background-image',
			'type' => 'upload',
			'std'  => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background position?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''    => esc_html__( 'None', 'skstore' ),
				'left top'      => esc_html__( 'Left Top', 'skstore' ),
				'left center'   => esc_html__( 'Left Center', 'skstore' ),
				'left bottom'   => esc_html__( 'Left Bottom', 'skstore' ),
				'right top'     => esc_html__( 'Right Top', 'skstore' ),
				'right center'  => esc_html__( 'Right Center', 'skstore' ),
				'right bottom'  => esc_html__( 'Right Bottom', 'skstore' ),
				'center top'    => esc_html__( 'Center Top', 'skstore' ),
				'center center' => esc_html__( 'Center Center', 'skstore' ),
				'center bottom' => esc_html__( 'Center Bottom', 'skstore' ),
			),
			'std'  => '',
			'id'   => 'footer-background-position',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background repeat?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''    => esc_html__( 'None', 'skstore' ),
				'no-repeat' => esc_html__( 'No repeat', 'skstore' ),
				'repeat'    => esc_html__( 'Repeat', 'skstore' ),
				'repeat-x'  => esc_html__( 'Repeat X', 'skstore' ),
				'repeat-y'  => esc_html__( 'Repeat Y', 'skstore' ),
			),
			'std'  => '',
			'id'  => 'footer-background-repeat',
			'desc'  => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background size?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''        => esc_html__( 'None', 'skstore' ),
				'auto'    => esc_html__( 'Auto', 'skstore' ),
				'cover'   => esc_html__( 'Cover', 'skstore' ),
				'contain' => esc_html__( 'Contain', 'skstore' ),
			),
			'std'  => '',
			'id'   => 'footer-background-size',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Footer copyright text', 'skstore' ),
			'type' => 'textarea',
			'id'   => 'footer-copyright-text',
			'std'  => esc_html__( '<p>sk - Wordpress Theme 2016 by <a href="#">Sunrisetheme.com</a></p>
						<p>All stock photos used on this sk demo site are only for demo purposes and not included in the template package.</p>', 'skstore' ),
			'desc' => esc_html__( 'HTML and shortcodes are allowed.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide social icon', 'skstore' ),
			'id'   => 'footer-social',
			'type' => 'switch',
			'std'  => true,
		);

		$of_options[] = array( 'name' => esc_html__( 'Payment method', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Payment method', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide payment method', 'skstore' ),
			'id'   => 'footer-payment-method',
			'type' => 'switch',
			'std'  => true,
		);

		$of_options[] = array( 'name' => esc_html__( 'Visa', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => 'Visa',
		);

		$of_options[] = array( 'name' => esc_html__( 'Master Card', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => 'MasterCard',
		);
		$of_options[] = array( 'name' => esc_html__( 'Paypal', 'skstore' ),
			'type' => 'text',
			'id'   => 'Paypal',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Western Union', 'skstore' ),
			'type' => 'text',
			'id'   => 'WesternUnion',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( '2CO', 'skstore' ),
			'type' => 'text',
			'id'   => '2co',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'ACH', 'skstore' ),
			'type' => 'text',
			'id'   => 'ach',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'American Express', 'skstore' ),
			'type' => 'text',
			'id'   => 'american-express',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Cirrus', 'skstore' ),
			'type' => 'text',
			'id'   => 'cirrus',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Delta', 'skstore' ),
			'type' => 'text',
			'id'   => 'delta',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Discover', 'skstore' ),
			'type' => 'text',
			'id'   => 'discover',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'JCB', 'skstore' ),
			'type' => 'text',
			'id'   => 'jcb',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Lovicons', 'skstore' ),
			'type' => 'text',
			'id'   => 'lovicons',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Maestro', 'skstore' ),
			'type' => 'text',
			'id'   => 'maestro',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Moneybookers', 'skstore' ),
			'type' => 'text',
			'id'   => 'moneybookers',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Solo', 'skstore' ),
			'type' => 'text',
			'id'   => 'solo',
			'std'  => '',
		);
		$of_options[] = array( 'name' => esc_html__( 'Switch', 'skstore' ),
			'type' => 'text',
			'id'   => 'switch',
			'std'  => '',
		);


		/*-----------------------------------------------------------------------------------*/
		/* Offcanvas sidebar
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Offcanvas sidebar', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-navicon" aria-hidden="true"></i>'
		);

		$of_options[] = array( 'name'   => esc_html__( 'Show/Hide Offcanvas sidebar', 'skstore' ),
			'id'   => 'offcanvas-turnon',
			'type' => 'switch',
			'std'  => true,
		);

		$of_options[] = array( 'name'   => esc_html__( 'Body swipe', 'skstore' ),
			'id'   => 'offcanvas-swipe',
			'type' => 'switch',
			'std'  => true,
		);

		$of_options[] = array( 'name' => esc_html__( 'Offcanvas sidebar position', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				'right'    => esc_html__( 'Right', 'skstore' ),
				'left'      => esc_html__( 'Left', 'skstore' ),
			),
			'std'  => '',
			'id'   => 'offcanvas-sidebar-position',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Shown sidebar?', 'skstore' ),
			'type' => 'select',
			'options' => $sidebars,
			'id' => 'offcanvas-sidebar',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background setting', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Background setting', 'skstore' ),
		);

		$of_options[] = array( 'name'   => esc_html__( 'Offcanvas sidebar background image', 'skstore' ),
			'id'   => 'offcanvas-sidebar-background-image',
			'type' => 'upload',
			'std'  => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Offcanvas sidebar background position?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''    => esc_html__( 'None', 'skstore' ),
				'left top'      => esc_html__( 'Left Top', 'skstore' ),
				'left center'   => esc_html__( 'Left Center', 'skstore' ),
				'left bottom'   => esc_html__( 'Left Bottom', 'skstore' ),
				'right top'     => esc_html__( 'Right Top', 'skstore' ),
				'right center'  => esc_html__( 'Right Center', 'skstore' ),
				'right bottom'  => esc_html__( 'Right Bottom', 'skstore' ),
				'center top'    => esc_html__( 'Center Top', 'skstore' ),
				'center center' => esc_html__( 'Center Center', 'skstore' ),
				'center bottom' => esc_html__( 'Center Bottom', 'skstore' ),
			),
			'std'  => '',
			'id'   => 'offcanvas-sidebar-background-position',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Offcanvas sidebar background repeat?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''    => esc_html__( 'None', 'skstore' ),
				'no-repeat' => esc_html__( 'No repeat', 'skstore' ),
				'repeat'    => esc_html__( 'Repeat', 'skstore' ),
				'repeat-x'  => esc_html__( 'Repeat X', 'skstore' ),
				'repeat-y'  => esc_html__( 'Repeat Y', 'skstore' ),
			),
			'std'  => '',
			'id'  => 'offcanvas-sidebar-background-repeat',
			'desc'  => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Offcanvas sidebar background size?', 'skstore' ),
			'type'    => 'select',
			'options' => array(
				''        => esc_html__( 'None', 'skstore' ),
				'auto'    => esc_html__( 'Auto', 'skstore' ),
				'cover'   => esc_html__( 'Cover', 'skstore' ),
				'contain' => esc_html__( 'Contain', 'skstore' ),
			),
			'std'  => '',
			'id'   => 'offcanvas-sidebar-background-size',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Offcanvas sidebar background color', 'skstore' ),
			'type' => 'color',
			'id' => 'offcanvas-sidebar-background-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Offcanvas sidebar text color', 'skstore' ),
			'type' => 'color',
			'id' => 'offcanvas-sidebar-text-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Offcanvas sidebar custom css', 'skstore' ),
			'type' => 'textarea',
			'std'  => '',
			'id'   => 'offcanvas-sidebar-custom-css',
		);

		/*-----------------------------------------------------------------------------------*/
		/* Layout
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Layout', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-th" aria-hidden="true"></i>'
		);
		/* Layout */
		$of_options[] = array( 'name' => esc_html__( 'Layout', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Layout', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Content Width (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 1170,
			'min'  => 940,
			'max'  => 1200,
			'step' => 10,
			'id'   => 'use-content-width',
			'desc' => esc_html__( 'You can choose content width in the range from 940px to 1200px.', 'skstore' ),
		);

		/* Titlebar */
		$of_options[] = array( 'name' => esc_html__( 'Titlebar', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Titlebar', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar title font size', 'skstore' ),
			'type' => 'text',
			'std'  => '30',
			'id'   => 'titlebar-title-size',
			'desc' => esc_html__( 'Unit: px.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar title color', 'skstore' ),
			'type' => 'color',
			'std'  => '#fff',
			'id'   => 'titlebar-title-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Top padding', 'skstore' ),
			'type' => 'text',
			'std'  => '100px',
			'id'   => 'padding-top',
			'desc' => esc_html__( 'Unit: px. Eg: 10px;', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Bottom padding', 'skstore' ),
			'type' => 'text',
			'std'  => '100px',
			'id'   => 'padding-bottom',
			'desc' => esc_html__( 'Unit: px. Eg: 10px;', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Background image', 'skstore' ),
			'type' => 'media',
			'std'  => get_template_directory_uri() . '/assets/img/titlebar-blog.jpg',
			'id'   => 'background-image',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background color', 'skstore' ),
			'type' => 'color',
			'std'  => '',
			'id'   => 'background-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background position', 'skstore' ),
			'type' => 'select',
			'std'  => 'left',
			'options' => array(
				'left top'      => esc_html__( 'Left Top', 'skstore' ),
				'left center'   => esc_html__( 'Left Center', 'skstore' ),
				'left bottom'   => esc_html__( 'Left Bottom', 'skstore' ),
				'right top'     => esc_html__( 'Right Top', 'skstore' ),
				'right center'  => esc_html__( 'Right Center', 'skstore' ),
				'right bottom'  => esc_html__( 'Right Bottom', 'skstore' ),
				'center top'    => esc_html__( 'Center Top', 'skstore' ),
				'center center' => esc_html__( 'Center Center', 'skstore' ),
				'center bottom' => esc_html__( 'Center Bottom', 'skstore' ),
			),
			'id' => 'background-position',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background repeat', 'skstore' ),
			'type' => 'select',
			'std'  => 'repeat',
			'options' => array(
				'no-repeat' => esc_html__( 'No Repeat', 'skstore' ),
				'repeat'    => esc_html__( 'Repeat', 'skstore' ),
				'repeat-x'  => esc_html__( 'Repeat X', 'skstore' ),
				'repeat-y'  => esc_html__( 'Repeat Y', 'skstore' ),
			),
			'id' => 'background-repeat',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background parallax', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'background-parallax',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar color', 'skstore' ),
			'type' => 'color',
			'std'  => '',
			'id'   => 'titlebar-title-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar shadow opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 5,
			'step' => 1,
			'id'   => 'titlebar-shadow-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar overlay opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 0,
			'step' => 1,
			'id'   => 'titlebar-overlay-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar clipmask opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 0,
			'step' => 1,
			'id'   => 'titlebar-clipmask-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar custom content', 'skstore' ),
			'type' => 'textarea',
			'std'  => '',
			'id'   => 'titlebar-custom-content',
		);

		/*-----------------------------------------------------------------------------------*/
		/* Styling
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Style', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-pie-chart" aria-hidden="true"></i>'
		);


		$of_options[] = array( 'name' => esc_html__( 'Primary Color', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Primary Color', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Primary color', 'skstore' ),
			'type' => 'color',
			'std'  => '#ff6600',
			'id'   => 'primary-color',
			'desc' => esc_html__( 'Primary color is the main color of site.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Background color', 'skstore' ),
			'type' => 'color',
			'std'  => '',
			'id'   => 'main-background-color',
			'desc' => esc_html__( '', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Heading color', 'skstore' ),
			'type' => 'color',
			'std'  => '#252525',
			'id'   => 'heading-color',
			'desc' => esc_html__( '', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Text color', 'skstore' ),
			'type' => 'color',
			'std'  => '#959595',
			'id'   => 'text-color',
			'desc' => esc_html__( '', 'skstore' ),
		);
		
		$of_options[] = array( 'name' => esc_html__( 'Links', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Links', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Link color', 'skstore' ),
			'type' => 'color',
			'std'  => '#727272',
			'id'   => 'link-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Link hover color', 'skstore' ),
			'type' => 'color',
			'std'  => '#ff6600',
			'id'   => 'link-hover-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Menu colors', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Menu colors', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Main menu color', 'skstore' ),
			'type' => 'color',
			'std'  => '#2a2a2a',
			'id'   => 'main-menu-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Sub menu color', 'skstore' ),
			'type' => 'color',
			'std'  => '#2a2a2a',
			'id'   => 'sub-menu-color',
		);


		/*-----------------------------------------------------------------------------------*/
		/* Typography
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Typography', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-text-height" aria-hidden="true"></i>'
		);

		$of_options[] = array( 'name' => esc_html__( 'Font family', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Font family', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Body font', 'skstore' ),
			'desc' => esc_html__( 'You can choose a normal font or Google font.', 'skstore' ),
			'id'   => 'body-font',
			'std'  => 'PT Serif, sans-serif',
			'type' => 'select_google_font',
			'preview'  => array(
				'text' => 'This is the preview!', //this is the text from preview box
				'size' => '30px' //this is the text size from preview box
			),
			'options' => k2t_fonts_array(),
		);

		$of_options[] = array( 'name' => esc_html__( 'Heading font', 'skstore' ),
			'desc' => esc_html__( 'You can choose a normal font or Google font', 'skstore' ),
			'id'   => 'heading-font',
			'std'  => 'Montserrat',
			'type' => 'select_google_font',
			'preview' => array(
				'text' => 'This is the preview!', //this is the text from preview box
				'size' => '30px' //this is the text size from preview box
			),
			'options' => k2t_fonts_array(),
		);

		$of_options[] = array( 'name' => esc_html__( 'Navigation font', 'skstore' ),
			'desc' => esc_html__( 'You can choose a normal font or Google font', 'skstore' ),
			'id'   => 'mainnav-font',
			'std'  => 'Montserrat',
			'type' => 'select_google_font',
			'preview' => array(
				'text' => 'This is the preview!', //this is the text from preview box
				'size' => '30px' //this is the text size from preview box
			),
			'options' => k2t_fonts_array(),
		);

		$of_options[] = array( 'name' => esc_html__( 'General font size', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'General font size', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Body font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 16,
			'min'  => 8,
			'max'  => 28,
			'step' => 1,
			'id'   => 'body-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'Main navigation font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 14,
			'min'  => 9,
			'max'  => 24,
			'step' => 1,
			'id'   => 'mainnav-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'Submenu of Main navigation font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 14,
			'min'  => 9,
			'max'  => 24,
			'step' => 1,
			'id'   => 'submenu-mainnav-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar title font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 30,
			'min'  => 14,
			'max'  => 120,
			'step' => 1,
			'id'   => 'titlebar-title-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'Headings font size', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Headings font size', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'H1 font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 30,
			'min'  => 20,
			'max'  => 80,
			'step' => 1,
			'id'   => 'h1-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'H2 font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 20,
			'min'  => 16,
			'max'  => 64,
			'step' => 1,
			'id'   => 'h2-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'H3 font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 16,
			'min'  => 12,
			'max'  => 48,
			'step' => 1,
			'id'   => 'h3-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'H4 font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 14,
			'min'  => 8,
			'max'  => 32,
			'step' => 1,
			'id'   => 'h4-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'H5 font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 12,
			'min'  => 8,
			'max'  => 30,
			'step' => 1,
			'id'   => 'h5-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'H6 font size (px)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 10,
			'min'  => 8,
			'max'  => 30,
			'step' => 1,
			'id'   => 'h6-size',
		);

		$of_options[] = array( 'name' => esc_html__( 'Font type', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Font type', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Navigation text transform', 'skstore' ),
			'desc' => esc_html__( 'Select navigation text transform.', 'skstore' ),
			'type' => 'select',
			'id'   => 'mainnav-text-transform',
			'std'  => 'uppercase',
			'options' => array (
				'none'       => esc_html__( 'None', 'skstore' ),
				'capitalize' => esc_html__( 'Capitalize', 'skstore' ),
				'uppercase'  => esc_html__( 'Uppercase', 'skstore' ),
				'lowercase'  => esc_html__( 'Lowercase', 'skstore' ),
				'inherit'    => esc_html__( 'Inherit', 'skstore' ),
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Navigation font weight', 'skstore' ),
			'desc' => esc_html__( 'Select navigation font weight.', 'skstore' ),
			'type' => 'select',
			'id'   => 'mainnav-font-weight',
			'std'  => '300',
			'options' => array (
				'100' => esc_html__( '100', 'skstore' ),
				'200' => esc_html__( '200', 'skstore' ),
				'300' => esc_html__( '300', 'skstore' ),
				'400' => esc_html__( '400', 'skstore' ),
				'500' => esc_html__( '500', 'skstore' ),
				'600' => esc_html__( '600', 'skstore' ),
				'700' => esc_html__( '700', 'skstore' ),
				'800' => esc_html__( '800', 'skstore' ),
				'900' => esc_html__( '900', 'skstore' ),
			),
		);

		/*-----------------------------------------------------------------------------------*/
		/* Blog
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Blog', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-file-text" aria-hidden="true"></i>'
		);

		$of_options[] = array( 'name' => esc_html__( 'Blog layout', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Blog layout', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Blog style', 'skstore' ),
			'type' => 'select',
			'id'   => 'blog-style',
			'options' => array (
				'large'    => esc_html__( 'Large', 'skstore' ),
				'large-2'    => esc_html__( 'Large 2', 'skstore' ),
				'medium'   => esc_html__( 'Medium', 'skstore' ),
				'small'    => esc_html__( 'Small', 'skstore' ),
				'masonry'  => esc_html__( 'Masonry', 'skstore' ),
				'timeline' => esc_html__( 'Timeline', 'skstore' ),
			),
			'std'       => 'large',
			'desc'      => esc_html__( 'Select blog style.', 'skstore' ),
			'logicstic' => true,
		);

		$of_options[] = array( 'name' => esc_html__( 'Columns', 'skstore' ),
			'type'    => 'select',
			'id'      => 'blog-masonry-column',
			'options' => array (
				'column-2' => esc_html__( '2 Columns', 'skstore' ),
				'column-3' => esc_html__( '3 Columns', 'skstore' ),
				'column-4' => esc_html__( '4 Columns', 'skstore' ),
				'column-5' => esc_html__( '5 Columns', 'skstore' )
			),
			'std'  => 'column-3',
			'desc' => esc_html__( 'Select column for layout masonry.', 'skstore' ),
			'conditional_logic' => array(
				'field'    => 'blog-style',
				'value'    => 'masonry',
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Full width', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'blog-masonry-full-width',
			'desc' => esc_html__( 'Enable full width layout for masonry blog.', 'skstore' ),
			'conditional_logic' => array(
				'field'    => 'blog-style',
				'value'    => 'masonry',
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Blog sidebar position', 'skstore' ),
			'type'    => 'select',
			'id'      => 'blog-sidebar-position',
			'options' => array (
				'right_sidebar' => esc_html__( 'Right Sidebar', 'skstore' ),
				'left_sidebar'  => esc_html__( 'Left Sidebar', 'skstore' ),
				'two_sidebars'  => esc_html__( 'Two Sidebars', 'skstore' ),
				'no_sidebar'    => esc_html__( 'No Sidebar', 'skstore' )
			),
			'std'  => 'right_sidebar',
			'desc' => esc_html__( 'Select blog sidebar position.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Blog Options', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Blog Options', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Content or excerpt', 'skstore' ),
			'type'    => 'select',
			'id'      => 'blog-display',
			'options' => array (
				'excerpts' => esc_html__( 'Excerpt', 'skstore' ),
				'contents' => esc_html__( 'Content', 'skstore' ) ),
			'std'  => 'contents',
			'desc' => esc_html__( 'Select display post content or excerpt on the blog.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Excerpt length (words)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 120,
			'step' => 1,
			'min'  => 20,
			'max'  => 150,
			'id'   => 'excerpt-length',
		);

		$of_options[] = array( 'name' => esc_html__( 'Infinite Scroll', 'skstore' ),
			'type'    => 'select',
			'id'      => 'pagination-type',
			'options' => array (
				'pagination_number' => esc_html__( 'False', 'skstore' ),
				'pagination_ajax'   => esc_html__( 'True', 'skstore' )
			),
			'std' => 'pagination_number'
		);

		$of_options[] = array( 'name' => esc_html__( 'Blog timeline image', 'skstore' ),
			'type' => 'media',
			'std'  => '',
			'id'   => 'blog-timeline-image',
			'desc' => esc_html__( 'Only support Blog Timeline style', 'skstore' ),
			'conditional_logic' => array(
				'field'    => 'blog-style',
				'value'    => 'timeline',
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide categories filter', 'skstore' ),
			'type' => 'switch',
			'id'   => 'blog-categories-filter',
			'std'  => true
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide title link?', 'skstore' ),
			'type' => 'switch',
			'id'   => 'blog-post-link',
			'std'  => true
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide post date', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-date',
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide the number of comments', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-number-comment',
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide categories', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-categories',
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide author', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'blog-author',
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide "Reamore" link', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-readmore',
		);

		/* Titlebar */
		$of_options[] = array( 'name' => esc_html__( 'Titlebar', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Titlebar', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar underline', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-title-underline',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar title font size', 'skstore' ),
			'type' => 'text',
			'std'  => '72px',
			'id'   => 'blog-titlebar-title-size',
			'desc' => esc_html__( 'Unit: px.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar title color', 'skstore' ),
			'type' => 'color',
			'std'  => '#fff',
			'id'   => 'blog-titlebar-title-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Top padding', 'skstore' ),
			'type' => 'text',
			'std'  => '100px',
			'id'   => 'blog-padding-top',
			'desc' => esc_html__( 'Unit: px. Eg: 10px;', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Bottom padding', 'skstore' ),
			'type' => 'text',
			'std'  => '100px',
			'id'   => 'blog-padding-bottom',
			'desc' => esc_html__( 'Unit: px. Eg: 10px;', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Background image', 'skstore' ),
			'type' => 'media',
			'std'  => get_template_directory_uri() . '/assets/img/titlebar-blog.jpg',
			'id'   => 'blog-background-image',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background color', 'skstore' ),
			'type' => 'color',
			'std'  => '',
			'id'   => 'blog-background-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background position', 'skstore' ),
			'type' => 'select',
			'std'  => 'left',
			'options' => array(
				'left top'      => esc_html__( 'Left Top', 'skstore' ),
				'left center'   => esc_html__( 'Left Center', 'skstore' ),
				'left bottom'   => esc_html__( 'Left Bottom', 'skstore' ),
				'right top'     => esc_html__( 'Right Top', 'skstore' ),
				'right center'  => esc_html__( 'Right Center', 'skstore' ),
				'right bottom'  => esc_html__( 'Right Bottom', 'skstore' ),
				'center top'    => esc_html__( 'Center Top', 'skstore' ),
				'center center' => esc_html__( 'Center Center', 'skstore' ),
				'center bottom' => esc_html__( 'Center Bottom', 'skstore' ),
			),
			'id'   => 'blog-background-position',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background repeat', 'skstore' ),
			'type' => 'select',
			'std'  => 'repeat',
			'options' => array(
				'no-repeat' => esc_html__( 'No Repeat', 'skstore' ),
				'repeat'    => esc_html__( 'Repeat', 'skstore' ),
				'repeat-x'  => esc_html__( 'Repeat X', 'skstore' ),
				'repeat-y'  => esc_html__( 'Repeat Y', 'skstore' ),
			),
			'id'   => 'blog-background-repeat',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background parallax', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'blog-background-parallax',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar shadow opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 5,
			'step' => 1,
			'id'   => 'blog-titlebar-shadow-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar overlay opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 0,
			'step' => 1,
			'id'   => 'blog-titlebar-overlay-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar clipmask opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 0,
			'step' => 1,
			'id'   => 'blog-titlebar-clipmask-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar custom content', 'skstore' ),
			'type' => 'textarea',
			'std'  => '',
			'id'   => 'blog-titlebar-custom-content',
		);

		/* Social Impact */
		$of_options[] = array( 'name' => esc_html__( 'Social', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Social', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide social buttons', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-social',
			'desc' => esc_html__( 'Turn it OFF if you do not want to display social buttons', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Facebook?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-social-facebook',
		);

		$of_options[] = array( 'name' => esc_html__( 'Twitter?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-social-twitter',
		);

		$of_options[] = array( 'name' => esc_html__( 'Instagram?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-social-instagram',
		);

		$of_options[] = array( 'name' => esc_html__( 'Google+?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-social-google-plus',
		);

		$of_options[] = array( 'name' => esc_html__( 'Linkedin?', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'blog-social-linkedin',
		);

		$of_options[] = array( 'name' => esc_html__( 'Tumblr?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'blog-social-tumblr',
		);

		$of_options[] = array( 'name' => esc_html__( 'Email?', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'blog-social-email',
		);

		
		/*-----------------------------------------------------------------------------------*/
		/* Single
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Single', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-user" aria-hidden="true"></i>'
		);

		/* Featured Image */
		$of_options[] = array( 'name' => esc_html__( 'Single Post Layout', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Single Post Layout', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Single post layout', 'skstore' ),
			'type' => 'select',
			'id'   => 'single-layout',
			'options' => array (
				'right_sidebar' => esc_html__( 'Right Sidebar (default)', 'skstore' ),
				'left_sidebar'  => esc_html__( 'Left Sidebar', 'skstore' ),
				'no_sidebar'    => esc_html__( 'No Sidebar', 'skstore' ) ),
			'std'  => 'right_sidebar',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( 'Single custom sidebar', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => 'single-custom-sidebar',
			'desc'   => '',
		);

		/* Meta */
		$of_options[] = array( 'name' => esc_html__( 'Meta', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Meta', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide Author', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'single-author',
			'desc' => esc_html__( 'Turn OFF if you don\'t want to display author on single post', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide post date', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'single-post-date',
			'desc' => esc_html__( 'Turn OFF if you don\'t want to display post date on single post', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide Categories', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'single-categories',
			'desc' => esc_html__( 'Turn OFF if you don\'t want to display categories on single post', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide Commnet Number', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'single-comments',
			'desc' => esc_html__( 'Turn OFF if you don\'t want to display comment number on single post', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide Next / Previous links?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'single-nav',
			'desc' => esc_html__( 'Turn OFF if you don\'t want to display post navigation links on single post', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide authorbox', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'single-authorbox',
			'desc' => esc_html__( 'Turn OFF if you don\'t want to display author box on single post', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide comment form', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'single-commnet-form',
			'desc' => esc_html__( 'Turn OFF if you don\'t want to display comment form on single post', 'skstore' ),
		);


		/*-----------------------------------------------------------------------------------*/
		/* WooCommerce
		/*-----------------------------------------------------------------------------------*/

		$of_options[] = array( 'name' => esc_html__( 'WooCommerce title bar', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-shopping-cart" aria-hidden="true"></i>'
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar For single, archive product', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Titlebar', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar title font size', 'skstore' ),
			'type' => 'switch',
			'id'   => 'product-titlebar-show-hidden',
			'desc' => esc_html__( 'On/Off title bar', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar title font size', 'skstore' ),
			'type' => 'text',
			'std'  => '30',
			'id'   => 'product-titlebar-title-size',
			'desc' => esc_html__( 'Unit: px.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar title color', 'skstore' ),
			'type' => 'color',
			'std'  => '#fff',
			'id'   => 'product-titlebar-title-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Top padding', 'skstore' ),
			'type' => 'text',
			'std'  => '100px',
			'id'   => 'product-padding-top',
			'desc' => esc_html__( 'Unit: px. Eg: 10px;', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Bottom padding', 'skstore' ),
			'type' => 'text',
			'std'  => '100px',
			'id'   => 'product-padding-bottom',
			'desc' => esc_html__( 'Unit: px. Eg: 10px;', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Background image', 'skstore' ),
			'type' => 'media',
			'std'  => get_template_directory_uri() . '/assets/img/titlebar-blog.jpg',
			'id'   => 'product-background-image',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background color', 'skstore' ),
			'type' => 'color',
			'std'  => '',
			'id'   => 'product-background-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background position', 'skstore' ),
			'type' => 'select',
			'std'  => 'left',
			'options' => array(
				'left top'      => esc_html__( 'Left Top', 'skstore' ),
				'left center'   => esc_html__( 'Left Center', 'skstore' ),
				'left bottom'   => esc_html__( 'Left Bottom', 'skstore' ),
				'right top'     => esc_html__( 'Right Top', 'skstore' ),
				'right center'  => esc_html__( 'Right Center', 'skstore' ),
				'right bottom'  => esc_html__( 'Right Bottom', 'skstore' ),
				'center top'    => esc_html__( 'Center Top', 'skstore' ),
				'center center' => esc_html__( 'Center Center', 'skstore' ),
				'center bottom' => esc_html__( 'Center Bottom', 'skstore' ),
			),
			'id' => 'product-background-position',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background repeat', 'skstore' ),
			'type' => 'select',
			'std'  => 'repeat',
			'options' => array(
				'no-repeat' => esc_html__( 'No Repeat', 'skstore' ),
				'repeat'    => esc_html__( 'Repeat', 'skstore' ),
				'repeat-x'  => esc_html__( 'Repeat X', 'skstore' ),
				'repeat-y'  => esc_html__( 'Repeat Y', 'skstore' ),
			),
			'id' => 'product-background-repeat',
		);

		$of_options[] = array( 'name' => esc_html__( 'Background parallax', 'skstore' ),
			'type' => 'switch',
			'std'  => false,
			'id'   => 'product-background-parallax',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar color', 'skstore' ),
			'type' => 'color',
			'std'  => '',
			'id'   => 'product-titlebar-title-color',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar shadow opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 5,
			'step' => 1,
			'id'   => 'product-titlebar-shadow-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar overlay opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 0,
			'step' => 1,
			'id'   => 'product-titlebar-overlay-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar clipmask opacity', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 0,
			'max'  => 10,
			'std'  => 0,
			'step' => 1,
			'id'   => 'product-titlebar-clipmask-opacity',
		);

		$of_options[] = array( 'name' => esc_html__( 'Titlebar custom content', 'skstore' ),
			'type' => 'textarea',
			'std'  => '',
			'id'   => 'product-titlebar-custom-content',
		);

		/* product title bar */

		$of_options[] = array( 'name' => esc_html__( 'WooCommerce', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-shopping-cart" aria-hidden="true"></i>'
		);


		/* Shop Archive Page */
		$of_options[] = array( 'name' => esc_html__( 'Shop Banner', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Shop Banner', 'skstore' ),
		);

		// Banner Left
		$of_options[] = array( 'name' => esc_html__( 'Background Banner Left', 'skstore' ),
			'type' => 'media',
			'std'  => '',
			'id'   => 'banner-left',
		);

		/* URL Banner Left  */
		$of_options[] = array( 'name' => esc_html__( 'Related URL Banner Left', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => 'banner-related-left',
			'desc' => esc_html__( 'Enter Related URL.', 'skstore' ),
		);


		// Banner Right
		$of_options[] = array( 'name' => esc_html__( 'Background Banner Right', 'skstore' ),
			'type' => 'media',
			'std'  => '',
			'id'   => 'banner-right',
		);

		/* URL Banner Right  */
		$of_options[] = array( 'name' => esc_html__( 'Related URL Banner Right', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => 'banner-related-right',
			'desc' => esc_html__( 'Enter Related URL.', 'skstore' ),
		);


		/* Shop Archive Page */
		$of_options[] = array( 'name' => esc_html__( 'Shop Archive', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Shop Archive', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Shop Archive Template', 'skstore' ),
			'type' => 'select',
			'std'  => 'right_sidebar',
			'options' => array(
				'right_sidebar' => esc_html__( 'Right Sidebar', 'skstore' ),
				'left_sidebar'  => esc_html__( 'Left Sidebar', 'skstore' ),
				'no_sidebar'    => esc_html__( 'No Sidebar', 'skstore' ),
			),
			'id' => 'shop-template',
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide WooCommerce Breadcrumb', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'shop-breadcrumb',
		);

		$of_options[] = array( 'name' => esc_html__( 'Show "sorting"?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'shop-display-sorting',
		);
		
		$of_options[] = array( 'name' => esc_html__( 'Product Layout', 'skstore' ),
			'type' => 'select',
			'std'  => 'grid',
			'options' => array(
				'grid' => esc_html__( 'Grid Product', 'skstore' ),
				'list'  => esc_html__( 'List Product', 'skstore' ),
			),
			'id' => 'product-layout',
		);


		$of_options[] = array( 'name' => esc_html__( 'Show "result count"?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'shop-display-result-count',
		);

		$of_options[] = array( 'name' => esc_html__( 'Number of columns (default)', 'skstore' ),
			'type' => 'sliderui',
			'std'  => 3,
			'min'  => 3,
			'max'  => 4,
			'id'   => 'shop-products-column',
		);

		$of_options[] = array( 'name' => esc_html__( 'Number of products per page', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => 'shop-products-per-page',
			'desc' => esc_html__( 'Fill it -1 if you want to display all products.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Sale Tag Color', 'skstore' ),
			'type' => 'color',
			'std'  => '#ff6600',
			'id'   => 'onsale-color',
			'desc' => '',
		);

		/* Single Product */
		$of_options[] = array( 'name' => esc_html__( 'Single Product', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Single Product', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show Product Extra Option popup', 'skstore' ),
			'type' => 'switch',
			'desc' => esc_html__( 'You can change your popup content at Pages -> Product Extra Option' , 'skstore' ),
			'std'  => true,
			'id' => 'shop-product-option',
			'logicstic' => true,
		);

		$of_options[] = array( 'name' => esc_html__( 'Product Extra Option Label', 'skstore' ),
			'type' => 'text',
			'id'   => 'shop-product-option-label',
			'std'  => esc_html__( 'Size Guide' , 'skstore' ),
			'conditional_logic' => array(
				'field' => 'shop-product-option',
				'value' => 'switch-1',
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide share your products?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'shop-single-display-share-products',
			'std'  => esc_html__( 'Size Guide', 'skstore' )
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide related products?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'shop-single-display-related-products',
			'logicstic' => true,
		);

		$of_options[] = array( 'name' => esc_html__( 'Number of related products to show on desktop', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 2,
			'max'  => 5,
			'std'  => 4,
			'step' => 1,
			'id'   => 'shop-related-products-number',
			'conditional_logic' => array(
				'field' => 'shop-single-display-related-products',
				'value' => 'switch-1',
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Number of related products to show on tablets (<=768px)', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 1,
			'max'  => 3,
			'std'  => 2,
			'step' => 1,
			'id'   => 'shop-related-products-number-tablet',
			'conditional_logic' => array(
				'field' => 'shop-single-display-related-products',
				'value' => 'switch-1',
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Number of related products to show on mobile (<=478px)', 'skstore' ),
			'type' => 'sliderui',
			'min'  => 1,
			'max'  => 3,
			'std'  => 1,
			'step' => 1,
			'id'   => 'shop-related-products-number-mobile',
			'conditional_logic' => array(
				'field' => 'shop-single-display-related-products',
				'value' => 'switch-1',
			),
		);

		$of_options[] = array( 'name' => esc_html__( 'Custom footer for product detail', 'skstore' ),
			'type' => 'textarea',
			'id'   => 'product-custom-footer',
		);

		/* Social Impact */
		$of_options[] = array( 'name' => esc_html__( 'Social', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( 'Social', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Show/Hide social buttons', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'woo-social',
			'desc' => esc_html__( 'Turn it OFF if you do not want to display social buttons', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Facebook?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'woo-social-facebook',
		);

		$of_options[] = array( 'name' => esc_html__( 'Twitter?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'woo-social-twitter',
		);

		$of_options[] = array( 'name' => esc_html__( 'Google+?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'woo-social-google-plus',
		);

		$of_options[] = array( 'name' => esc_html__( 'Linkedin?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'woo-social-linkedin',
		);

		$of_options[] = array( 'name' => esc_html__( 'Tumblr?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'woo-social-tumblr',
		);

		$of_options[] = array( 'name' => esc_html__( 'Email?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'woo-social-email',
		);


		/*-----------------------------------------------------------------------------------*/
		/* 404 Page
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( '404 Page', 'skstore' ),
			'type' => 'heading',
			'icon' => '<i class="fa fa-frown-o" aria-hidden="true"></i>'
		);

		$of_options[] = array( 'name' => esc_html__( '404 page', 'skstore' ),
			'type' => 'info',
			'std'  => esc_html__( '404 page', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( '404 Title', 'skstore' ),
			'type' => 'text',
			'std'  => '',
			'id'   => '404-title',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( '404 Image', 'skstore' ),
			'type' => 'media',
			'std'  => get_template_directory_uri() . '/assets/img/404.png',
			'id'   => '404-image',
			'desc' => '',
		);

		$of_options[] = array( 'name' => esc_html__( '404 Custom Text', 'skstore' ),
			'type' => 'textarea',
			'id'   => '404-text',
			'std'  => 'Page not found',
			'desc' => esc_html__( 'The message you want to show when they got to 404 page. HTML is allowed.', 'skstore' ),
		);

		/*-----------------------------------------------------------------------------------*/
		/* Social Icons
		/*-----------------------------------------------------------------------------------*/
		$of_options[] = array( 'name' => esc_html__( 'Social', 'skstore' ),
			'type'  => 'heading',
			'icon'  => '<i class="fa fa-share-alt" aria-hidden="true"></i>'
		);

		$of_options[] = array( 'name' => esc_html__( 'Target', 'skstore' ),
			'type' => 'select',
			'std'  => '_blank',
			'options' => array(
				'_self'  => esc_html__( 'Same tab', 'skstore' ),
				'_blank' => esc_html__( 'New tab', 'skstore' ),
			),
			'id' => 'social-target',
		);

		$of_options[] = array( 'name' => esc_html__( 'Twitter username?', 'skstore' ),
			'type' => 'text',
			'std'  => 'sunrisetheme',
			'id'   => 'twitter-username',
			'desc' => esc_html__( 'Twitter username used for tweet share buttons.', 'skstore' ),
		);

		$of_options[] = array( 'name' => esc_html__( 'Icon title?', 'skstore' ),
			'type' => 'switch',
			'std'  => true,
			'id'   => 'social-title',
			'desc' => esc_html__( 'Turn it ON if you want to display social icon titles like Facebook, Google+, Twitter... when hover icons.', 'skstore' ),
		);


		foreach ( k2t_skstore_social_array() as $s => $c ):

			$of_options[] = array( 'name' => $c,
				'type' => 'text',
				'std'  => '',
				'id'   => 'social-' . $s,
			);

		endforeach;
		
		// /*-----------------------------------------------------------------------------------*/
		// /* One Click Install */
		// /*-----------------------------------------------------------------------------------*/
		 $of_options[] = array( 'name'   => esc_html__( 'One Click Install', 'skstore' ),
			'type'  => 'heading',
		 	'icon'  => '<i class="fa fa-clock-o" aria-hidden="true"></i>'
		 );
		 $of_options[] = array( 'name'   => esc_html__( 'Transfer Theme Options Data', 'skstore' ),
		 	'id'   => 'k2t_advance_backup',
		 	'std'  => '',
		 	'type' => 'k2t_advance_backup',
			
		);

		/*-----------------------------------------------------------------------------------*/
		/* Get data for sample data */
		/*-----------------------------------------------------------------------------------*/
		//$of_options[] = array(  'name'   => esc_html__( 'Sample theme options', 'skstore' ),
			//'id'   => 'get_theme_option_widget',
			//'std'  => '',
			//'type' => 'get_theme_option_widget',
		//);

	}//End function: of_options()
}//End chack if function exists: of_options()
?>
