<?php

/**

 * Theme functions for skstore

 *

 * Do not edit the core files.

 * Add any modifications necessary under a child theme.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



/*--------------------------------------------------------------

	Define Constants

--------------------------------------------------------------*/

define( 'K2T_THEME_PATH', get_template_directory() . '/' );

define( 'K2T_THEME_URL', get_template_directory_uri() . '/');

define( 'K2T_FRAMEWORK_PATH', K2T_THEME_PATH . 'framework/' );

define( 'K2T_FRAMEWORK_URL', K2T_THEME_URL . 'framework/' );

define( 'K2T_TEMPLATE_PATH', K2T_THEME_PATH . 'templates/' );

/*--------------------------------------------------------------

	Admin - Framework

--------------------------------------------------------------*/

require_once K2T_FRAMEWORK_PATH . '/index.php';

require_once K2T_FRAMEWORK_PATH . 'inc/k2timporter/import.php'; // Advance Importer



/*--------------------------------------------------------------

	sk Theme

--------------------------------------------------------------*/

require_once K2T_FRAMEWORK_PATH. '/extensions/k2ticon/k2ticon.php'; // add Icon Feature

require_once K2T_FRAMEWORK_PATH . '/extensions/widgets/widget-register.php'; // Adding widgets

require_once K2T_FRAMEWORK_PATH . '/inc/fn.hooks.php'; // skstore theme extra functions

/*--------------------------------------------------------------

	3rd-plugins

--------------------------------------------------------------*/

require_once K2T_FRAMEWORK_PATH . '/extensions/plugins/class-tgm-plugin-activation.php'; // Load TGM Plugin Activation library if not already loaded

require_once K2T_FRAMEWORK_PATH . '/extensions/plugins/aq-resizer.php'; // Integration aq resizer script

require_once K2T_FRAMEWORK_PATH . '/inc/acf-content.php'; // Adding advanced custom fields

require_once K2T_FRAMEWORK_PATH . '/inc/mega-menu/mega-menu-framework.php'; // Adding k2t mega menu

require_once K2T_FRAMEWORK_PATH . '/inc/mega-menu/mega-menus.php';

if ( class_exists( 'Woocommerce' ) ) {

	require_once K2T_FRAMEWORK_PATH . 'inc/func-woo.php'; // Integrated Woocommerce plugin

}



/*--------------------------------------------------------------

	Enqueue front-end script

--------------------------------------------------------------*/

if ( ! function_exists( 'k2t_skstore_front_end_enqueue_script' ) ) :

	function k2t_skstore_front_end_enqueue_script() {

		global $smof_data;



		// Load jquery easing.

		wp_enqueue_script( 'jquery-easing-script', K2T_THEME_URL . '/assets/js/vendor/jquery-easing.js', array(), '', true );



		// Load parallax library.

		wp_enqueue_script( 'jquery-stellar-script', K2T_THEME_URL . '/assets/js/vendor/jquery.stellar.min.js', array(), '', true );



		// Owl Carousel

		wp_enqueue_script( 'owlcarousel', K2T_THEME_URL . '/assets/js/vendor/owl.carousel.min.js', array( 'jquery' ), '', true );



		// Load infinite scroll library.

		wp_enqueue_script( 'infinitescroll-script', K2T_THEME_URL . '/assets/js/vendor/jquery.infinitescroll.min.js', array(), '', true );



		// Load infinite scroll library.

		wp_enqueue_script( 'jquery-imageloaded-script', K2T_THEME_URL . '/assets/js/vendor/jquery.imageloaded.min.js', array(), '', true );



		// Load zoom effect for title bar.

		if ( function_exists( 'get_field' ) && get_field( 'background_zoom', get_the_ID() ) ) {

			wp_enqueue_script( 'zoomeffects-script', K2T_THEME_URL . '/assets/js/vendor/zoom-effect.js', array(), '', true );

		}



		// Enqueue jquery waypoints

		wp_enqueue_script( 'jquery-waypoints', K2T_THEME_URL . '/assets/js/vendor/jquery.waypoints.min.js', array(), '', true );



		// Enqueue jquery isotope

		wp_enqueue_script( 'jquery-isotope', K2T_THEME_URL . '/assets/js/vendor/isotope.pkgd.min.js', array(), '', true );

		

		// Jquery Library: Imagesloaded

		wp_enqueue_script( 'jquery-imagesloaded', K2T_THEME_URL . '/assets/js/vendor/imagesloaded.pkgd.min.js', array( 'jquery' ), '', true );

	

		// Youtube background video

		wp_register_script( 'tubular', K2T_THEME_URL . '/assets/js/vendor/jquery.tubular.js', array(), '', true);



		// single-wc

		wp_enqueue_script( 'k2t-single-wc', K2T_THEME_URL . '/assets/js/vendor/k2t-single-wc.js', array(), '', true);

		wp_enqueue_style('fancyStyle', K2T_THEME_URL . '/assets/js/vendor/fancybox/jquery.fancybox.css');

		wp_enqueue_script('fancyScript', K2T_THEME_URL . '/assets/js/vendor/fancybox/jquery.fancybox.js', array('jquery'), '', true );



		// Load our custom javascript.

		$mainParams = array();

		wp_enqueue_script( 'skstore-main-script', K2T_THEME_URL . '/assets/js/main.js', array( 'jquery' ), '', true );

		if ( isset( $smof_data['offcanvas-swipe'] ) && $smof_data['offcanvas-swipe'] == "1") {

			$mainParams['offcanvas_turnon'] = $smof_data['offcanvas-turnon'];

		}

		if ( isset( $smof_data['sticky-menu'] ) ) {

			$mainParams['sticky_menu'] = $smof_data['sticky-menu'];

		}

		if ( isset( $smof_data['vertical-menu'] ) ) {

			$mainParams['vertical_menu'] = $smof_data['vertical-menu'];

		}

		if ( 'masonry' == $smof_data['blog-style'] ) {

			$mainParams['blog_style'] = $smof_data['blog-style'];

		}

		wp_localize_script( 'skstore-main-script', 'mainParams', $mainParams );

		

		// Adds the comment-reply JavaScript to the single post pages

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {

			wp_enqueue_script( 'comment-reply' );

		}



	}

	add_action( 'wp_enqueue_scripts', 'k2t_skstore_front_end_enqueue_script' );

endif;



/*--------------------------------------------------------------

	Enqueue front-end style

--------------------------------------------------------------*/

if ( ! function_exists( 'k2t_skstore_front_end_enqueue_style' ) ) :

	function k2t_skstore_front_end_enqueue_style() {

		global $wp_styles, $smof_data;

		

		// Load background slider

		wp_enqueue_style( 'cbpBGSlideshow', K2T_THEME_URL . '/assets/css/vendor/cbpBGSlideshow.css' );



		// Load font awesome for first active theme

		if ( ! function_exists( 'k2t_pre_process_shortcode' ) ) {

			wp_enqueue_style( 'font-awesome-style', K2T_THEME_URL . '/assets/css/vendor/font-awesome.min.css' );

			wp_enqueue_style( 'simple-line-icons', K2T_THEME_URL . '/assets/css/vendor/simple-line-icons.css' );

		}



		wp_enqueue_style( 'k2t-hamburgers', K2T_THEME_URL .'/assets/css/vendor/hamburgers.css' );



		// Owl Carousel

		wp_enqueue_style( 'owl-carousel', K2T_THEME_URL . 'assets/css/vendor/owl.css' );



		// Load our main stylesheet.

		wp_enqueue_style( 'skstore-main-style', K2T_THEME_URL . '/assets/css/main.css' );



		// Load responsive stylesheet.

		wp_enqueue_style( 'skstore-reponsive-style', K2T_THEME_URL . '/assets/css/responsive.css' );

	}

	add_action( 'wp_enqueue_scripts', 'k2t_skstore_front_end_enqueue_style' );

endif;



// Hooks on Back-end

if( is_admin() ){



	/*--------------------------------------------------------------

	Var for Script Backup

	--------------------------------------------------------------*/

	if ( ! function_exists( 'aslan_sample_import_add_admin_head' ) ) {

		function aslan_sample_import_add_admin_head() {

			echo '<scr' . 'ipt>';

			echo 'var home_url = "' . esc_url( site_url() ) . '";';

			echo 'var installing_proccess  = 0;';

			echo 'var cache_installing_url = "' . K2T_FRAMEWORK_URL . 'inc/k2timporter/tmp_backup/cache_proccess";';

			echo '</scr' . 'ipt>';

		}

		add_action( 'admin_head', 'aslan_sample_import_add_admin_head');

	}

}



/*--------------------------------------------------------------

	Deactive old plugin

--------------------------------------------------------------*/



add_filter('deprecated_constructor_trigger_error', '__return_false');

add_filter( 'wpcf7_support_html5_fallback', '__return_true' );

add_filter( 'woocommerce_default_address_fields' , 'custom_override_edit_billing_address' );



add_filter("woocommerce_checkout_fields", "k2t_order_fields");



function k2t_order_fields($fields) {



    $order = array(

        "billing_last_name" => array( 

        	'priority' => 25,

        	), 

        "billing_first_name" => array( 

        	'priority' => 20,

        	), 

        "billing_company" => array( 

        	'priority' => 30,

        	), 

       	"billing_country" => array( 

        	'priority' => 40,

        	),

        "billing_address_1" => array( 

        	'priority' => 50,

        	), 

        "billing_address_2" => array( 

        	'priority' => 60,

        	), 

        "billing_postcode" => array( 

        	'priority' => 65,

        	),  

        "billing_email" => array( 

        	'priority' => 100,

        	), 

        "billing_phone" => array( 

        	'priority' => 110,

        	)



    );

    foreach($order as $key => $field)

    {	

        if ( isset( $field['priority'] ) ) {

        	$fields["billing"][$key]['priority'] = $field['priority'];

        }

    }



    return $fields;



}