<?php
/**
 * The header for theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package skstore
 * @author  SunriseTheme
 * @link	http://www.sunrisetheme.com
 */

// Get theme options
if ( empty( $smof_data ) )
	$smof_data = of_get_options();

$classes = array();

// Fixed header
if ( ! empty( $smof_data['fixed-header'] ) ) {
	$classes[] = 'fixed';
}
// Full width header
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="https://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head();?>
</head>

<body <?php body_class(); ?>>

<?php if ( ! empty( $smof_data['pageloader'] ) ) : ?>
	<div id="loader-wrapper">
		<div class="loader">
		  <div class="side"></div>
		  <div class="side"></div>
		  <div class="side"></div>
		  <div class="side"></div>
		  <div class="side"></div>
		  <div class="side"></div>
		  <div class="side"></div>
		  <div class="side"></div>
		</div>
	</div>
<?php endif; ?>

<div class="k2t-container">

<?php 
	// get header style 
	$header_style = function_exists( 'get_field' ) ? get_field( 'header_style', get_the_ID() ) : '';
	$classes[] = str_replace( '_', '-', $header_style );

	if( $header_style == ''){
		$classes[] = 'header-horizontal';
	}

?>

	<header class="k2t-header <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
		<?php
			// Include top header layout
			if ( ! empty( $smof_data['use-top-header'] ) ) {
				include_once K2T_TEMPLATE_PATH . '/header/top.php';
			}

			// Include middle header layout
			if ( ! empty( $smof_data['use-mid-header'] ) ) {
				include_once K2T_TEMPLATE_PATH . '/header/mid.php';
			}

			// Include bottom header layout
			if ( ! empty( $smof_data['use-bot-header'] ) ) {
				include_once K2T_TEMPLATE_PATH . '/header/bot.php';
			}

			include_once K2T_TEMPLATE_PATH . '/header/responsive.php';
		?>
	</header><!-- .k2t-header -->

	<div class="k2t-body">

		<?php 
			if( class_exists( 'acf' ) ){
				if ( get_post_type() == 'product' ) :
					get_template_part( 'templates/titlebar/titlebar', 'product' );
				else: 
					get_template_part( 'templates/titlebar/title', 'bar' );
				endif;
			}
			else{
				get_template_part( 'templates/titlebar/title-bar', 'submit' );
			}
		?>