<?php

/**

 * The main template file.

 *

 * @package Skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();



$classes = array();



// Get blog layout

$blog_layout = $smof_data['blog-sidebar-position'];



// Get blog style

$blog_style = $smof_data['blog-style'];



if ( 'right_sidebar' == $blog_layout ) {

	$classes[] = 'right-sidebar';

} elseif ( 'left_sidebar' == $blog_layout ) {

	$classes[] = 'left-sidebar';

} elseif ( 'two_sidebars' == $blog_layout ) {

	$classes[] = 'two-sidebars';

} else {

	$classes[] = 'no-sidebar';

}



if ( $blog_style ) {

	$classes[] = 'b-' . $blog_style;

}



// Blog masonry full width

$fullwidth = ( isset ( $smof_data['blog-masonry-full-width'] ) && $smof_data['blog-masonry-full-width'] ) ? ' fullwidth' : '';



get_header(); ?>



	<div class="k2t-content <?php echo esc_attr( implode( ' ', $classes ) ) . $fullwidth ?>">



		<div class="k2t-wrap">



			<?php

				if ( 'two_sidebars' == $blog_layout ) {

					echo '<div class="k2t-btc">';



					if ( 'small' == $blog_style ) {

						$featured = new WP_Query( 'category_name=featured&posts_per_page=1' );



						while ( $featured->have_posts() ) : $featured->the_post();				

							get_template_part('blog/content','featured');

						endwhile;



						// Reset global query object

						wp_reset_query();

					}



					// Get secondary sidebar for blog 3 columns

					get_sidebar( 'sub' );

				}

			?>

			<div class="k2t-blog" role="main">

				

				<?php



					echo '<div>';



					if ( 'masonry' == $blog_style ) {

						echo '<div class="masonry-layout">';

						echo '<div class="grid-sizer"></div>';

					}



					if ( have_posts() ) :

						while ( have_posts() ) : the_post();

							

							if ( 'large' == $blog_style ) {

								get_template_part('templates/blog/content','large');

							} elseif ( 'large-2' == $blog_style ) {

								get_template_part('templates/blog/content','large-2');

							} elseif ( 'masonry' == $blog_style ) {

								get_template_part('templates/blog/content','masonry');

							}

						

						endwhile;

					else :

						get_template_part( 'content', 'none' );

					endif;



					if ( 'timeline' == $blog_style || 'masonry' == $blog_style ) {

						echo '</div>';

					}



					echo '</div>';



					get_template_part('templates/navigation');



				?>



			</div><!-- .k2t-main -->



			<?php

				if ( 'two_sidebars' == $blog_layout ) {

					echo '</div>';

				}

				if ( 'no_sidebar' != $blog_layout ) {

					get_sidebar();

				}

			?>



		</div><!-- .k2t-wrap -->

	</div><!-- .k2t-content -->



<?php get_footer(); ?>

