<?php

/**

 * The template for displaying all pages.

 *

 * This is the template that displays all pages by default.

 * Please note that this is the WordPress construct of pages

 * and that other 'pages' on your WordPress site will use a

 * different template.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();



$classes = array();



// Get post or page id

if ( is_home() ) {

	$id = get_option( 'page_for_posts' );

} else {

	$id = get_the_ID();

}



// Get page layout

$page_layout        	= ( function_exists( 'get_field' ) ) ? get_field( 'page_layout', $id ) : 'right_sidebar';

$page_sidebar_width 	= ( function_exists( 'get_field' ) ) ? get_field( 'page_sidebar_width', $id ) : '';



if ( 'right_sidebar' == $page_layout ) {

	$classes[] = 'right-sidebar';

} elseif ( 'left_sidebar' == $page_layout ) {

	$classes[] = 'left-sidebar';

} elseif ( 'no_sidebar' == $page_layout || 'full_width' == $page_layout ) {

	$classes[] = 'no-sidebar';

}



get_header(); ?>



	<div class="k2t-content <?php echo esc_attr( implode( ' ', $classes ) ) ?>">



		<?php

			if ( 'full_width' != $page_layout ) {

				echo '<div class="container k2t-wrap">';

			}

		?>



		<div class="k2t-main page" role="main">



				<?php while ( have_posts() ) : the_post(); ?>

	

					<?php get_template_part( 'content', 'page' ); ?>

	

				<?php endwhile; // end of the loop. ?>

	

				<div class="clear"></div>

				

				<?php if ( comments_open() ) :

						comments_template();

					endif;

				?>

		</div><!-- #main -->



		<?php

			if ( 'default' == $page_layout || 'right_sidebar' == $page_layout || 'left_sidebar' == $page_layout ) {

				get_sidebar();

			}



			if ( 'full_width' != $page_layout ) {

				echo '</div>';

			}

		?>

	</div><!-- .k2t-content -->



<?php get_footer(); ?>