<?php

/**

 * The blog template file.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 * Template Name: Blog grid 2 Columns

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();

// Get blog layout

$blog_layout = ( function_exists( 'get_field' ) ) ? get_field( 'page_layout', get_the_ID() ) : $smof_data['blog-sidebar-position'];

$blog_layout_cl = str_replace('_', '-', $blog_layout);

$blog_style  = 'grid';



$page_select_categories         = ( function_exists( 'get_field' ) ) ? get_field( 'page_select_categories', $id ) : '';



// Get category by id

$post_of_cats = '';

if ( is_numeric( $page_select_categories ) ) {

	$post_of_cats = $page_select_categories;

} else {

	$i = 0;

	if ( count( $page_select_categories ) > 0 ) {

		foreach( (array) $page_select_categories as $key => $val ) {

			if ( $i == count( $page_select_categories ) ) {

				$post_of_cats .= $val;

			} else {

				$post_of_cats .= ',' . $val;

			}

			$i++;

		}

	}

}

get_header(); 



?>



	<div class="k2t-content <?php echo ( $blog_layout_cl ); ?> b-masonry">



		<div class="k2t-wrap">



			<div class="k2t-blog" role="main">

				

				<div class="grid-layout column-2">

					<div class="grid-sizer"></div>

					<?php

					$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : ( get_query_var( 'page' ) ? get_query_var( 'page' ) : 1 );

					$args = array(

						'post_type'      => 'post',

						'posts_per_page' => get_option('posts_per_page '),

						'paged'			 => $paged,

						'cat'				=> $post_of_cats,

					);

					$wp_query = new WP_query( $args );

					while ( $wp_query->have_posts() ) : $wp_query->the_post();

						get_template_part( 'templates/blog/content', 'grid' );

					endwhile;

					?>

					<?php wp_reset_postdata(); ?>

				</div>

				<?php 

					get_template_part('templates/navigation');

				?>

			</div><!-- .k2t-main -->



			<?php 

				if ( $blog_layout == 'right_sidebar' || $blog_layout == 'left_sidebar') {

					get_sidebar();

				}

			?>



		</div><!-- .k2t-wrap -->

	</div><!-- .k2t-content -->



<?php get_footer(); ?>