<?php

/**

 * The template for displaying content masonry.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();

$blog_style = $smof_data['blog-style'];



// Get all categories of post

$category_list = get_the_category_list( ', ', '', get_the_ID() );



// Get post format

$post_format = get_post_format();

$large       = ( function_exists( 'get_field' ) ) ? get_field( 'post_large', get_the_ID() ) : '';

?>



<article id="post-<?php the_ID(); ?>" <?php post_class( 'element hentry post-item ' . $post_format . '-post' ); ?>>

	<div class="post-article-inner">

	    <?php get_template_part( 'templates/blog/post', 'format' ); ?>

	</div>

</article>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'element hentry post-item ' . $post_format . '-post' ); ?>>

	<div class="post-article-inner post">

		<!-- Include thumb -->

	    	<header>

				<?php if ( 'quote' != $post_format ) {

						if ( 'link' == $post_format ) {

							the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( $link ) ), '</a></h2>' );

						} else {

							if ( $smof_data['blog-post-link'] ) {

								the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

							}

						}

					}

				?>

				<div class="post-meta-left">

					<?php if ( $smof_data['blog-date'] ):?>

						<span data-time="<?php echo esc_attr( get_the_date( 'c' ) ) ?>" class="entry-date"><?php the_time( 'j M Y' ); ?></span>

					<?php endif;?>

				</div>

				<div class="post-meta-right">

					<?php if ( $smof_data['blog-number-comment'] ) :?>

						<span class="entry-comment"><i class="awesome-comment-o"></i><a href="<?php comments_link(); ?>"><?php comments_number( '0', '1', '%' ); ?></a></span>

						<span class="entry-comment"><i class="awesome-heart-o"></i><?php echo esc_html( skstore_wpb_get_post_views( get_the_ID() ) ) ?></span>

					<?php endif;?>

				</div>

			</header>



	        <div class="entry-content clearfix">

			<?php

				if ( 'quote' != $post_format ) {	

					if ( 'excerpts' == $smof_data['blog-display'] ) {

						$excerpts = get_the_excerpt();

						if ( empty( $excerpts ) ) :

							echo ( $trimmed_content = '<p>' . wp_trim_words( get_the_content(), $smof_data['excerpt-length'] ) . '</p>' );

						else :

							the_excerpt();

						endif;

					} else {

						if ( $smof_data['blog-readmore'] ) {

							the_content( sprintf( esc_html__( 'Read more', 'skstore' ) ) );

						} else {

							the_content( sprintf( esc_html__( ' ', 'skstore' ) ) );

						}   

					}

				} else {

					echo '<a class="more-link" href="' . esc_url( get_permalink() ) . '">'. esc_html__( 'Read more', 'skstore' ) .'</a>';

				}

			?>

	    </div><!--end:entry-content-->

    </div>

</article><!--end:post-item-->