<?php

/**

 * The template for displaying content small image thumbnail.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();



// Get post format

$post_format = get_post_format();

?>



<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>



	<?php

		get_template_part( 'templates/blog/post', 'format' );



		if ( 'quote' != $post_format ) :

	?>



		<div class="k2t-entry">

			<div class="k2t-meta">

				<?php if ( $smof_data['blog-author'] ) { ?>

					<div class="post-author">

						<?php echo sprintf( esc_html__( 'Posted by <span>%s</span>', 'skstore' ), get_the_author_link() );?>

					</div>

				<?php }



				if ( $smof_data['blog-date'] ) { ?>

					<div class="posted-on">

						<i class="fa fa-clock-o"></i><?php the_time( 'j M Y' ); ?>

					</div>

				<?php }



				if ( $smof_data['blog-number-comment'] ) {

					if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>

						<div class="post-comment">

							<a href="<?php comments_link(); ?>"><i class="fa fa-comments"></i><?php comments_number( '0 Comment', '1 Comment', '% Comments' ); ?></a>

						</div>

				<?php

					endif;

				}



				?>

			</div><!-- .k2t-meta -->



			<?php 

				if ( 'quote' != $post_format ) {	

					if ( 'excerpts' == $smof_data['blog-display'] ) {

						$excerpts = get_the_excerpt();

						if ( empty( $excerpts ) ) :

							echo ( $trimmed_content = '<p>' . wp_trim_words( get_the_content(), $smof_data['excerpt-length'] ) . '</p>' );

						else :

							the_excerpt();

						endif;

					} else {

						if ( $smof_data['blog-readmore'] ) {

							the_content( sprintf( esc_html__( 'Read more', 'skstore' ) ) );

						} else {

							the_content( sprintf( esc_html__( ' ', 'skstore' ) ) );

						}   

					}

				} else {

					echo '<a class="more-link" href="' . esc_url( get_permalink() ) . '">'. esc_html__( 'Read more', 'skstore' ) .'</a>';

				}

			?>

		</div><!-- .k2t-entry -->

	<?php endif; ?>



</article><!-- #post-## -->

