<?php

/**

 * The template for displaying post formats.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();



// Get blog style

$blog_style = ( empty( $blog_style ) || ! isset( $blog_style ) ) ? $smof_data['blog-style'] : $blog_style;



// Get post format

$post_format = get_post_format();



// Post format video

$video_source       = ( function_exists( 'get_field' ) ) ? get_field( 'video_format_source', get_the_ID() ) : '';

$video_source_link  = ( function_exists( 'get_field' ) ) ? get_field( 'video_url', get_the_ID() ) : '';

$video_source_embed = ( function_exists( 'get_field' ) ) ? get_field( 'video_code', get_the_ID() ) : '';

$video_source_local = ( function_exists( 'get_field' ) ) ? get_field( 'video_local', get_the_ID() ) : '';



// Post format audio

$audio_source       = ( function_exists( 'get_field' ) ) ? get_field( 'audio_format_source', get_the_ID() ) : '';

$audio_source_link  = ( function_exists( 'get_field' ) ) ? get_field( 'audio_url', get_the_ID() ) : '';

$audio_source_local = ( function_exists( 'get_field' ) ) ? get_field( 'audio_local', get_the_ID() ) : '';



// Post format gallery

$post_gallery = ( function_exists( 'get_field' ) ) ? get_field( 'post_gallery', get_the_ID() ) : array();

$auto_play    = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_auto', get_the_ID() ) : '';

$duration     = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_auto_time_wait', get_the_ID() ) : '';

$speed        = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_speed', get_the_ID() ) : '';

$pagination   = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_pagination', get_the_ID() ) : '';

$navigation   = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_navigation', get_the_ID() ) : '';

$mouse        = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_mousewheel', get_the_ID() ) : '';

if ( function_exists( 'k2t_pre_process_shortcode' ) ) {

	$script = '

		<div>

		<scr' . 'ipt>

			(function($) {

				"use strict";

				$(document).ready(function() {

					$(".k2t-thumb-gallery").owlCarousel({

						dots: ' . $pagination . ',

						nav: ' . $navigation . ',

						smartSpeed: ' . $speed . ',

						loop: true,

						navText: [

							"<i class=\"fa fa-chevron-left\"></i>",

							"<i class=\"fa fa-chevron-right\"></i>"

						],

						items: 1,

					});

				});

			})(jQuery);

		</scr' . 'ipt>

		</div>

	';

}



// Post format quote

$quote_author  = ( function_exists( 'get_field' ) ) ? get_field( 'quote_author', get_the_ID() ) : '';

$quote_link    = ( function_exists( 'get_field' ) ) ? get_field( 'author_quote_url', get_the_ID() ) : '';

$quote_content = ( function_exists( 'get_field' ) ) ? get_field( 'quote_content', get_the_ID() ) : '';



if ( is_single() ) {

	$image_size = 'full';

} else {

	$image_size = 'k2t_skstore_770x520';

}

if ( $blog_style == 'medium' ) {

	$image_size = 'k2t_skstore_500x500';

} elseif ( $blog_style == 'masonry' ) {

	$image_size = 'k2t_skstore_999x999';

} elseif ( $blog_style == 'grid' ) {

	$image_size = 'k2t_skstore_999x999';

}

elseif ( $blog_style == 'large' ) {

	$image_size = 'k2t_skstore_999x999';

}

?>



<?php if ( $post_format != 'quote') :?><div class="flx-entry-thumb <?php echo ( $blog_style ); ?>"><?php endif;?>

 <?php

	switch ( $post_format ) :

		case 'video':

				if ( 'link' == $video_source ) :

					echo do_shortcode( '[vc_video link="' . esc_url( $video_source_link ) . '"/]' );

				elseif ( 'embed' == $video_source ) :

					echo ( $video_source_embed );

				elseif ( 'local' == $video_source ) :

					echo do_shortcode('[video src="' . esc_url( $video_source_local['url'] ) . '"/]');

				endif;

			break;

		case 'audio':

			if ( 'link' == $audio_source ) :

				k2t_skstore_audio( '[embed]' . esc_url( $audio_source_link ) . '[/embed]' );

			elseif ( 'local' == $audio_source ) :

				echo do_shortcode('[audio src="' . esc_url( $audio_source_local['url'] ) . '"/]');

			endif;

		break;

		case 'gallery':

				if ( count( $post_gallery ) > 0 && is_array( $post_gallery ) ) :

					echo '<div class="k2t-thumb-gallery">';

						foreach ( $post_gallery as $slide ):



							if ( is_array( $slide ) && ! empty( $slide['ID'] ) ) : $image = wp_get_attachment_image( $slide['ID'], $image_size ); ?>

								<div class="item"> 

									<?php echo ( $image ); ?>

								</div>



							<?php elseif ( ! empty( $slide ) ) : $image = wp_get_attachment_image( $slide, $image_size ); ?>

								<div class="item"> 

									<?php echo ( $image ); ?>

								</div>

							<?php endif;



						endforeach;

					echo '</div>';

					echo ( $script );

				else :

					the_post_thumbnail( $image_size );

				endif;

			break;

		case 'quote':

			if ( is_single() ) {

				if ( has_post_thumbnail() ) :

					echo '<a href="'. esc_url( get_permalink() ) .'">'. get_the_post_thumbnail( get_the_ID(), $image_size ) .'</a>';

				else:

					echo '<a href="'. esc_url( get_permalink() ) .'"><img src="' . get_template_directory_uri() . '/assets/img/placeholder/'. $image_size  .'.png" alt="' . get_the_title() . '" /></a>';

				endif;



			} else {

				if( isset( $quote_content ) && !empty( $quote_content ) ) :

					echo '

		                <div class="quote-wrapper">

	                		<div class="quote-inner">

		                    	<a href="#">

		                        	<div class="quote-content">

			                    		<h4>

			                    			<blockquote><p>'. $quote_content  .'

			                    			</p></blockquote>

			                    		</h4>

			                            <p><span>'. esc_html( $quote_author ) .'</span></p>

			                    	</div><!--end:quote-content-->

		                        </a>                                    	

		                    </div><!--end:quote-inner-->

		                </div><!--end:quote-wrapper-->

					';

				else :

					the_content();

				var_dump(the_content());

				endif;

			}

			break;

		default:

			if ( is_single() && $blog_style != 'grid' ) {

				if ( has_post_thumbnail() ) :

					echo get_the_post_thumbnail( get_the_ID(), 'full' );

				else:

					echo '<img src="' . get_template_directory_uri() . '/assets/img/placeholder/1000x500.png" alt="' . esc_attr( get_the_title() ) . '" />';

				endif;

			} else {

				if ( has_post_thumbnail() ) :

					echo '<a href="'. esc_url( get_permalink() ) .'">'. get_the_post_thumbnail( get_the_ID(), $image_size ) .'</a>';

				endif;

			}

			echo '<div class="mask"><a href="' .esc_url( get_permalink() ) . '" title="' . esc_attr( get_the_title() ) . '"></a></div>';

	endswitch;

?>	

<?php if ( $post_format != 'quote' ) :?></div><!--end:flx-entry-thumb--><?php endif;?>