<?php

/**

 * The bottom header for theme.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



if ( $smof_data['header_section_3'] != '' ) :

	// Get all data of top header

	$data = json_decode ( $smof_data[ 'header_section_3' ], true );



	// Get number of column display

	$col = $data['columns_num'];

	

	// Get section properties

	$style    			= array();

	$fullwidth			= ! empty( $data['setting']['fullwidth'] ) ? k2t_skstore_k2tde( $data['setting']['fullwidth'] ) : '';

	$header_height      = ! empty( $data['setting']['header_height'] ) ? k2t_skstore_k2tde( $data['setting']['header_height'] ) : '' ;

	$hex      			= ! empty( $data['setting']['bg_color'] ) ? k2t_skstore_k2tde( $data['setting']['bg_color'] ) : '';

	$bg_image 			= ! empty( $data['setting']['bg_image'] ) ? k2t_skstore_k2tde( $data['setting']['bg_image'] ) : '';

	$opacity  			= ! empty( $data['setting']['opacity'] ) ? k2t_skstore_k2tde( $data['setting']['opacity'] ) : '';

	$css      			= ! empty( $data['setting']['custom_css'] ) ? k2t_skstore_k2tde( $data['setting']['custom_css'] ) : '';

	$rgb      			= k2t_skstore_hex2rgb( $hex );



	if ( $opacity ) {

		$a = ',' . $opacity / 100;

	}



	if ( $hex ) {

		$style[] = 'background-color: rgba(' . $rgb['0'] . ',' . $rgb['1'] . ',' . $rgb['2'] . $a .');';

	}

	if ( $bg_image ) {

		$style[] = 'background-image: url( ' . $bg_image . ' );';

		if ( $hex == '' &&  $opacity != '' ) {

			$style[] = 'opacity: ' . $opacity . ';';

		}

	}

	if ( $header_height ) {

		if ( is_numeric( $header_height ) ) {

			$style[] = 'height: ' . $header_height . 'px;';

		} else {

			$style[] = 'height: ' . $header_height . ';';

		}

	}

	

	if ( $css != '' ) {

		echo '<style>' . $css . '</style>';

	}



	/**

	 * Bottom header output.

	 *

	 * @since  1.0

	 */

	function k2t_skstore_bot_header_value( $data, $id, $section ) {

		$values = $data['columns'][$id]['value'];

		$i = 0;

		foreach ( $values as $val ) {

			if ( function_exists( 'k2t_skstore_data' ) ) {

				k2t_skstore_data( $id, $i, $section );

			}

			$i++;

		}

	}

	?>

	<div class="k2t-header-bot" style="<?php echo esc_attr( implode( ' ', $style ) ); ?>">

		<?php if ( $fullwidth != 'yes' ) echo '<div class="k2t-wrap">'; ?>

			<div class="k2t-row">

				<?php

					$section = 'header_section_3';

					for ( $i = 0; $i < $col; $i++ ) {

						echo '<div class="col-' . esc_attr( $data['columns'][$i]['percent'] ) . '">';

							k2t_bot_header_value( $data, $i, $section );

						echo '</div>';

					}

				?>

			</div><!-- .row -->

		<?php if ( $fullwidth != 'yes' ) echo '</div><!-- .k2t-wrap -->'; ?>

	</div><!-- .k2t-header-bot -->

<?php endif; ?>