<?php

/**

 * The template for displaying title and breadcrumb.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();



// Get post or page id

if ( is_home() ) {

	$id = get_option( 'page_for_posts' );

} elseif ( function_exists( 'is_shop' ) && is_shop() ) {

	$id = get_option( 'woocommerce_shop_page_id' );

} else {

	$id = get_the_ID();

}

$classes = $css = $html = array();



// Check pre

$pre = '';

if ( is_single() ) {

	if ( is_singular( 'post-portfolio' ) ) {

		$pre = 'portfolio-';

	} elseif ( is_singular( 'product' ) ) {

		$pre = 'product-';

	}

} elseif ( is_category() ) {

	$pre = 'blog-';

}



// Show or hidden title bar

if ( is_category() || is_tax( 'portfolio-category' ) || function_exists( 'is_product_category' ) && is_product_category() || function_exists( 'is_account_page' ) && is_account_page() || function_exists( 'is_cart' ) && is_cart() || function_exists( 'is_checkout' ) && is_checkout() ) {

	$titlebar_show_hidden = 'show';

} else {

	$titlebar_show_hidden = ( function_exists( 'get_field' ) ) ? get_field( 'display_titlebar', $id ) : '';

}



// Title bar Underline 

$titlebar_underline = ( function_exists( 'get_field' ) ) ? get_field( 'skstoretitle_underline', $id ) : '';

if ( $titlebar_underline ) {

	$classes[] = ( $titlebar_underline == 'show') ? 'underline' : '';

} else {

	$classes[] = empty ( $smof_data[$pre . 'title-underline'] ) ? 'underline' : '';

}



// Title bar layout 'layout-1 = Justify' or 'layout-2 = Center'

$titlebar_layout        = ( function_exists( 'get_field' ) ) ? get_field( 'titlebar_layout', $id ) : '';

if ( $titlebar_layout ) {

	$classes[] = empty( $titlebar_layout ) ? 'center' : $titlebar_layout;

} else {

	$classes[] = empty( $smof_data['titlebar-layout'] ) ? 'center' : $smof_data['titlebar-layout'];

}



// Title bar font size

$titlebar_font_size = ( function_exists( 'get_field' ) ) ? get_field( 'page_titlebar_font_size', $id ) : '';

if ( $titlebar_font_size ) {

	if ( is_numeric( $titlebar_font_size ) ) {

		$titlebar_line_height = ! empty( $titlebar_font_size ) ? 'line-height:' . $titlebar_font_size . 'px;' : '';

		$titlebar_font_size = ! empty( $titlebar_font_size ) ? 'font-size:' . $titlebar_font_size . 'px;' : '';

	} else {

		$titlebar_line_height = ! empty( $titlebar_font_size ) ? 'line-height:' . $titlebar_font_size . ';' : '';

		$titlebar_font_size = ! empty( $titlebar_font_size ) ? 'font-size:' . $titlebar_font_size . ';' : '';

	}

} else {

	if ( is_numeric( $smof_data[$pre . 'titlebar-title-size'] ) ) {

		$titlebar_line_height = ! empty( $smof_data[$pre . 'titlebar-title-size'] ) ? 'line-height:' . $smof_data[$pre . 'titlebar-title-size'] . 'px;' : '';

		$titlebar_font_size = ! empty( $smof_data[$pre . 'titlebar-title-size'] ) ? 'font-size:' . $smof_data[$pre . 'titlebar-title-size'] . 'px;' : '';



	} else {

		$titlebar_line_height = ! empty( $smof_data[$pre . 'titlebar-title-size'] ) ? 'line-height:' . $smof_data[$pre . 'titlebar-title-size'] . ';' : '';

		$titlebar_font_size = ! empty( $smof_data[$pre . 'titlebar-title-size'] ) ? 'font-size:' . $smof_data[$pre . 'titlebar-title-size'] . ';' : '';

	}

}



// Title bar color

$titlebar_font_color = ( function_exists( 'get_field' ) ) ? get_field( 'page_titlebar_color', $id ) : '';

if ( $titlebar_font_color ) {

	$titlebar_font_color = ! empty( $titlebar_font_color ) ? 'color:' . $titlebar_font_color . ';' : '';

} else {

	$titlebar_font_color = ! empty( $smof_data[$pre . 'titlebar-title-color'] ) ? 'color:' . $smof_data[$pre . 'titlebar-title-color'] . ';' : '';

}



// Background zoom effect

$titlebar_bg_zoom        = ( function_exists( 'get_field' ) ) ? get_field( 'background_zoom', $id ) : '';

$titlebar_bg_zoom_height = ( function_exists( 'get_field' ) ) ? get_field( 'background_zoom_height', $id ) : '';

if ( $titlebar_bg_zoom ) {

	$classes[] = empty( $titlebar_bg_zoom ) ? '' : 'zoom-effect';

	$css[]     = ! empty( $titlebar_bg_zoom_height ) ? 'height: ' . $titlebar_bg_zoom_height . ';' : '';



	if( function_exists( 'k2t_skstore_bg_zoom_trigger_script' ) ):

		k2t_skstore_bg_zoom_trigger_script();

	endif;

}



// Padding for title bar

$titlebar_padding_top    = ( function_exists( 'get_field' ) ) ? get_field( 'padding_top', $id ) : '';

$titlebar_padding_bottom = ( function_exists( 'get_field' ) ) ? get_field( 'padding_bottom', $id ) : '';

if ( $titlebar_padding_top || $titlebar_padding_bottom ) {

	if ( is_numeric( $titlebar_padding_top ) ) {

		$titlebar_padding_top = ! empty( $titlebar_padding_top ) ? 'padding-top:' . $titlebar_padding_top . 'px;' : '';

	} else {

		$titlebar_padding_top = ! empty( $titlebar_padding_top ) ? 'padding-top:' . $titlebar_padding_top . ';' : '';

	}

	$css[] = ! empty( $titlebar_padding_bottom ) ? 'padding-bottom:' . $titlebar_padding_bottom . ';' : '';

} else {

	$css[] = ! empty( $smof_data[$pre . 'padding-top'] ) ? 'padding-top:' . $smof_data[$pre . 'padding-top'] . ';' : '';

	$css[] = ! empty( $smof_data[$pre . 'padding-bottom'] ) ? 'padding-bottom:' . $smof_data[$pre . 'padding-bottom'] . ';' : '';

}



// Background image

$titlebar_bg_image    = ( function_exists( 'get_field' ) ) ? get_field( 'background_image', $id ) : '';

$titlebar_bg_position = ( function_exists( 'get_field' ) ) ? get_field( 'background_position', $id ) : '';

$titlebar_bg_size     = ( function_exists( 'get_field' ) ) ? get_field( 'background_size', $id ) : '';

$titlebar_bg_repeat   = ( function_exists( 'get_field' ) ) ? get_field( 'background_repeat', $id ) : '';

if ( empty( $titlebar_bg_zoom ) && ( $titlebar_bg_image || $titlebar_bg_position || $titlebar_bg_repeat ) ) {

	$css[] = ! empty( $titlebar_bg_image ) ? 'background-image: url(' . $titlebar_bg_image['url'] . ');' : '';

	$css[] = ! empty( $titlebar_bg_position ) ? 'background-position: ' . $titlebar_bg_position . ';' : '';

	$css[] = ! empty( $titlebar_bg_repeat ) ? 'background-repeat: ' . $titlebar_bg_repeat . ';' : '';

	if ( 'full' == $titlebar_bg_size ) {

		$css[] = ! empty( $titlebar_bg_size ) ? 'background-size: cover;' : '';

	}

	$css[] = ! empty( $titlebar_bg_size ) ? 'background-size: ' . $titlebar_bg_size . ';' : '';

} else {

	$css[] = ! empty( $smof_data[$pre . 'background-image'] ) ? 'background-image: url(' . $smof_data[$pre . 'background-image'] . ');' : '';

	$css[] = ! empty( $smof_data[$pre . 'background-position'] ) ? 'background-position: ' . $smof_data[$pre . 'background-position'] . ';' : '';

	$css[] = ! empty( $smof_data[$pre . 'background-repeat'] ) ? 'background-repeat: ' . $smof_data[$pre . 'background-repeat'] . ';' : '';

	$css[] = ! empty( $smof_data[$pre . 'background-size'] ) ? 'background-size: ' . $smof_data[$pre . 'background-size'] . ';' : 'background-size: cover';



}



// Background color

$titlebar_bg_color = ( function_exists( 'get_field' ) ) ? get_field( 'background_color', $id ) : '';

if ( $titlebar_bg_color ) {

	$css[] = ! empty( $titlebar_bg_color ) ? 'background-color: ' . $titlebar_bg_color . ';' : '';

} else {

	$css[] = ! empty( $smof_data[$pre . 'background-color'] ) ? 'background-color: ' . $smof_data[$pre . 'background-color'] . ';' : '';

}



// Background parallax

$titlebar_bg_parallax = ( function_exists( 'get_field' ) ) ? get_field( 'background_parallax', $id ) : '';

if ( $titlebar_bg_parallax ) {

	$classes[] = empty( $titlebar_bg_parallax ) ? '' : 'parallax';

} else {

	$classes[] = empty( $smof_data[$pre . 'background-parallax'] ) ? '' : 'parallax';

}

$inline_attr = '';

if ( $titlebar_bg_parallax || $smof_data[$pre . 'background-parallax'] ) {

	if( function_exists( 'k2t_skstore_parallax_trigger_script' ) ){

		k2t_skstore_parallax_trigger_script();

	}

	$inline_attr = 'data-stellar-background-ratio="0.5"';

}



// Title bar shadow

$titlebar_shadow = ( function_exists( 'get_field' ) ) ? get_field( 'titlebar_shadow_opacity', $id ) : '';

if ( $titlebar_bg_color ) {

	$classes[] = empty( $titlebar_shadow ) ? '' : 'shadow';

} else {

	$classes[] = empty( $smof_data[$pre . 'titlebar-shadow-opacity'] ) ? '' : 'shadow';

}



// Title bar mask color & background

$titlebar_mask_color   = ( function_exists( 'get_field' ) ) ? get_field( 'titlebar_overlay_opacity', $id ) : '';

$titlebar_mask_pattern = ( function_exists( 'get_field' ) ) ? get_field( 'titlebar_clipmask_opacity', $id ) : '';

if ( $titlebar_mask_color || $titlebar_mask_pattern ) {

	$html[] = empty( $titlebar_mask_color ) ? '' : '<div class="mask colors"></div>';

	$html[] = empty( $titlebar_mask_pattern ) ? '' : '<div class="mask pattern"></div>';

} else {

	$html[] = empty( $smof_data[$pre . 'titlebar-overlay-opacity'] ) ? '' : '<div class="mask colors"></div>';

	$html[] = empty( $smof_data[$pre . 'titlebar-clipmask-opacity'] ) ? '' : '<div class="mask pattern"></div>';

}



// Title custom content

$titlebar_custom_content = ( function_exists( 'get_field' ) ) ? get_field( 'titlebar_custom_content', $id ) : '';

if ( $titlebar_custom_content ) {

	$titlebar_custom_content = ( function_exists( 'get_field' ) ) ? get_field( 'titlebar_custom_content', $id ) : '';

} else {

	$titlebar_custom_content = empty ( $smof_data[$pre . 'titlebar-custom-content'] ) ? '' : $smof_data[$pre . 'titlebar-custom-content'];

}



//Main title

if ( is_tag() ) {

	$main_title = single_tag_title("", false);

} elseif ( is_day() ) {

	$main_title = get_the_time( 'F j, Y' );

} elseif ( is_month() ) {

	$main_title = get_the_time( 'F, Y' );

} elseif ( is_year() ) {

	$main_title = get_the_time( 'Y' );

} elseif ( is_search() ) {

	$main_title = esc_html__( 'Search for ', 'skstore' ) . get_search_query();

} elseif ( is_front_page() ) {

	$main_title = get_bloginfo( 'name' );

} elseif ( is_single() ) {

	$main_title = single_post_title("", false);

} elseif ( is_tax( 'portfolio-category' ) ) {

	global $wp_query;

    $term = $wp_query->get_queried_object();

    $main_title = $term->name;

} elseif ( is_category() ) {

	$main_title = single_cat_title("", false);

} elseif ( is_author() ) {

	global $wp_query;

	$curauth = $wp_query->get_queried_object();

	$main_title = $curauth->nickname;

} elseif ( is_page() ) {

	$main_title = get_the_title();

} elseif ( is_home() ) {

	$main_title = esc_html__( 'Blog', 'skstore' );

} elseif ( is_404() ) {

	$main_title = esc_html__( 'Error 404', 'skstore' );

} elseif (  function_exists( 'is_product_category' ) && is_product_category() ) {

	$id          = get_the_ID();

	$product_cat = wp_get_post_terms( $id, 'product_cat' );

	$title = $slug = array();

	if ( $product_cat ) {

		foreach ( $product_cat as $category ) {

			$title[] = "{$category->name}";

		}

	}

	$main_title = $title[0];

} elseif ( is_post_type_archive( 'product' ) ) {

	$main_title = esc_html__( 'Shop', 'skstore' );

} elseif ( is_post_type_archive() ) {

	$main_title = post_type_archive_title("", false);

} elseif (

	( function_exists( 'is_woocommerce' ) && is_woocommerce() ) ||

	( function_exists( 'is_cart' ) && is_cart() ) ||

	( function_exists( 'is_checkout' ) && is_checkout() )

) {

	$product_cat = wp_get_post_terms( $id, 'product_cat' );

	$title = array();

	if ( $product_cat ) {

		foreach ( $product_cat as $category ) {

			$title[] = "{$category->name}";

		}

	}

	$main_title = $title[0];

}

$titlebar_mask_color   = ( function_exists( 'get_field' ) ) ? get_field( 'titlebar_overlay_opacity', $id ) : '';

$search_form   = ( function_exists( 'get_field' ) ) ? get_field( 'search_form', $id ) : '';

if ( isset( $titlebar_show_hidden ) && ( 'show' == $titlebar_show_hidden ) ):

?>



	<div class="k2t-title-bar <?php echo esc_attr( implode( ' ', $classes ) ); ?>" style="<?php echo esc_attr( implode( '', $css ) ); ?>" <?php echo esc_attr( $inline_attr ); ?>>

		<?php if ( $titlebar_bg_zoom ) : ?>

			<div class="zoom" style="background-size: cover;background-image: url('<?php echo esc_url( $titlebar_bg_image['url'] ) ?>');background-repeat: <?php echo esc_atrr( $titlebar_bg_repeat ); ?>;height: 100%;width: 100%;"></div>

		<?php endif; ?>

		<?php echo implode( ' ', $html ); ?>

			<div class="container k2t-wrap" style="<?php echo esc_atrr( $titlebar_padding_top );?>">

				<h1 class="main-title" style="<?php echo esc_atrr( $titlebar_font_size ) . esc_atrr( $titlebar_line_height ) . esc_atrr( $titlebar_font_color ); ?>">

					<?php echo esc_html( $main_title ); ?>

				</h1>

				<span class="main-excerpt">

					<?php

						if ( is_single() ) {

							if ( ! empty( $titlebar_custom_content ) ) {

								echo do_shortcode( $titlebar_custom_content );

							} else {

								if ( is_singular( 'product' ) ) {

									global $post;

									$content = get_extended( $post->post_content );

									echo esc_html( $content['main'] );

								} else {

									the_excerpt();

								}

							}

						} elseif ( is_tax( 'portfolio-category' ) ) {

							global $wp_query;

						    $term = $wp_query->get_queried_object();

						    printf(  esc_html( $term->description ) );

						} elseif ( is_category() ) {

							// Show an optional term description.

							$term_description = term_description();

							if ( ! empty( $term_description ) ) {

								printf( '<div class="taxonomy-description">%s</div>', $term_description );

							} elseif ( $titlebar_custom_content ) {

								echo do_shortcode( $titlebar_custom_content );

							}

						} else {

							if ( ! empty( $titlebar_custom_content ) ) {

								echo do_shortcode( $titlebar_custom_content );

							}

						}

					?>

				</span><!-- .main-excerpt -->

				<?php

				if ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {

					if ( $smof_data['shop-breadcrumb'] ) {

						echo '<div class="container k2t-wrap breadcrumb">';

						k2t_skstore_breadcrumbs();

						echo '</div><!-- k2t-wrap -->';

					}

				} else {

					if ( $smof_data['breadcrumb'] ) {

						echo '<div class="container k2t-wrap breadcrumb">';

						k2t_skstore_breadcrumbs();

						echo '</div><!-- k2t-wrap -->';

					}

				}

				?>

				<?php

					if ( $search_form == "show" ) {

						get_search_form();

					};

				?>

			</div>

		</div>

	</div><!-- .k2t-title-bar -->

<?php else: ?>

	<div class="k2t-title-bar">

			<div class="container">

				<h1 class="main-title" style="padding: 50px 0 50px; <?php echo esc_html( $titlebar_font_size ) . $titlebar_font_color; ?>">

					<?php printf( $main_title ); ?>

				</h1>

			</div>

	</div>

<?php endif;