<?php

/**

 * The template for displaying woocommerce.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */



// Get theme options

if ( empty( $smof_data ) )

	$smof_data = of_get_options();



$classes = array();



// Get shop layout

$shop_layout   = $smof_data['shop-template'];

$shop_column   = $smof_data['shop-products-column'];



if ( ! is_product() ) :

	if ( 'right_sidebar' == $shop_layout ) {

		$classes[] = 'right-sidebar';

	} elseif ( 'left_sidebar' == $shop_layout ) {

		$classes[] = 'left-sidebar';

	} else {

		$classes[] = 'no-sidebar';

	}

endif;

get_header(); 

?>

	<div class="k2t-content <?php echo esc_attr( implode( ' ', $classes ) ); ?>">

		<section class="k2t-wrap">

			<div class="shop-banner">

				<?php if( isset( $smof_data['banner-left'] ) && $smof_data['banner-left'] != '' ): ?>

					<div class="col-7 banner-left" style="background:url('<?php echo esc_url( $smof_data['banner-left']); ?>');">

						<?php if( isset( $smof_data['banner-related-left'] ) && $smof_data['banner-related-left'] !='' ): ?>

							<div class="k2t-button">

								<a href="<?php echo esc_url( $smof_data['banner-related-left'] ); ?>" class="k2t-btn btn-medium" target="_blank">

									<span class="button-text">

										<span><?php esc_html_e('View Shop Now','skstore'); ?></span>

									</span>

								</a>

							</div>

						<?php endif; ?>

					</div>

				<?php endif; ?>



				<?php if( isset( $smof_data['banner-right'] ) && $smof_data['banner-right'] != '' ): ?>

					<div class="col-5 banner-right" style="background:url('<?php echo esc_url( $smof_data['banner-right']); ?>');">

						<?php if( isset( $smof_data['banner-related-right'] ) && $smof_data['banner-related-right'] !='' ): ?>

							<div class="k2t-button">

								<a href="<?php echo esc_url( $smof_data['banner-related-right'] ); ?>" class="k2t-btn btn-medium" target="_blank">

									<span class="button-text">

										<span><?php esc_html_e('View Shop Now','skstore'); ?></span>

									</span>

								</a>

							</div>

						<?php endif; ?>

					</div>

				<?php endif; ?>



			</div>

			<div class="k2t-wrap-inner">

				<div id="main" class="k2t-shop <?php if ( ! is_product() ) : echo 'columns-' . esc_attr( $shop_column ) . ''; endif; ?>">



					<?php woocommerce_content(); ?>

					

				</div><!-- #main -->

				

				<?php

				if ( ! is_product() ) {

					if ( 'no_sidebar' != $shop_layout ) { ?>

						<div class="k2t-shop-sidebar" role="complementary">

							<?php

								if ( empty( $single_custom_sidebar ) ) {

									dynamic_sidebar( 'shop_sidebar' );

								} else {

									dynamic_sidebar( $single_custom_sidebar );

								}

							?>

						</div><!-- .k2t-sidebar -->

				<?php }

				} ?>

			</div>

		</section><!-- .container -->

		<?php 

		$product_custom_footer = isset ( $smof_data['product-custom-footer'] ) ? $smof_data['product-custom-footer'] : '';

		if ( ! empty( $product_custom_footer ) ) :

			echo '<div class="k2t-line-top">';

			echo apply_filters( 'the_content', $product_custom_footer );

			echo '</div>';

		endif;?>



	</div><!-- .k2t-content -->

<?php get_footer(); ?>