<?php

/**

 * Checkout Form

 *

 * @author 		WooThemes

 * @package 	WooCommerce/Templates

 * @version     2.3.0

 */



if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



wc_print_notices();



do_action( 'woocommerce_before_checkout_form', $checkout );



// If checkout registration is disabled and not logged in, the user cannot checkout

if ( ! $checkout->enable_signup && ! $checkout->enable_guest_checkout && ! is_user_logged_in() ) {

	echo apply_filters( 'woocommerce_checkout_must_be_logged_in_message', esc_html__( 'You must be logged in to checkout.', 'skstore' ) );

	return;

}



// filter hook for include new pages inside the payment method

$get_checkout_url = apply_filters( 'woocommerce_get_checkout_url', wc_get_checkout_url() ); ?>

<a href="javascript:history.go(-1)" onMouseOver="self.status=document.referrer;return true"><i class="fa fa-long-arrow-left"></i><?php esc_html_e( 'Back', 'skstore') ?></a>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( $get_checkout_url ); ?>" enctype="multipart/form-data">



	<?php if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>



		<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>



		<div id="customer_details">

			<div class="checkout_billing">

				<?php do_action( 'woocommerce_checkout_billing' ); ?>

			</div>



			<div class="checkout_billing different_address">

				<?php do_action( 'woocommerce_checkout_shipping' ); ?>

			</div>

		</div>



		<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

	<?php endif; ?>



	<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>



	<div id="order_review" class="woocommerce-checkout-review-order">

		<h3 id="order_review_heading"><?php esc_html_e( 'Your order', 'skstore' ); ?></h3>

		<?php do_action( 'woocommerce_checkout_order_review' ); ?>

	</div>



	<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>



</form>



<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>



<script type="text/javascript">

	jQuery(document).ready(function( $ ) {

		var ms_ie = false;

	    var ua = window.navigator.userAgent;

	    var old_ie = ua.indexOf('MSIE ');

	    var new_ie = ua.indexOf('Trident/');



	    if ((old_ie > -1) || (new_ie > -1)) {

	        ms_ie = true;

	    }



	    if ( ms_ie ) {

	        $('body').addClass('web-ie');

	    }		

	});

</script>