<?php

/**

 * Product quantity inputs

 *

 * @author 		WooThemes

 * @package 	WooCommerce/Templates

 * @version     3.4.0

 */



if ( ! defined( 'ABSPATH' ) ) {

	exit; // Exit if accessed directly

}



?>

<div class="quantity">

	<input type="number" step="<?php echo esc_attr( $step ); ?>" <?php if ( is_numeric( $min_value ) ) : ?>min="<?php echo esc_attr( $min_value ); ?>"<?php endif; ?> <?php if ( is_numeric( $max_value ) ) : ?>max="<?php echo esc_attr( $max_value ); ?>"<?php endif; ?> name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $input_value ); ?>" title="<?php _ex( 'Qty', 'Product quantity input tooltip', 'skstore' ) ?>" class="input-text qty text" size="1" />

	<div class="qty-adjust">

		<a class="qty-plus" href="#"><i class="sf-icon-chevron-up"></i></a>

		<a class="qty-minus" href="#"><i class="sf-icon-chevron-down"></i></a>

	</div>

</div>

