<?php

/**

 * Simple product add to cart

 *

 * @author 		WooThemes

 * @package 	WooCommerce/Templates

 * @version     3.4.0

 */



if ( ! defined( 'ABSPATH' ) ) {

	exit; // Exit if accessed directly

}



global $product;



if ( ! $product->is_purchasable() ) {

	return;

}



?>



<?php if ( $product->is_in_stock() ) : ?>



	<?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>



	<form class="cart" method="post" enctype='multipart/form-data'>

	 	<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>



	 	



	 	<?php

	 		if ( ! $product->is_sold_individually() )

	 			woocommerce_quantity_input( array(

	 				'min_value' => apply_filters( 'woocommerce_quantity_input_min', 1, $product ),

	 				'max_value' => apply_filters( 'woocommerce_quantity_input_max', $product->backorders_allowed() ? '' : $product->get_stock_quantity(), $product )

	 			) );

	 	?>



	 	<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" />



	 	<button type="submit" class="single_add_to_cart_button button alt"><?php echo ( $product->single_add_to_cart_text()); ?></button>



		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>

		<?php if ( class_exists( 'YITH_WCWL_UI' ) ): ?>

		<div class="wishlist">

			<?php echo do_shortcode('[yith_wcwl_add_to_wishlist]');?>

		</div>	

	<?php endif; ?>

	</form>



	<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>



<?php endif; ?>

