<?php

/**

 * Single Product Image

 *

 * @author 		WooThemes

 * @package 	WooCommerce/Templates

 * @version     3.3.2

 */



if ( ! defined( 'ABSPATH' ) ) {

	exit; // Exit if accessed directly

}



global $post, $woocommerce, $product;

$shop_single    = wc_get_image_size( 'shop_single' );

$shop_thumbnail = wc_get_image_size( 'shop_thumbnail' );

$shop_img_width = ( isset( $shop_single['width'] ) ) ? $shop_single['width'] : '570';

$shop_img_height = ( isset( $shop_single['height'] ) ) ? $shop_single['height'] : '570';

$shop_gallery_width = ( isset( $shop_thumbnail['width'] ) ) ? $shop_thumbnail['width'] : '100';

$shop_gallery_height = ( isset( $shop_thumbnail['height'] ) ) ? $shop_thumbnail['height'] : '100';

?>

<div id="single-product-image-wrap" class="images">

	<div class="product-img-cont">

		<div class="product-img">

			<?php

				//gallery images

				$attachment_ids = $product->get_gallery_image_ids();

				$nav_loop = false;

				if ( count( $attachment_ids ) >= 4 ) $nav_loop = true;

				if ( $attachment_ids ) {

					//  IMAGE PRODUCT FOR variation

					if ( has_post_thumbnail() ) {



						$image_title 	= esc_attr( get_the_title( get_post_thumbnail_id() ) );

						$image_caption 	= get_post( get_post_thumbnail_id() )->post_excerpt;

						$image_link  	= wp_get_attachment_url( get_post_thumbnail_id() );

						$image       	= get_the_post_thumbnail( $post->ID, 'shop_single' );



						$attachment_count = count( $product->get_gallery_image_ids() );



						if ( $attachment_count > 0 ) {

							$gallery = '[product-gallery]';

						} else {

							$gallery = '';

						}



						$img_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'single-post-thumbnail' );

						$get_full_size = $img_url[0];



						echo '<div class="item">';

						echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<div class="z-item" href="%s" itemprop="image" class="produc-main-image" title="%s" data-rel="' . $gallery . '">%s</div>', $image_link, $image_caption, $image ), $post->ID );

						echo '<a class="click-fullscreen click-view click-1" href="'. esc_url( $get_full_size ) .'"><span class="icon-size-fullscreen"></span></a>';

						echo '</div>';



					} else {



						echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<img src="%s" alt="%s" />', wc_placeholder_img_src(), esc_html__( 'Placeholder', 'skstore' ) ), $post->ID );



					}

					$i = 1;

					foreach ( $attachment_ids as $attachment_id ) { 

						// Get image link by attachment ID

						if ( $i > 1 ) : 

							$img_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'single-post-thumbnail' );

							$get_full_size = $img_url[0];

							$image  = wp_get_attachment_url( $attachment_id );

							$image_full     = wp_get_attachment_image_src( $attachment_id, 'full' );

							$image_alt   = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);

							$image_url       = ( aq_resize( $image, $shop_img_width, $shop_img_height, true ) != '' ) ? aq_resize( $image, $shop_img_width, $shop_img_height, true ) : $image;

							$main_image  = ( aq_resize( $image, $shop_img_width, $shop_img_height, true ) != '' ) ? aq_resize( $image, $shop_img_width, $shop_img_height, true ) : $image;

							if ( $image != '' ) { 

								echo '<div class="item">

										<img src="' . esc_url( $image_url ) . '" alt="' . esc_attr( $image_alt ) . '" />

										<a class="click-fullscreen click-view click-2" href="'. esc_url( $image_full[0] ).'"><span class="icon-size-fullscreen"></span></a>

									</div>';

							}

						endif;

						$i++;

					}



				} else {

					if ( has_post_thumbnail() ) {

						$img_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'single-post-thumbnail' );

						$get_full_size = $img_url[0];

						$post_thumbnail_id = get_post_thumbnail_id( $post->ID );

						$thumb =  wp_get_attachment_url( $post_thumbnail_id );

						$thumb_url = ( aq_resize( $thumb, $shop_img_width, $shop_img_height, true ) != '' ) ? aq_resize( $thumb, $shop_img_width, $shop_img_height, true ) : $thumb ;

						echo '<div class="item">

								<div class="item-cont"><img src="' . esc_url( $thumb_url ) . '" alt="' . esc_html( get_the_title() ) . '" /></div>

								<a class="click-fullscreen click-view click-3 reload-button-link" href="' . esc_url( $get_full_size ) . '"><span class="icon-size-fullscreen"></span></a>

							</div>';

					} else {

							echo '<div class="item">

									<img src="' . get_template_directory_uri() . '/assets/img/placeholder/999x999.png" alt="" />

									<a class="click-fullscreens click-4 reload-button-link" href="' . get_template_directory_uri() . '/assets/img/placeholder/570x444.png "><span class="icon-size-fullscreen"></span></a>

								</div>';

					}

				}

			?>







		</div>

	</div>

<?php if ( $attachment_ids ) : ?>

		<div id="nav" class="navs">

			<?php 

			//featured image                   ------------------- NAV CAROUSEL -------------------

					//gallery images

			if ( $attachment_ids ) {  	

				$j = 1;

				foreach ( $attachment_ids as $attachment_id ) { 

					if ($image) { 

						echo '<a class="secondary url">'

								. wp_get_attachment_image( $attachment_id, 'shop_thumbnail' ) .

							'</a>';

					}

					$j++;

				}

			} else {

				if ( has_post_thumbnail() ) {

					$post_thumbnail_id = get_post_thumbnail_id( $post->ID );

					$thumb =  wp_get_attachment_url( $post_thumbnail_id );

					$thumb_url = aq_resize( $thumb, $shop_gallery_width, $shop_gallery_height, true );

						echo '<a class="secondary url clicked">'

							. wp_get_attachment_image( $attachment_id, 'shop_thumbnail' ) .

						'</a>';

				} else {

						echo '<a class="secondary url clicked"><img src="' . get_template_directory_uri() . '/assets/img/placeholder/120x90.png" alt="" /></a>';

				}

			}



			?>

		</div>

<?php endif;?>

		<script type="text/javascript">	

			(function($) {

				"use strict";



				$(document).ready(function(){

					var sync1 = $(".product-img");

					var sync2 = $(".navs");

					var flag = false;

					<?php 

			    		if ( $attachment_ids ) :

			    			echo 'var main_src = "' . $image_url .'";';

			    		endif;

			    	?>

					var slides = sync1.owlCarousel({

						items:1,

						loop:false,

						margin:10,

						autoplay:false,

						autoplayTimeout:6000,

						autoplayHoverPause:false,

						nav: false,

						dots: true

					});

					var thumbs = sync2.owlCarousel({

				        items:4,

						loop: false,

						margin:10,

						autoplay:false,

						nav: true,

						dots: false

					}).on('click', '.owl-item', function(e) {

				        e.preventDefault();	

				        sync1.trigger('to.owl.carousel', [$(e.target).parents('.owl-item').index(), 300, true]);

					}).on('change.owl.carousel', function(e) {

		                if (e.namespace && e.property.name === 'position' && !flag) {

				    }

					}).data('owl.carousel');

					

					$('.navs a').each(function(index){

						$(this).on('click', function(e){

							e.preventDefault(); 

						    $(this).addClass('clicked');

							$(this).parent().siblings().children('a').removeClass('clicked');

						});

					});

					$('body').on('change', '.variations select', function(){

						var src = $('div.images img:eq(0)').attr('src');

						var nav_src = src.replace('570x570','100x80');

						$('.reload-button-link').attr('href',src);

						if ( main_src != src) {

							$('.navs img:eq(0)').trigger('click');

						};

						$.ajax({

						    url: nav_src,

						    type:'HEAD',

						    error: function()

						    {

						        //file not exists

						        $('.navs img:eq(0)').attr('src',src);

						    },

						    success: function()

						    {

						        //file exists

						        $('.navs img:eq(0)').attr('src',nav_src);

						    }

						});

					});

					

				});

			})(jQuery);

		</script>

</div><!--end:single-product-image-wrap-->

<?php //do_action( 'woocommerce_product_thumbnails' ); ?>