<?php

/**

 * Single Product Rating

 *

 * @author 		WooThemes

 * @package 	WooCommerce/Templates

 * @version     3.1.0

 */



if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



global $product;



if ( get_option( 'woocommerce_enable_review_rating' ) === 'no' )

	return;



$count   = $product->get_rating_count();

$average = $product->get_average_rating();



if ( $count > 0 ) : ?>



	<div class="woocommerce-product-rating" itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">

		<div class="star-rating" title="<?php printf( esc_html__( 'Rated %s out of 5', 'skstore' ), $average ); ?>">

			<span style="width:<?php echo ( ( $average / 5 ) * 100 ); ?>%"></span>

		</div>

	</div>



<?php endif; ?>