<?php

/**

 * Related Products

 *

 * @author 		WooThemes

 * @package 	WooCommerce/Templates

 * @version     3.0.0

 */



if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



global $product, $woocommerce_loop, $smof_data;



if ( empty( $product ) || ! $product->exists() ) {

	return;

}



$related = wc_get_related_products( $product->get_id(), 12 );



if ( sizeof( $related ) == 0 ) return;



$number = $smof_data['shop-related-products-number'];

$number_tablet = $smof_data['shop-related-products-number-tablet'];

$number_mobile = $smof_data['shop-related-products-number-mobile'];



$args = apply_filters( 'woocommerce_related_products_args', array(

	'post_type'            => 'product',

	'ignore_sticky_posts'  => 1,

	'no_found_rows'        => 1,

	'posts_per_page'       => 8,

	'orderby'              => $orderby,

	'post__in'             => $related,

	'post__not_in'         => array( $product->get_id() )

) );



$products = new WP_Query( $args );



$woocommerce_loop['columns'] = $columns;



if ( $products->have_posts() ) : ?>



	<div class="product-related columns-<?php echo esc_html( $number ); ?>">

		<?php woocommerce_product_loop_start();

		?>

		<div class="k2t-heading-img">

			<div class="img">

				<span class="fist-sk">.</span>

				<span class="last-sk">.</span>

			</div>

		</div>

		<div class="text-heading">

			<h2><?php esc_html_e( 'Related', 'skstore' ); ?><span class="heading-style"> Products </span></h2>

		</div>

		

		<div class="k2t-isotope-wrapper isotope-4-columns isotope-gallery isotope-sk">

			<div class="article-loop k2t-isotope-container loaded" >

				<div class="gutter-sizer"></div>

				<?php while ( $products->have_posts() ) : $products->the_post(); ?>



					<?php wc_get_template_part( 'content', 'product' ); ?>



				<?php endwhile; // end of the loop. ?>

			</div> <!-- end article-loop !-->

		</div> <!-- end k2t-isotope-wrapper !-->



		<?php woocommerce_product_loop_end(); ?>



	</div>



<?php endif;



wp_reset_query();

