/**

 * Custom script for skstore.

 *

 * @package skstore

 * @author  SunriseTheme

 * @link	http://www.sunrisetheme.com

 */

 

(function($) {

	"use strict";



	$(document).ready(function() {



		// remove envato bar 

		//if (top != self) top.location.replace(self.location.href);



		/*  [ Detecting Mobile Devices ]

		- - - - - - - - - - - - - - - - - - - - */

		var isMobile = {

			Android: function() {

				return navigator.userAgent.match(/Android/i);

			},

			BlackBerry: function() {

				return navigator.userAgent.match(/BlackBerry/i);

			},

			iOS: function() {

				return navigator.userAgent.match(/iPhone|iPad|iPod/i);

			},

			Opera: function() {

				return navigator.userAgent.match(/Opera Mini/i);

			},

			Windows: function() {

				return navigator.userAgent.match(/IEMobile/i) || navigator.userAgent.match(/WPDesktop/i);

			},

			Desktop: function() {

				return window.innerWidth <= 960;

			},

			any: function() {

				return ( isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows() || isMobile.Desktop() );

			}

		}



		/*  [ Add product shortcode title ]

		- - - - - - - - - - - - - - - - - - - - */

		if ( $( '.product-heading' ).length ) {

			$( '.product-heading' ).addClass( 'isotope-selector product' );

			$( '.product-heading' ).prependTo( $( ".products" ) );

		}



		// get height for header vertical



		function resize_header(){

			var $rev = $('.rev_slider_wrapper').height();

			$('.k2t-header.header-vertical .k2t-header-mid .k2t-row').css('height',$rev);

		}

		resize_header();

		window.onresize = function(event) {

			resize_header();

		};



		// product grid home 1

		

		var $dhvc_woo = $('.grid-2-columns .dhvc-woo-grid-item').height();

		var $dhvc_woo_h = $('.dhvc-woo.grid-1-columns .dhvc-woo-item').css('height', 2*$dhvc_woo + 30);

		window.onresize = function(event) {

			$('.dhvc-woo.grid-1-columns .dhvc-woo-item.dhvc-woo-grid-item').css('height', 2*$dhvc_woo + 30);

		};



		// window scroll switch menu horizontal



		if( $('.k2t-header').hasClass('header-vertical') ){

			$(window).bind('scroll', function () {

				if( $(window).scrollTop() > $('.rev_slider_wrapper').height() ){

					$('.k2t-header.header-vertical').removeClass('header-vertical');

					$('.k2t-header').addClass('header-horizontal');

					$('.header-social-share').css('display','none');

					$('.k2t-header.header-horizontal .k2t-header-mid .k2t-row-mid').css('height','auto');

				}

				else{

					$('.k2t-header.header-horizontal').removeClass('header-horizontal');

					$('.k2t-header').addClass('header-vertical');

					$('.header-social-share').css('display','block');

					$('.k2t-header.header-vertical .k2t-header-mid .k2t-row-mid').css('height', $('.rev_slider_wrapper').height() );

				}

			})

		}



		/* Add to cart product */



		$('.add_to_cart_button').on('click',function(){

			// start add class and show shop cart

			var onclick = setInterval(function() {

				$('.shop-item').addClass('active');

			}, 4500);

			setInterval(function(){

				// remove timer and class active

				clearInterval( onclick );

				$('.shop-item').removeClass('active');

			}, 8000);

		});



        $(window).bind('scroll', function () {

            if ($(window).scrollTop() > 50) {

                $('body').addClass('scroll-dow');

            }

            else $('body').removeClass('scroll-dow');

        });



		// fancybox

		if ( $().fancybox){

			$(".click-view").fancybox({

				openEffect	: 'elastic',

				closeEffect	: 'elastic',

				padding : 0,

		    });

		}



		// Quick view

		$('.dhvc-woo-quickview').find('a').addClass('yith-wcqv-button');

		

		/*  [ Sticky menu trigger ]

		- - - - - - - - - - - - - - - - - - - - */

		if ( true ) {

			if ( mainParams.sticky_menu == 'sticky_top' ) {

				var nav = $(".k2t-header-top");

				var waypoint_offset = 20;

			} else if ( mainParams.sticky_menu == 'sticky_mid' ) {

				var nav = $(".k2t-header-mid");

				var waypoint_offset = 50;

			} else if ( mainParams.sticky_menu == 'sticky_bot' ) {

				var nav = $(".k2t-header-bot");

				var waypoint_offset = 30;

			}

			if ( mainParams.sticky_menu == 'sticky_top' || mainParams.sticky_menu == 'sticky_mid' || mainParams.sticky_menu == 'sticky_bot' ) {

				var container = $( '.k2t-header' );

				var top_spacing = 0;

				container.waypoint({

					handler: function (event, direction) {

						if ( direction == 'down' ) {

							container.css({

								'height': nav.outerHeight()

							});

							nav.stop().addClass('sticky').css('top', - nav.outerHeight() ).animate({

								'top': top_spacing

							});

							$('body').addClass('header-sticky');

						} else {

							container.css({

								'height': 'auto'

							});

							nav.stop().removeClass('sticky').css('top', nav.outerHeight() + waypoint_offset).animate({

								'top': ''

							});

							$('body').removeClass('header-sticky');

						}

					},

					offset: function () {

						return - nav.outerHeight() - waypoint_offset;

					}

				});

			}

		}



		/*  [ Vertical header ]

		- - - - - - - - - - - - - - - - - - - - */

		$('#showPushMenu').on('click', function() {

			if ( mainParams.vertical_menu == '1' ){

				$('body').toggleClass('vertical-close');

			}

			return false;

		});



		/*  [ Custom RTL Menu ]

		- - - - - - - - - - - - - - - - - - - - */

		if ( ! isMobile.any() ) {

			$( '.sub-menu li' ).on( 'hover', function () {

				var sub_menu = $( this ).find( ' > .sub-menu' );

				if ( sub_menu.length ) {

					if ( sub_menu.outerWidth() > ( $( window ).outerWidth() - sub_menu.offset().left ) ) {

						$( this ).addClass( 'menu-rtl' );

					}

				}

			});

		}



		/*  [ Back to top ]

		- - - - - - - - - - - - - - - - - - - - */

		$(window).scroll(function () {

			if ($(this).scrollTop() > 50) {

				$('.k2t-btt').fadeIn('slow');

			} else {

				$('.k2t-btt').fadeOut('slow');

			}

		});

		$( '.k2t-btt' ).on( 'click', function () {

			$("html, body").animate({

				scrollTop: 0

			}, 500);

			return false;

		});



		/*  [ Scroll to Next Section ]

		- - - - - - - - - - - - - - - - - - - - */



		if ( $( '.k2t-scrolldown' ).length ) {

			$( '.k2t-scrolldown' ).on( 'click', function() {

				var nextSection = $(this).closest('.vc_row').next('.vc_row');

				$("html, body").animate({

					scrollTop: nextSection.offset().top

				}, 500);

				return false;

			});

		}





		/*  [ Offcanvas Sidebar ]

		- - - - - - - - - - - - - - - - - - - - */

		$( '.open-sidebar' ).on( 'click', function() {

			//if ( mainParams.offcanvas_turnon == '1' ){

				$( 'body' ).toggleClass( 'offcanvas-open' );

				$( '.offcanvas-sidebar' ).toggleClass( 'is-open' );

				$(this).toggleClass( 'close-sidebar' );

			//}

			//return false;

		});



		$( '.k2t-container' ).on( 'click', function(e) {

			if ($(e.target).hasClass( 'open-sidebar' ) || $(e.target).closest( '.open-sidebar' ).length > 0 ) {

				return;

			}

			$( 'body' ).removeClass( 'offcanvas-open' );

			$( '.offcanvas-sidebar' ).removeClass( 'is-open' );

			$( '.open-sidebar' ).removeClass( 'close-sidebar' );

		});



		$('.offcanvas-sidebar .k2t-sidebar ul li').on("click", function(){

			if ($(this).find('ul') && $(this).find('ul').hasClass('k2t-active')){

				$(this).find('ul').removeClass('k2t-active');

				$(this).removeClass('k2t-active');

			}else {

				$(this).find('ul').addClass('k2t-active');

				$(this).addClass('k2t-active');

			}

		});



		/*  [ Search Box ]

		- - - - - - - - - - - - - - - - - - - - */

		$('.search-box.style-1 i').on('click', function(e) {    

			e.stopPropagation();

			var search_form = $( '.k2t-searchbox' );                

			$('.k2t-searchbox').addClass('active');

			$('.k2t-searchbox > form > input[type="search"]').focus();

		});            

		$('.k2t-searchbox').on('click', function(e) {

			if (event.target == this) {

				$(this).removeClass('active');

			}

		});            



		$( '.k2t-header-m .search-box i' ).click(function(e) {

			e.stopPropagation();

			var search_form = $( '.k2t-searchbox' );                

			$('.k2t-searchbox').addClass('active');

			$('.k2t-searchbox > form > input[type="search"]').focus();

		});            

		$('.k2t-searchbox').on('click', function(e) {

			if (event.target == this) {

				$(this).removeClass('active');

			}

		});



		/*  [ Ajax login ]

		- - - - - - - - - - - - - - - - - - - - */

		$( '.not-a-member-handle' ).html( 'Register' );



		/*  [ VC Alert close ]

		- - - - - - - - - - - - - - - - - - - - */

		$( '.wpb_alert .close' ).on( 'click', function(){

			var parent = $(this).parent();

			parent.css({"opacity":"0", "height":"0", "padding":"0", "margin":"0"});

		});



		/*  [ Mobile menu ] 

		- - - - - - - - - - - - - - - - - - - - */

		$('.hamburger').on('click',function(){

			$(this).toggleClass('is-active');

		});



		$('.mobile-menu-toggle').on("click", function(e) {

			e.stopPropagation();

			$(this).toggleClass('active');

			$('.mobile-menu-wrap').toggleClass('active');

			$(this).find('.main-mm-trigger').each(function(){

				if( $(this).hasClass('is-active') ) {

						setTimeout(function(){

							$('.main-mm-trigger').css('opacity','0');

							$(this).css('position','fixed');

						}, 300)

					}

				else {

					$(this).css('position','relative');

					$('.main-mm-trigger').css('opacity','1');

				}

			});

			$('.mobile-menu-wrap .hamburger ').addClass('is-active');

	    });

	    $('body').on('click',function(){

	    	$('.mobile-menu-wrap').removeClass('active');

	    	$('.mobile-menu-toggle').removeClass('active');

	    	$('.mobile-menu-toggle .hamburger').removeClass('is-active');

	    	$('.main-mm-trigger').each(function(){

				$(this).css('position','relative');

				$('.main-mm-trigger').css('opacity','1');

			});

	    });



	    // open sub menu



		$('.menu-item-has-children > .wrap-link-item .open-sub-menu').on('click', function(e){

			e.stopPropagation();

			var $parent = $(this).parent().parent();

			$(this).toggleClass('active');

			$parent.children('.sub-menu').slideToggle();

		})



		$(".mobile-menu .menu-item-has-children ").find('a').on('click',function(e){

			if ( $(this).attr('href') == '#' || typeof( $(this).attr('href') ) == '') {

				e.stopPropagation();

				var $parent = $(this).parent().parent();

				$(this).toggleClass('active');

				$parent.children('.sub-menu').slideToggle();

			};

		});



		// prevent parent element scroll



		$(".mobile-menu-wrap").bind('mousewheel', function(e, d)  {

		    var t = $(this);

		    if (d > 0 && t.scrollTop() === 0) {

		        e.preventDefault();

		    }

		    else {

		        if (d < 0 && (t.scrollTop() == t.get(0).scrollHeight - t.innerHeight())) {

		            e.preventDefault();

		        }

		    }

		})



		/* ============= End Menu Mobile ====================*/



		// Isotope

		if ( $().masonry && $().isotope && $().imagesLoaded ) {

			

			$( '.k2t-isotope-wrapper' ).each( function() {



				var $this = $(this);

				var $container = $this.find('.k2t-isotope-container');

				

				// initialize Isotope + Masonry after all images have loaded  

				$this.imagesLoaded( function() {



					$container.addClass('loaded').find('.isotope-selector').find('.article-inner');

					var isotope_args = {

						itemSelector: '.isotope-selector',

						transitionDuration	: '.55s',

						masonry: {

							gutter	: '.gutter-sizer',

							//columnWidth: 

						},

					};

					if ($this.hasClass('isotope-sk')) {

						isotope_args['layoutMode'] = 'fitRows';

					}

					if ($this.hasClass('isotope-no-padding')) {

						delete isotope_args.masonry.gutter; //true

					}

					if ($this.hasClass('isotope-free')) {

						isotope_args.masonry['columnWidth'] = '.width-1';

					}

					var $sk = $container.isotope(isotope_args);

					

					// animation

					var animation = $sk.data('animation');

					if (animation = true) {

						$container.find('.isotope-selector').find('.article-inner').each(function(){

							var $this=$(this);

							$this.parent().one('inview', function(event, isInView, visiblePartX, visiblePartY) {

								if (isInView) {

									$this.addClass('run_animation');

								} // inview						  

							});// bind

						}); // each

							

					} // endif animation

					

					// filter items when filter link is clicked

					$this.find('.cd-dropdown').find('span').click(function(){

						if ( $(this).parent().parent().parent().hasClass('cd-active') ){

                            var selector = $(this).attr('class');

                            $container.isotope({

                                filter: selector,

                            });

                        }

					});

					

				}); // imagesLoaded

				

			}); // each .k2t-isotope-wrapper

		} // if isotope



		/*  [ Performs a smooth page scroll to an anchor ]

		- - - - - - - - - - - - - - - - - - - - */

		$('.scroll').click(function() {

			if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {

				var target = $(this.hash),

				headerH = $('.k2t-header').outerHeight();



				target = target.length ? target : $('[name=' + this.hash.slice(1) +']');

				if (target.length) {

					$('html,body').animate({

						scrollTop: target.offset().top - 170 + "px"

					}, 1200);

					return false;

			   }

		   }

		});



		var $logoImg = $('.k2t-logo img');

		if ( $logoImg.css( 'min-height' ) == '1px' ) {

			$logoImg.attr( 'src', $logoImg.attr( 'src' ).replace( 'logo.png', 'logo@2x.png' ) );

		}



	});



	$(window).load(function() {



		/*  [ Page loader effect ]

		- - - - - - - - - - - - - - - - - - - - */

		$( '#loader' ).delay(600).fadeOut();

		$( '#loader-wrapper' ).delay(600).fadeOut( 'slow' );

		setTimeout(function(){

			$( '#loader-wrapper' ).remove();

		}, 800);



		

		/*  [ Menu One Page ]

		- - - - - - - - - - - - - - - - - - - - */

		var headerH = $(".k2t-header-mid").height();

		var adminbar = $("#wpadminbar").height();

		if (!adminbar) adminbar = 0;

		function i() {

			var e = "";

			var t = "";

			$(".k2t-header .k2t-menu > li").each(function(e) {

				var n = $(this).find("a").attr("href");

				var r = $(this).find("a").attr("data-target");

				if ($(r).length > 0 && $(r).position().top - headerH <= $(document).scrollTop()) {

					t = r

				}

			});

		}

		

		var n = 1e3;

		var r = "#" + $(".k2t-content").attr("id");

		$("body").on("click", ".k2t-header .k2t-menu > li > a", function() {

			var e = $(this).attr("href");

			var i = $(this).attr("data-target");



			$(".k2t-header .k2t-menu > li").each(function(){

				$(this).removeClass("active");

			});

			$(this).parent("li").addClass("active");

			if (e.charAt(0) == "#") {

				i = e

			}

			if ($(i).length > 0) {

				if (e == r) {

					$("html,body").animate({

						scrollTop: 0

					}, n, "easeInOutQuart")

				} else {

					$("html,body").animate({

						scrollTop: $(i).offset().top - headerH - adminbar

					}, n, "easeInOutQuart")

				}

				return false

			}

		});

		

		i();

		

		

		/*  [ Woocommerce CheckOut Labels ]

		- - - - - - - - - - - - - - - - - - - - */

		var placeholderInput = [$("#commentform :input"), $("#commentform textarea"), $(".woocommerce-billing-fields :input"), $(".woocommerce-shipping-fields :input")];

		placeholderInput.forEach(function(entry)  {

			if ( entry.length > 0 ) { 

				entry.each(function(index, elem) {

					var eId = $(elem).attr("id");

					var label = null;

					if ( eId && (label = $(elem).parents("form").find("label[for="+eId+"]")).length == 1 ) {

					    $(elem).attr("placeholder", $(label).text());

					    $(label).remove();

					}

				});

			};

		});



		/* Set cookie for change product layout

		- - - - - - - - - - - - - - - - - - - - */

		

		jQuery('.pageviewitem').not('.active').click(function () {

			if (jQuery.cookie('product-view') != '') {

				jQuery.cookie('product-view', jQuery(this).attr('data-view'));

				document.location.reload();

			}

		});

		

		/* Subscribe Form Placeholder

		- - - - - - - - - - - - - - - - - - - -  */

		var subForm = $('.widgetGuts.shortcode form');

		if ( subForm.length ) {

			subForm.removeAttr('id');

			subForm.addClass("frm-subscriptionFront");

			$(".frm-subscriptionFront .text").attr("placeholder", "Your Email");

			$(".frm-subscriptionFront .text").removeAttr('id');



		}



		/*  [ Blog masonry trigger ]

		- - - - - - - - - - - - - - - - - - - - */

		if ( $('.b-masonry .masonry-layout').length > 0 ){

			var container = document.querySelector('.b-masonry .masonry-layout');

			var msnry = new Masonry( container, {

				itemSelector: '.hentry',

				columnWidth: container.querySelector('.sk-sizer'),

				gutter: 0

			});

		}

	});

})(jQuery);

