<?php
/**
 * Shortcode banner.
 *
 * @since  1.0
 * @author SunriseTheme
 * @link   http://www.sunrisetheme.com
 */

if ( ! function_exists('k2t_banner_shortcode')){
	function k2t_banner_shortcode( $atts, $content ){
		$html = $image = $link = $text_box = $text_size = $color = $banner_hover = $border = $border_width = $border_style = $style = $border_html = $border_color  = $anm = $anm_name = $anm_delay = $data_name = $data_delay = $id = $class = '';
		  extract( shortcode_atts( array(
		    'link'			=> '',
		    'text_box' 		=> '',
		    'text_size'		=> '',
		    'color'			=> '',
		    'banner_hover' 	=> '',
		    'border' 		=> '',
		    'border_width'	=> '1',
		    'border_style'	=> 'dashed',
		    'border_color'	=> '#fff',
		    'style'			=> '',
		    'image' 		=> '', // Set default value
		    'parallax' 		=> '',
		    'anm'         	=> '',
			'anm_name'    	=> '',
			'anm_delay'   	=> '',
			'id'          	=> '',
			'class'       	=> '',
		  ), $atts ) );

		  ob_start();
		
   		if ( !empty( $content ) ) {
   			$content = do_shortcode( $content );
   		} else {
   			$content = '<a class="round-border" href="' . esc_url( $link ). '">
	                		<span class="text-box" style="font-size: ' . $text_size .'px; color: ' . $color . '">'. $text_box .'</span>
	                	</a>';
   		}
		// Global $cl
		$cl = array( 'banner-sc' );
		// Animation
		if ( $anm ) {
			$anm        = ' animated';
			$data_name  = ' data-animation="' . $anm_name . '"';
			$data_delay = ' data-animation-delay="' . $anm_delay . '"';
		}
		$id    = ( $id != '' ) ? ' id="' . $id . '"' : '';

		if ( $border == "1" ) {
			$border_html = 'style="border: '. $border_width . 'px ' . $border_style . ' ' . $border_color. '"';
		}
			
		// Apply filters to cl
		$cl = apply_filters( 'k2t_banner_classes', $cl );
		if ( !empty ( $style ) ) $cl[] .= $style;
		
		// Join cl class
		$cl = join( ' ', $cl );

		/*-----------Image-------------*/
		if ( trim( $image ) != '' ) {
			$image_id       = preg_replace( '/[^\d]/', '', $image );
			$img            = wpb_getImageBySize( array( 'attach_id' => $image_id, 'thumb_size' => '' ) );
			$image_html = '<img src="' . esc_attr( trim( $img['p_img_large'][0] ) ) . '" alt="image" />';
		}
		
		// Output to frontend
		$html = '<div ' . $id . $data_name . $data_delay . ' class="' . trim( $cl ) . $anm . '">';
		$html .= '
			<article>
            	<div class="banner-box">
               	'. $image_html .'
                </div>
                <div class="banner-content ' . $banner_hover . '">
                	<div class="banner-border" ' . $border_html . '>
		                <div class="banner-content-inner">
		                	' . $content . '
		                </div>
	                </div>
                </div>
            </article>
		';
		$html .= '</div>';
		

		//Apply filters return
		$return = apply_filters('k2t_i_return', $html);
		
		return $return;
	}
}