<?php
/**
 * Shortcode k2t slider.
 *
 * @since  1.0
 * @author SunriseTheme
 * @link   http://www.sunrisetheme.com
 */

if ( ! function_exists( 'k2t_blog_post_shortcode' ) ) {
	function k2t_blog_post_shortcode( $atts, $content ) {
		$html = $i = $style = $cat = $script = $limit = $slider_open = $slider_close = $items = $items_desktop = $items_tablet = $items_mobile = $navigation = $pagination = $p_class = $anm = $anm_name = $anm_delay = $id = $class = $rows_num = '';
		extract( shortcode_atts( array(
			'style'         => '2',
			'thumb_align'	=> 'top',
			'limit'	        => '-1',
			'cat'           => '0',
			'slider'        => '',
			'items'         => '',
			'rows_num'      => '1',
			'show_content'  => '',
			'items_desktop' => '4',
			'items_tablet'  => '2',
			'items_mobile'  => '1',
			'navigation'    => '',
			'pagination'    => '',
			'row'			=> '',
			'auto_play'     => '',
			'anm'           => '',
			'anm_name'      => '',
			'anm_delay'     => '',
			'id'            => '',
			'class'         => '',
		), $atts));

	$id    = ( $id != '' ) ? ' id="' . $id . '"' : '';
	$class = ( $class != '' ) ? ' ' . $class . '' : '';

	wp_enqueue_script( 'k2t-owlcarousel' );
	// Global variables
	global $post, $smof_data;
	if ( $style == '3') {
		$limit == '4';
	}elseif ($style == '4') {
		$limit == '4';
	}
	// Filter post type
	$args = array(
		'post_type'      => 'post',
		'posts_per_page' => $limit,
		'cat'            => $cat,
	);
	// The query
	$blog = new WP_query( $args );
	if ( $slider && ( '2' == $style ) ) {
		// Generate random id
		$length = 10;
		$ids     = substr( str_shuffle( "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ" ), 0, $length );
		if ( $pagination ) { $p_class = 'pagi-bottm'; } else { $p_class = ''; }
		$slider_open = '<div id="' . $ids . '" class="post-slider '. $p_class .'">';
		$slider_close = '</div>';
		
		// Set param for carousel
		$auto_play = ( $auto_play ) ? 'autoPlay: true,' : '';
		$navigation = ( $navigation ) ? 'nav: true,' : 'nav: false,';
		$pagination = ( $pagination ) ? 'dots: true,' : 'dots: false,';
		$script .= '<scr' . 'ipt>
			(function($) {
				"use strict";
				$(document).ready(function() {				
					$("#' . $ids . '").owlCarousel({
						loop: true,
    					margin: 30,
    					responsive:{
					        1199:{
					            items:' . $items_desktop . ',
					        },
					        979:{
					            items:' . $items_desktop . ',
					        },
					        768:{
					            items:' . $items_tablet . ',
					        },
					        479:{
					            items:' . $items_mobile . ',
					        },
					        0:{
					            items: ' . $items_mobile . ',
					        },
					    }, 
					    navText: ["<i class=\"fa fa-chevron-left\"></i>", "<i class=\"fa fa-chevron-right\"></i>"],
					    ' . $navigation . $pagination .'
					});
				});
			})(jQuery);
		</scr' . 'ipt>';
	}
	$html .= $slider_open;
	if ( '1' == $style ) {

		wp_enqueue_script( 'masonry-min' );

		$html .= '<div class="b-masonry">';
		$html .= '<div class="masonry-layout column-2">';
		$html .= '<div class="sk-sizer"></div>';
		
		while ( $blog->have_posts() ) : $blog->the_post();
			ob_start();
				include 'tmpl/blog/content-masonry.php';
			$html .= ob_get_clean();
		endwhile;
		$html .= '</div><div>';

		$html .= '
			<scr'.'ipt>
			(function($) {
				"use strict";
				$(window).load(function() {
					var container = document.querySelector(".b-masonry .masonry-layout");
					var msnry = new Masonry( container, {
						itemSelector: ".hentry",
						columnWidth: container.querySelector(".sk-sizer")
					});
				});
			})(jQuery);
			</scr'.'ipt>
		';

		$html .= '</div></div>';

		// Restore original Post Data
		wp_reset_postdata();

	} elseif ( '2' == $style ) {
		while ( $blog->have_posts() ) : $blog->the_post();
			ob_start();
			$title 				= get_the_title();
			$thumb_link 		= wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) );
			$thumb 				= aq_resize( $thumb_link, 500, 479, true );
			$post_format 		= get_post_format();
			$thumb_html 		= ( has_post_thumbnail() ) ? '<img width="386" height="370" src="'. $thumb .'" alt="'. $title .'" />' : '<img width="500" height="333" src="'. esc_url( plugin_dir_url( __FILE__ ) . '../images/thumb-500x333.png' ) .'" alt="'. $title .'" />';
			$url = get_permalink(get_the_ID());
		    ?>
				<article class="article isotope-selector entry-item <?php echo esc_attr( implode( ' ', get_post_class( 'k2t-blog-post k2t-blog-post-' . $style ) ) ) . esc_attr( $class ) ?>">
					<div class="entry-box">
						<div class="entry-thumb">
							<?php if ( has_post_thumbnail() ) {
									the_post_thumbnail( 'thumb_500x479' );
								} ?>
						</div>
						<div class="entry-content">
							<header>
								<h5 class="entry-title"><a href="<?php echo get_permalink() ?>" title="<?php echo esc_attr( $title ); ?>" href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( truncate( $title, '150' ) );?></a></h5>
								<div class="post-meta">
									<div class="post-meta-left">
										<?php if ( $smof_data['blog-date'] ): ?>
											<span data-time="<?php echo esc_attr( get_the_date( 'c' ) ) ?>" class="entry-date"><?php the_time( 'j M, Y' ); ?></span>
										<?php endif;?>
									</div>
								</div>
							</header>
							<?php
								$excerpt = $blog->post->post_excerpt;
								if ( ! empty( $excerpt ) )
									echo '<p>' . $excerpt . '</p>';
								else {
									echo $trimmed_content = '<p>' . wp_trim_words( get_the_content(), $smof_data['excerpt-length'] ) . '</p>';
								}
							?>
						</div>
					</div>
				</article>
			<?php
			$html .= ob_get_clean();
		endwhile;
		// Restore original Post Data
		wp_reset_postdata();

	} elseif ( '3' == $style ) {
		$html .= '<div class="b-style-3">';
		ob_start();
		while ( $blog->have_posts() ) : $blog->the_post();
			
				if ( $blog->current_post == 1 ) 
					echo '<div class="blog-article-col2 thumb-height">';// group item 1 and item 2;

				if ( $blog->current_post == 3 ) $blog_style_3_last_item = true;  // flag to get size image of 3 item;

				include 'tmpl/blog/content-style-3.php';

				if ( $blog->current_post == 2 ) 
					echo '</div>';	// end group item;
		endwhile;
		$html .= ob_get_clean();
		$html .= '</div>'; //end b-style-3
	} elseif ( '4' == $style ) {
		$html .= '<div class="b-style-4">';
		ob_start();
		while ( $blog->have_posts() ) : $blog->the_post();
			
				if ( $blog->current_post == 1 ) 
					echo '<div class="blog-article-col2 thumb-height article-style-4 ">';// group item 1 and item 2;

				if ( $blog->current_post == 3 ) $blog_style_4_last_item = true;  // flag to get size image of 3 item;

				include 'tmpl/blog/content-style-3.php';

				if ( $blog->current_post == 2 ) 
					echo '</div>';	// end group item;
		endwhile;
		$html .= ob_get_clean();
		$html .= '</div>'; //end b-style-4
	} elseif ( '5' == $style ) {
		$html .= '<div class="b-style-5">';
		ob_start();
		while ( $blog->have_posts() ) : $blog->the_post();
			
			$blog_index = $blog->current_post % 3;
			if ( $blog->current_post % 3 == 1 ) echo '<div class="group-item">';

			include 'tmpl/blog/content-masonry.php';

			if ( $blog->current_post % 3 == 2 ) echo '</div>';

		endwhile;
		$html .= ob_get_clean();
		$html .= '</div>'; //end b-style-5
	}


	$html .= $slider_close;

	// Apply filters return
	$html = apply_filters( 'k2t_blog_post_return', $html );
	return $html . $script;
	}
}