<?php
/**
 * Shortcode icon box.
 *
 * @since  1.0
 * @author SunriseTheme
 * @link   http://www.sunrisetheme.com
 */

if ( ! function_exists( 'k2t_iconbox_shortcode' ) ) {
	function k2t_iconbox_shortcode( $atts, $content ) {
		$html = $layout = $title = $icon_html = $fontsize = $border = $color = $text_transform = $icon_type = $graphic = $icon_bg = $icon = $link = $link_text = $anm = $anm_name = $anm_delay = $data_name = $data_delay = $id = $class = $padding_layout_3 = $image_link = '';
		extract( shortcode_atts( array(
			'layout'             		=> '1',
			'title'              		=> '',
			'fontsize'           		=> '',
			'color'              		=> '',
			'text_transform'     		=> 'inherit',
			'icon_type'          		=> '',
			'graphic'            		=> $graphic,
			'icon'               		=> '',
			'icon_font_size'     		=> '',
			'icon_color'         		=> '',
			'link'               		=> '',
			'link_text'          		=> 'Learn more &gt;',
			'border'               		=> '',
			'mgt'                		=> '',
			'mgr'                		=> '',
			'mgb'                		=> '',
			'mgl'                		=> '',
			'anm'                		=> '',
			'anm_name'           		=> '',
			'anm_delay'          		=> '',
			'id'                 		=> '',
			'class'              		=> '',
		), $atts ) );

		//Global $cl
		$cl = array( 'k2t-iconbox' );

		if ( $anm ) {
			$anm        				= ' animated';
			$data_name  				= ' data-animation="' . $anm_name . '"';
			$data_delay 				= ' data-animation-delay="' . $anm_delay . '"';
		}
		$id    							= ( $id != '' ) ? ' id="' . $id . '"' : '';
		$class 							= ( $class != '' ) ? ' ' . $class . '' : '';
		$mgt   							= ( $mgt != '' ) ? 'margin-top: ' . $mgt . 'px;' : '';
		$mgr   							= ( $mgr != '' ) ? 'margin-right: ' . $mgr . 'px;' : '';
		$mgb   							= ( $mgb != '' ) ? 'margin-bottom: ' . $mgb . 'px;' : '';
		$mgl   							= ( $mgl != '' ) ? 'margin-left: ' . $mgl . 'px;' : '';

		// Get icon graphics
		$graphic_id  					= preg_replace( '/[^\d]/', '', $graphic );
		$img         					= ( ! empty( $graphic_id ) && function_exists('wpb_getImageBySize') ) ? wpb_getImageBySize( array( 'attach_id' => $graphic_id, 'thumb_size' => '' ) ) : array();
		$image_link  					= ( ! empty( $img ) ) ? $img['p_img_large'][0] : '';
		$data       					= ! empty( $image_link ) ? getimagesize( $image_link ) : array( 'auto', 'auto' );
		$width      					= isset( $data[0] ) ? $data[0] : '';
		$height     					= isset( $data[1] ) ? $data[1] : '';

		// Layout
		if ( ! empty( $layout ) ) { $cl[] = 'layout-' . trim( $layout ); } else { $cl[] = 'layout-1'; }

		// Select icon type

		if ( 'graphics' == $icon_type ) {
			$icon_html .= '<div class="iconbox-image"><img width="' . $width . '" height="' . $height . '" src="' . $image_link . '" alt="' . $title . '" /></div>';
		} elseif ( 'no_icon' == $icon_type ) {
			$icon_html = '';
		}elseif( 'background_icon' == $icon_type ){
			$icon_html .= '<div class="iconbox-image iconbox-background" style="background-image:url('. $image_link .')"></div>';
		} else {
			$icon_css = array();

			// Icon font size
			$icon_font_size = ( $icon_font_size != '' ) ? 'font-size: ' . $icon_font_size . 'px;' : '';

			// Icon color
			if ( $icon_color ) { $icon_css[] = 'color: ' . trim( $icon_color ); }

			// HTML output of icon
			$icon_html = '<div class="iconbox-icon ' . $icon_bg . '" style="' . implode( ';', $icon_css ) . '"><i style="'. $icon_font_size .'" class="' . trim( $icon ) . '"></i></div>';
		}
		
		// Text link
		if ( trim( $link_text ) == '' ) { $link_text = 'Learn more &gt;'; } else { $link_text = trim( $link_text ); }

		$link_html = ! empty( $link ) ? '<div class="learnmore"><a href="' . esc_url( trim( $link ) ) . '">' . $link_text . ' &gt;</a></div>' : '';

		// Title
		$color 				= ( $color != '' ) ? 'color: ' . $color . ';' : '';
		$fontsize 			= ( $fontsize != '' ) ? 'font-size: ' . $fontsize . 'px; line-height: ' . $fontsize . 'px;' : '';
		$text_transform 	= ( $text_transform != '' ) ? 'text-transform: ' . $text_transform . ';' : '';
		if ( trim( $title ) == '' ) { $title_html = ''; } else { $title_html = '<div class="title"><h3 style="' . $color . $text_transform . $fontsize . $padding_layout_3 . '" class="h">' . trim( $title ) . '</h3></div>'; }

		//Border 
		if ( $border != 'none' ) $cl[] .= $border;

		// Apply filters to cl
		$cl = apply_filters( 'k2t_iconbox_classes', $cl );

		// Join cl class
		$cl = join( ' ', $cl );

		$html = '<div class="' . trim( $cl ). $anm . $class . '" ' . $data_name . $data_delay . $id . ' style="' . $mgt . $mgr . $mgb . $mgl . '">';
		$html .= do_action( 'k2t_iconbox_open' );
		$html .= $icon_html . '<div class="iconbox-text ' . $icon_type . '">' . $title_html . '<div class="desc">' . do_shortcode( $content ) . '</div>' . $link_html . '</div>';
		$html .= do_action( 'k2t_iconbox_close' );
		$html .= '</div>';

		// Apply filters return
		$html = apply_filters( 'k2t_iconbox_return', $html );

		return $html;
	}
}
