<?php
/**
 * The template for displaying content masonry.
 *
 * @package skstore
 * @author  SunriseTheme
 * @link	http://www.sunrisetheme.com
 */

// Get theme options
global $smof_data, $post;

// Get all categories of post
$post_categories = wp_get_post_categories( get_the_ID() );
$post_categories_html = '';
if ( count( $post_categories ) > 0 ){
	foreach ($post_categories as $key => $value) {
		$category_name = get_the_category_by_ID( $value );
		$category_link = get_category_link( $value );
		if ( $key == 0 ){
			$post_categories_html .= '<a href="'. $category_link .'">'. $category_name .'</a>';
		}else{
			$post_categories_html .= ', <a href="'. $category_link .'">'. $category_name .'</a>';
		}
	}
}

// Get post format
$post_format = get_post_format();
$link        = ( function_exists( 'get_field' ) ) ? get_field( 'link_format_url', get_the_ID() ) : '';
$large       = ( function_exists( 'get_field' ) ) ? get_field( 'post_large', get_the_ID() ) : '';
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'element hentry post-item ' . $post_format . '-post' ); ?>>
    <?php include 'post-format.php'; ?>
    <?php if ( $post_format != 'quote' ): ?>
    	<header>
    		<?php 
    			if ( 'link' == $post_format ) {
					the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( $link ) ), '</a></h2>' );
				} else {
					if ( $smof_data['blog-post-link'] ) {
						the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
					}
				}
    		?>
            <?php if ( $smof_data['blog-date'] ):?>
            	<time data-time="<?php echo get_the_date( 'c' ) ?>" class="entry-date"><?php the_time( 'j M Y' ); ?></time>
            <?php endif;?>
        </header>
        <?php endif;?>
    <?php if ( 'quote' != $post_format ) : ?>
	<?php endif;?>
</article>