<?php
/**
 * The template for displaying post formats.
 *
 * @package skstore
 * @author  SunriseTheme
 * @link	http://www.sunrisetheme.com
 */

// Get theme options
global $smof_data, $post;

// Get blog style
$blog_style = ( empty( $blog_style ) || ! isset( $blog_style ) ) ? $smof_data['blog-style'] : $blog_style;

// Get post format
$post_format = get_post_format();

// Post format video
$video_source       = ( function_exists( 'get_field' ) ) ? get_field( 'video_format_source', get_the_ID() ) : '';
$video_source_link  = ( function_exists( 'get_field' ) ) ? get_field( 'video_url', get_the_ID() ) : '';
$video_source_embed = ( function_exists( 'get_field' ) ) ? get_field( 'video_code', get_the_ID() ) : '';
$video_source_local = ( function_exists( 'get_field' ) ) ? get_field( 'video_local', get_the_ID() ) : '';

// Post format audio
$audio_source       = ( function_exists( 'get_field' ) ) ? get_field( 'audio_format_source', get_the_ID() ) : '';
$audio_source_link  = ( function_exists( 'get_field' ) ) ? get_field( 'audio_url', get_the_ID() ) : '';
$audio_source_local = ( function_exists( 'get_field' ) ) ? get_field( 'audio_local', get_the_ID() ) : '';

// Post format gallery
$post_gallery = ( function_exists( 'get_field' ) ) ? get_field( 'post_gallery', get_the_ID() ) : array();
$auto_play    = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_auto', get_the_ID() ) : '';
$duration     = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_auto_time_wait', get_the_ID() ) : '';
$speed        = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_speed', get_the_ID() ) : '';
$pagination   = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_pagination', get_the_ID() ) : '';
$navigation   = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_navigation', get_the_ID() ) : '';
$mouse        = ( function_exists( 'get_field' ) ) ? get_field( 'gallery_mousewheel', get_the_ID() ) : '';
if ( function_exists( 'k2t_pre_process_shortcode' ) ) {
	wp_enqueue_script( 'k2t-owlcarousel' );
	$script = '
		<div>
		<scr' . 'ipt>
			(function($) {
				"use strict";
				$(document).ready(function() {
					$(".k2t-thumb-gallery").owlCarousel({
						dots: ' . $pagination . ',
						nav: ' . $navigation . ',
						slideSpeed: ' . $speed . ',
						rewindSpeed: ' . $duration . ',
						navText: [
							"<i class=\"fa fa-chevron-left\"></i>",
							"<i class=\"fa fa-chevron-right\"></i>"
						],
						responsive:{
                            0:{
                                items: 1,
                            },
                        }
					});
				});
			})(jQuery);
		</scr' . 'ipt>
		</div>
	';
}

// Post format quote
$quote_author  = ( function_exists( 'get_field' ) ) ? get_field( 'quote_author', get_the_ID() ) : '';
$quote_link    = ( function_exists( 'get_field' ) ) ? get_field( 'author_quote_url', get_the_ID() ) : '';
$quote_content = ( function_exists( 'get_field' ) ) ? get_field( 'quote_content', get_the_ID() ) : '';

$image_size = 'thumb_800x350';
if ( $blog_style == 'medium' ) $image_size = 'thumb_500x500';

if ( isset( $style ) & $style == '3') {
	$image_size = 'thumb_570x444';
}elseif ( isset( $style ) & $style == '4'){ 
	$image_size = 'thumb_370x467';
}elseif ( isset( $style ) & $style == '5'){ 

	// thumb size for blog style 5 

	if ( isset( $blog_index ) ) :
		switch ( $blog_index ) {
			case '0': 	$image_size = 'thumb_870x345'	;	break;
			case '1': 	$image_size = 'thumb_570x675'	;	break;
			case '2': 	$image_size = 'thumb_270x345'	;	break;
		}

	endif;

}

$blog_style_3_last_item = $blog_style_4_last_item = '';

if ( isset( $blog_style_3_last_item ) && $blog_style_3_last_item ) { 
	$image_size = 'thumb_500x746';
}elseif ( isset( $blog_style_4_last_item ) && $blog_style_4_last_item ) {
	$image_size = 'thumb_300x300';
}

?>
<?php if ( $post_format != 'quote' ) :?><div class="flx-entry-thumb"><div class="mask-style"></div><?php endif;?>
 <?php
	switch ( $post_format ) :
		case 'video':
				if ( 'link' == $video_source ) :
					echo do_shortcode( '[vc_video link="' . $video_source_link . '"/]' );
				elseif ( 'embed' == $video_source ) :
					echo $video_source_embed;
				elseif ( 'local' == $video_source ) :
					echo do_shortcode('[video src="' . $video_source_local['url'] . '"/]');
				endif;
			break;
		case 'audio':
				if ( 'link' == $audio_source ) :
					global $wp_embed;
						$media_result = $wp_embed->run_shortcode( '[embed]' . $audio_source_link . '[/embed]' );
					echo $media_result;
				elseif ( 'local' == $audio_source ) :
					echo do_shortcode('[audio src="' . $audio_source_local['url'] . '"/]');
				endif;
			break;
		case 'gallery':
				if ( count( $post_gallery ) > 0 && is_array( $post_gallery ) ) :
					echo '<div class="k2t-thumb-gallery">';
						foreach ( $post_gallery as $slide ):

							if ( is_array( $slide ) && ! empty( $slide['ID'] ) ) : $image = wp_get_attachment_image( $slide['ID'], $image_size ); ?>
								<div class="item"> 
									<?php echo $image; ?>
								</div>

							<?php elseif ( ! empty( $slide ) ) : $image = wp_get_attachment_image( $slide, $image_size ); ?>
								<div class="item"> 
									<?php echo $image; ?>
								</div>
							<?php endif;

						endforeach;
					echo '</div>';
					echo $script;
				else :
					the_post_thumbnail( $image_size );
				endif;
			break;
		case 'quote':
			echo '
                <div class="quote-wrapper">
                	<div class="quote-inner">
                    	<a href="#">
                        	<div class="quote-content">
	                    		<h4>'. get_the_content() .'</h4>
	                            <p><span>'. $quote_author .'</span></p>
	                    	</div>
                        </a>                                    	
                    </div>
                </div>
			';
			break;
		default:
			if ( has_post_thumbnail() ) :
				echo '<a href="'. esc_url( get_permalink() ) .'"><div class="wrap-img">'. get_the_post_thumbnail( get_the_ID(), $image_size ) .'</div></a>';
			else:
				echo '<a href="'. esc_url( get_permalink() ) .'"><img src="' . get_template_directory_uri() . '/assets/img/placeholder/'. str_replace( 'thumb_', '', $image_size ) .'.png" alt="' . get_the_title() . '" /></a>';
			endif;
	endswitch;
?>	
<?php if ( $post_format != 'quote' ) :?></div><?php endif;?>